/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.ResultPrinter;

public class QAResultPrinter
extends ResultPrinter {
    private IdentityHashMap<Test, SimpleTestResult> m_testResultsMap = new IdentityHashMap();
    private ArrayList<SimpleTestResult> m_testResults = new ArrayList();

    public QAResultPrinter(PrintStream writer) {
        super(writer);
    }

    public void addError(Test test, Throwable t) {
        this.m_testResultsMap.get(test).addError(t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.m_testResultsMap.get(test).addFailure(t);
    }

    public void startTest(Test test) {
        SimpleTestResult testResult = new SimpleTestResult(test);
        this.m_testResultsMap.put(test, testResult);
        this.m_testResults.add(testResult);
    }

    protected void printHeader(long runTime) {
        super.printHeader(runTime);
        PrintStream writer = this.getWriter();
        for (SimpleTestResult testResult : this.m_testResults) {
            writer.print(testResult.getName());
            writer.print(' ');
            if (testResult.hasErrors()) {
                writer.print("Errors ");
            }
            if (testResult.hasFailures()) {
                writer.print("Failures");
            }
            writer.println();
        }
    }

    private static class SimpleTestResult {
        private Test m_test;
        private ArrayList<Throwable> m_errors = new ArrayList();
        private ArrayList<AssertionFailedError> m_failures = new ArrayList();

        public SimpleTestResult(Test test) {
            this.m_test = test;
        }

        public String getName() {
            return ((TestCase)this.m_test).getName();
        }

        public void addError(Throwable error) {
            this.m_errors.add(error);
        }

        public boolean hasErrors() {
            return this.m_errors.size() > 0;
        }

        public void addFailure(AssertionFailedError failure) {
            this.m_failures.add(failure);
        }

        public boolean hasFailures() {
            return this.m_failures.size() > 0;
        }
    }
}

