/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ide.extension.Extension;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.abbot.AbbotTestSuite;
import oracle.ide.ExtensionRegistry;
import oracle.javatools.util.ModelUtil;

public class TestFinder {
    private static HashMap<String, String> LEVELS = new HashMap();
    private ExtensionRegistry m_registry = ExtensionRegistry.getExtensionRegistry();
    private VirtualFileSystem m_vfs = VirtualFileSystem.getVirtualFileSystem();
    private HashMap<String, ExtensionTest> m_extensionTests = new HashMap();
    private Collection<ExtensionTest> m_validExtensionTests = new ArrayList<ExtensionTest>();
    private Pattern m_testFilter;

    public void setTestFilter(String filePattern) {
        this.m_testFilter = null;
        if (ModelUtil.hasLength((String)filePattern) && !filePattern.equals("*")) {
            try {
                filePattern = filePattern.replaceAll("\\.\\*", "*");
                filePattern = filePattern.replaceAll("\\*", ".*");
                filePattern = ".*" + filePattern;
                this.m_testFilter = Pattern.compile(filePattern);
            }
            catch (PatternSyntaxException pse) {
                Logger.getLogger("oracle.abbot").log(Level.WARNING, pse.getMessage() + "\nIgnoring invalid filter " + filePattern);
            }
        }
    }

    public void addExtensions(Extension ... extensions) {
        if (extensions != null) {
            this.addExtensions(Arrays.asList(extensions));
        }
    }

    public void addExtensions(Collection<Extension> extensions) {
        if (extensions == null) {
            return;
        }
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        for (Extension extension : extensions) {
            String reason;
            if (this.m_extensionTests.get(extension.getID()) != null || this.m_registry.getExtensionJAR(extension) == null || ModelUtil.hasLength((String)(reason = er.getNotLoadedReason(extension.getID())))) continue;
            ExtensionTest extensionTest = new ExtensionTest(extension);
            this.m_extensionTests.put(extension.getID(), extensionTest);
            if (extensionTest.getLevelTests().size() <= 0) continue;
            this.m_validExtensionTests.add(extensionTest);
        }
    }

    public Collection<ExtensionTest> getExtensionTests() {
        return Collections.unmodifiableCollection(this.m_validExtensionTests);
    }

    public Collection<AbbotTestSuite> getSuites(String ... levels) {
        HashSet<String> expandedLevels = new HashSet<String>();
        if (levels != null) {
            for (String level : levels) {
                if ("".equals(level = level.trim())) continue;
                String cannedLevels = LEVELS.get(level.toLowerCase());
                if (cannedLevels != null) {
                    for (String cannedLevel : cannedLevels.split(",")) {
                        expandedLevels.add(cannedLevel);
                    }
                    continue;
                }
                expandedLevels.add(level);
            }
        }
        ArrayList<AbbotTestSuite> suites = new ArrayList<AbbotTestSuite>();
        for (ExtensionTest extensionTest : this.m_validExtensionTests) {
            for (ExtensionTest.LevelTest levelTest : extensionTest.getLevelTests()) {
                if (expandedLevels.size() != 0 && !expandedLevels.contains(levelTest.getLevel())) continue;
                suites.add(levelTest.getSuite());
            }
        }
        return suites;
    }

    static {
        LEVELS.put("acceptance", "level0");
        LEVELS.put("mats", "level0");
        LEVELS.put("srg", "level1");
        LEVELS.put("lrg", "level2");
        LEVELS.put("all", "level0,level1,level2,level3");
    }

    public class ExtensionTest {
        private Extension m_extension;
        private URI m_extDir;
        private Collection<LevelTest> m_levelTests;

        public ExtensionTest(Extension extension) {
            this.m_extension = extension;
            File extJar = TestFinder.this.m_registry.getExtensionJAR(extension);
            this.m_extDir = URIFactory.newDirURI((URI)TestFinder.this.m_vfs.convertSuffix(extJar.toURI(), ".jar", ""), (String)"abbot");
        }

        public Extension getExtension() {
            return this.m_extension;
        }

        public Collection<LevelTest> getLevelTests() {
            if (this.m_levelTests == null) {
                this.m_levelTests = new ArrayList<LevelTest>();
                URI[] levels = TestFinder.this.m_vfs.list(this.m_extDir);
                if (levels != null) {
                    for (URI level : levels) {
                        if (!TestFinder.this.m_vfs.isDirectory(level)) continue;
                        this.m_levelTests.add(new LevelTest(level));
                    }
                }
            }
            return Collections.unmodifiableCollection(this.m_levelTests);
        }

        public class LevelTest {
            private URI m_levelDir;
            private String m_level;
            private AbbotTestSuite m_suite;

            public LevelTest(URI levelDir) {
                this.m_levelDir = levelDir;
                this.m_level = TestFinder.this.m_vfs.getFileName(levelDir);
            }

            public String getLevel() {
                return this.m_level;
            }

            public AbbotTestSuite getSuite() {
                if (this.m_suite == null) {
                    String extensionId = ExtensionTest.this.m_extension.getID();
                    int dotIndex = extensionId.lastIndexOf(46);
                    this.m_suite = new AbbotTestSuite(extensionId, extensionId + "." + this.m_level, extensionId);
                    this.addTests(this.m_levelDir, TestFinder.this.m_testFilter);
                }
                return new AbbotTestSuite(this.m_suite);
            }

            private void addTests(URI scriptDir, Pattern testFilter) {
                URI[] uris = TestFinder.this.m_vfs.list(scriptDir);
                if (uris != null) {
                    for (URI uri : uris) {
                        if (TestFinder.this.m_vfs.isDirectory(uri)) {
                            this.addTests(uri, testFilter);
                            continue;
                        }
                        if (!TestFinder.this.m_vfs.hasSuffix(uri, ".xml")) continue;
                        String name = TestFinder.this.m_vfs.toRelativeSpec(uri, this.m_levelDir, true);
                        name = name.substring(0, name.length() - 4);
                        name = name.replace('/', '.');
                        if (testFilter != null && !testFilter.matcher(name).matches()) continue;
                        this.m_suite.addTest(name, new File(uri));
                    }
                }
            }
        }
    }
}

