/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import abbot.InterruptedAbbotException;
import abbot.WaitTimedOutException;
import abbot.finder.BasicFinder;
import abbot.finder.ComponentNotFoundException;
import abbot.finder.Hierarchy;
import abbot.finder.Matcher;
import abbot.finder.MultipleComponentsFoundException;
import abbot.finder.TestHierarchy;
import abbot.finder.matchers.ClassMatcher;
import abbot.finder.matchers.NameMatcher;
import abbot.finder.matchers.WindowMatcher;
import abbot.tester.ComponentTester;
import abbot.tester.JButtonTester;
import abbot.tester.Robot;
import abbot.util.Condition;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.net.VirtualFileSystem;
import javax.imageio.ImageIO;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.abbot.AWTThreadBlockedError;
import oracle.abbot.AbbotAddin;
import oracle.abbot.AbbotFixture;
import oracle.abbot.AbbotFixtureHook;
import oracle.abbot.JDevScriptFixtureContext;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.util.Assert;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.layout.LayoutsImpl;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.ReadWriteLockImplementation;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.CompositeIterator;
import oracle.javatools.util.Holder;
import oracle.javatools.util.Pair;

public class TestHelper {
    public static final Robot ROBOT = new Robot();
    private static final int DEFAULT_TIMEOUT = 60;
    private static final Set<String> PROCESSES_TO_IGNORE = new HashSet<String>();
    private static StringBuilder INTERNAL_LOG;
    private static Logger TEST_STATE_HELPER;
    private static ArrayList<String> PROPERTY_KEY;
    private static HashMap<String, String> OLD_PROPERTY;
    private static String retry;
    private static ConcurrentMap<String, StringBuffer> CLEAR_LOG_TOPS;
    private static HashMap<String, Long> watches;

    public static void addProcessToIgnore(String name) {
        PROCESSES_TO_IGNORE.add(name);
    }

    private TestHelper() {
    }

    private static void clearLog() {
        INTERNAL_LOG.setLength(0);
        INTERNAL_LOG.trimToSize();
    }

    public static URL createTemporaryDir(String prefix, String suffix) {
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            URL tempFile = URLFileSystem.createTempFile((String)prefix, (String)suffix, null);
            URLFileSystem.delete((URL)tempFile);
            URL tempDir = URLFactory.newDirURL((String)(tempFile.getPath() + "/"));
            URLFileSystem.mkdirs((URL)tempDir);
            return tempDir;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void dumpStackTrace(JDevScriptFixtureContext context, String postfix) throws IOException {
        retry = System.getProperty("abbot.current.retry") == null ? "" : "-retry_" + System.getProperty("abbot.current.retry");
        PrintStream ps = new PrintStream((OutputStream)context.getResultsStream("stacks" + postfix + retry + ".log").getSecond());
        TestHelper.dumpStackTrace(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStackTrace(PrintStream ps) throws IOException {
        try {
            long[] monitorLocked;
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            for (ThreadInfo ti : threadMXBean.dumpAllThreads(true, true)) {
                ps.print(ti);
                StackTraceElement[] ste = ti.getStackTrace();
                if (ste.length > 8) {
                    ps.println("[Extra stack]");
                    for (int element = 8; element < ste.length; ++element) {
                        ps.println("\tat " + ste[element]);
                        for (MonitorInfo mi : ti.getLockedMonitors()) {
                            if (mi.getLockedStackDepth() != element) continue;
                            ps.append("\t-  locked " + mi);
                            ps.append('\n');
                        }
                    }
                    ps.println("[Extra stack]");
                }
                ps.println();
            }
            long[] deadlock = threadMXBean.findDeadlockedThreads();
            if (deadlock != null && deadlock.length > 0) {
                ps.println("Deadlocked threads : ");
                for (long d : deadlock) {
                    ps.println(threadMXBean.getThreadInfo(d));
                }
                ps.println();
            }
            if ((monitorLocked = threadMXBean.findMonitorDeadlockedThreads()) != null && monitorLocked.length > 0) {
                ps.println("Monitor locked threads : ");
                for (long d : monitorLocked) {
                    ps.println(threadMXBean.getThreadInfo(d));
                }
                ps.println();
            }
        }
        finally {
            ps.close();
        }
    }

    public static void writeLogFiles(String logWindowTitle, final JDevScriptFixtureContext context) throws Exception {
        if (!context.isResultsDirDefined()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogManager logManager = LogManager.getLogManager();
                LogPage[] logPages = logManager.getPages();
                retry = System.getProperty("abbot.current.retry") == null ? "" : "-retry_" + System.getProperty("abbot.current.retry");
                for (LogPage page : logPages) {
                    if (!(page instanceof AbstractLogPage)) continue;
                    AbstractLogPage msgPage = (AbstractLogPage)page;
                    OutputStream os = null;
                    PrintStream ps = null;
                    try {
                        os = (OutputStream)context.getResultsStream("LogPage." + msgPage.getTitleName() + retry + ".log").getSecond();
                        ps = new PrintStream(os);
                        logManager.showLog();
                        logManager.getLogWindow().selectPage((LogPage)msgPage);
                        CharSequence logTop = (CharSequence)CLEAR_LOG_TOPS.get(msgPage.getTitleName());
                        if (logTop != null) {
                            ps.append(logTop);
                        }
                        if (msgPage instanceof DefaultLogPage) {
                            StringBuilder sb = new StringBuilder();
                            ((DefaultLogPage)msgPage).asTextForTestingOnly(sb);
                            ps.print(sb);
                            continue;
                        }
                        ClassMatcher textComponentMatcher = new ClassMatcher(JTextComponent.class);
                        try {
                            Component component = new BasicFinder().find((Container)msgPage.getGUI(), (Matcher)textComponentMatcher);
                            if (component == null) continue;
                            JTextComponent textPane = (JTextComponent)component;
                            ps.print(textPane.getText());
                        }
                        catch (ComponentNotFoundException componentNotFoundException) {
                        }
                        catch (MultipleComponentsFoundException multipleComponentsFoundException) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        } else if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        });
    }

    public static void startwatch(String name) throws Exception {
        if (watches.containsKey(name)) {
            throw new IllegalStateException(name + " has already been started");
        }
        watches.put(name, new Long(System.currentTimeMillis()));
    }

    public static void stopwatch(String name) throws Exception {
        TestHelper.stopwatch(name, 0L);
    }

    public static void stopwatch(String name, long maxWait) throws Exception {
        if (!watches.containsKey(name)) {
            throw new IllegalStateException("Cannot stop " + name + " it hasn't been started");
        }
        long stopTime = System.currentTimeMillis();
        long totalTime = stopTime - watches.remove(name);
        stopTime = 0L;
        if (totalTime > maxWait) {
            throw new IllegalStateException("Time taken " + totalTime + " " + "milli seconds, max time allowed " + maxWait + " milli seconds");
        }
    }

    public static String resolveExtensionFile(String extension, String pathToFile) throws FileNotFoundException {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        Extension ex = er.findExtension(extension);
        if (ex == null) {
            throw new IllegalStateException("Cannot find extension" + extension);
        }
        URI root = er.getInstallRoot(ex);
        String fileSystemRoot = VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(root);
        URL fileURL = URLFactory.newURL((URL)URLFactory.newDirURL((String)fileSystemRoot), (String)pathToFile);
        if (!URLFileSystem.exists((URL)fileURL)) {
            throw new FileNotFoundException(fileURL.toExternalForm());
        }
        String filename = URLFileSystem.getPlatformPathName((URL)fileURL);
        return filename;
    }

    public static void storeExtensionFileLocation(String systemProperty, String extension, String pathToFile) throws FileNotFoundException {
        String location = TestHelper.resolveExtensionFile(extension, pathToFile);
        System.setProperty(systemProperty, location);
    }

    public static String resolveOracleHomeFile(String pathToFile) throws FileNotFoundException {
        URL oracleHome = URLFileSystem.getParent((URL)URLFactory.newDirURL((String)Ide.getOracleHomeDirectory()));
        URL fileURL = URLFactory.newURL((URL)oracleHome, (String)pathToFile);
        if (!URLFileSystem.exists((URL)fileURL)) {
            throw new FileNotFoundException(fileURL.toExternalForm());
        }
        String filename = URLFileSystem.getPlatformPathName((URL)fileURL);
        return filename;
    }

    public static void storeExtensionOracleHomeFile(String systemProperty, String pathToFile) throws FileNotFoundException {
        String location = TestHelper.resolveOracleHomeFile(pathToFile);
        System.setProperty(systemProperty, location);
    }

    public static String resolveWorkDirectoryPath(String subDir) {
        URL dirUrl = Ide.getWorkspaces().getWorkDirectory();
        URL relDir = URLFactory.newURL((URL)dirUrl, (String)subDir);
        return URLFileSystem.getPlatformPathName((URL)relDir);
    }

    public static void unzipTestCase(String extension, String pathToZip) throws Exception {
        String filename = TestHelper.resolveExtensionFile(extension, pathToZip);
        TestHelper.unzipTestCase(URLFactory.newFileURL((String)filename));
    }

    public static void unzipTestCaseAndAddAllWorkspaces(String extension, String pathToZip) throws Exception {
        String filename = TestHelper.resolveExtensionFile(extension, pathToZip);
        TestHelper.unzipTestCaseAndAddAllWorkspaces(filename);
    }

    public static void unzipTestCaseAndAddAllWorkspaces(String filename) throws Exception {
        TestHelper.unzipTestCaseAndAddAllWorkspaces(URLFactory.newFileURL((String)filename));
    }

    public static void unzipTestCaseAndMigrateWorkspace(String extension, String pathToZip) throws Exception {
        String filename = TestHelper.resolveExtensionFile(extension, pathToZip);
        TestHelper.unzipTestCaseAndMigrateWorkspace(URLFactory.newFileURL((String)filename));
    }

    public static void unzipTestCaseAndAddAllWorkspaces(URL filename) throws Exception {
        final List<URL> workspaces = TestHelper.unzipTestCase(filename);
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Workspaces wps = Ide.getWorkspaces();
                for (URL wsURL : workspaces) {
                    try {
                        Workspace wp = (Workspace)NodeFactory.findOrCreate((URL)wsURL);
                        wps.add((Element)wp);
                        UpdateMessage.fireChildAdded((Subject)wps, (Element)wp);
                        for (Project p : wp.projects()) {
                            String baseDir = p.getBaseDirectory();
                            URL purl = URLFactory.newDirURL((String)baseDir);
                            if (URLFileSystem.exists((URL)purl)) continue;
                            TestHelper.logMessageForZipper("Project base directory " + baseDir + " is not a valid location", true);
                        }
                    }
                    catch (Exception ex) {
                        Assert.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
        ROBOT.waitForIdle();
    }

    public static void unzipTestCaseAndMigrateWorkspace(URL filename) throws Exception {
        final List<URL> workspaces = TestHelper.unzipTestCase(filename);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OpenCommand command = new OpenCommand();
                    command.setContext(Context.newIdeContext());
                    command.openURL((URL)workspaces.get(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ComponentTester ct = new ComponentTester();
        JButtonTester bt = new JButtonTester();
        final WindowMatcher openWarningMatcher = new WindowMatcher("Open Warning");
        final WindowMatcher migrationWizardMatcher = new WindowMatcher("Migrate Application .*");
        final Matcher migrationStatusMatcher = new Matcher(){

            public boolean matches(Component c) {
                String name;
                Dialog w;
                return c.isDisplayable() && c instanceof Dialog && "Migration Status".equals((w = (Dialog)c).getTitle()) && "oracle.javatools.dialogs.BaseMessageDialog".equals(name = w.getClass().getName());
            }
        };
        final NameMatcher okMatcher = new NameMatcher("OK_Button");
        NameMatcher nextMatcher = new NameMatcher("Next");
        NameMatcher finishMatcher = new NameMatcher("Finish");
        final BasicFinder bf = new BasicFinder((Hierarchy)new TestHierarchy(false));
        final Holder isWizard = new Holder((Object)false);
        try {
            Robot.wait((Condition)new Condition(){

                public boolean test() {
                    try {
                        if (bf.find((Matcher)openWarningMatcher) != null) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (bf.find((Matcher)migrationWizardMatcher) != null) {
                            isWizard.set((Object)true);
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }

                public String toString() {
                    return "Looking for open migration warning";
                }
            }, (long)20000L);
        }
        catch (WaitTimedOutException wto) {
            return;
        }
        if (((Boolean)isWizard.get()).booleanValue()) {
            Window migrationWizard = (Window)bf.find((Matcher)migrationWizardMatcher);
            JButton nextButton = (JButton)bf.find((Container)migrationWizard, (Matcher)nextMatcher);
            final JButton finishButton = (JButton)bf.find((Container)migrationWizard, (Matcher)finishMatcher);
            while (true) {
                if (Robot.callAndWait((Component)finishButton, (Callable)new Callable(){

                    public Object call() {
                        return finishButton.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }) != Boolean.FALSE) break;
                bt.actionClick((Component)nextButton);
                ROBOT.waitForIdle();
            }
            bt.actionClick((Component)finishButton);
            ROBOT.waitForIdle();
        } else {
            Window openWarning = (Window)bf.find((Matcher)openWarningMatcher);
            ROBOT.waitForIdle();
            JButton button = (JButton)bf.find((Container)openWarning, (Matcher)okMatcher);
            bt.actionClick((Component)button);
        }
        Robot.wait((Condition)new Condition(){

            public boolean test() {
                try {
                    return bf.find(migrationStatusMatcher) != null;
                }
                catch (Exception ex) {
                    return false;
                }
            }

            public String toString() {
                return "Looking for migration status dialog";
            }
        }, (long)60000L);
        final Window migrationStatus = (Window)bf.find(migrationStatusMatcher);
        ROBOT.waitForIdle();
        Robot.wait((Condition)new Condition(){

            public boolean test() {
                try {
                    return bf.find((Container)migrationStatus, (Matcher)okMatcher) != null;
                }
                catch (Throwable ex) {
                    return false;
                }
            }

            public String toString() {
                return "Looking for OK button on migration status window";
            }
        }, (long)10000L);
        JButton okButton = (JButton)bf.find((Container)migrationStatus, (Matcher)okMatcher);
        bt.actionClick((Component)okButton);
        Robot.wait((Condition)new Condition(){

            public boolean test() {
                try {
                    return !migrationStatus.isVisible();
                }
                catch (Throwable ex) {
                    return true;
                }
            }

            public String toString() {
                return "Waiting for migration status dialog to go away";
            }
        }, (long)5000L);
        ROBOT.waitForIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> unzipTestCase(URL filename) throws Exception {
        String workingDirectory = Ide.getWorkDirectory();
        ArrayList<URL> workspaces = new ArrayList<URL>();
        byte[] buf = new byte[1024];
        ZipInputStream zipinputstream = null;
        zipinputstream = new ZipInputStream(URLFileSystem.openInputStream((URL)filename));
        try {
            ZipEntry zipEntry = zipinputstream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                File targetFile = new File(workingDirectory + entryName);
                if (zipEntry.isDirectory()) {
                    targetFile.mkdirs();
                } else {
                    File parent = targetFile.getParentFile();
                    parent.mkdirs();
                    try (BufferedOutputStream fileoutputstream = new BufferedOutputStream(new FileOutputStream(targetFile));){
                        int n;
                        while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                            ((OutputStream)fileoutputstream).write(buf, 0, n);
                        }
                    }
                    zipinputstream.closeEntry();
                    if (targetFile.toString().endsWith(".jws")) {
                        workspaces.add(URLFactory.newFileURL((File)targetFile));
                    }
                }
                zipEntry = zipinputstream.getNextEntry();
            }
        }
        finally {
            zipinputstream.close();
        }
        return workspaces;
    }

    public static void zipTestCaseFromMyWork(URL destination, boolean useGlobalIgnore, boolean logToMessages) throws IOException {
        if (URLFileSystem.exists((URL)destination)) {
            if (URLFileSystem.isReadOnly((URL)destination) && !URLFileSystem.setReadOnly((URL)destination, (boolean)false)) {
                TestHelper.logMessageForZipper("Cannot write to " + destination, logToMessages);
                return;
            }
        } else {
            URL destinationParent = URLFileSystem.getParent((URL)destination);
            boolean canWrite = URLFileSystem.canWrite((URL)destinationParent);
            if (!canWrite || !URLFileSystem.mkdirs((URL)destinationParent)) {
                TestHelper.logMessageForZipper("Cannot write to " + destinationParent, logToMessages);
                return;
            }
        }
        TestHelper.logMessageForZipper("Creating " + URLFileSystem.getPlatformPathName((URL)destination), logToMessages);
        TestHelper.zipTestCaseFromMyWork(URLFileSystem.openOutputStream((URL)destination), useGlobalIgnore, logToMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipTestCaseFromMyWork(OutputStream destination, boolean useGlobalIgnore, boolean logToMessages) throws IOException {
        String directory = Ide.getWorkDirectory();
        URL mywork = URLFactory.newDirURL((String)directory);
        byte[] buf = new byte[1024];
        URLFilter filter = useGlobalIgnore ? GlobalIgnoreList.getURLFilter() : new URLFilter(){

            public boolean accept(URL url) {
                return true;
            }
        };
        ArrayList<Object> urlList = new ArrayList<Object>();
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.push(mywork);
        while (!stack.isEmpty()) {
            URL currentDir = (URL)stack.pop();
            for (URL next : URLFileSystem.list((URL)currentDir)) {
                if (!filter.accept(next)) {
                    TestHelper.logMessageForZipper("Ignoring " + URLFileSystem.toRelativeSpec((URL)next, (URL)mywork), logToMessages);
                    continue;
                }
                if (URLFileSystem.isDirectory((URL)next)) {
                    stack.push(next);
                    continue;
                }
                urlList.add(next);
            }
        }
        if (urlList.size() == 0) {
            TestHelper.logMessageForZipper("Empty", logToMessages);
            destination.close();
            return;
        }
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(destination));){
            for (URL uRL : urlList) {
                String relativeSpec = URLFileSystem.toRelativeSpec((URL)uRL, (URL)mywork);
                TestHelper.logMessageForZipper("Adding " + relativeSpec, logToMessages);
                ZipEntry ze = new ZipEntry(relativeSpec);
                zos.putNextEntry(ze);
                try (BufferedInputStream input = new BufferedInputStream(URLFileSystem.openInputStream((URL)uRL));){
                    int n = 0;
                    while ((n = ((InputStream)input).read(buf)) > 0) {
                        zos.write(buf, 0, n);
                    }
                }
            }
        }
        TestHelper.logMessageForZipper("Finished", logToMessages);
    }

    private static final void logMessageForZipper(final String msg, boolean logToMessages) {
        if (logToMessages) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogManager.getLogManager().showLog();
                    LogManager.getLogManager().getMsgPage().log((Object)(msg + "\n"));
                }
            });
        } else {
            System.err.println(msg);
        }
    }

    public static void initializePropertyFile(String extension, String relPath) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        Extension ex = er.findExtension(extension);
        if (ex == null) {
            throw new IllegalStateException("Cannot find extension" + extension);
        }
        URI root = er.getInstallRoot(ex);
        String fileSystemRoot = VirtualFileSystem.getVirtualFileSystem().getPlatformPathName(root);
        String filename = fileSystemRoot + File.separatorChar + relPath;
        try {
            FileInputStream fis = new FileInputStream(filename);
            Properties prop = new Properties();
            prop.load(fis);
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                String existingValue = System.getProperty(key);
                if (existingValue == null) {
                    System.setProperty(key, value);
                    PROPERTY_KEY.add(key);
                    continue;
                }
                if (existingValue.equals(value)) continue;
                System.setProperty(key, value);
                OLD_PROPERTY.put(key, existingValue);
            }
            fis.close();
        }
        catch (Exception e) {
            System.err.print("Error in initializing properties");
            Assert.printStackTrace((Throwable)e);
        }
    }

    public static void clearProperties() {
        if (!OLD_PROPERTY.isEmpty()) {
            for (String key : OLD_PROPERTY.keySet()) {
                System.setProperty(key, OLD_PROPERTY.get(key));
            }
            OLD_PROPERTY.clear();
        }
        if (!PROPERTY_KEY.isEmpty()) {
            for (String key : PROPERTY_KEY) {
                System.clearProperty(key);
            }
            PROPERTY_KEY.clear();
        }
    }

    public static void waitForLogWindow(String logWindowTitle, String searchFor) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, 60, true);
    }

    public static void waitForLogWindow(String logWindowTitle, String searchFor, int timeout) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, timeout, true);
    }

    public static void waitForLogWindowNoClear(String logWindowTitle, String searchFor) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, 60, false);
    }

    public static void waitForLogWindow(String logWindowTitle, String searchFor, int timeout, boolean clearAfterRead) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, null, timeout, clearAfterRead);
    }

    public static void clearLogWindow(String logWindowTitle) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, ".*", null, 60, true, true);
    }

    public static void waitForNotInLogWindow(String logWindowTitle, String searchFor) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, null, 60, true, false);
    }

    public static void waitForNotInLogWindow(String logWindowTitle, String searchFor, int timeout) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, null, timeout, true, false);
    }

    public static void waitForNotInLogWindowNoClear(String logWindowTitle, String searchFor) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, null, 60, false, false);
    }

    public static void waitForNotInLogWindowNoClear(String logWindowTitle, String searchFor, int timeout) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, null, timeout, false, false);
    }

    public static void waitForLogWindow(String logWindowTitle, String searchFor, String shortCircuit, int timeout, boolean clearAfterRead) throws Exception {
        TestHelper.waitForLogWindow(logWindowTitle, searchFor, shortCircuit, timeout, clearAfterRead, true);
    }

    public static void waitForLogWindow(String logWindowTitle, String searchFor, String shortCircuit, int timeout, boolean clearAfterRead, boolean positiveSearch) throws Exception {
        int counter;
        Robot.delay((int)1000);
        LogItem logItem = null;
        if ("INTERNAL".equals(logWindowTitle)) {
            logItem = new LogItem(){

                @Override
                public String getContents() {
                    return INTERNAL_LOG.toString();
                }

                @Override
                public String getName() {
                    return "INTERNAL_LOG";
                }

                @Override
                public void clear() {
                    TestHelper.clearLog();
                }
            };
        } else {
            final LogManager logManager = LogManager.getLogManager();
            LogPage found = null;
            int tries = timeout;
            while (found == null && tries-- >= 0) {
                LogPage[] pages = logManager.getPages();
                for (int i = 0; i < pages.length; ++i) {
                    if (!Pattern.matches(logWindowTitle, pages[i].getTitleName())) continue;
                    found = pages[i];
                    break;
                }
                if (found != null) continue;
                Robot.delay((int)1000);
            }
            if (found != null) {
                final LogPage foundPage = found;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        System.err.println("Bringing logs to front");
                        logManager.showLog();
                        logManager.getLogWindow().selectPage(foundPage);
                    }
                });
                ClassMatcher matcher = new ClassMatcher(JTextComponent.class);
                final JTextComponent textPane = (JTextComponent)new BasicFinder().find((Container)((MessagePage)found).getGUI(), (Matcher)matcher);
                final Holder textPaneContents = new Holder();
                final Runnable textPaneFetcher = new Runnable(){

                    @Override
                    public void run() {
                        String string = textPane.getText();
                        textPaneContents.set((Object)string);
                    }
                };
                logItem = new LogItem(){

                    @Override
                    public String getContents() {
                        try {
                            System.err.println("In getContents()");
                            SwingUtilities.invokeAndWait(textPaneFetcher);
                        }
                        catch (Exception e) {
                            Assert.printStackTrace((Throwable)e);
                        }
                        return (String)textPaneContents.get();
                    }

                    @Override
                    public String getName() {
                        return foundPage.getTitleName();
                    }

                    @Override
                    public void clear() {
                        System.err.println("In clear(); going to clear the test message");
                        foundPage.clearAll();
                    }
                };
            }
        }
        if (logItem == null) {
            throw new IllegalStateException("Page " + logWindowTitle + " not found");
        }
        int limit = timeout;
        System.err.println("Waiting for " + searchFor + " in " + logWindowTitle);
        try {
            for (counter = 0; !TestHelper.searchString(searchFor, logItem.getContents()) && counter < limit; ++counter) {
                if (shortCircuit != null && TestHelper.searchString(shortCircuit, logItem.getContents())) {
                    System.err.println("Found short circuit string " + shortCircuit + " in " + logWindowTitle);
                    throw new IllegalStateException("Short circuited by " + shortCircuit + " waiting for " + searchFor + " in " + logWindowTitle);
                }
                System.err.print(".");
                if (counter % 20 == 0) {
                    System.err.println();
                }
                Robot.delay((int)1000);
            }
        }
        catch (StackOverflowError soe) {
            soe.printStackTrace();
        }
        System.err.println("Finished");
        if (positiveSearch) {
            if (counter >= limit) {
                throw new IllegalStateException("Time out waiting for " + searchFor + " in " + logWindowTitle);
            }
        } else {
            System.out.println("Negative Search, counter is: " + counter);
            if (counter < limit) {
                throw new IllegalStateException(searchFor + " in " + logWindowTitle + " is unexpectedly found");
            }
        }
        if (clearAfterRead) {
            StringBuffer sb = new StringBuffer();
            StringBuffer original = CLEAR_LOG_TOPS.putIfAbsent(logItem.getName(), sb);
            StringBuffer toUse = (original != null ? original : sb).append(logItem.getContents());
            toUse.append("\n\n\n********** Log was cleared at this point by abbot test ************\n\n\n");
            logItem.clear();
        }
    }

    private static boolean searchString(String searchFor, String textPaneContents) {
        String[] bits = textPaneContents.split("[\n\r]");
        for (int i = bits.length - 1; i >= 0; --i) {
            if (!Pattern.matches(searchFor, bits[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean runUnfilteredFixtures() {
        Preferences cache = AbbotAddin.getPreferences();
        String suite = cache.get("Abbot.selectedExtension", "oracle.abbot-jdev").split(",")[0];
        oracle.ide.ExtensionRegistry er = oracle.ide.ExtensionRegistry.getExtensionRegistry();
        Extension ex = er.findExtension(suite);
        if (ex != null) {
            er.fullyLoadExtension(ex, "Force load extension to ensure fixtures present");
        } else {
            ex = er.findExtension("oracle.abbot-jdev");
            if (ex != null) {
                er.fullyLoadExtension(ex, "Force load extension to ensure fixtures present");
            } else {
                System.err.println("WARNING: can't find and load oracle.abbot-jdev");
            }
        }
        AbbotFixtureHook afe = (AbbotFixtureHook)oracle.ide.ExtensionRegistry.getExtensionRegistry().getHook(AbbotFixtureHook.NAME);
        ArrayList<AbbotFixture> fixtures = new ArrayList<AbbotFixture>();
        fixtures.addAll(afe.getPerRunFixtures(new String[]{suite}));
        fixtures.addAll(afe.getPerSuiteFixtures(suite));
        fixtures.addAll(afe.getPerTestFixtures(suite));
        JDevScriptFixtureContext tearDownContext = new JDevScriptFixtureContext(null, TestHelper.createTemporaryDir("cleanUp", null), suite != null ? suite : "InvalidName", "DoesntMatter");
        for (int i = fixtures.size() - 1; i >= 0; --i) {
            AbbotFixture fixture = (AbbotFixture)fixtures.get(i);
            fixture.tearDown(tearDownContext);
        }
        JDevScriptFixtureContext setupContext = new JDevScriptFixtureContext(null, TestHelper.createTemporaryDir("setup", null), suite != null ? suite : "InvalidName", "DoesntMatter");
        for (AbbotFixture fixture : fixtures) {
            fixture.setUp(setupContext);
        }
        return true;
    }

    public static boolean cleanUp(boolean delete) {
        return TestHelper.cleanUp(delete, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cleanUp(boolean delete, final JDevScriptFixtureContext scriptContext) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Needs to be run on seperate thread");
        }
        try {
            TimeUnit tu = TimeUnit.SECONDS;
            int time = 30;
            Runnable nullRunnable = new Runnable(){

                @Override
                public void run() {
                }
            };
            if (!TestHelper.invokeAndWait(nullRunnable, tu, time)) {
                System.err.println("***********************************************************");
                System.err.println();
                System.err.println("UI Queue didn't response for " + time + " " + (Object)((Object)tu) + " on clean up");
                System.err.println("Assuming deadlock so breaking locks");
                System.err.println();
                System.err.println("***********************************************************");
                if (scriptContext != null) {
                    scriptContext.setFailure(new IllegalStateException("UI queue blocked for more than " + time + " " + (Object)((Object)tu) + " on clean up"));
                }
                PrintWriter writer = new PrintWriter(System.err);
                TestHelper.breakLocks(writer);
                writer.flush();
                if (!TestHelper.invokeAndWait(nullRunnable, tu, time)) {
                    AWTThreadBlockedError ex = new AWTThreadBlockedError("Cannot unblock AWT Thread");
                    ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                    for (ThreadInfo ti : threadMXBean.dumpAllThreads(true, true)) {
                        if (!ti.getThreadName().startsWith("AWT-EventQueue-")) continue;
                        ex.setStackTrace(ti.getStackTrace());
                        break;
                    }
                    throw ex;
                }
            }
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        if (delete && !TestHelper.promptUser()) {
            return false;
        }
        try {
            Node node;
            String directory = Ide.getWorkDirectory();
            final URL workDirectoryURL = URLFactory.newDirURL((String)directory);
            TestHelper.closeVisibleWindows(20);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Component[] comps;
                    JLayeredPane layers = Ide.getMainWindow().getLayeredPane();
                    for (Component comp : comps = layers.getComponentsInLayer(JLayeredPane.POPUP_LAYER)) {
                        if (layers.getLayer(comp) == -1) continue;
                        layers.remove(comp);
                    }
                }
            });
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    IdeMainWindow mainWindow = Ide.getMainWindow();
                    mainWindow.requestFocus();
                    mainWindow.toFront();
                    mainWindow.toFront();
                    mainWindow.setExtendedState(mainWindow.getExtendedState() | 6);
                }
            });
            ROBOT.waitForIdle();
            final EditorManager editorManager = EditorManager.getEditorManager();
            final ArrayList editors = new ArrayList();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    editors.addAll(editorManager.getAllEditors());
                }
            });
            Iterator it = editors.iterator();
            while (it.hasNext()) {
                Object node2;
                Context context = ((Editor)it.next()).getContext();
                if (context == null || (node2 = context.getNode()) == null) continue;
                SwingUtilities.invokeAndWait(new Runnable((Node)node2){
                    final /* synthetic */ Node val$node;
                    {
                        this.val$node = node;
                    }

                    @Override
                    public void run() {
                        this.val$node.markDirty(false);
                    }
                });
            }
            IdeAction closeNodeAction = IdeActions.getFileCloseAction();
            String oldCloseNodeCmd = closeNodeAction.getCommand();
            closeNodeAction.setCommand("oracle.ide.cmd.CloseNodeCommand");
            for (final Editor editor : editors) {
                if (TestHelper.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        editorManager.closeEditors(Collections.singletonList(editor));
                    }
                })) continue;
                TestHelper.closeVisibleWindows(10);
            }
            closeNodeAction.setCommand(oldCloseNodeCmd);
            TestHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Iterator it = NodeFactory.getOpenNodes();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        boolean isWorkDir = URLFileSystem.isBaseURLFor((URL)workDirectoryURL, (URL)node.getURL());
                        if (!isWorkDir || !node.isDirty()) continue;
                        System.err.println("Marking node not dirty " + URLFileSystem.getPlatformPathName((URL)node.getURL()));
                        node.markDirty(false);
                        if (!node.isOpen()) continue;
                        if (TestHelper.breakLockIfRequired(node, new PrintWriter(System.err)) && scriptContext != null) {
                            scriptContext.setFailure(new IllegalStateException("Had to break lock on " + node.getURL()));
                        }
                        try {
                            node.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            final Workspaces workspaces = Ide.getWorkspaces();
            Iterator it2 = workspaces.getChildren();
            while (it2.hasNext()) {
                URL toCleanUp;
                final Workspace wp = (Workspace)it2.next();
                Runner runn = Runner.getRunner();
                Iterator itp = wp.getChildren();
                while (itp.hasNext()) {
                    final Project proj = (Project)itp.next();
                    try {
                        Folder process = runn.getProcessesFolder();
                        ArrayList<RunProcess> processListInReverseOrder = new ArrayList<RunProcess>();
                        Iterator ps = process.getChildren();
                        if (ps != null) {
                            while (ps.hasNext()) {
                                processListInReverseOrder.add(0, (RunProcess)ps.next());
                            }
                        }
                        Iterator rpit = processListInReverseOrder.iterator();
                        while (rpit.hasNext()) {
                            RunProcess rp = (RunProcess)rpit.next();
                            String shortLabel = rp.getShortLabel();
                            if (PROCESSES_TO_IGNORE.contains(shortLabel)) {
                                rpit.remove();
                                continue;
                            }
                            rp.terminate();
                            Holder stillrunning = new Holder((Object)false);
                            int timeout = 0;
                            do {
                                Robot.delay((int)200);
                                stillrunning.set((Object)(!rp.hasFinished() ? 1 : 0));
                            } while (((Boolean)stillrunning.get()).booleanValue() && ++timeout <= 500);
                            if (timeout < 500) continue;
                            throw new IllegalStateException(shortLabel + " process failed to stop for " + proj.getShortLabel());
                        }
                        if (process.getChildren().hasNext()) {
                            throw new IllegalStateException("At least one process failed to stop for " + proj.getShortLabel());
                        }
                    }
                    catch (Exception e) {
                        Assert.println((String)e.getMessage());
                    }
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (TestHelper.breakLockIfRequired((Node)proj, new PrintWriter(System.err)) && scriptContext != null) {
                                scriptContext.setFailure(new IllegalStateException("Had to break lock on " + proj.getURL()));
                            }
                            try {
                                proj.close();
                            }
                            catch (IOException e) {
                                Assert.println((String)e.getMessage());
                            }
                        }
                    });
                }
                TestHelper.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (TestHelper.breakLockIfRequired((Node)wp, new PrintWriter(System.err)) && scriptContext != null) {
                            scriptContext.setFailure(new IllegalStateException("Had to break lock on " + wp.getURL()));
                        }
                        try {
                            wp.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                if (delete && URLFileSystem.isBaseURLFor((URL)workDirectoryURL, (URL)wp.getURL())) {
                    wp.delete();
                }
                TestHelper.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        workspaces.remove((Element)wp);
                        UpdateMessage.fireChildRemoved((Subject)workspaces, (Element)wp);
                    }
                });
                NodeFactory.uncache((URL)wp.getURL());
                if (!delete || !URLFileSystem.isBaseURLFor((URL)workDirectoryURL, (URL)(toCleanUp = URLFileSystem.getParent((URL)wp.getURL())))) continue;
                TestHelper.deleteRecursively(toCleanUp);
            }
            if (delete) {
                TestHelper.deleteRecursively(workDirectoryURL);
            }
            ROBOT.waitForIdle();
            ROBOT.waitForIdle();
            ROBOT.waitForIdle();
            StringWriter nodeLog = new StringWriter();
            PrintWriter nodeWriter = new PrintWriter(nodeLog);
            Object it3 = new CompositeIterator(new Iterator[]{NodeFactory.getLoadedNodes(), NodeFactory.getOpenNodes(), NodeFactory.getCachedNodes()});
            while (it3.hasNext()) {
                node = (Node)it3.next();
                if (node == null || node.getURL() == null) continue;
                nodeWriter.println("Looking at " + URLFileSystem.getPlatformPathName((URL)node.getURL()));
                boolean isWorkDir = URLFileSystem.isBaseURLFor((URL)workDirectoryURL, (URL)node.getURL());
                if (!isWorkDir && URLFileSystem.isLocal((URL)node.getURL())) continue;
                if (node.isOpen()) {
                    nodeWriter.println("Closng " + URLFileSystem.getPlatformPathName((URL)node.getURL()));
                    TestHelper.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (TestHelper.breakLockIfRequired(node, new PrintWriter(System.err)) && scriptContext != null) {
                                scriptContext.setFailure(new IllegalStateException("Had to break lock on " + node.getURL()));
                            }
                            try {
                                node.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                nodeWriter.println("Uncaching " + URLFileSystem.getPlatformPathName((URL)node.getURL()));
                NodeFactory.uncache((URL)node.getURL());
            }
            it3 = NodeFactory.getOpenNodes();
            while (it3.hasNext()) {
                node = (Node)it3.next();
                if (node.isOpen()) {
                    nodeWriter.println("Left open " + URLFileSystem.getPlatformPathName((URL)node.getURL()));
                    continue;
                }
                nodeWriter.println("Not open " + URLFileSystem.getPlatformPathName((URL)node.getURL()) + " but in open list");
            }
            String messages = nodeLog.toString();
            if (scriptContext != null) {
                try (OutputStream out = null;){
                    int count = messages.split("\n").length;
                    String string = retry = System.getProperty("abbot.current.retry") == null ? "" : "-retry_" + System.getProperty("abbot.current.retry");
                    if (count > 250) {
                        System.err.println();
                        System.err.println("Possibly a problem too many nodes, logging log output");
                        System.err.println();
                        out = URLFileSystem.openOutputStream((URL)scriptContext.getResultsFilename("NodeCleaningLog" + retry + ".txt.gz"));
                    } else {
                        Pair<URL, OutputStream> pair = scriptContext.getResultsStream("NodeCleaningLog" + retry + ".txt.gz");
                        out = (OutputStream)pair.getSecond();
                    }
                    GZIPOutputStream gzipOut = new GZIPOutputStream(out);
                    try {
                        new PrintStream(gzipOut).println(messages);
                    }
                    finally {
                        gzipOut.finish();
                    }
                }
            }
            if (System.getProperty("oracle.abbot.turnDTCacheOff") == null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Ide.getDTCache().removeAll();
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                        }
                    }
                });
            }
            ROBOT.waitForIdle();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Iterator it = NodeFactory.getCachedNodes();
                    while (it.hasNext()) {
                        Node node = (Node)it.next();
                        if (!(node instanceof Project) && !(node instanceof Workspace)) continue;
                        NodeFactory.uncache((URL)node.getURL());
                    }
                }
            });
            TestHelper.clearLog();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (LogPage page : LogManager.getLogManager().getPages()) {
                        if (!page.getTitleName().contains("Extensions")) {
                            if (page.getTitleName().matches("Searching.*") || page.getTitleName().matches("Replacing.*")) {
                                LogManager.getLogManager().removePage(page);
                            } else {
                                page.clearAll();
                            }
                        }
                        if (!(page instanceof RunLogPage)) continue;
                        LogManager.getLogManager().removePage(page);
                    }
                }
            });
            CLEAR_LOG_TOPS.clear();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Context context = Context.newIdeContext();
                    try {
                        IdeAction.get((int)64).performAction(context);
                        IdeAction.get((int)49).performAction(context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (WindowManagerStartingController.getInstance() == null) {
                            Method ml = LayoutsImpl.class.getDeclaredMethod("restoreLayoutsToFactorySettings", new Class[0]);
                            ml.setAccessible(true);
                            ml.invoke((Object)LayoutsImpl.getInstance(), DockStationImpl.getInstance().getResetAction());
                        } else {
                            DockStation ds = DockStation.getDockStation();
                            Method mds = ds.getClass().getDeclaredMethod("resetWindowsToFactoryDefaults", new Class[0]);
                            mds.setAccessible(true);
                            mds.invoke((Object)ds, new Object[0]);
                        }
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                    }
                }
            });
            ROBOT.waitForIdle();
        }
        catch (Exception ex) {
            FeedbackManager.reportException((Throwable)ex);
        }
        return true;
    }

    public static void checkUndisposedWindows(final JDevScriptFixtureContext scriptContext) {
        boolean notFailOnUndisposedWindows = System.getProperty("abbot.notFailOnUndisposedWindows") != null;
        try {
            List<Window> openedWindows = TestHelper.getOpenedWindows();
            if (openedWindows.size() > 2) {
                Pair<List<Window>, List<Window>> classified = TestHelper.classifyWindows(openedWindows);
                List visible = (List)classified.getFirst();
                List notdisposed = (List)classified.getSecond();
                if (visible.size() > 0 || notdisposed.size() > 0) {
                    System.err.println("******* Too Many Owned Windows After Test ***********");
                    System.err.println();
                    System.err.println();
                    System.err.println("Still Visible : " + visible.size());
                    if (visible.size() > 0) {
                        System.err.println();
                        for (final Window win : visible) {
                            System.err.println(win);
                        }
                        System.err.println();
                    }
                    if (visible.size() > 0) {
                        String message = TestHelper.extendedWindowMessage("cleanUp has failed windows still open", visible);
                        WindowProblem we = new WindowProblem(message);
                        if (scriptContext != null) {
                            TestHelper.captureScreenshot(scriptContext, "-open-window");
                            TestHelper.dumpStackTrace(scriptContext, "-open-window");
                            scriptContext.setFailure(we);
                        } else {
                            throw we;
                        }
                    }
                    System.err.println();
                    System.err.println();
                    System.err.println("******************************************************");
                    System.err.println("Not Disposed, likely to be a leak : " + notdisposed.size());
                    if (notdisposed.size() > 0) {
                        System.err.println();
                        for (final Window win : notdisposed) {
                            StringBuilder name = new StringBuilder();
                            if (win instanceof Frame) {
                                name.append(((Frame)win).getTitle());
                            }
                            if (win instanceof Dialog) {
                                name.append(((Dialog)win).getTitle());
                            }
                            name.append(win);
                            System.err.println(name);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        win.dispose();
                                    }
                                    catch (StackOverflowError e) {
                                        try {
                                            Field $windowListener = Window.class.getDeclaredField("windowListener");
                                            $windowListener.setAccessible(true);
                                            WindowListener aem = (WindowListener)$windowListener.get(win);
                                            WindowListener[] listeners = (WindowListener[])AWTEventMulticaster.getListeners((EventListener)aem, WindowListener.class);
                                            PrintStream ps = new PrintStream((OutputStream)scriptContext.getResultsStream("dispose-stackoverflow" + UUID.randomUUID() + ".txt").getSecond());
                                            for (WindowListener wl : listeners) {
                                                ps.println(wl.getClass());
                                                ps.println(wl);
                                            }
                                        }
                                        catch (Throwable th) {
                                            th.printStackTrace();
                                        }
                                        throw e;
                                    }
                                }
                            });
                        }
                        System.err.println();
                        if (scriptContext != null) {
                            if (notFailOnUndisposedWindows) {
                                System.err.println();
                                System.err.println("WARNING: You are using 'abbot.dont.fail.undisposed' switch. Please check logs for undisposed window errors and file appropriate bugs if needed.");
                                System.err.println();
                            } else {
                                scriptContext.setFailure(new Exception(TestHelper.extendedWindowMessage("There were un-disposed windows a the end of this test, this can result in later test failures", notdisposed)));
                            }
                        }
                    }
                }
            }
            ROBOT.waitForIdle();
        }
        catch (Exception ex) {
            FeedbackManager.reportException((Throwable)ex);
        }
    }

    private static String extendedWindowMessage(String prefix, List<Window> visible) {
        StringBuffer message = new StringBuffer(prefix);
        for (Window window : visible) {
            String title = "<No Title>";
            if (window instanceof Frame) {
                title = ((Frame)window).getTitle();
            } else if (window instanceof Dialog) {
                title = ((Dialog)window).getTitle();
            }
            String name = window.getName();
            if (name == null || name.length() == 0) {
                name = "<No Name>";
            }
            message.append('\n');
            message.append("Title \"");
            message.append(title);
            message.append("\" Name \"");
            message.append(window.getName());
            message.append("\" Class ");
            message.append(window.getClass());
            message.append("\n");
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter);
            window.list(pw);
            message.append(stringWriter.toString());
        }
        return message.toString();
    }

    private static boolean promptUser() {
        String directory = Ide.getWorkDirectory();
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)("<html><p>This action will delete every workspace/project and the contents of the your mywork directory, are you sure?</p><br><p>Your current mywork directory is : </p><br><p><font color=\"red\">" + directory + "</font></p></html>"), (String)"Confirm Trashing", null, (boolean)true)) {
            return false;
        }
        File possibleAdePath = new File(directory, ".ade_path");
        if (possibleAdePath.exists()) {
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)("<html><p>The path you has asked to delete contains .ade_path are you sure you want to delete it?</p><br><p>Your current mywork directory is : </p><br><p><font color=\"red\">" + directory + "</font></p></html>"), (String)"Confirm Trashing", null, (boolean)true)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Are you actually reading these dialogs?", (String)"Idiot users", null);
            }
            return false;
        }
        return true;
    }

    private static void closeVisibleWindows(int tries) throws InvocationTargetException, InterruptedException {
        int counter = 0;
        Window next = null;
        List<Window> visibleWindows = TestHelper.getVisibleWindows();
        while (visibleWindows.size() > 0 && counter < tries) {
            System.err.println("***** Closing window attempt " + ++counter + " currently " + visibleWindows.size() + " open");
            for (int j = visibleWindows.size() - 1; j >= 0; --j) {
                final Window param = next = visibleWindows.get(j);
                System.err.println("Closing " + next);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (param instanceof MainWindow) {
                            return;
                        }
                        if (param.getClass().getName().contains("SwingUtilities")) {
                            return;
                        }
                        if (param instanceof WizardDialog) {
                            try {
                                Method m = param.getClass().getDeclaredMethod("dismissDialog", Boolean.TYPE);
                                m.setAccessible(true);
                                m.invoke((Object)param, true);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                param.setVisible(false);
                            }
                        } else if (param instanceof JEWTDialog) {
                            ((JEWTDialog)param).closeDialog(true);
                            if (param.isVisible()) {
                                param.setVisible(false);
                            }
                        } else {
                            param.setVisible(false);
                        }
                        if (!param.isVisible()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    param.setVisible(false);
                                    param.dispose();
                                }
                            });
                        }
                    }
                });
                ROBOT.waitForIdle();
            }
            System.err.println("***** End window closing attempt " + counter);
            visibleWindows = TestHelper.getVisibleWindows();
        }
    }

    public static boolean invokeAndWait(Runnable runnable) throws InvocationTargetException {
        return TestHelper.invokeAndWait(runnable, TimeUnit.SECONDS, 20L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean invokeAndWait(final Runnable runnable, TimeUnit units, long timeout) throws InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock lock = new AWTInvocationLock();
        final AtomicBoolean disabled = new AtomicBoolean(false);
        final AtomicBoolean completed = new AtomicBoolean(false);
        InvocationEvent event = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), new Runnable(){

            @Override
            public void run() {
                try {
                    if (!disabled.get()) {
                        runnable.run();
                    }
                }
                finally {
                    completed.set(true);
                }
            }
        }, lock, true);
        AWTInvocationLock aWTInvocationLock = lock;
        synchronized (aWTInvocationLock) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(event);
            try {
                lock.wait(units.toMillis(timeout));
                disabled.set(true);
            }
            catch (InterruptedException io) {
                throw new InterruptedAbbotException("Interrupted in invokeAndWait");
            }
        }
        Throwable eventThrowable = event.getThrowable();
        if (eventThrowable != null) {
            throw new InvocationTargetException(eventThrowable);
        }
        return completed.get();
    }

    private static Pair<List<Window>, List<Window>> classifyWindows(List<Window> openedWindows) {
        ArrayList<Window> visible = new ArrayList<Window>();
        ArrayList<Window> notdisposed = new ArrayList<Window>();
        for (Window win : openedWindows) {
            String name = win.getClass().getName();
            if (win instanceof MainWindow || name.startsWith("abbot.") || name.equals("oracle.ide.splashscreen.SplashScreen") || name.contains("SwingUtilities") || name.equals("javax.swing.Popup$HeavyWeightWindow")) continue;
            if (win.isVisible()) {
                visible.add(win);
                continue;
            }
            if (!win.isDisplayable()) continue;
            notdisposed.add(win);
        }
        return new Pair(visible, notdisposed);
    }

    private static List<Window> getVisibleWindows() {
        return (List)TestHelper.classifyWindows(TestHelper.getOpenedWindows()).getFirst();
    }

    private static List<Window> getOpenedWindows() {
        ArrayList<Window> openWindows = new ArrayList<Window>();
        Frame[] frames = Frame.getFrames();
        for (int frame = 0; frame < frames.length; ++frame) {
            if (frames[frame] == null) continue;
            openWindows.add(frames[frame]);
        }
        int lastCount = 0;
        do {
            int startIndex = lastCount;
            lastCount = openWindows.size();
            for (int window = startIndex; window < lastCount; ++window) {
                Window next = (Window)openWindows.get(window);
                Window[] ownedWindows = next.getOwnedWindows();
                int ownedWindowCount = ownedWindows.length;
                for (int ow = 0; ow < ownedWindowCount; ++ow) {
                    if (ownedWindows[ow] == null || openWindows.contains(ownedWindows[ow])) continue;
                    openWindows.add(ownedWindows[ow]);
                }
            }
        } while (lastCount != openWindows.size());
        Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (focusedWindow != null && !openWindows.contains(focusedWindow)) {
            openWindows.add(focusedWindow);
        }
        return openWindows;
    }

    public static void breakLocks(PrintWriter pw) {
        try {
            Iterator nodes = NodeFactory.getCachedNodes();
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                TestHelper.breakLockIfRequired(node, pw);
            }
        }
        catch (Throwable th) {
            th.printStackTrace(pw);
        }
    }

    public static boolean breakLockIfRequired(Node node, PrintWriter pw) {
        block10: {
            try {
                Field lockField = Node.class.getDeclaredField("_nodeLock");
                lockField.setAccessible(true);
                final ReadWriteLock lock = (ReadWriteLock)lockField.get(node);
                pw.println("Breaking lock for " + node.getURL());
                int timeout = 5000;
                try {
                    Robot.wait((Condition)new Condition(){

                        public boolean test() {
                            return lock.tryWriteLock();
                        }
                    }, (long)timeout, (int)100);
                    lock.writeUnlock();
                    return false;
                }
                catch (WaitTimedOutException wtoe) {
                    pw.printf("Failed to achieve write lock after %d ms\n", timeout);
                    int readCount = lock.getReadHoldCount();
                    int writeCount = lock.getWriteHoldCount();
                    boolean readLock = lock.isReadLockHeld();
                    boolean writeLock = lock.isWriteLockHeld();
                    Field implementationField = lock.getClass().getDeclaredField("implementation");
                    implementationField.setAccessible(true);
                    ReadWriteLockImplementation implementation = (ReadWriteLockImplementation)implementationField.get(lock);
                    if ("LegacyReadWriteLockImplementation".equals(implementation.getClass().getSimpleName())) {
                        Field readersField = implementation.getClass().getDeclaredField("readers");
                        readersField.setAccessible(true);
                        Map readers = (Map)readersField.get(implementation);
                        readers.clear();
                        Field writeField = implementation.getClass().getDeclaredField("writeThread");
                        writeField.setAccessible(true);
                        writeField.set(implementation, null);
                        Field writeState = implementation.getClass().getDeclaredField("writeState");
                        writeState.setAccessible(true);
                        writeState.set(implementation, null);
                        break block10;
                    }
                    if (ReentrantReadWriteLock.class.isAssignableFrom(implementation.getClass())) {
                        ReentrantReadWriteLock impl = (ReentrantReadWriteLock)implementation;
                        Field syncField = ReentrantReadWriteLock.class.getDeclaredField("sync");
                        syncField.setAccessible(true);
                        AbstractQueuedSynchronizer sync = (AbstractQueuedSynchronizer)syncField.get(impl);
                        Method getExclusiveOwnerMethod = AbstractOwnableSynchronizer.class.getDeclaredMethod("getExclusiveOwnerThread", new Class[0]);
                        getExclusiveOwnerMethod.setAccessible(true);
                        Object ownerThread = getExclusiveOwnerMethod.invoke((Object)sync, new Object[0]);
                        Method setExclusiveOwnerMethod = AbstractOwnableSynchronizer.class.getDeclaredMethod("setExclusiveOwnerThread", Thread.class);
                        setExclusiveOwnerMethod.setAccessible(true);
                        setExclusiveOwnerMethod.invoke((Object)sync, Thread.currentThread());
                        Field headField = AbstractQueuedSynchronizer.class.getDeclaredField("head");
                        headField.setAccessible(true);
                        Field tailField = AbstractQueuedSynchronizer.class.getDeclaredField("tail");
                        tailField.setAccessible(true);
                        Object value = headField.get(sync);
                        ArrayList<Thread> waiting = new ArrayList<Thread>();
                        if (value != null) {
                            while (value != null) {
                                Field threadField = value.getClass().getDeclaredField("thread");
                                threadField.setAccessible(true);
                                Thread lockedThread = (Thread)threadField.get(value);
                                if (lockedThread != null) {
                                    waiting.add(lockedThread);
                                }
                                Field nextField = value.getClass().getDeclaredField("next");
                                nextField.setAccessible(true);
                                value = nextField.get(value);
                            }
                        }
                        Field stateField = AbstractQueuedSynchronizer.class.getDeclaredField("state");
                        stateField.setAccessible(true);
                        stateField.set(sync, 0);
                        Class<?> syncClass = sync.getClass().getSuperclass();
                        Field cachedHoldCounter = syncClass.getDeclaredField("cachedHoldCounter");
                        cachedHoldCounter.setAccessible(true);
                        cachedHoldCounter.set(sync, null);
                        Field readHolds = syncClass.getDeclaredField("readHolds");
                        Class<?> threadLocalHoldCounterClass = readHolds.getType();
                        Constructor<?> cons = threadLocalHoldCounterClass.getDeclaredConstructor(new Class[0]);
                        cons.setAccessible(true);
                        Object threadLocalHoldCounter = cons.newInstance(new Object[0]);
                        readHolds.setAccessible(true);
                        readHolds.set(sync, threadLocalHoldCounter);
                        setExclusiveOwnerMethod.invoke((Object)sync, new Object[]{null});
                        for (Thread t : waiting) {
                            LockSupport.unpark(t);
                        }
                        break block10;
                    }
                    throw new IllegalStateException("Unknown lock implementation");
                }
            }
            catch (Throwable th) {
                th.printStackTrace(pw);
                th.printStackTrace();
            }
        }
        return true;
    }

    private static void deleteRecursively(String context) {
        File deleteMe = new File(context);
        if (deleteMe.isDirectory()) {
            File[] list = deleteMe.listFiles();
            for (int item = 0; item < list.length; ++item) {
                TestHelper.deleteRecursively(list[item].getAbsolutePath());
            }
        } else {
            NodeFactory.uncache((URL)URLFactory.newFileURL((File)deleteMe));
        }
        System.err.println("Removing " + context);
        boolean result = deleteMe.isDirectory() ? URLFileSystem.delete((URL)URLFactory.newDirURL((File)deleteMe)) : URLFileSystem.delete((URL)URLFactory.newFileURL((File)deleteMe));
        if (!result) {
            System.err.println("!Failed " + context);
        }
    }

    public static void deleteRecursively(URL context) {
        if (URLFileSystem.isDirectory((URL)context)) {
            URL[] list = URLFileSystem.list((URL)context);
            if (list != null) {
                for (int item = 0; item < list.length; ++item) {
                    if (!URLFileSystem.exists((URL)list[item])) continue;
                    TestHelper.deleteRecursively(list[item]);
                }
            }
        } else {
            NodeFactory.uncache((URL)context);
        }
        System.err.println("Removing " + context);
        boolean result = URLFileSystem.delete((URL)context);
        if (!result) {
            System.err.println("!Failed " + context);
        }
    }

    public static void captureScreenshot(JDevScriptFixtureContext context, String postFix) {
        if (context.isResultsDirDefined()) {
            try {
                retry = System.getProperty("abbot.current.retry") == null ? "" : "-retry_" + System.getProperty("abbot.current.retry");
                TestHelper.captureScreenshot((OutputStream)context.getResultsStream("FailedTest" + postFix + retry + ".png").getSecond());
            }
            catch (Exception e) {
                FeedbackManager.reportException((String)("Error capturing screen shot for " + context.getTestName() + " in suite " + context.getSuiteName()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void captureScreenshot(OutputStream os) throws IOException {
        Robot r = new Robot();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        BufferedImage bi = r.capture(new Rectangle(0, 0, dim.width, dim.height));
        try {
            Graphics g = bi.getGraphics();
            try {
                Window win;
                Component comp = FocusManager.getCurrentManager().getFocusOwner();
                if (comp != null && comp.isVisible()) {
                    Point p = comp.getLocationOnScreen();
                    Dimension cdim = comp.getSize();
                    g.setColor(new Color(Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue(), 128));
                    g.fillRect(p.x, p.y, cdim.width, cdim.height);
                }
                if ((win = FocusManager.getCurrentManager().getFocusedWindow()) != null && win.isVisible()) {
                    Point p = win.getLocationOnScreen();
                    Dimension cdim = win.getSize();
                    g.setColor(Color.RED);
                    g.drawRect(p.x, p.y, cdim.width, cdim.height);
                }
            }
            finally {
                g.dispose();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TestHelper.writePNG(os, bi);
    }

    private static void writePNG(OutputStream os, BufferedImage img) throws IOException {
        ImageIO.write((RenderedImage)img, "png", os);
        os.close();
    }

    static {
        retry = "";
        final StringBuilder sb = INTERNAL_LOG = new StringBuilder();
        TEST_STATE_HELPER = Logger.getLogger("oracle.abbot.test");
        TEST_STATE_HELPER.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                sb.append(record.getMessage());
                sb.append('\n');
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
        TEST_STATE_HELPER.setLevel(Level.ALL);
        PROPERTY_KEY = new ArrayList();
        OLD_PROPERTY = new HashMap();
        CLEAR_LOG_TOPS = new ConcurrentHashMap<String, StringBuffer>();
        watches = new HashMap();
    }

    private static interface LogItem {
        public String getContents();

        public String getName();

        public void clear();
    }

    public static class WindowProblem
    extends RuntimeException {
        public WindowProblem(String msg) {
            super(msg);
        }
    }
}

