/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot;

import abbot.tester.Robot;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import oracle.abbot.AbbotFixture;
import oracle.abbot.JDevScriptFixtureContext;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

public class VideoGrabFixture
implements AbbotFixture {
    private static final int DELAY = 500;
    private static final int FAST_TIME = Integer.parseInt(System.getProperty("abbot.video.fast", "10000"));
    private static final int FAST_COUNT = FAST_TIME / 500;
    private static Robot r = new Robot();
    private static Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private static final AtomicBoolean captureInputEvents = new AtomicBoolean(false);
    private static long startTime;
    private static List<byte[]> inputImages;
    private static ExecutorService queue;
    private Timer _timer;
    private SpecialList quickImages = new SpecialList();
    private List<byte[]> slowImages = new ArrayList<byte[]>();

    @Override
    public void setUp(JDevScriptFixtureContext context) {
        startTime = System.currentTimeMillis();
        this.clearImagesAndSettings();
        if ("timer".equals(System.getProperty("abbot.video"))) {
            this.startImageWriter();
            this._timer = new Timer("Abbot Frame Capture");
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    BufferedImage bi = VideoGrabFixture.grabImage(false, null);
                    VideoGrabFixture.this.storeImageForVideo(bi);
                }

                @Override
                public long scheduledExecutionTime() {
                    return super.scheduledExecutionTime();
                }
            };
            this._timer.scheduleAtFixedRate(task, 0L, 500L);
        } else if ("input".equals(System.getProperty("abbot.video"))) {
            this.startImageWriter();
            captureInputEvents.set(true);
        }
    }

    private void startImageWriter() {
        queue = Executors.newSingleThreadExecutor(oracle.javatools.util.Executors.namedThreadFactory((String)"VideoGrabFixture"));
    }

    @Override
    public void tearDown(JDevScriptFixtureContext context) {
        if (queue != null) {
            queue.shutdown();
            try {
                if (!queue.awaitTermination(10L, TimeUnit.MINUTES)) {
                    throw new RuntimeException("Time out rendering images");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            queue = null;
        }
        if (this._timer != null) {
            this._timer.cancel();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            int counter = 0;
            counter = this.dumpImages(context, this.slowImages, "slow", counter, FAST_TIME);
            this.pruneQuickImages();
            int n = this.dumpImages(context, this.quickImages, "quick", counter, 500);
        }
        if (inputImages.size() > 0) {
            this.dumpImages(context, inputImages, "click", 0, 1);
        }
        this.clearImagesAndSettings();
    }

    private void clearImagesAndSettings() {
        this.quickImages.clear();
        this.slowImages.clear();
        inputImages.clear();
        captureInputEvents.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpImages(JDevScriptFixtureContext context, List<byte[]> images, String postfix, int counter, int incremenet) {
        PrintWriter pw = new PrintWriter((OutputStream)context.getResultsStream("index-images-" + postfix + ".html").getSecond());
        pw.println("<html><head><title>Image dump</title></head><body>");
        for (byte[] bi : images) {
            Pair<URL, OutputStream> pair = context.getResultsStream("video." + (counter += incremenet) + postfix + ".png");
            OutputStream os = (OutputStream)pair.getSecond();
            try {
                os.write(bi);
                pw.printf("<p><img src=\"%s\" /></p>\n", URLFileSystem.getFileName((URL)((URL)pair.getFirst())));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException sfg) {
                    sfg.printStackTrace();
                }
            }
        }
        pw.println("</body>");
        pw.close();
        return counter;
    }

    private void storeImageForVideo(final BufferedImage image) {
        queue.submit(new Runnable(){

            @Override
            public void run() {
                byte[] array = VideoGrabFixture.storeImageImpl(image);
                VideoGrabFixture.this.quickImages.add(array);
                if (VideoGrabFixture.this.quickImages.size() > FAST_COUNT * 2) {
                    VideoGrabFixture.this.slowImages.add(VideoGrabFixture.this.quickImages.get(0));
                    VideoGrabFixture.this.pruneQuickImages();
                }
            }
        });
    }

    private static void storeImage(final BufferedImage image) {
        queue.submit(new Runnable(){

            @Override
            public void run() {
                byte[] array = VideoGrabFixture.storeImageImpl(image);
                inputImages.add(array);
            }
        });
    }

    private static byte[] storeImageImpl(BufferedImage image) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", bos);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        byte[] array = bos.toByteArray();
        return array;
    }

    private void pruneQuickImages() {
        if (this.quickImages.size() > FAST_COUNT) {
            this.quickImages.removeRange(0, this.quickImages.size() - FAST_COUNT);
        }
    }

    private static BufferedImage grabImage(boolean mouseClick, String text) {
        BufferedImage bi = r.capture(new Rectangle(0, 0, VideoGrabFixture.dim.width, VideoGrabFixture.dim.height));
        PointerInfo info = MouseInfo.getPointerInfo();
        Point location = info.getLocation();
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(mouseClick ? Color.RED : Color.GREEN);
        graphics.setStroke(new BasicStroke(2.0f));
        int x = location.x - 10;
        int y = location.y - 10;
        graphics.drawOval(x, y, 20, 20);
        if (ModelUtil.hasLength((String)text)) {
            String[] lines = text.split("\n");
            FontMetrics metrics = graphics.getFontMetrics();
            double width = 0.0;
            double height = 0.0;
            double[] ys = new double[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                Rectangle2D rect = metrics.getStringBounds(line, graphics);
                double lineWidth = rect.getWidth();
                if (lineWidth > width) {
                    width = lineWidth;
                }
                double lineHeight = rect.getHeight();
                ys[i] = height += lineHeight;
            }
            double textX = Math.min((double)x, (double)VideoGrabFixture.dim.width - (width += 2.0));
            double textY = Math.max((double)(y - 1) - (height += 1.0), 0.0);
            graphics.translate(textX, textY);
            graphics.setComposite(AlphaComposite.SrcOver.derive(0.7f));
            graphics.setColor(Color.WHITE);
            graphics.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
            graphics.setComposite(AlphaComposite.Src);
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                graphics.drawString(line, 1.0f, (float)ys[i]);
            }
        }
        return bi;
    }

    static {
        inputImages = new ArrayList<byte[]>();
        queue = null;
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (captureInputEvents.get() && (event.getID() == 500 || event.getID() == 501 || event.getID() == 502)) {
                    Object source = event.getSource();
                    String message = source.getClass().getName();
                    if (source instanceof Component) {
                        Component c = (Component)source;
                        Point location = null;
                        if (c.isShowing()) {
                            location = c.getLocationOnScreen();
                        } else {
                            location = c.getLocation();
                            message = message + "!hidden!";
                        }
                        int left = location.x;
                        int top = location.y;
                        message = message + "[";
                        message = message + c.getName();
                        message = message + ", left=" + left;
                        message = message + ", top=" + top;
                        message = message + ", right=" + (left + c.getWidth());
                        message = message + ", bottom=" + (top + c.getHeight());
                        message = message + "]";
                    }
                    message = message + "\n" + event.paramString();
                    if (event instanceof InputEvent) {
                        message = message + "\n at " + (((InputEvent)event).getWhen() - startTime) + "ms";
                    }
                    VideoGrabFixture.storeImage(VideoGrabFixture.grabImage(true, message));
                }
            }
        }, 500L);
    }

    private static class SpecialList
    extends ArrayList<byte[]> {
        private SpecialList() {
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

