/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot.junit;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import oracle.abbot.JDevScriptFixture;
import oracle.abbot.junit.JUnitTest;
import oracle.abbot.junit.XMLConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XMLJUnitResultFormatter
implements TestListener,
XMLConstants {
    private static final double ONE_SECOND = 1000.0;
    private static final String UNKNOWN = "unknown";
    private Document doc;
    private Element rootElement;
    private JUnitTest currentSuite;
    private Hashtable testElements = new Hashtable();
    private Hashtable failedTests = new Hashtable();
    private Hashtable testStarts = new Hashtable();

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public void setOutput(OutputStream out) {
        throw new IllegalStateException("Override createOutput instead");
    }

    protected abstract OutputStream createOutput() throws IOException;

    public void setSystemOutput(String out) {
        this.formatOutput("system-out", out);
    }

    public void setSystemError(String out) {
        this.formatOutput("system-err", out);
    }

    public void startTestSuite(JUnitTest suite) {
        this.currentSuite = suite;
        this.doc = XMLJUnitResultFormatter.getDocumentBuilder().newDocument();
        this.rootElement = this.doc.createElement("testsuite");
        String n = suite.getName();
        this.rootElement.setAttribute("name", n == null ? UNKNOWN : n);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String timestamp = sdf.format(new Date());
        this.rootElement.setAttribute("timestamp", timestamp);
        this.rootElement.setAttribute("hostname", this.getHostname());
        Element propsElement = this.doc.createElement("properties");
        this.rootElement.appendChild(propsElement);
        Properties props = suite.getProperties();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Element propElement = this.doc.createElement("property");
                propElement.setAttribute("name", name);
                propElement.setAttribute("value", props.getProperty(name));
                propsElement.appendChild(propElement);
            }
        }
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public void endTestSuite(JUnitTest suite) throws IOException {
        this.rootElement.setAttribute("tests", "" + suite.runCount());
        this.rootElement.setAttribute("failures", "" + suite.failureCount());
        this.rootElement.setAttribute("errors", "" + suite.errorCount());
        this.rootElement.setAttribute("time", "" + (double)suite.getRunTime() / 1000.0);
        OutputStream out = this.createOutput();
        if (out != null) {
            BufferedWriter wri = null;
            try {
                wri = new BufferedWriter(new OutputStreamWriter(out, "UTF8"));
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.rootElement), new StreamResult(wri));
                ((Writer)wri).flush();
            }
            catch (Exception exc) {
                throw new IOException("Unable to write log file", exc);
            }
            finally {
                if (out != System.out && out != System.err) {
                    ((Writer)wri).close();
                }
            }
        }
    }

    public void startTest(Test t) {
        this.testStarts.put(t, new Long(System.currentTimeMillis()));
    }

    public void endTest(Test test) {
        if (!this.testStarts.containsKey(test)) {
            this.startTest(test);
        }
        Element currentTest = null;
        if (!this.failedTests.containsKey(test)) {
            currentTest = this.doc.createElement("testcase");
            JDevScriptFixture tc = (JDevScriptFixture)test;
            currentTest.setAttribute("name", tc.getName());
            currentTest.setAttribute("classname", tc.getClassName());
            if (tc.getExemptUntil() != null) {
                currentTest.setAttribute("exemptUntil", tc.getExemptUntil());
            }
            if (tc.getUnstable() != null) {
                currentTest.setAttribute("unstable-bugs", tc.getUnstable());
            }
            this.rootElement.appendChild(currentTest);
            this.testElements.put(test, currentTest);
        } else {
            currentTest = (Element)this.testElements.get(test);
        }
        long duration = ((JDevScriptFixture)test).getDuration();
        if (duration <= 0L) {
            Long l = (Long)this.testStarts.get(test);
            duration = System.currentTimeMillis() - l;
        }
        currentTest.setAttribute("time", "" + (double)duration / 1000.0);
        try {
            this.endTestSuite(this.currentSuite);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeTest(Test test) {
        this.failedTests.remove(test);
        JDevScriptFixture jdsf = (JDevScriptFixture)test;
        String name = jdsf.getName();
        NodeList children = this.rootElement.getChildNodes();
        int i = children.getLength();
        for (int j = 0; j < i; ++j) {
            Element next = (Element)children.item(j);
            String nextName = next.getAttribute("name");
            if (!name.equals(nextName)) continue;
            this.rootElement.removeChild(next);
            break;
        }
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("failure", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        this.formatError("error", test, t);
    }

    private void formatError(String type, Test test, Throwable t) {
        if (test != null) {
            this.endTest(test);
            this.failedTests.put(test, test);
        }
        Element nested = this.doc.createElement(type);
        Element currentTest = null;
        currentTest = test != null ? (Element)this.testElements.get(test) : this.rootElement;
        currentTest.appendChild(nested);
        String message = t.getMessage();
        if (message != null && message.length() > 0) {
            nested.setAttribute("message", t.getMessage());
        }
        nested.setAttribute("type", t.getClass().getName());
        if (!(t instanceof HangingTest)) {
            System.err.println("*********************************************************");
            System.err.println("*********************************************************");
            System.err.println("Recording problem in test : " + test.toString());
            t.printStackTrace();
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                System.err.println("*");
                System.err.println("*");
                System.err.println("* Drilling into Cause");
                System.err.println("*");
                cause.printStackTrace();
            }
            System.err.println("*********************************************************");
            System.err.println("*********************************************************");
        }
        String strace = XMLJUnitResultFormatter.getStackTrace(t);
        Text trace = this.doc.createTextNode(strace);
        nested.appendChild(trace);
    }

    private void formatOutput(String type, String output) {
        Element nested = this.doc.createElement(type);
        this.rootElement.appendChild(nested);
        nested.appendChild(this.doc.createCDATASection(output));
    }

    private static String getStackTrace(Throwable th) {
        StringWriter sw = new StringWriter();
        th.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static class HangingTest
    extends Throwable {
        public HangingTest(String message) {
            super(message);
        }
    }
}

