/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot.util;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;

public class CauseDeadlock {
    public static void setup() {
        try {
            CauseDeadlock.setupImpl();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    private static void setupImpl() throws IOException, InterruptedException, Exception {
        final File tmp = File.createTempFile("text", ".txt");
        URL tmpUrl = URLFactory.newFileURL((File)tmp);
        final TextNode txt = (TextNode)NodeFactory.findOrCreateOrFail(TextNode.class, (URL)tmpUrl);
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    txt.open();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    txt.callUnderReadLock((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws InterruptedException {
                            System.out.println("@@@@@@@@@ Got hold of read lock of " + tmp);
                            System.out.println("@@@@@@@@@ Now sleeping");
                            TimeUnit.MINUTES.sleep(15L);
                            System.out.println("@@@@@@@@@ Awake again " + tmp);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        TimeUnit.SECONDS.sleep(5L);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    txt.callUnderWriteLock((Callable)new Callable<Void>(){

                        @Override
                        public Void call() {
                            System.out.println("@@@@@@@@@ Got hold of write lock of " + tmp);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

