/*
 * Decompiled with CFR 0.152.
 */
package oracle.abbot.util;

import java.net.URL;
import java.util.ArrayList;
import oracle.abbot.TestHelper;
import oracle.abbot.util.Unzipper;
import oracle.abbot.util.Zipper;
import oracle.ide.Ide;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.log.LogManager;
import oracle.ide.net.URLFileSystem;

public class Migrator
implements Runnable {
    URL[] zips;

    public Migrator(URL[] projects) {
        this.zips = projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<String> migrated = new ArrayList<String>();
        ArrayList<String> failed = new ArrayList<String>();
        for (URL zip : this.zips) {
            URL storedWorkDir = Ide.getWorkspaces().getWorkDirectory();
            try {
                URL tempDir = TestHelper.createTemporaryDir("migration", "");
                Ide.getWorkspaces().setWorkDirectory(tempDir);
                String name = URLFileSystem.getPlatformPathName((URL)zip);
                String filename = URLFileSystem.getFileName((URL)zip);
                this.log("Looking at " + name);
                if (zip.getPath().contains("NOMIGRATE")) {
                    this.log("Skipping " + name);
                    continue;
                }
                if (!URLFileSystem.canWrite((URL)zip) && !URLFileSystem.setReadOnly((URL)zip, (boolean)false)) {
                    this.log("Cannot check out zip " + name);
                    this.log("Is versioning disbled? Try Versioning->Connect to ADE");
                    return;
                }
                try {
                    Unzipper unzipper = new Unzipper(zip, true, false);
                    unzipper.run();
                    SaveAllCommand.saveAll((boolean)true);
                    Zipper zippper = new Zipper(zip);
                    zippper.run();
                    migrated.add(filename);
                }
                catch (Throwable t) {
                    failed.add(filename);
                    this.log("Failed to migrate project " + name);
                    t.printStackTrace();
                }
            }
            finally {
                Ide.getWorkspaces().setWorkDirectory(storedWorkDir);
            }
        }
        LogManager.getLogManager().showLog();
        this.log("");
        this.log("");
        this.log("");
        this.log("Finished migrating projects");
        this.log("Migrated : " + migrated);
        this.log("Failed : " + failed);
        this.log("");
        this.log("");
        this.log("");
    }

    private void log(String text) {
        System.err.println("{}{}{}{}   " + text);
        LogManager.getLogManager().getMsgPage().log((Object)(text + "\n"));
    }
}

