/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.util.HashMap;
import java.util.Hashtable;
import oracle.dss.dataView.DataviewAttributes;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.presutil.CommonViewXML;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

@Concealed
public class DataviewXML
extends CommonViewXML {
    @Concealed
    public static final String a_drillingEnabled = "drillingEnabled";
    @Concealed
    public static final String a_pagingControlVisible = "pagingControlVisible";
    @Concealed
    public static final String a_pagingControlPosition = "pagingControlPosition";
    @Concealed
    public static final String a_htmlPagingControlWidth = "htmlPagingControlWidth";
    @Concealed
    public static final String a_htmlPagingControlAutosubmit = "htmlPagingControlAutosubmit";
    @Concealed
    public static final String left = "LEFT";
    @Concealed
    public static final String center = "CENTER";
    @Concealed
    public static final String right = "RIGHT";
    @Concealed
    public static final String leading = "LEADING";
    private static final String a_columnLayerMetadataLabelType = "columnLayerMetadataLabelType";
    private static final String a_rowLayerMetadataLabelType = "rowLayerMetadataLabelType";
    private static final String a_pageLayerMetadataLabelType = "pageLayerMetadataLabelType";
    private static final String a_columnMemberMetadataLabelType = "columnMemberMetadataLabelType";
    private static final String a_rowMemberMetadataLabelType = "rowMemberMetadataLabelType";
    private static final String a_pageMemberMetadataLabelType = "pageMemberMetadataLabelType";
    private static final String layer_metadata_longlabel = "LAYER_METADATA_LONGLABEL";
    private static final String layer_metadata_mediumlabel = "LAYER_METADATA_MEDIUMLABEL";
    private static final String layer_metadata_shortlabel = "LAYER_METADATA_SHORTLABEL";
    private static final String layer_metadata_name = "LAYER_METADATA_NAME";
    private static final String metadata_longlabel = "METADATA_LONGLABEL";
    private static final String metadata_mediumlabel = "METADATA_MEDIUMLABEL";
    private static final String metadata_shortlabel = "METADATA_SHORTLABEL";
    private static final String metadata_value = "METADATA_VALUE";
    protected String d_name;
    protected String d_localName;
    protected String d_description;
    protected boolean d_drillingEnabled;
    protected boolean d_pagingControlVisible;
    protected int d_pagingControlPosition;
    protected int d_htmlPagingControlWidth;
    protected boolean d_htmlPagingControlAutosubmit;
    protected String[] d_layerMetadataLabelTypes;
    protected String[] d_memberMetadataLabelTypes;
    private DataviewAttributes _dataview;
    @Concealed
    protected Hashtable m_context;
    private HashMap m_jsfHashMap = null;

    @Concealed
    public DataviewXML(DataviewAttributes dataview) {
        this._dataview = dataview;
    }

    protected void initDefaults(DataviewDefaultValues ddv) {
        this.d_name = ddv.getName();
        this.d_localName = ddv.getLocalName();
        this.d_description = ddv.getDescription();
        this.d_drillingEnabled = ddv.isDrillingEnabled();
        this.d_pagingControlVisible = ddv.isPagingControlVisible();
        this.d_pagingControlPosition = ddv.getPagingControlPosition();
        this.d_htmlPagingControlWidth = ddv.getHTMLPagingControlWidth();
        this.d_htmlPagingControlAutosubmit = ddv.isHTMLPagingControlAutosubmit();
        this.d_layerMetadataLabelTypes = new String[3];
        this.d_memberMetadataLabelTypes = new String[3];
        for (int edge = 0; edge < 3; ++edge) {
            this.d_layerMetadataLabelTypes[edge] = DataviewDefaultValues.getLayerMetadataLabelType(edge);
            this.d_memberMetadataLabelTypes[edge] = DataviewDefaultValues.getMemberMetadataLabelType(edge);
        }
    }

    @Concealed
    public void setContext(Hashtable context) {
        this.m_context = context;
    }

    @Concealed
    public void setXML(ObjectNode node, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    @Concealed
    public void setXML(ObjectNode node) {
        boolean val;
        this.setStyleXML(node);
        PropertyNode pNode = node.getProperty(a_drillingEnabled);
        if (pNode != null) {
            val = pNode.getValueAsBoolean();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_drillingEnabled, new Boolean(val));
            } else {
                this._dataview.setDrillingEnabled(val);
            }
        }
        if ((pNode = node.getProperty(a_pagingControlVisible)) != null) {
            val = pNode.getValueAsBoolean();
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put(a_pagingControlVisible, new Boolean(val));
            } else {
                this._dataview.setPagingControlVisible(val);
            }
        }
        if ((pNode = node.getProperty(a_pagingControlPosition)) != null) {
            String tmp = pNode.getValueAsString();
            if (tmp.equals("PAGING_CONTROL_ABOVE_TITLES")) {
                this._dataview.setPagingControlPosition(0);
            } else if (tmp.equals("PAGING_CONTROL_BELOW_TITLES")) {
                this._dataview.setPagingControlPosition(1);
            }
        }
        if ((pNode = node.getProperty(a_htmlPagingControlAutosubmit)) != null) {
            this._dataview.setHTMLPagingControlAutosubmit(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_htmlPagingControlWidth)) != null) {
            this._dataview.setHTMLPagingControlWidth(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty(a_columnLayerMetadataLabelType)) != null) {
            this._dataview.setLayerMetadataLabelType(0, this._convertStringToLayerMetadataLabelType(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_rowLayerMetadataLabelType)) != null) {
            this._dataview.setLayerMetadataLabelType(1, this._convertStringToLayerMetadataLabelType(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_pageLayerMetadataLabelType)) != null) {
            this._dataview.setLayerMetadataLabelType(2, this._convertStringToLayerMetadataLabelType(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_columnMemberMetadataLabelType)) != null) {
            this._dataview.setMemberMetadataLabelType(0, this._convertStringToMemberMetadataLabelType(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_rowMemberMetadataLabelType)) != null) {
            this._dataview.setMemberMetadataLabelType(1, this._convertStringToMemberMetadataLabelType(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_pageMemberMetadataLabelType)) != null) {
            this._dataview.setMemberMetadataLabelType(2, this._convertStringToMemberMetadataLabelType(pNode.getValueAsString()));
        }
    }

    @Concealed
    public ObjectNode getObjectNode(ObjectNode node, boolean allProperties) {
        boolean nodeExists = this.getStyleXML(allProperties, node);
        if (allProperties || this._dataview.isDrillingEnabled() != this.d_drillingEnabled) {
            node.addProperty(a_drillingEnabled, this._dataview.isDrillingEnabled());
            nodeExists = true;
        }
        if (allProperties || this.d_pagingControlVisible != this._dataview.isPagingControlVisible()) {
            node.addProperty(a_pagingControlVisible, this._dataview.isPagingControlVisible());
            nodeExists = true;
        }
        if (allProperties || this._dataview.getPagingControlPosition() != this.d_pagingControlPosition) {
            int tmp = this._dataview.getPagingControlPosition();
            if (tmp == 0) {
                node.addProperty(a_pagingControlPosition, "PAGING_CONTROL_ABOVE_TITLES");
            } else if (tmp == 1) {
                node.addProperty(a_pagingControlPosition, "PAGING_CONTROL_BELOW_TITLES");
            }
            nodeExists = true;
        }
        if (allProperties || this.d_htmlPagingControlAutosubmit != this._dataview.isHTMLPagingControlAutosubmit()) {
            node.addProperty(a_htmlPagingControlAutosubmit, this._dataview.isHTMLPagingControlAutosubmit());
            nodeExists = true;
        }
        if (allProperties || this.d_htmlPagingControlWidth != this._dataview.getHTMLPagingControlWidth()) {
            node.addProperty(a_htmlPagingControlWidth, this._dataview.getHTMLPagingControlWidth());
            nodeExists = true;
        }
        String type = this._dataview.getLayerMetadataLabelType(0);
        if (allProperties || !type.equals(this.d_layerMetadataLabelTypes[0])) {
            node.addProperty(a_columnLayerMetadataLabelType, this._convertLayerMetadataLabelTypeToString(type));
            nodeExists = true;
        }
        type = this._dataview.getLayerMetadataLabelType(1);
        if (allProperties || !type.equals(this.d_layerMetadataLabelTypes[1])) {
            node.addProperty(a_rowLayerMetadataLabelType, this._convertLayerMetadataLabelTypeToString(type));
            nodeExists = true;
        }
        type = this._dataview.getLayerMetadataLabelType(2);
        if (allProperties || !type.equals(this.d_layerMetadataLabelTypes[2])) {
            node.addProperty(a_pageLayerMetadataLabelType, this._convertLayerMetadataLabelTypeToString(type));
            nodeExists = true;
        }
        type = this._dataview.getMemberMetadataLabelType(0);
        if (allProperties || !type.equals(this.d_memberMetadataLabelTypes[0])) {
            node.addProperty(a_columnMemberMetadataLabelType, this._convertMemberMetadataLabelTypeToString(type));
            nodeExists = true;
        }
        type = this._dataview.getMemberMetadataLabelType(1);
        if (allProperties || !type.equals(this.d_memberMetadataLabelTypes[1])) {
            node.addProperty(a_rowMemberMetadataLabelType, this._convertMemberMetadataLabelTypeToString(type));
            nodeExists = true;
        }
        type = this._dataview.getMemberMetadataLabelType(2);
        if (allProperties || !type.equals(this.d_memberMetadataLabelTypes[2])) {
            node.addProperty(a_pageMemberMetadataLabelType, this._convertMemberMetadataLabelTypeToString(type));
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Concealed
    public void resetDataviewXML() {
        this.resetStyleDataviewXML();
        this._dataview.setDrillingEnabled(this.d_drillingEnabled);
        this._dataview.setPagingControlVisible(this.d_pagingControlVisible);
        this._dataview.setPagingControlPosition(this.d_pagingControlPosition);
        this._dataview.setHTMLPagingControlAutosubmit(this.d_htmlPagingControlAutosubmit);
        this._dataview.setHTMLPagingControlWidth(this.d_htmlPagingControlWidth);
        for (int edge = 0; edge < 3; ++edge) {
            this._dataview.setLayerMetadataLabelType(edge, this.d_layerMetadataLabelTypes[edge]);
            this._dataview.setMemberMetadataLabelType(edge, this.d_memberMetadataLabelTypes[edge]);
        }
    }

    @Concealed
    public void setStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("name");
        if (pNode != null) {
            this._dataview.setName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty("localName")) != null) {
            this._dataview.setLocalName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty("description")) != null) {
            this._dataview.setDescription(pNode.getValueAsString());
        }
    }

    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = false;
        if (allProperties || !this.d_name.equals(this._dataview.getName())) {
            node.addProperty("name", this._dataview.getName());
            styleOverridden = true;
        }
        if (allProperties || !this.d_localName.equals(this._dataview.getLocalName())) {
            node.addProperty("localName", this._dataview.getLocalName());
            styleOverridden = true;
        }
        if (allProperties || !this.d_description.equals(this._dataview.getDescription())) {
            node.addProperty("description", this._dataview.getDescription());
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Concealed
    public void resetStyleDataviewXML() {
        this._dataview.setName(this.d_name);
        this._dataview.setLocalName(this.d_localName);
        this._dataview.setDescription(this.d_description);
    }

    private String _convertLayerMetadataLabelTypeToString(String type) {
        if (type.equals("dimShortName")) {
            return layer_metadata_shortlabel;
        }
        if (type.equals("dimMediumName")) {
            return layer_metadata_mediumlabel;
        }
        if (type.equals("layerName")) {
            return layer_metadata_name;
        }
        return layer_metadata_longlabel;
    }

    private String _convertStringToLayerMetadataLabelType(String xmlString) {
        if (xmlString.equals(layer_metadata_shortlabel)) {
            return "dimShortName";
        }
        if (xmlString.equals(layer_metadata_mediumlabel)) {
            return "dimMediumName";
        }
        if (xmlString.equals(layer_metadata_name)) {
            return "layerName";
        }
        return "layerLabel";
    }

    private String _convertMemberMetadataLabelTypeToString(String type) {
        if (type.equals("shortName")) {
            return metadata_shortlabel;
        }
        if (type.equals("mediumName")) {
            return metadata_mediumlabel;
        }
        if (type.equals("value")) {
            return metadata_value;
        }
        return metadata_longlabel;
    }

    private String _convertStringToMemberMetadataLabelType(String xmlString) {
        if (xmlString.equals(metadata_shortlabel)) {
            return "shortName";
        }
        if (xmlString.equals(metadata_mediumlabel)) {
            return "mediumName";
        }
        if (xmlString.equals(metadata_value)) {
            return "value";
        }
        return "label";
    }
}

