/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dss.gauge.CustomShape;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeLayout;
import oracle.dss.gauge.GaugeType;
import oracle.javatools.annotations.Concealed;

@Concealed
public class StatusMeterGauge
extends GaugeType {
    private boolean m_horizontalFlip = false;
    private static final double HEIGHT_OVERLAY_REFLECTION = 0.5;
    private static final int VERTICAL_STATUSMETER_GAP = 2;
    private static final int VERTICAL_TICKLBL_GAP = 2;
    private static final int TICKMARK_LENGTH = 6;
    private static final double INCR_FACTOR = 0.02;
    private double _tickMarkYPos;
    private ArrayList<Point2D> _tickMarkPositions;
    private int _tickMarkLength = 6;
    private Area _plotArea;

    public StatusMeterGauge(GaugeEngine engine) {
        super(engine);
    }

    @Override
    public int getGaugeType() {
        return 1;
    }

    @Override
    protected Dimension autoLayout(Graphics2D g, Rectangle rect, Map map) {
        Dimension dim = super.autoLayout(g, rect, map);
        if (this._csParser == null || !this._csParser.defines("plotAreaBounds") && !this._csParser.defines("gaugeFrame")) {
            int metLblPos;
            if (this.isSpaceLimited(dim, rect)) {
                this._layout.setScalingUsed(true);
                dim = super.autoLayout(g, rect, map);
            }
            int labelsRemoved = 0;
            if (this.isSpaceLimited(dim, rect)) {
                int topLblPos = this.getTopLabelPosition(map);
                if (topLblPos == 3 && (this._csParser == null || !this._csParser.defines("topLabelBounds") && !this._csParser.defines("upperLabelFrame"))) {
                    map.put("TopLabelPosition", 0);
                    dim = super.autoLayout(g, rect, map);
                }
                ++labelsRemoved;
            }
            if (this.isSpaceLimited(dim, rect)) {
                map.put("TickLabelContent", 0);
                map.put("TickMarkContent", 0);
                dim = super.autoLayout(g, rect, map);
                ++labelsRemoved;
            }
            if (this.isSpaceLimited(dim, rect)) {
                int bottomLblPos = this.getBottomLabelPosition(map);
                if (bottomLblPos == 1 && (this._csParser == null || !this._csParser.defines("bottomLabelBounds") && !this._csParser.defines("lowerLabelFrame"))) {
                    map.put("BottomLabelPosition", 0);
                    dim = super.autoLayout(g, rect, map);
                }
                ++labelsRemoved;
            }
            if (this.isSpaceLimited(dim, rect) && (metLblPos = this.getMetricLabelPosition(map)) == 1 && (this._csParser == null || !this._csParser.defines("metricLabelBounds") && !this._csParser.defines("lowerLabelFrame"))) {
                map.put("MetricLabelPosition", 0);
                dim = super.autoLayout(g, rect, map);
            }
            if (labelsRemoved == 3) {
                this._engine.getErrorHandler().trace(this._engine.getIntlString("af_dvt_gauge.LABEL_REMOVE_TOP_TICK_BOTTOM", this._gaugeBundle), this.getClass().getName(), "autoLayout");
            } else if (labelsRemoved == 2) {
                this._engine.getErrorHandler().trace(this._engine.getIntlString("af_dvt_gauge.LABEL_REMOVE_TOP_TICK", this._gaugeBundle), this.getClass().getName(), "autoLayout");
            } else if (labelsRemoved == 1) {
                this._engine.getErrorHandler().trace(this._engine.getIntlString("af_dvt_gauge.LABEL_REMOVE_TOP", this._gaugeBundle), this.getClass().getName(), "autoLayout");
            }
        }
        return dim;
    }

    boolean isSpaceLimited(Dimension reqSize, Rectangle availBounds) {
        return this._innerBounds.height < 12 || reqSize.height > availBounds.height;
    }

    @Override
    protected Collection getPlotAreaObject(Map map, int type) {
        Color borderColor;
        Color fillColor;
        ArrayList<Object> objects = new ArrayList<Object>(15);
        this.m_horizontalFlip = false;
        if (this._engine.isBIDILocale()) {
            this.m_horizontalFlip = true;
        }
        if ((fillColor = (Color)map.get("PlotAreaFillColor")) == null) {
            fillColor = GaugeDefaultValues.getPlotAreaFillColor(this.getGaugeType());
        }
        if ((borderColor = (Color)map.get("PlotAreaBorderColor")) == null) {
            borderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
        }
        HashMap sfxMap = (HashMap)map.get("PlotAreaSFX");
        double x = this._innerBounds.x;
        double y = this._innerBounds.y;
        double width = this._innerBounds.width;
        double height = this._innerBounds.height;
        double arcRadius = this._innerBounds.height / 3;
        Area plotArea = new Area(new Rectangle2D.Double(x, y, width, height));
        if (this._innerBounds.height >= 10) {
            Area mask = new Area(new RoundRectangle2D.Double(x, y, width, height * 2.0, arcRadius, arcRadius));
            plotArea.intersect(mask);
        }
        if (height >= 10.0) {
            this._plotArea = (Area)plotArea.clone();
        }
        if (this._csParser != null && this._csParser.defines("plotArea")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("plotArea");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = StatusMeterGauge.getScalingTransform(bounds, this._innerBounds, this.m_horizontalFlip);
                this._moveTransform = move = StatusMeterGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            Color userBorderColor = (Color)map.get("PlotAreaBorderColor");
            Color userFillColor = (Color)map.get("PlotAreaFillColor");
            if (map.get("PlotAreaUseThresholdFillColor") != null && ((Boolean)map.get("PlotAreaUseThresholdFillColor")).booleanValue()) {
                userFillColor = this._getIndicatorColor(map, true);
            }
            HashMap userSFXMap = (HashMap)map.get("PlotAreaSFX");
            List<CustomShape> shapesList = this._csParser.getShapes("plotArea");
            for (int i = 0; i < shapesList.size(); ++i) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                HashMap csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                objects.add(new DrawableObject.Shape(11, s, csBorderColor, csFillColor, csSFXMap, null));
            }
            if (map.get("ThresholdValues") != null) {
                objects.add(this._getThresholdObjects(map, new Area(bounds)));
            }
        } else if (map.get("ThresholdValues") != null) {
            objects.add(new DrawableObject.Shape(11, plotArea, borderColor, null, sfxMap, null));
            objects.add(this._getThresholdObjects(map, plotArea));
        } else {
            objects.add(new DrawableObject.Shape(11, plotArea, borderColor, fillColor, sfxMap, null));
        }
        return objects;
    }

    @Override
    protected Collection getIndicatorObject(Map map, int metricIndex) {
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>(15);
        if (this._engine.getMetricMin() < this._engine.getMin()) {
            return objects;
        }
        if (this._engine.isNullMetric()) {
            DrawableObject noDataObj = this.getNoDataLabelObject(map);
            if (noDataObj != null) {
                objects.add(noDataObj);
            }
            return objects;
        }
        Double metric = this._engine.getMetric(metricIndex);
        if (metric != null) {
            double xEnd;
            double xArc;
            double x;
            Color borderColor;
            double[] tValues = (double[])map.get("ThresholdValues");
            ArrayList tList = (ArrayList)map.get("THRESHOLD_ATTRIBUTES");
            Color fillColor = (Color)this._engine.getIndicatorAttr("IndicatorBarFillColor", metricIndex);
            if (fillColor == null) {
                fillColor = GaugeDefaultValues.getIndicatorBarFillColor();
            }
            if ((borderColor = (Color)this._engine.getIndicatorAttr("IndicatorBarBorderColor", metricIndex)) == null) {
                borderColor = GaugeDefaultValues.getIndicatorBarBorderColor();
            }
            HashMap sfxMap = (HashMap)this._engine.getIndicatorAttr("IndicatorBarSFX", metricIndex);
            Boolean autoColor = (Boolean)this._engine.getIndicatorAttr("IndicatorUseThresholdFillColor", metricIndex);
            GaugeDefaultValues.isIndicatorUseThresholdFillColor();
            if (autoColor == null) {
                autoColor = GaugeDefaultValues.isIndicatorUseThresholdFillColor();
            }
            if (autoColor.booleanValue() && tValues != null) {
                int index = -1;
                for (int i = 0; i < tValues.length; ++i) {
                    if (metric <= tValues[i]) {
                        index = i;
                        break;
                    }
                    if (i != tValues.length - 1) continue;
                    index = tValues.length;
                }
                if (tList != null && index < tList.size()) {
                    HashMap tMap = (HashMap)tList.get(index);
                    fillColor = ((Color)StatusMeterGauge.getThresholdAttribute(tMap, index, "ThresholdFillColor")).darker();
                    sfxMap = (HashMap)StatusMeterGauge.getThresholdAttribute(tMap, index, "ThresholdSFX");
                } else {
                    Color[] defClrs = GaugeDefaultValues.getThresholdColors();
                    if (index < defClrs.length) {
                        fillColor = defClrs[index].darker();
                    }
                }
            }
            double barLength = (metric - this._engine.getMin()) / (this._engine.getMax() - this._engine.getMin());
            barLength = Math.min(barLength, 1.0);
            int barHeight = GaugeLayout.getStatusmeterIndicatorSize(this._innerBounds.height);
            double width = (double)this._innerBounds.width * barLength;
            double height = barHeight;
            double arcRadius = height >= 10.0 ? (double)(barHeight / 2) : 0.0;
            double y = this._innerBounds.y + (this._innerBounds.height / 2 - barHeight / 2);
            double yArc1 = y + arcRadius;
            double yArc2 = y + height - arcRadius;
            double yEnd = y + height;
            double fudgeFactor = 0.1;
            if (!this.m_horizontalFlip) {
                x = this._innerBounds.x;
                xArc = Math.max(x + width - arcRadius, x + fudgeFactor);
                xEnd = x + width;
            } else {
                x = this._innerBounds.x + this._innerBounds.width;
                xEnd = x - (double)this._innerBounds.width * barLength;
                xArc = Math.min(xEnd + arcRadius, x - fudgeFactor);
            }
            Path2D.Double indicator = new Path2D.Double();
            ((Path2D)indicator).moveTo(x, y);
            ((Path2D)indicator).lineTo(x, yEnd);
            ((Path2D)indicator).lineTo(xArc, yEnd);
            ((Path2D)indicator).curveTo(xEnd, yEnd, xEnd, yEnd, xEnd, yArc2);
            ((Path2D)indicator).lineTo(xEnd, yArc1);
            ((Path2D)indicator).curveTo(xEnd, y, xEnd, y, xArc, y);
            indicator.closePath();
            if (this._csParser != null && this._csParser.defines("indicator")) {
                AffineTransform move;
                AffineTransform scale;
                Rectangle2D bounds = this._csParser.getBounds("indicator");
                if (this._scaleTransform != null && this._moveTransform != null) {
                    scale = this._scaleTransform;
                    move = this._moveTransform;
                } else {
                    Rectangle iBounds = new Rectangle(this._innerBounds.x, this._innerBounds.y + (this._innerBounds.height / 2 - barHeight / 2), this._innerBounds.width, barHeight);
                    scale = StatusMeterGauge.getScalingTransform(bounds, iBounds, this.m_horizontalFlip);
                    this._moveTransform = move = StatusMeterGauge.getTranslateTransform(bounds, iBounds, scale);
                    this._scaleTransform = scale;
                }
                Shape s = scale.createTransformedShape(bounds);
                s = move.createTransformedShape(s);
                Rectangle scaledBounds = s.getBounds();
                int maxX = (int)((double)this._innerBounds.x + (double)this._innerBounds.width * barLength);
                double indWidth = Math.max(maxX - scaledBounds.x, 0);
                Area mask = !this.m_horizontalFlip ? new Area(new Rectangle2D.Double(scaledBounds.x, scaledBounds.y, indWidth, scaledBounds.height)) : new Area(new Rectangle2D.Double((double)(scaledBounds.x + scaledBounds.width) - indWidth, scaledBounds.y, indWidth, scaledBounds.height));
                Color userBorderColor = (Color)this._engine.getIndicatorAttr("IndicatorBarBorderColor", metricIndex);
                Color userFillColor = (Color)this._engine.getIndicatorAttr("IndicatorBarFillColor", metricIndex);
                Boolean isUserFillColor = (Boolean)this._engine.getIndicatorAttr("IndicatorUseThresholdFillColor", metricIndex);
                if (isUserFillColor != null && isUserFillColor.booleanValue()) {
                    userFillColor = this._getIndicatorColor(map, true, metricIndex);
                }
                HashMap userSFXMap = (HashMap)this._engine.getIndicatorAttr("IndicatorSFX", metricIndex);
                List<CustomShape> shapesList = this._csParser.getShapes("indicator");
                for (int i = 0; i < shapesList.size(); ++i) {
                    CustomShape cs = shapesList.get(i);
                    s = cs.getShape();
                    s = scale.createTransformedShape(s);
                    s = move.createTransformedShape(s);
                    Area ind = new Area(s);
                    ind.intersect(mask);
                    Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                    Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                    HashMap csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                    objects.add(new DrawableObject.Shape(14, metricIndex, map, ind, csBorderColor, csFillColor, csSFXMap, null));
                }
            } else {
                objects.add(new DrawableObject.Shape(14, metricIndex, map, indicator, borderColor, fillColor, sfxMap, null));
            }
        }
        return objects;
    }

    protected Collection _getThresholdObjects(Map map, Area plotAreaMask) {
        Rectangle2D.Double tholdRect;
        Color tBorderColor;
        Color tColor;
        HashMap tMap;
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>(15);
        double min = this._engine.getMin();
        double max = this._engine.getMax();
        double currX = 0.0;
        double currTholdWidth = 0.0;
        double totalTholdWidth = 0.0;
        boolean bBlended = false;
        boolean autoColor = GaugeDefaultValues.isPlotAreaUseThresholdFillColor();
        if (map.get("PlotAreaUseThresholdFillColor") != null) {
            autoColor = (Boolean)map.get("PlotAreaUseThresholdFillColor");
        }
        Area csThreshold = null;
        if (this._csParser != null && this._csParser.defines("thresholdFillArea")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("thresholdFillArea");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = StatusMeterGauge.getScalingTransform(bounds, this._innerBounds, this.m_horizontalFlip);
                this._moveTransform = move = StatusMeterGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            csThreshold = new Area();
            List<CustomShape> shapesList = this._csParser.getShapes("thresholdFillArea");
            for (int j = 0; j < shapesList.size(); ++j) {
                CustomShape cs = shapesList.get(j);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                csThreshold.add(new Area(s));
            }
        }
        double[] tValues = (double[])map.get("ThresholdValues");
        ArrayList tList = (ArrayList)map.get("THRESHOLD_ATTRIBUTES");
        Color prevColor = null;
        HashMap sfxMap = null;
        int index = -1;
        for (int i = 0; i < tValues.length; ++i) {
            Double metric;
            if (tList != null && i < tList.size()) {
                tMap = (HashMap)tList.get(i);
                tColor = (Color)StatusMeterGauge.getThresholdAttribute(tMap, i, "ThresholdFillColor");
                tBorderColor = (Color)StatusMeterGauge.getThresholdAttribute(tMap, i, "ThresholdBorderColor");
                sfxMap = (HashMap)StatusMeterGauge.getThresholdAttribute(tMap, i, "ThresholdSFX");
            } else {
                Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
                tColor = i < defFillColors.length ? defFillColors[i] : Color.white;
                tBorderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
            }
            if (bBlended) {
                Color nextColor;
                if (tList != null && i + 1 < tList.size()) {
                    tMap = (HashMap)tList.get(i + 1);
                    nextColor = (Color)StatusMeterGauge.getThresholdAttribute(tMap, i + 1, "ThresholdFillColor");
                } else {
                    Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
                    nextColor = i + 1 < defFillColors.length ? defFillColors[i + 1] : tColor;
                }
                Color endColor = this._blendColors(tColor, nextColor);
                if (prevColor == null) {
                    prevColor = tColor;
                }
                sfxMap = GaugeDefaultValues.getBlendedThresholdSFX(prevColor, tColor, endColor, 1);
                prevColor = endColor;
            }
            if (autoColor && (metric = this._engine.getMetric()) != null) {
                if (metric <= tValues[i]) {
                    if (csThreshold != null) {
                        objects.add(new DrawableObject.Shape(15, i, map, csThreshold, tBorderColor, tColor, sfxMap, null));
                        return objects;
                    }
                    index = i;
                    tBorderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
                    objects.add(new DrawableObject.Shape(15, i, map, plotAreaMask, tBorderColor, tColor, sfxMap, null));
                    return objects;
                }
                if (i != tValues.length - 1) continue;
                index = tValues.length;
                continue;
            }
            currTholdWidth = (tValues[i] - min) / (max - min) * (double)this._innerBounds.width - totalTholdWidth;
            if (csThreshold != null) {
                Rectangle csThresholdBounds = csThreshold.getBounds();
                Rectangle2D.Double mask = !this.m_horizontalFlip ? new Rectangle2D.Double((double)this._innerBounds.x + currX, ((RectangularShape)csThresholdBounds).getY(), Math.floor(currTholdWidth), ((RectangularShape)csThresholdBounds).getHeight()) : new Rectangle2D.Double((double)(this._innerBounds.x + this._innerBounds.width) - currX - Math.floor(currTholdWidth), ((RectangularShape)csThresholdBounds).getY(), Math.floor(currTholdWidth), ((RectangularShape)csThresholdBounds).getHeight());
                Area segment = new Area(mask);
                segment.intersect(csThreshold);
                objects.add(new DrawableObject.Shape(15, i, map, segment, tBorderColor, tColor, sfxMap, null));
            } else {
                tholdRect = new Rectangle2D.Double();
                if (!this.m_horizontalFlip) {
                    ((Rectangle2D)tholdRect).setRect((double)this._innerBounds.x + currX, this._innerBounds.y, currTholdWidth, this._innerBounds.height);
                } else {
                    ((Rectangle2D)tholdRect).setRect((double)(this._innerBounds.x + this._innerBounds.width) - currX - currTholdWidth, this._innerBounds.y, currTholdWidth, this._innerBounds.height);
                }
                Area tholdArea = new Area(tholdRect);
                tholdArea.intersect(plotAreaMask);
                objects.add(new DrawableObject.Shape(15, i, map, tholdArea, tBorderColor, tColor, sfxMap, null));
            }
            currX += currTholdWidth;
            totalTholdWidth += currTholdWidth;
        }
        if (tList != null && tValues.length < tList.size()) {
            tMap = (HashMap)tList.get(tValues.length);
            tColor = (Color)StatusMeterGauge.getThresholdAttribute(tMap, tValues.length, "ThresholdFillColor");
            tBorderColor = (Color)StatusMeterGauge.getThresholdAttribute(tMap, tValues.length, "ThresholdBorderColor");
            sfxMap = (HashMap)StatusMeterGauge.getThresholdAttribute(tMap, tValues.length, "ThresholdSFX");
        } else {
            Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
            tColor = tValues.length < defFillColors.length ? defFillColors[tValues.length] : Color.white;
            tBorderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
        }
        if (bBlended) {
            if (prevColor == null) {
                prevColor = tColor;
            }
            sfxMap = GaugeDefaultValues.getBlendedThresholdSFX(prevColor, tColor, tColor, 1);
        }
        if (csThreshold != null) {
            Rectangle csThresholdBounds = csThreshold.getBounds();
            double width = (double)this._innerBounds.width - currX;
            Rectangle2D.Double mask = !this.m_horizontalFlip ? new Rectangle2D.Double((double)this._innerBounds.x + currX, ((RectangularShape)csThresholdBounds).getY(), width, ((RectangularShape)csThresholdBounds).getHeight()) : new Rectangle2D.Double(this._innerBounds.x, ((RectangularShape)csThresholdBounds).getY(), width, ((RectangularShape)csThresholdBounds).getHeight());
            Area segment = new Area(mask);
            segment.intersect(csThreshold);
            objects.add(new DrawableObject.Shape(15, tValues.length, map, segment, tBorderColor, tColor, sfxMap, null));
        } else {
            tholdRect = new Rectangle2D.Double();
            if (!this.m_horizontalFlip) {
                ((Rectangle2D)tholdRect).setRect((double)this._innerBounds.x + currX, this._innerBounds.y, (double)this._innerBounds.width - totalTholdWidth, this._innerBounds.height);
            } else {
                ((Rectangle2D)tholdRect).setRect((double)(this._innerBounds.x + this._innerBounds.width) - currX - (double)this._innerBounds.width + totalTholdWidth, this._innerBounds.y, (double)this._innerBounds.width - totalTholdWidth, this._innerBounds.height);
            }
            Area tholdArea = new Area(tholdRect);
            tholdArea.intersect(plotAreaMask);
            objects.add(new DrawableObject.Shape(15, tValues.length, map, tholdArea, tBorderColor, tColor, sfxMap, null));
        }
        return objects;
    }

    protected Collection getOverlayEffectObjects(Map map) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>();
        int visualEffects = GaugeDefaultValues.getVisualEffects();
        if (map.get("VisualEffects") != null) {
            visualEffects = (Integer)map.get("VisualEffects");
        }
        if (visualEffects == 0) {
            return objects;
        }
        if (!(this._plotArea == null || this._csParser != null && this._csParser.defines("plotArea"))) {
            Rectangle2D bounds = this._plotArea.getBounds2D();
            Rectangle2D.Double overlayBounds = new Rectangle2D.Double();
            ((Rectangle2D)overlayBounds).setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), 0.5 * bounds.getHeight());
            Area overlay = new Area(overlayBounds);
            overlay.intersect(this._plotArea);
            HashMap sfxMap = GaugeDefaultValues.getStatusMeterOverlay();
            objects.add(new DrawableObject.Shape(34, overlay, null, null, sfxMap, null));
        }
        return objects;
    }

    @Override
    protected Collection getTickLabelObjects(Map map) {
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>(15);
        int tickContent = -1;
        if (this._tickMarkPositions != null) {
            Integer tickLabelPos;
            Color color;
            Font font = (Font)map.get("TickLabelFont");
            if (font == null) {
                font = GaugeDefaultValues.getTickLabelFont();
            }
            if ((color = (Color)map.get("TickLabelColor")) == null) {
                color = GaugeDefaultValues.getTickLabelFontColor();
            }
            if ((tickLabelPos = (Integer)map.get("TickLabelPosition")) == null) {
                tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
            }
            Graphics2D g = this._engine.getGraphics();
            double min = this._engine.getMin();
            double max = this._engine.getMax();
            double range = max - min;
            for (int i = 0; i < this._tickMarkPositions.size(); ++i) {
                Point2D pt = this._tickMarkPositions.get(i);
                double val = range * (pt.getX() - (double)this._innerBounds.x) / (double)this._innerBounds.width + min;
                val = Math.min(Math.max(val, min), max);
                String value = this._engine.formatValue(val, "TickLabelViewFormat");
                Dimension dim = DrawableObject.getLabelDimensions(g, font, value);
                int x = !this.m_horizontalFlip ? (int)pt.getX() - dim.width / 2 : this._innerBounds.x * 2 + this._innerBounds.width - (int)pt.getX() - dim.width / 2;
                int y = (int)pt.getY() + this._layout.getGapHeight(2) + this._tickMarkLength;
                Rectangle tickRect = new Rectangle(x, y, dim.width, dim.height);
                objects.add(DrawableObject.getTickLabelObject(g, value, font, color, tickRect, 4));
            }
        } else {
            tickContent = (Integer)map.get("TickLabelContent") == null ? (map.get("ThresholdValues") == null ? 7 : 11) : (Integer)map.get("TickLabelContent");
            objects.addAll(this.getTickLabelObjects(map, tickContent));
        }
        return objects;
    }

    private Collection<DrawableObject> getTickLabelObjects(Map map, int type) {
        double x;
        Dimension dim;
        String value;
        int i;
        Color fontColor;
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>(15);
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getTickLabelFont();
        }
        if ((fontColor = (Color)map.get("TickLabelColor")) == null) {
            fontColor = GaugeDefaultValues.getTickLabelFontColor();
        }
        Graphics2D g = this._engine.getGraphics();
        double y = this._tickMarkYPos + (double)this._layout.getGapHeight(2);
        if (map.get("TickMarkContent") == null || (Integer)map.get("TickMarkContent") != 0) {
            y += (double)this._tickMarkLength;
        }
        double min = this._engine.getMin();
        double max = this._engine.getMax();
        Rectangle tickRect = null;
        if ((type & 0x10) != 0) {
            if (this._engine.isNullMetric()) {
                return objects;
            }
            for (i = 0; i < this._engine.getMetricSize(); ++i) {
                Double metric = this._engine.getMetric(i);
                if (metric == null) continue;
                value = this._engine.formatValue(metric, "MetricLabelViewFormat");
                dim = DrawableObject.getLabelDimensions(g, font, value);
                x = !this.m_horizontalFlip ? (metric - min) / (max - min) * (double)this._innerBounds.width + (double)this._innerBounds.x - (double)(dim.width / 2) : -((metric - min) / (max - min) * (double)this._innerBounds.width) + (double)this._innerBounds.x + (double)this._innerBounds.width - (double)(dim.width / 2);
                tickRect = new Rectangle((int)x, (int)y, dim.width, dim.height);
                objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
            }
        }
        if ((type & 8) != 0) {
            double[] array = (double[])map.get("ThresholdValues");
            if (array == null) {
                return objects;
            }
            for (int i2 = 0; i2 < array.length; ++i2) {
                if (array[i2] > max || array[i2] < min) continue;
                value = this._engine.formatValue(array[i2], "TickLabelViewFormat");
                dim = DrawableObject.getLabelDimensions(g, font, value);
                x = !this.m_horizontalFlip ? (max - min != 0.0 ? (array[i2] - min) / (max - min) * (double)this._innerBounds.width + (double)this._innerBounds.x - (double)(dim.width / 2) : (double)(this._innerBounds.x - dim.width / 2)) : (max - min != 0.0 ? -((array[i2] - min) / (max - min) * (double)this._innerBounds.width) + (double)this._innerBounds.x + (double)this._innerBounds.width - (double)(dim.width / 2) : (double)(this._innerBounds.x + this._innerBounds.width - dim.width / 2));
                tickRect = new Rectangle((int)x, (int)y, dim.width, dim.height);
                objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
            }
        }
        if ((type & 3) != 0) {
            value = this._engine.formatValue(min, "TickLabelViewFormat");
            dim = DrawableObject.getLabelDimensions(g, font, value);
            x = !this.m_horizontalFlip ? (double)this._innerBounds.x : (double)(this._innerBounds.x + this._innerBounds.width - dim.width);
            tickRect = new Rectangle((int)x, (int)y, dim.width, dim.height);
            objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
            value = this._engine.formatValue(max, "TickLabelViewFormat");
            dim = DrawableObject.getLabelDimensions(g, font, value);
            x = !this.m_horizontalFlip ? (double)(this._innerBounds.x + this._innerBounds.width - dim.width) : (double)this._innerBounds.x;
            tickRect = new Rectangle((int)x, (int)y, dim.width, dim.height);
            objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
        }
        if ((type & 4) != 0) {
            for (i = 0; i < this._engine.getNumberOfSteps() - 1; ++i) {
                double incrVal = this._engine.getIncrement() * (double)(i + 1);
                value = this._engine.formatValue(incrVal + min, "TickLabelViewFormat");
                dim = DrawableObject.getLabelDimensions(g, font, value);
                x = !this.m_horizontalFlip ? incrVal / (max - min) * (double)this._innerBounds.width + (double)this._innerBounds.x - (double)(dim.width / 2) : -(incrVal / (max - min) * (double)this._innerBounds.width) + (double)this._innerBounds.width + (double)this._innerBounds.x - (double)(dim.width / 2);
                tickRect = new Rectangle((int)x, (int)y, dim.width, dim.height);
                objects.add(DrawableObject.getTickLabelObject(g, value, font, fontColor, tickRect, type));
            }
        }
        return objects;
    }

    @Override
    protected Collection getTickMarkObjects(Map map) {
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>(15);
        int tickMarks = -1;
        tickMarks = (Integer)map.get("TickMarkContent") == null ? (map.get("ThresholdValues") == null ? 7 : 11) : (Integer)map.get("TickMarkContent");
        this._tickMarkYPos = this._innerBounds.y + this._innerBounds.height;
        if (this._csParser != null && this._csParser.defines("tickMarkPath")) {
            Rectangle2D bounds = this._csParser.getBounds("tickMarkPath");
            if (this._scaleTransform != null && this._moveTransform != null) {
                Shape s = bounds;
                s = this._scaleTransform.createTransformedShape(s);
                s = this._moveTransform.createTransformedShape(s);
                this._tickMarkYPos = s.getBounds().getCenterY();
            }
            this.createTickMarkObjects(objects, map, tickMarks, this._tickMarkYPos);
        } else if (this._csParser != null && this._csParser.defines("tickMark")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("tickMark");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = StatusMeterGauge.getScalingTransform(bounds, this._innerBounds, this.m_horizontalFlip);
                this._moveTransform = move = StatusMeterGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            Color userColor = (Color)map.get("MajorTickColor");
            List<CustomShape> shapesList = this._csParser.getShapes("tickMark");
            this._tickMarkPositions = new ArrayList();
            this._tickMarkLength = 0;
            for (int i = 0; i < shapesList.size(); ++i) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Rectangle2D sBounds = s.getBounds2D();
                double cx = sBounds.getCenterX();
                double cy = sBounds.getCenterY();
                double h = sBounds.getHeight();
                if (this.m_horizontalFlip) {
                    cx = (double)(this._innerBounds.width + this._innerBounds.x * 2) - cx;
                }
                Point2D.Double center = new Point2D.Double(cx, cy);
                int tmLength = (int)(h / 2.0);
                if (tmLength > this._tickMarkLength) {
                    this._tickMarkLength = tmLength;
                }
                this._tickMarkPositions.add(center);
                Color csColor = userColor != null ? userColor : cs.getFillColor();
                objects.add(new DrawableObject.Shape(13, s, cs.getBorderColor(), csColor, cs.getSFXMap(), null));
            }
        } else {
            this.createTickMarkObjects(objects, map, tickMarks, this._tickMarkYPos);
        }
        return objects;
    }

    protected void createTickMarkObjects(List<DrawableObject> objects, Map map, int tickMarkType, double yPos) {
        double[] array;
        double x;
        Color tmColor = (Color)map.get("MajorTickColor");
        if (tmColor == null) {
            tmColor = GaugeDefaultValues.getMajorTickMarkColor();
        }
        int tmLength = 6;
        int minorTickLength = GaugeDefaultValues.getMinorTickMarkLength();
        Color minorTickColor = (Color)map.get("MinorTickColor");
        if (minorTickColor == null) {
            minorTickColor = GaugeDefaultValues.getMinorTickMarkColor();
        }
        double y = yPos;
        double min = this._engine.getMin();
        double max = this._engine.getMax();
        if ((tickMarkType & 3) != 0) {
            x = this._innerBounds.x;
            this.createTickMark(objects, map, new Point2D.Double(x, y), tmColor, tmLength);
            x = this._innerBounds.x + this._innerBounds.width;
            this.createTickMark(objects, map, new Point2D.Double(x, y), tmColor, tmLength);
        }
        if ((tickMarkType & 4) != 0) {
            int i;
            for (i = 0; i < this._engine.getNumberOfSteps() - 1; ++i) {
                double incrVal = this._engine.getIncrement() * (double)(i + 1);
                x = !this.m_horizontalFlip ? (max - min != 0.0 ? incrVal / (max - min) * (double)this._innerBounds.width + (double)this._innerBounds.x : (double)this._innerBounds.x) : (max - min != 0.0 ? -(incrVal / (max - min) * (double)this._innerBounds.width) + (double)this._innerBounds.x + (double)this._innerBounds.width : (double)(this._innerBounds.x + this._innerBounds.width));
                this.createTickMark(objects, map, new Point2D.Double(x - 1.0, y), tmColor, tmLength);
            }
            for (i = 0; i < this._engine.getNumberOfSteps(); ++i) {
                for (int j = 1; j <= this._engine.getMinorNumberOfSteps(); ++j) {
                    double incrVal = this._engine.getIncrement() * (double)i + (double)j * this._engine.getMinorIncrement();
                    if (incrVal > this._engine.getMax()) continue;
                    x = !this.m_horizontalFlip ? (max - min != 0.0 ? incrVal / (max - min) * (double)this._innerBounds.width + (double)this._innerBounds.x : (double)this._innerBounds.x) : (max - min != 0.0 ? -(incrVal / (max - min) * (double)this._innerBounds.width) + (double)this._innerBounds.x + (double)this._innerBounds.width : (double)(this._innerBounds.x + this._innerBounds.width));
                    this.createMinorTickMark(objects, map, new Point2D.Double(x - 1.0, y), minorTickColor, minorTickLength);
                }
            }
        }
        if ((tickMarkType & 8) != 0 && (array = (double[])map.get("ThresholdValues")) != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] > max || array[i] < min) continue;
                x = !this.m_horizontalFlip ? (max - min != 0.0 ? (array[i] - min) / (max - min) * (double)this._innerBounds.width + (double)this._innerBounds.x : (double)this._innerBounds.x) : (max - min != 0.0 ? -((array[i] - min) / (max - min) * (double)this._innerBounds.width) + (double)this._innerBounds.x + (double)this._innerBounds.width : (double)(this._innerBounds.x + this._innerBounds.width));
                this.createTickMark(objects, map, new Point2D.Double(x, y), tmColor, tmLength);
            }
        }
        if ((tickMarkType & 0x10) != 0) {
            for (int i = 0; i < this._engine.getMetricSize(); ++i) {
                Double metric = this._engine.getMetric(i);
                if (metric == null) continue;
                x = !this.m_horizontalFlip ? (max - min != 0.0 ? (metric - min) / (max - min) * (double)this._innerBounds.width + (double)this._innerBounds.x : (double)this._innerBounds.x) : (max - min != 0.0 ? -((metric - min) / (max - min) * (double)this._innerBounds.width) + (double)this._innerBounds.x + (double)this._innerBounds.width : (double)(this._innerBounds.x + this._innerBounds.width));
                this.createTickMark(objects, map, new Point2D.Double(x, y), tmColor, tmLength);
            }
        }
    }

    private void createTickMark(List<DrawableObject> objects, Map map, Point2D pt, Color color, int tmLength) {
        this.createTickMark(objects, map, pt, color, tmLength, "tickMark");
    }

    private void createMinorTickMark(List<DrawableObject> objects, Map map, Point2D pt, Color color, int tmLength) {
        this.createTickMark(objects, map, pt, color, tmLength, "minorTickMark");
    }

    private void createTickMark(List<DrawableObject> objects, Map map, Point2D pt, Color tmColor, int tmLength, String customShapesType) {
        if (this._csParser != null && this._csParser.defines(customShapesType) && this._scaleTransform != null && this._moveTransform != null) {
            Rectangle2D bounds = this._csParser.getBounds(customShapesType);
            bounds = this._scaleTransform.createTransformedShape(bounds).getBounds2D();
            bounds = this._moveTransform.createTransformedShape(bounds).getBounds2D();
            AffineTransform move = new AffineTransform();
            if (!this.m_horizontalFlip) {
                move.translate(pt.getX() - this._innerBounds.getX(), pt.getY() - this._tickMarkYPos);
            } else {
                move.translate(-pt.getX() + this._innerBounds.getX(), pt.getY() - this._tickMarkYPos);
            }
            double maxY = bounds.getY() + bounds.getHeight();
            this._tickMarkLength = (int)(maxY - this._tickMarkYPos);
            Color userColor = customShapesType == "minorTickMark" ? (Color)map.get("MinorTickColor") : (Color)map.get("MajorTickColor");
            List<CustomShape> shapesList = this._csParser.getShapes(customShapesType);
            for (int i = 0; i < shapesList.size(); ++i) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = this._scaleTransform.createTransformedShape(s);
                s = this._moveTransform.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Color csColor = userColor != null ? userColor : cs.getFillColor();
                objects.add(new DrawableObject.Shape(13, s, cs.getBorderColor(), csColor, cs.getSFXMap(), null));
            }
        } else {
            double x = pt.getX();
            double y = pt.getY();
            objects.add(new DrawableObject.Shape(13, new Line2D.Double(x, y, x, y + (double)tmLength), tmColor, null, null, null));
        }
    }

    @Override
    protected DrawableObject getNoDataLabelObject(Map map) {
        String noDataLabel = this._engine.getIntlStringFromUtilBundle("af_dvt_util.NO_DATA");
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getNoDataLabelFont();
        }
        Dimension dim = DrawableObject.getLabelDimensions(this._engine.getGraphics(), font, noDataLabel);
        int plotAreaWidth = this._innerBounds.width - this._layout.getGapWidth(5) * 2;
        if (dim.width > plotAreaWidth) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        bounds.x = this._innerBounds.x + this._innerBounds.width / 2 - dim.width / 2;
        bounds.y = this._innerBounds.y + this._innerBounds.height - 2 - dim.height;
        bounds.width = dim.width;
        bounds.height = dim.height;
        return DrawableObject.getLabelObject(this._engine.getGraphics(), noDataLabel, font, GaugeDefaultValues.getNoDataLabelFontColor(), bounds, "NoDataLabel");
    }

    private int getSpaceBelowPlotArea(Map map, Graphics2D g2d) {
        int reqBelowSpace = 0;
        if (map.get("TickLabelContent") == null || (Integer)map.get("TickLabelContent") != 0) {
            Font tickLblFont = (Font)map.get("TickLabelFont");
            if (tickLblFont == null) {
                tickLblFont = GaugeDefaultValues.getTickLabelFont();
            }
            Dimension tickLblDim = DrawableObject.getLabelDimensions(g2d, tickLblFont, "W");
            reqBelowSpace += tickLblDim.height + this._layout.getGapHeight(2);
        }
        if (map.get("TickMarkContent") == null || (Integer)map.get("TickMarkContent") != 0) {
            reqBelowSpace += 6;
        }
        return reqBelowSpace;
    }

    @Override
    protected Rectangle _getPlotAreaBounds(Rectangle gaugeFrameBounds, Map map, Graphics2D g) {
        int reqAboveSpace = 0;
        int reqBelowSpace = this.getSpaceBelowPlotArea(map, g);
        int reqLeftSpace = 0;
        int reqRightSpace = 0;
        Rectangle bounds = this.getInnerBounds(map, gaugeFrameBounds, reqAboveSpace, reqBelowSpace, reqLeftSpace, reqRightSpace);
        if (this._csParser == null || !this._csParser.defines("gaugeFrame")) {
            int maxY = gaugeFrameBounds.y + gaugeFrameBounds.height;
            int y = bounds.y - reqAboveSpace;
            int height = Math.max(maxY - y, bounds.height + reqAboveSpace + reqBelowSpace);
            this._gaugeFrameBounds = new Rectangle(bounds.x - reqLeftSpace, y, bounds.width + reqLeftSpace + reqRightSpace, height);
        }
        return bounds;
    }

    @Override
    protected int getGaugeRadius(int availWidth, int availHeight) {
        return availWidth;
    }

    @Override
    protected Rectangle getInnerBounds(Map map, Rectangle rect, int reqAboveSpace, int reqBelowSpace, int reqLeftSpace, int reqRightSpace) {
        int availHeight = rect.height - reqAboveSpace - reqBelowSpace;
        int availWidth = rect.width - reqLeftSpace - reqRightSpace;
        int meterHeight = Math.max(Math.min(25, availHeight), 3);
        if (this._csParser != null && (this._csParser.defines("plotArea") || this._csParser.defines("plotAreaBounds") || this._csParser.defines("gaugeFrame"))) {
            Rectangle2D csBounds = this._csParser.getBounds("plotArea");
            if (csBounds == null) {
                csBounds = this._csParser.getBounds("plotAreaBounds");
            }
            if (csBounds == null) {
                csBounds = this._csParser.getBounds("gaugeFrame");
            }
            double ratio = csBounds.getHeight() / csBounds.getWidth();
            meterHeight = (int)(ratio * (double)availWidth);
        }
        Rectangle bounds = new Rectangle();
        bounds.x = rect.x + reqLeftSpace;
        bounds.y = rect.y + reqAboveSpace + availHeight / 2 - meterHeight / 2;
        bounds.width = availWidth;
        bounds.height = meterHeight;
        if (bounds.width < 10) {
            bounds.width = 10;
            bounds.x = rect.x + (rect.width - bounds.width) / 2;
        }
        return bounds;
    }

    @Override
    protected int getMaxNumberOfSteps() {
        return (int)Math.round(0.02 * (double)this._innerBounds.width);
    }

    @Override
    protected Collection getGaugeFrameObject(Map map) {
        ArrayList objects = new ArrayList();
        return objects;
    }

    @Override
    protected Collection getGaugeLinkObject(Map map, Rectangle outerBounds) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>();
        Color clr = GaugeDefaultValues.getGaugeFrameBorderColor();
        if (map.get("GaugeFrameBorderColor") != null) {
            clr = (Color)map.get("GaugeFrameBorderColor");
        }
        Rectangle tempBounds = new Rectangle(this._innerBounds.x - 1, this._innerBounds.y - 1, this._innerBounds.width, this._innerBounds.height);
        Color color = new Color(1.0f, 1.0f, 1.0f, 0.01f);
        objects.add(new DrawableObject.Shape(11, map, (Shape)tempBounds, null, color, null, null));
        return objects;
    }
}

