/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerAdapter;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.GroupComponentHandle;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.SeriesComponentHandle;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphController;
import oracle.dss.graph.GraphModel;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.KeyState;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.event.TDGEvent;
import oracle.dss.graph.pfj.event.TDGListener;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.pagingControl.PagingComponent;
import oracle.dss.util.DataException;
import oracle.dss.util.GroupComponentInfo;
import oracle.javatools.annotations.Concealed;

@Concealed
public class GraphControllerAdapter
extends ControllerAdapter
implements GraphController,
TDGListener,
PagingPivotListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected Graph m_graph = null;
    protected GraphModel m_model = null;
    protected PFJ m_pfj = null;
    protected int m_selectedComponentHandle = 67;
    protected int m_currentComponentHandle;
    protected boolean m_isCursorOnResizeHandle;
    protected int m_resizeCursorValue;
    protected ComponentHandle m_currentHandle = null;
    protected ComponentHandle m_selectedObject = null;
    private boolean _m_selectingPageItem = false;
    private boolean m_shiftKey = false;
    private boolean m_canDrill = false;
    private static final String m_method_perspectiveEvent = "public void perspectiveEvent( TDGEvent event )";

    public GraphControllerAdapter(Graph graph, GraphModel graphModel) {
        super(graph);
        this.m_graph = graph;
        this.m_model = graphModel;
        this.m_pfj = this.m_graph.getPFJ();
        this.m_pfj.addPerspectiveListener(this);
        this.m_isCursorOnResizeHandle = false;
        if (this.m_graph.getThickPFJ() != null) {
            ((Component)((Object)this.m_graph.getThickPFJ())).addFocusListener(this);
        }
        if (graph.getPagingControl() != null) {
            graph.getPagingControl().addKeyListener(this);
            graph.getPagingControl().addMouseListener(this);
            graph.getPagingControl().addMouseMotionListener(this);
            graph.getPagingControl().addFocusListener(this);
            graph.getPagingControl().getPagingComponent().addPropertyChangeListener(this);
            graph.getPagingControl().getPagingComponent().addPivotListener(this);
        }
    }

    @Override
    @Concealed
    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        final NonDataComponentHandle c = this.getNonDataComponent((ViewComponent)e.getSource());
        if (c.getID() == 6 || c.getID() == 7 || c.getID() == 8) {
            Component comp = (Component)e.getSource();
            if (!comp.isFocusTraversable()) {
                Component rootComponent = SwingUtilities.getRoot(comp);
                rootComponent.requestFocus();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphControllerAdapter.this.setSelectedObject(c);
                }
            });
        }
        this.processViewMouseEvent(e, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pivot(PagingPivotEvent e) {
        int flags = 0;
        try {
            int sourceIndex = e.getSourceIndex();
            int destinationIndex = e.getDestinationIndex();
            flags = sourceIndex < destinationIndex ? 3 : 2;
            this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(2));
            if (this.m_graph.getGraphModel().getControllerActions().canPivot(this.m_graph, 2, 2, sourceIndex, destinationIndex, flags)) {
                this.m_graph.getGraphModel().getControllerActions().pivotGestureHappened(this.m_graph, 2, 2, sourceIndex, destinationIndex, flags);
            }
        }
        catch (DataException exception) {
            this.m_graph.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "pivot");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(PagingPivotEvent e) {
        try {
            int sourceIndex = e.getSourceIndex();
            int destinationIndex = e.getDestinationIndex();
            this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(2));
            if (this.m_graph.getGraphModel().getControllerActions().canPivot(this.m_graph, 2, 2, sourceIndex, destinationIndex, 1)) {
                this.m_graph.getGraphModel().getControllerActions().pivotGestureHappened(this.m_graph, 2, 2, sourceIndex, destinationIndex, 1);
            }
        }
        catch (DataException exception) {
            this.m_graph.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "swap");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(0));
        }
    }

    protected void setCursor(Component component, Cursor c) {
        component.setCursor(c);
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setCursor(cont.getComponent(i), c);
            }
        }
    }

    private boolean _isDrillUpComponent(int id) {
        boolean drillUp = false;
        switch (id) {
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                drillUp = true;
            }
        }
        return drillUp;
    }

    private void _drillUp(ComponentHandle id) {
        int edge;
        boolean seriesAreRows = this.m_graph.isDataRowShownAsASeries();
        int n = edge = seriesAreRows ? 1 : 0;
        if (id.getID() == 70) {
            edge = seriesAreRows ? 0 : 1;
        }
        try {
            int flag = 16;
            if (this.m_model.getDataAccess().getLayerCount(edge) > 0 && this.m_model.getControllerActions().canDrill(this.m_graph, edge, 0, 0, flag)) {
                this.m_model.getControllerActions().drillGestureHappened(this.m_graph, edge, 0, 0, flag);
            }
        }
        catch (DataException exception) {
            this.m_graph.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "_mouseClicked");
        }
    }

    private boolean _canDrill(ComponentHandle id) {
        boolean canDrill = false;
        boolean seriesAreRows = this.m_graph.isDataRowShownAsASeries();
        if (this.m_graph.isDrillingEnabled() && this.m_graph.isDrillingSupported() && this.m_graph.isMetadataDrillSupported()) {
            switch (id.getID()) {
                case 17: 
                case 18: 
                case 59: {
                    int edge = seriesAreRows ? 1 : 0;
                    canDrill = this.m_graph.getDrillState(edge, ((SeriesComponentHandle)id).getSeries());
                    break;
                }
                case 14: 
                case 38: 
                case 40: {
                    int edge = seriesAreRows ? 1 : 0;
                    canDrill = this.m_graph.getDrillState(edge, ((DataComponentHandle)id).getSeries());
                    break;
                }
                case 10: 
                case 13: 
                case 32: {
                    int edge = seriesAreRows ? 1 : 0;
                    int series = 0;
                    series = this.m_graph.isPie(this.m_graph.getGraphType()) ? ((DataComponentHandle)id).getSeries() : ((SeriesComponentHandle)id).getSeries();
                    canDrill = this.m_graph.getDrillState(edge, series);
                    break;
                }
                case 24: 
                case 28: {
                    GroupComponentInfo info = (GroupComponentInfo)id.getComponentInfo();
                    if (this.m_pfj.isTimeAxis() && info.getLayer() == 0 && this.m_pfj.getO1LabelCallBack().getNumLevels() == 2) {
                        canDrill = false;
                        break;
                    }
                    int edge = seriesAreRows ? 0 : 1;
                    canDrill = this.m_graph.getDrillState(edge, ((GroupComponentHandle)id).getGroup());
                    break;
                }
                case 70: 
                case 71: 
                case 72: 
                case 73: {
                    canDrill = true;
                }
            }
        }
        return canDrill;
    }

    private boolean _isMovableSubcomponent(int id) {
        switch (id) {
            case 0: 
            case 1: 
            case 2: 
            case 16: 
            case 27: 
            case 29: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    private void _mouseMoved(TDGEvent event) {
        TDGMouseState mouseState = (TDGMouseState)event.getDataObject();
        ComponentHandle id = this.m_graph.getGraphComponentHandle(mouseState);
        this.m_currentComponentHandle = id.getID();
        if (id != null && !id.equals(this.m_currentHandle)) {
            this.m_currentHandle = id;
            this.m_canDrill = this._canDrill(id);
            this.setGraphCursor(this.m_currentComponentHandle);
        }
        this.mouseEvent = mouseState.getMouseEvent();
        this.processViewMouseMotionEvent(mouseState.getMouseEvent(), id);
    }

    private void _mousePressed(TDGEvent event) {
        TDGMouseState mouseState = (TDGMouseState)event.getDataObject();
        ComponentHandle id = this.m_graph.getGraphComponentHandle(mouseState);
        this.mouseEvent = mouseState.getMouseEvent();
        this.processViewMouseEvent(mouseState.getMouseEvent(), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _mouseDragged(TDGEvent event) {
        TDGMouseState mouseState = (TDGMouseState)event.getDataObject();
        ComponentHandle id = this.m_graph.getGraphComponentHandle(mouseState);
        this.m_pfj.stopRepaints();
        try {
            this._updatePlacementFlags();
        }
        finally {
            this.m_pfj.resumeRepaints();
        }
        this.mouseEvent = mouseState.getMouseEvent();
        this.processViewMouseMotionEvent(mouseState.getMouseEvent(), id);
    }

    private void _mouseClicked(TDGEvent event) {
        TDGMouseState mouseState = (TDGMouseState)event.getDataObject();
        ComponentHandle id = this.m_graph.getGraphComponentHandle(mouseState);
        this.mouseEvent = mouseState.getMouseEvent();
        this.processViewMouseEvent(mouseState.getMouseEvent(), id);
        int clickCount = 2;
        switch (id.getID()) {
            case 18: 
            case 24: 
            case 28: 
            case 59: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                clickCount = 1;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 32: 
            case 38: 
            case 40: {
                clickCount = 2;
            }
        }
        if (SwingUtilities.isLeftMouseButton(mouseState.getMouseEvent()) && mouseState.getMouseEvent().getClickCount() == clickCount && this.m_model.isDrillingEnabled() && this.m_graph.isEnabled() && this.m_canDrill) {
            if (this._isDrillUpComponent(id.getID())) {
                this._drillUp(id);
                return;
            }
            int[] params = this.m_graph.getDrillParameters(id);
            if (params == null) {
                return;
            }
            try {
                int flag = 0;
                flag = this.m_shiftKey ? 2 : 1;
                if (this.m_model.getDataAccess().getLayerCount(params[0]) > 0 && this.m_model.getControllerActions().canDrill(this.m_graph, params[0], params[1], params[2], flag)) {
                    this.m_model.getControllerActions().drillGestureHappened(this.m_graph, params[0], params[1], params[2], flag);
                }
            }
            catch (DataException exception) {
                this.m_graph.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "_mouseClicked");
            }
        }
    }

    private void _mouseReleased(TDGEvent event) {
        TDGMouseState mouseState = (TDGMouseState)event.getDataObject();
        ComponentHandle id = this.m_graph.getGraphComponentHandle(mouseState);
        this.mouseEvent = mouseState.getMouseEvent();
        this.processViewMouseEvent(mouseState.getMouseEvent(), id);
    }

    private void _mouseEntered(TDGEvent event) {
        TDGMouseState mouseState = (TDGMouseState)event.getDataObject();
        ComponentHandle id = this.m_graph.getGraphComponentHandle(mouseState);
        this.mouseEvent = mouseState.getMouseEvent();
        this.processViewMouseEvent(mouseState.getMouseEvent(), id);
    }

    private void _mouseExited(TDGEvent event) {
        TDGMouseState mouseState = (TDGMouseState)event.getDataObject();
        ComponentHandle id = this.m_graph.getGraphComponentHandle(mouseState);
        this.mouseEvent = mouseState.getMouseEvent();
        this.processViewMouseEvent(mouseState.getMouseEvent(), id);
    }

    private void _keyTyped(TDGEvent event) {
        KeyState keyState = (KeyState)event.getDataObject();
        this.processViewKeyEvent(keyState.getKeyEvent(), null);
    }

    private void _keyPressed(TDGEvent event) {
        KeyState keyState = (KeyState)event.getDataObject();
        this.m_shiftKey = keyState.getKeyEvent().getKeyCode() == 16;
        this.processViewKeyEvent(keyState.getKeyEvent(), null);
    }

    private void _keyReleased(TDGEvent event) {
        KeyState keyState = (KeyState)event.getDataObject();
        this.m_shiftKey = false;
        this.processViewKeyEvent(keyState.getKeyEvent(), null);
    }

    private void _afterSelect(TDGEvent event) {
        this.setSelectedObject(null);
        Object dataObj = event.getDataObject();
        ComponentHandle id = this.m_graph.getSelectedObject();
        this.m_selectedComponentHandle = id == null ? 67 : id.getID();
        if (this.m_currentComponentHandle == this.m_selectedComponentHandle) {
            this.setGraphCursor(this.m_selectedComponentHandle);
        }
        this.fireComponentSelected(this.m_graph, id);
    }

    private void _updatePlacementFlags() {
        ComponentHandle handle = this.m_graph.getSelectedObject();
        int component = -1;
        if (handle != null) {
            component = handle.getID();
        }
        if (component == 29 || component == 27) {
            this.m_graph.setFrameSizeAutomatic(false);
        } else if (component == 16) {
            this.m_pfj.getLegendLayout().setRectDefault(false);
        }
    }

    private void _resizeHandle() {
        this.m_isCursorOnResizeHandle = true;
        switch (this.m_resizeCursorValue) {
            case 6: {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_nwResizeCursor);
                break;
            }
            case 8: {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_nResizeCursor);
                break;
            }
            case 7: {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_neResizeCursor);
                break;
            }
            case 11: {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_eResizeCursor);
                break;
            }
            case 5: {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_seResizeCursor);
                break;
            }
            case 9: {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_sResizeCursor);
                break;
            }
            case 4: {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_swResizeCursor);
                break;
            }
            case 10: {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_wResizeCursor);
                break;
            }
            default: {
                this.m_isCursorOnResizeHandle = false;
            }
        }
    }

    @Override
    public void setSelectedObject(ComponentHandle c) {
        this.m_selectedObject = c;
        this._m_selectingPageItem = true;
        this.changeTitleSelectedState(false);
        if (c != null && c.getComponent() instanceof BaseTitle) {
            ((BaseTitle)c.getComponent()).setSelected(true);
            this.m_pfj.setSelection((IdentObj)null);
            this.fireComponentSelected(this.m_graph, c);
        } else if (c instanceof PageItemComponentHandle) {
            PageItemComponentHandle pid = (PageItemComponentHandle)c;
            this.m_pfj.setSelection((IdentObj)null);
            this.fireComponentSelected(this.m_graph, c);
        } else {
            this.m_selectedComponentHandle = 67;
            if (this.m_graph.getPagingControl() != null && this.m_graph.getPagingControl().getPagingComponent() != null) {
                this.m_graph.getPagingControl().getPagingComponent().setSelectedItem(null);
            }
        }
        this._m_selectingPageItem = false;
    }

    @Override
    public ComponentHandle getSelectedObject() {
        return this.m_selectedObject;
    }

    @Override
    public void setCursorType(Cursor c, int type) {
        Cursor currentCursor = ((Component)((Object)this.m_graph.getThickPFJ())).getCursor();
        if (currentCursor != null && currentCursor.equals(this.getCursorType(type))) {
            ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(c);
        }
        if (type < 0 || type > 16) {
            this.m_graph.getErrorHandler().log("invalid cursor type", this.getClass().getName(), "setCursorType(Cursor c, int type)");
        } else {
            super.setCursorType(c, type);
        }
    }

    @Override
    public void setWaitCursorForced(boolean yesNo) {
        super.setWaitCursorForced(yesNo);
        this.setGraphCursor(this.m_currentComponentHandle);
    }

    @Override
    @Concealed
    public void propertyChange(PropertyChangeEvent pce) {
        PageItem pi;
        PagingComponent dpc;
        int index;
        if (!this._m_selectingPageItem && pce.getSource() instanceof PagingComponent && pce.getPropertyName() == "selectedIndex" && (index = (dpc = (PagingComponent)pce.getSource()).getIndex(pi = dpc.getSelectedItem())) != -1) {
            this.m_graph.selectObject(new PageItemComponentHandle(4, "PageItem", dpc, index));
        }
    }

    public void setGraphCursor(int id) {
        if (this.m_isWaitCursor) {
            if (!((Component)((Object)this.m_graph.getThickPFJ())).getCursor().equals(this.m_waitCursor)) {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_waitCursor);
            }
            return;
        }
        if (this.m_graph.getMouseActions() != 1) {
            if (((Component)((Object)this.m_graph.getThickPFJ())).getCursor() == null || !((Component)((Object)this.m_graph.getThickPFJ())).getCursor().equals(this.m_defaultCursor)) {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_defaultCursor);
            }
            return;
        }
        if (this.m_model.isDrillingEnabled() && this.m_graph.isEnabled() && this.m_canDrill) {
            switch (id) {
                case 10: 
                case 13: 
                case 14: 
                case 17: 
                case 32: 
                case 38: 
                case 40: 
                case 73: {
                    return;
                }
            }
            if (!((Component)((Object)this.m_graph.getThickPFJ())).getCursor().equals(this.m_drillCursor)) {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_drillCursor);
            }
            return;
        }
        if (id == this.m_selectedComponentHandle) {
            if (this._isMovableSubcomponent(id)) {
                if (this.m_graph.isMouseMovingEnabled()) {
                    if (this.m_isCursorOnResizeHandle) {
                        this._resizeHandle();
                        return;
                    }
                    if (!((Component)((Object)this.m_graph.getThickPFJ())).getCursor().equals(this.m_moveCursor)) {
                        ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_moveCursor);
                    }
                }
            } else if (!((Component)((Object)this.m_graph.getThickPFJ())).getCursor().equals(this.m_defaultCursor)) {
                ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_defaultCursor);
            }
        } else {
            if (this.m_isCursorOnResizeHandle) {
                this._resizeHandle();
                return;
            }
            ((Component)((Object)this.m_graph.getThickPFJ())).setCursor(this.m_defaultCursor);
        }
        this.m_isCursorOnResizeHandle = false;
    }

    @Override
    public void perspectiveEvent(TDGEvent event) {
        Object object = event.getSource();
        int bitSet = event.getBitSet();
        String message = null;
        if ((bitSet & 2) > 0 && (bitSet & 1) > 0 && (bitSet & 4) > 0) {
            message = "null, negative and zero";
        } else if ((bitSet & 2) > 0 && (bitSet & 1) > 0) {
            message = "negative and zero";
        } else if ((bitSet & 2) > 0 && (bitSet & 4) > 0) {
            message = "negative and null";
        } else if ((bitSet & 1) > 0 && (bitSet & 4) > 0) {
            message = "zero and null";
        } else if ((bitSet & 1) > 0) {
            message = "zero";
        } else if ((bitSet & 4) > 0) {
            message = "null";
        } else if ((bitSet & 2) > 0) {
            message = "negative";
        }
        if (object == this.m_pfj) {
            switch (event.getID()) {
                case 3968: {
                    this._mouseMoved(event);
                    break;
                }
                case 3965: {
                    this._mousePressed(event);
                    break;
                }
                case 3966: {
                    this._mouseDragged(event);
                    break;
                }
                case 3967: {
                    this._mouseReleased(event);
                    break;
                }
                case 3974: {
                    this._mouseClicked(event);
                    break;
                }
                case 3973: {
                    this._mouseEntered(event);
                    break;
                }
                case 3972: {
                    this._mouseExited(event);
                    break;
                }
                case 3969: {
                    this._keyPressed(event);
                    break;
                }
                case 3970: {
                    this._keyReleased(event);
                    break;
                }
                case 3971: {
                    this._keyTyped(event);
                    break;
                }
                case 3959: {
                    this._afterSelect(event);
                    break;
                }
                case 3976: {
                    this.m_resizeCursorValue = (Integer)event.getDataObject();
                    this._resizeHandle();
                    break;
                }
                case 3975: {
                    this.m_graph.getCommonGraph().notEnoughData(event);
                    break;
                }
                case 3985: {
                    this.m_graph.processAlertEvent(3);
                    this.m_graph.getErrorHandler().log("inappropriate data: partial group", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3980: {
                    this.m_graph.processAlertEvent(4);
                    this.m_graph.getErrorHandler().log("inappropriate data: stock high less than low", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3984: {
                    this.m_graph.processAlertEvent(5);
                    this.m_graph.getErrorHandler().log("inappropriate data: stock open or close not between high and low", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3992: {
                    this.m_graph.processAlertEvent(6);
                    this.m_graph.getErrorHandler().log("inappropriate data: all values are " + message, this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3993: {
                    this.m_graph.processAlertEvent(7);
                    this.m_graph.getErrorHandler().log("inappropriate data: all data null", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3994: {
                    this.m_graph.processAlertEvent(8);
                    this.m_graph.getErrorHandler().log("inappropriate data: partial data " + message, this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3995: {
                    this.m_graph.processAlertEvent(9);
                    this.m_graph.getErrorHandler().log("inappropriate data: partial data is null", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3996: {
                    this.m_graph.processAlertEvent(10);
                    this.m_graph.getErrorHandler().log("inappropriate data: all axis data " + message, this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3997: {
                    this.m_graph.processAlertEvent(11);
                    this.m_graph.getErrorHandler().log("inappropriate data: axis data is null", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3998: {
                    this.m_graph.getErrorHandler().log("inappropriate data: dates are out of order", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3999: {
                    this.m_graph.getErrorHandler().log("inappropriate data: dates have irregular interval", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 4000: {
                    this.m_graph.getErrorHandler().log("inappropriate data: dates are missing in the sequence", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 4001: {
                    this.m_pfj.getLegendLayout().setPositionForRect();
                    break;
                }
                case 4002: {
                    this.m_graph.getErrorHandler().log("formats for all relevant time axis elements are NONE", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3962: {
                    this._afterSelect(event);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_graph.getPagingControl() != null) {
            this.m_graph.getPagingControl().removeKeyListener(this);
            this.m_graph.getPagingControl().removeMouseListener(this);
            this.m_graph.getPagingControl().removeMouseMotionListener(this);
            this.m_graph.getPagingControl().removeFocusListener(this);
            this.m_graph.getPagingControl().getPagingComponent().removePropertyChangeListener(this);
            this.m_graph.getPagingControl().getPagingComponent().removePivotListener(this);
        }
        if (this.m_graph.getThickPFJ() != null) {
            ((Component)((Object)this.m_graph.getThickPFJ())).removeFocusListener(this);
        }
        this.m_pfj.removePerspectiveListener(this);
    }
}

