/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;

public class DataChunk
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ROWS_PER_CHUNK = 16;
    public static final int COLS_PER_CHUNK = 16;
    private int m_page;
    private int m_rowStart;
    private int m_colStart;
    private Object[][] m_cells;

    public DataChunk(int p, int r, int c) {
        int rowStart = r / 16 * 16;
        int colStart = c / 16 * 16;
        this.m_page = p;
        this.m_rowStart = rowStart;
        this.m_colStart = colStart;
        this.m_cells = new Object[16][16];
    }

    public DataChunk(DataChunk srcChunk) {
        this.m_page = srcChunk.m_page;
        this.m_rowStart = srcChunk.m_rowStart;
        this.m_colStart = srcChunk.m_colStart;
        this.m_cells = new Object[16][16];
        for (int ir = 0; ir < 16; ++ir) {
            for (int ic = 0; ic < 16; ++ic) {
                Object obj = srcChunk.m_cells[ir][ic];
                if (obj == null) continue;
                if (obj instanceof Number) {
                    this.m_cells[ir][ic] = new Double(((Number)obj).doubleValue());
                    continue;
                }
                if (!(obj instanceof String)) continue;
                this.m_cells[ir][ic] = (String)obj;
            }
        }
    }

    public boolean contains(int p, int r, int c) {
        boolean b = p == this.m_page && r >= this.m_rowStart && r < this.m_rowStart + 16 && c >= this.m_colStart && c < this.m_colStart + 16;
        return b;
    }

    public void dumpChunk() {
        for (int ir = 0; ir < 16; ++ir) {
            for (int ic = 0; ic < 16; ++ic) {
                if (this.m_cells[ir][ic] == null) continue;
            }
        }
    }

    public Object getData(int r, int c) {
        return this.m_cells[r - this.m_rowStart][c - this.m_colStart];
    }

    public boolean isOnPage(int p) {
        return p == this.m_page;
    }

    public void setData(int r, int c, Object obj) {
        this.m_cells[r - this.m_rowStart][c - this.m_colStart] = obj;
    }

    public String toString() {
        return "Chunk(" + this.m_page + "," + this.m_rowStart + "," + this.m_colStart + ")";
    }
}

