/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Area;
import java.util.List;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.DetShape;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.legend.impl.LegendMarker;
import oracle.dss.legend.impl.LegendText;
import oracle.dss.legend.impl.ListLegendItem;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Ellipse;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.FillColor;
import oracle.dss.util.shapes.FillGradient;
import oracle.dss.util.shapes.Label;
import oracle.dss.util.shapes.Line;
import oracle.dss.util.shapes.Path;
import oracle.dss.util.shapes.Rectangle;
import oracle.dss.util.shapes.Stroke;
import oracle.javatools.annotations.Concealed;

public class GraphDrawUtils {
    @Concealed
    public static void processDrawableObjects(Perspective pfj, List<DrawableObject> items) {
        for (DrawableObject d : items) {
            IdentObj id = (IdentObj)d.getProperty("L_ID");
            if (id == null) {
                id = new IdentObj(2000);
            }
            if (d instanceof Label) {
                GraphDrawUtils.convertLabel(pfj, id, (Label)d);
                continue;
            }
            if (d instanceof Rectangle) {
                GraphDrawUtils.convertRectangle(pfj, id, (Rectangle)d);
                continue;
            }
            if (d instanceof Path) {
                GraphDrawUtils.convertPath(pfj, id, (Path)d);
                continue;
            }
            if (d instanceof Ellipse) {
                GraphDrawUtils.convertEllipse(pfj, id, (Ellipse)d);
                continue;
            }
            if (!(d instanceof Line)) continue;
            GraphDrawUtils.convertLine(pfj, id, (Line)d);
        }
    }

    @Concealed
    public static BlackBoxIF convertFillToBlackBox(Perspective pfj, DrawableObject draw) {
        IdentObj id = (IdentObj)draw.getProperty("L_ID");
        BlackBoxIF bb = null;
        if (id != null) {
            if (id.getObjectID() == 13 && id.getSeriesID() != -3) {
                bb = pfj.getGraphObject().assignSeriesColor(id.getSeriesID(), false);
                bb = bb.runRules(id.getSeriesID(), id.getGroupID());
            } else if (id.getObjectID() == 504 && id.getMiscID() > 0) {
                bb = new BlackBoxObj(pfj, (IdentObj)pfj.m_referenceObjects.get(id.getMiscID() - 1));
                bb.setTransparentBorderColor(true);
            } else {
                bb = new BlackBoxObj(pfj, id);
            }
        } else {
            bb = new BlackBoxObj(pfj, new IdentObj(2000));
        }
        Fill fill = draw.getFill();
        if (fill instanceof FillColor) {
            Color c = ((FillColor)fill).getColor();
            if (c != null) {
                bb.setFillType(1);
                bb.setTransparentFillColor(false);
                bb.setFillColor(c);
            }
        } else if (fill instanceof FillGradient && ((FillGradient)fill).getGradientObj() != null) {
            bb.setFillType(2);
            bb.setFillGradientObj(new FillGradientObj(((FillGradient)fill).getGradientObj()));
        }
        Stroke border = draw.getStroke();
        if (border != null) {
            bb.setTransparentBorderColor(false);
            bb.setBorderColor(border.getColor());
        }
        return bb;
    }

    @Concealed
    public static DetLabel convertLabel(Perspective pfj, IdentObj id, Label label) {
        Font font = label.getFont();
        IdentObj initID = id;
        if (id.getObjectID() == 2000 || id.getObjectID() == 344 || id.getObjectID() == 503) {
            id = new IdentObj(14);
            label.setProperty("L_ID", id);
        }
        if (label.getAltText() != null) {
            pfj.setLegendLabelsTruncated(true);
        }
        TextStyleObj textStyleObj = font != null ? new TextStyleObj(pfj.getFontCache(), font.getFamily(), font.getStyle(), pfj.getFontSizeAbsolute(id), pfj.getFontSize(id), pfj.getFontSizeVC(id), pfj.getTextRotation(id), pfj.getTextJustHoriz(id), pfj.getTextJustVert(id), pfj.getAutofit(id), false, false) : new TextStyleObj(pfj.getFontCache(), pfj.getFontName(id), pfj.getFontStyle(id), pfj.getFontSizeAbsolute(id), pfj.getFontSize(id), pfj.getFontSizeVC(id), pfj.getTextRotation(id), pfj.getTextJustHoriz(id), pfj.getTextJustVert(id), pfj.getAutofit(id), false, true);
        return new DetLabel(pfj.getDetectiv(), initID, label.toString(), pfj.getVC().destToVirt(label.getBounds().getBounds()), textStyleObj, GraphDrawUtils.convertFillToBlackBox(pfj, label));
    }

    @Concealed
    public static DetRect convertRectangle(Perspective pfj, IdentObj id, Rectangle rect) {
        return new DetRect(pfj.getDetectiv(), id, rect.getBounds().getBounds(), GraphDrawUtils.convertFillToBlackBox(pfj, rect), true);
    }

    public static DetOval convertEllipse(Perspective pfj, IdentObj id, Ellipse ellipse) {
        return new DetOval(pfj.getDetectiv(), id, pfj.getVC().destToVirt(ellipse.getBounds().getBounds()), GraphDrawUtils.convertFillToBlackBox(pfj, ellipse));
    }

    @Concealed
    public static DetShape convertPath(Perspective pfj, IdentObj id, Path path) {
        return new DetShape(pfj.getDetectiv(), id, GraphDrawUtils.convertFillToBlackBox(pfj, path), new Area(path.getShape()));
    }

    @Concealed
    public static DetLine convertLine(Perspective pfj, IdentObj id, Line line) {
        Stroke stroke = line.getStroke();
        if (stroke == null) {
            return new DetLine(pfj.getDetectiv(), id, pfj.getVC().destToVirtX(line.getX1()), pfj.getVC().destToVirtY(line.getY1()), pfj.getVC().destToVirtX(line.getX2()), pfj.getVC().destToVirtY(line.getY2()), GraphDrawUtils.convertFillToBlackBox(pfj, line), null, 0);
        }
        int lineStyle = GraphDrawUtils.convertLineStyleToInt(stroke.getStyle());
        int lineWidth = (int)stroke.getWidth();
        return new DetLine(pfj.getDetectiv(), id, (int)pfj.getVC().destToVirtX(line.getX1()), (int)pfj.getVC().destToVirtY(line.getY1()), (int)pfj.getVC().destToVirtX(line.getX2()), (int)pfj.getVC().destToVirtY(line.getY2()), GraphDrawUtils.convertFillToBlackBox(pfj, line), null, lineWidth, lineStyle);
    }

    @Concealed
    public static LegendText createSectionTitle(String title) {
        LegendText sectionTitle = new LegendText(title);
        sectionTitle.setCustomID(new IdentObj(14));
        return sectionTitle;
    }

    @Concealed
    public static ListLegendItem createMarker(MarkerTemplate template, String text, IdentObj idMarker, IdentObj idText) {
        return GraphDrawUtils.createMarker(template, text, idMarker, idText, null, null);
    }

    @Concealed
    public static ListLegendItem createMarker(MarkerTemplate template, String text, IdentObj idMarker, IdentObj idText, Color fillColor, Color borderColor) {
        return GraphDrawUtils.createMarker(template, text, idMarker, idText, fillColor, borderColor, false);
    }

    @Concealed
    public static ListLegendItem createMarker(MarkerTemplate template, String text, IdentObj idMarker, IdentObj idText, Color fillColor, Color borderColor, boolean markerWithLine) {
        LegendMarker marker;
        LegendText label = new LegendText(text);
        FillColor fill = null;
        Stroke border = null;
        if (fillColor != null) {
            fill = new FillColor();
            fill.setColor(fillColor);
        }
        if (borderColor != null) {
            border = new Stroke();
            border.setColor(borderColor);
        }
        Stroke lborder = null;
        if (markerWithLine) {
            lborder = new Stroke();
            lborder.setWidth(template.getLineWidth());
            lborder.setColor(template.getLineColor());
            lborder.setStyle(GraphDrawUtils.convertLineStyleToString(template.getLineStyle()));
        }
        switch (template.getMarkerType()) {
            case 11: {
                marker = new LegendMarker(MarkerObj.SHAPE_HUMAN, markerWithLine, lborder);
                break;
            }
            case 4: 
            case 10: {
                marker = new LegendMarker(LegendMarker.MarkerShape.LINE);
                border = new Stroke();
                border.setWidth(template.getLineWidth());
                border.setColor(template.getLineColor());
                border.setStyle(GraphDrawUtils.convertLineStyleToString(template.getLineStyle()));
                break;
            }
            case 8: {
                marker = new LegendMarker("");
                break;
            }
            case 2: {
                marker = new LegendMarker(LegendMarker.MarkerShape.CIRCLE, markerWithLine, lborder);
                break;
            }
            case 3: {
                marker = new LegendMarker(LegendMarker.MarkerShape.DIAMOND, markerWithLine, lborder);
                break;
            }
            case 5: {
                marker = new LegendMarker(LegendMarker.MarkerShape.PLUS, markerWithLine, lborder);
                break;
            }
            case 7: {
                marker = new LegendMarker(LegendMarker.MarkerShape.TRIANGLE_UP, markerWithLine, lborder);
                break;
            }
            case 6: {
                marker = new LegendMarker(LegendMarker.MarkerShape.TRIANGLE_DN, markerWithLine, lborder);
                break;
            }
            default: {
                marker = new LegendMarker(LegendMarker.MarkerShape.RECTANGLE, markerWithLine, lborder);
            }
        }
        marker.setCustomID(idMarker);
        marker.setFill(fill);
        marker.setBorder(border);
        label.setCustomID(idText);
        ListLegendItem item = new ListLegendItem(marker, label);
        return item;
    }

    private static String convertLineStyleToString(int style) {
        if (style == 1) {
            return "dashed";
        }
        if (style == 2) {
            return "dotted";
        }
        if (style == 3) {
            return "dashDot";
        }
        return null;
    }

    private static int convertLineStyleToInt(String style) {
        if (style == null) {
            return 0;
        }
        if (style.equals("dashed")) {
            return 1;
        }
        if (style.equals("dotted")) {
            return 2;
        }
        if (style.equals("dashDot")) {
            return 3;
        }
        return 0;
    }
}

