/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis3DObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_3D_Surf;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.QSortAlgorithm;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Matrix3d;
import oracle.dss.graph.pfj.model3d.Matrix4d;
import oracle.dss.graph.pfj.model3d.Model3DCubeWall;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Model3DModRectSolid;
import oracle.dss.graph.pfj.model3d.Model3DOctagonSolid;
import oracle.dss.graph.pfj.model3d.Model3DRectPyramid;
import oracle.dss.graph.pfj.model3d.Model3DRectSolid;
import oracle.dss.graph.pfj.model3d.Model3DRibbonGroupSolid;
import oracle.dss.graph.pfj.model3d.Model3DRibbonSeriesSolid;
import oracle.dss.graph.pfj.model3d.Point3d;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class JChart_3D
extends JChart_Base {
    private static final long serialVersionUID = 1L;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    public static final int CHANGED_ALL = 0;
    public static final int CHANGED_COLOR = 1;
    public static final int CHANGED_CUBE = 2;
    public static final int CHANGED_GRID = 3;
    public static final int CHANGED_RISER = 4;
    public static final int CHANGED_SCALE = 5;
    public static final int CHANGED_VIEW = 6;
    public static final double LIGHTSOURCE_FACTOR = 0.01;
    public static final int LIGHTSOURCE_OFFSET = 0;
    public static final int SIZE_FACTOR = 200;
    public static final int SIZE_OFFSET = 2000;
    public static final int WALL_FACTOR = 20;
    public static final int WALL_OFFSET = 100;
    public static final int TRANS_FACTOR = 200;
    public static final int TRANS_OFFSET = -10000;
    public static final int VIEW_XY_FACTOR = 100;
    public static final int VIEW_XY_OFFSET = -5000;
    public static final int VIEW_Z_FACTOR = 500;
    public static final int VIEW_Z_OFFSET = 0;
    public static final int PAN_FACTOR = 300;
    public static final int PAN_OFFSET = -15000;
    public static final double ZOOM_BASE = 1.028113827;
    public static final double ZOOM_MULT = 0.25;
    public static final double ZOOM_MIN = 0.25;
    public static final double ZOOM_MAX = 4.0;
    public static final double FOCUS_BASE = 1.011778466;
    public static final double FOCUS_MULT = 0.556837407;
    public static final int INTERP_LARGE_DATASETS = 0;
    public static final int INTERP_ISOMETRIC = 1;
    public static final int INTERP_NEVER = 2;
    static final int WIREPOINTS = 17;
    static final int CONNECTIONS = 21;
    @CodeSharingSafe(value="StaticField")
    static final int[][] m_Connect = new int[][]{{0, 1}, {0, 2}, {0, 3}, {7, 3}, {1, 7}, {1, 8}, {3, 9}, {9, 2}, {2, 8}, {10, 11}, {11, 12}, {12, 13}, {13, 10}, {10, 14}, {11, 15}, {13, 16}, {14, 15}, {16, 14}, {9, 16}, {15, 8}, {12, 7}};
    Point3d[] m_wirePts3D;
    Point[] m_wirePts2D;
    boolean m_bAlreadyDrawn;
    protected boolean m_bChangedColor;
    protected boolean m_bChangedCube;
    protected boolean m_bChangedGrid;
    protected boolean m_bChangedRiser;
    protected boolean m_bChangedScale;
    protected boolean m_bChangedView;
    protected boolean m_bNoWireframeYet;
    protected boolean m_bSafeAngle;
    protected boolean m_bCanUseSimpleVis;
    protected boolean m_bColorAutoshading;
    public double m_fColorLightSourceX;
    public double m_fColorLightSourceY;
    public double m_fColorLightSourceZ;
    protected boolean m_bCubeDisplay3DFloor;
    protected boolean m_bCubeDisplay3DLeftWall;
    protected boolean m_bCubeDisplay3DRightWall;
    protected double m_fCubeSizeX;
    protected double m_fCubeSizeY;
    protected double m_fCubeSizeZ;
    protected double m_fCubeWallThickX;
    protected double m_fCubeWallThickY;
    protected double m_fCubeWallThickZ;
    protected boolean m_bGrid3DFloorDisplayX;
    protected boolean m_bGrid3DFloorDisplayZ;
    protected boolean m_bGrid3DLeftWallDisplayY;
    protected boolean m_bGrid3DLeftWallDisplayZ;
    protected boolean m_bGrid3DRightWallDisplayX;
    protected boolean m_bGrid3DRightWallDisplayY;
    protected boolean m_bGrid3DRiserDisplayX;
    protected boolean m_bGrid3DRiserDisplayY;
    protected boolean m_bGrid3DRiserDisplayZ;
    protected int m_nRiser3DThicknessY;
    protected boolean m_bRiserScaleFromZero;
    protected boolean m_bRiserSquareRisers;
    protected boolean m_bDataTextDisplay;
    protected boolean m_bScaleY1AxisAscending;
    protected boolean m_bScaleMustIncludeZero;
    protected boolean m_bScaleO1LabelDisplay;
    protected boolean m_bScaleO2LabelDisplay;
    protected boolean m_bScaleY1LabelDisplay;
    protected boolean m_bY1LogScale;
    protected double m_fViewTranslationX;
    protected double m_fViewTranslationY;
    protected double m_fViewTranslationZ;
    protected double m_fViewPanX;
    protected double m_fViewPanY;
    protected double m_fViewZoomFactor;
    protected double m_fViewFocusFactor;
    protected double m_fViewViewerX;
    protected double m_fViewViewerY;
    protected double m_fViewViewerZ;
    protected boolean m_bViewRawViewerZ;
    protected boolean m_bViewForceIsometric;
    protected Matrix3d m_rotationMatrix;
    protected Axis3DObj m_O1Axis;
    protected Axis3DObj m_O2Axis;
    protected Axis3DObj m_Y1Axis;
    protected List m_objectList;
    protected Model3DCubeWall m_Floor;
    protected Model3DCubeWall m_LWall;
    protected Model3DCubeWall m_RWall;
    protected Model3DRectSolid m_wholeCube;
    protected Matrix4d m_matrix;
    int[][] m_numYCoords;
    boolean[][] m_dataOK;
    double[][] m_rawValues;
    String[][] m_DataLabel;

    @Override
    public void calc() {
        int AxisLabelCalcPhase = 0;
        int saveMode = 0;
        boolean bUseInterpolation = false;
        super.calc();
        if (this.m_bChangedView) {
            this.createMatrix();
        }
        if (this.m_bNoWireframeYet) {
            this.createWireframe();
        }
        if (this.m_bChangedCube || this.m_bChangedScale) {
            this.createAxes3D();
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calc();
            }
            if (this.m_O1Axis != null) {
                this.m_O1Axis.calc();
            }
            if (this.m_O2Axis != null) {
                this.m_O2Axis.calc();
            }
            this.calcDataAbsolute();
        }
        if (this.m_bChangedCube) {
            this.defineCube();
        }
        if (this.m_bChangedCube || this.m_bChangedView) {
            this.setDrawOrder();
        }
        if (this.m_bSafeAngle) {
            this.m_Floor.preDisplay();
            this.m_LWall.preDisplay();
            this.m_RWall.preDisplay();
            switch (this.m_Perspective.getCubeRiserInterpolation()) {
                case 0: {
                    bUseInterpolation = !this.m_bSmallDataSet;
                    break;
                }
                case 1: {
                    bUseInterpolation = this.m_bViewForceIsometric;
                    break;
                }
            }
            if (bUseInterpolation) {
                if (this.m_bChangedRiser || this.m_bChangedScale) {
                    this.defineFast3DMatrixObjects();
                }
            } else if (this.m_bChangedRiser || this.m_bChangedScale) {
                this.define3DMatrixObjects();
            }
            this.m_RWall.postDisplay();
            this.m_LWall.postDisplay();
            this.m_Floor.postDisplay();
        } else {
            if (this.m_bChangedRiser || this.m_bChangedScale) {
                this.define3DMatrixObjects();
            }
            if (this.m_bChangedRiser || this.m_bChangedView) {
                this.sort3DObjects();
            }
            this.displayAll3DObjects();
        }
        this.calculateAxisTitlePosition();
        while (true) {
            if (AxisLabelCalcPhase < 1) {
                this.m_Perspective.setMinimumAxisTextSizeVC(16000);
                saveMode = this.m_Perspective.getAxisTextAutofitMode();
                this.m_Perspective.setAxisTextAutofitMode(0);
                if (saveMode != 0) {
                    this.m_Perspective.setTestLabelCalc(true);
                } else {
                    this.m_Perspective.setTestLabelCalc(false);
                }
            }
            if (this.m_O1Axis != null && this.m_bScaleO1LabelDisplay) {
                this.m_O1Axis.calcLabels();
                if (AxisLabelCalcPhase < 1 && this.m_O1Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_O1Axis.getAxisTextLabelSizeVC());
                }
            }
            if (this.m_O2Axis != null && this.m_bScaleO2LabelDisplay) {
                this.m_O2Axis.calcLabels();
                if (AxisLabelCalcPhase < 1 && this.m_O2Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_O2Axis.getAxisTextLabelSizeVC());
                }
            }
            if (this.m_Y1Axis != null && this.m_bScaleY1LabelDisplay) {
                this.m_Y1Axis.calcLabels();
                if (AxisLabelCalcPhase < 1 && this.m_Y1Axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                    this.m_Perspective.setMinimumAxisTextSizeVC(this.m_Y1Axis.getAxisTextLabelSizeVC());
                }
            }
            if (AxisLabelCalcPhase < 1) {
                this.m_Perspective.setAxisTextAutofitMode(saveMode);
                this.m_Perspective.setTestLabelCalc(false);
            }
            if (this.m_Perspective.getAxisTextAutofitMode() == 0 || AxisLabelCalcPhase == 1) break;
            ++AxisLabelCalcPhase;
        }
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcGrids();
        }
        if (this.m_O2Axis != null) {
            this.m_O2Axis.calcGrids();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcGrids();
        }
        this.fireInapropriateDataEvent();
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Axis3DObj axisObj = this.m_Y1Axis;
        double fValue = 0.0;
        boolean bNegLogEvent = false;
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_rawValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                this.m_dataOK[s][g] = true;
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.m_fValue;
                if (!dObj.m_bOK) {
                    this.m_dataOK[s][g] = false;
                }
                if (this.m_bY1LogScale && fValue <= 0.0) {
                    if (fValue == 0.0 && dObj.m_bOK) {
                        this.m_zeroVal = true;
                    } else if (fValue < 0.0) {
                        this.m_negativeVal = true;
                    }
                    bNegLogEvent = true;
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                } else {
                    this.m_positiveVal = true;
                }
                if (this.isIgnoredOffScale(axisObj, fValue)) {
                    this.m_dataOK[s][g] = false;
                    fValue = 0.0;
                }
                this.m_rawValues[s][g] = fValue;
                this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
            }
        }
    }

    @Override
    public void calcDataScrollers() {
    }

    protected int calcSeriesPerPixel() {
        Point3d p0 = new Point3d(this.m_fCubeWallThickX, this.m_fCubeWallThickY, this.m_fCubeSizeZ);
        Point3d p1 = new Point3d(this.m_fCubeSizeX - this.m_fCubeWallThickX, this.m_fCubeWallThickY, this.m_fCubeSizeZ);
        this.transformPoint3d(p0);
        this.transformPoint3d(p1);
        Point p2d_0 = this.projectPoint3d(p0);
        Point p2d_1 = this.projectPoint3d(p1);
        int nPixelsX = this.m_Perspective.m_VC.virtToDestWidth(p2d_1.x - p2d_0.x);
        int nSeriesPerPixel = this.m_nSeries / nPixelsX;
        if (nSeriesPerPixel < 1) {
            nSeriesPerPixel = 1;
        }
        return nSeriesPerPixel;
    }

    private Point3d centerGraph(Matrix4d mCurrent) {
        double oldX = mCurrent.m30;
        double oldY = mCurrent.m31;
        double oldZ = mCurrent.m32;
        mCurrent.translate(-oldX, -oldY, -oldZ);
        return new Point3d(oldX, oldY, oldZ);
    }

    public void changed() {
        this.changed(0);
    }

    public void changed(int what) {
        switch (what) {
            case 0: {
                this.m_bChangedColor = true;
                this.m_bChangedCube = true;
                this.m_bChangedGrid = true;
                this.m_bChangedRiser = true;
                this.m_bChangedScale = true;
                this.m_bChangedView = true;
                break;
            }
            case 1: {
                this.m_bChangedColor = true;
                break;
            }
            case 2: {
                this.m_bChangedCube = true;
                break;
            }
            case 3: {
                this.m_bChangedGrid = true;
                break;
            }
            case 4: {
                this.m_bChangedRiser = true;
                break;
            }
            case 5: {
                this.m_bChangedScale = true;
                break;
            }
            case 6: {
                this.m_bChangedView = true;
                break;
            }
            default: {
                throw new AssertionException(0, 6, what);
            }
        }
    }

    public void clearWireframe() {
        this.m_bAlreadyDrawn = false;
    }

    @Override
    public void copyParams() {
        super.copyParams();
        this.copyColorParams();
        this.copyCubeParams();
        this.copyGridParams();
        this.copyRiserParams();
        this.copyScaleParams();
        this.copyViewParams();
    }

    public void copyColorParams() {
        this.m_bColorAutoshading = this.m_Perspective.getAutoshading();
        this.m_fColorLightSourceX = this.denormalize(this.m_Perspective.getCubeLightSourceX(), 0.0, 100.0, 0.01, 0.0);
        this.m_fColorLightSourceY = this.denormalize(this.m_Perspective.getCubeLightSourceY(), 0.0, 100.0, 0.01, 0.0);
        this.m_fColorLightSourceZ = this.denormalize(this.m_Perspective.getCubeLightSourceZ(), 0.0, 100.0, 0.01, 0.0);
    }

    public void copyCubeParams() {
        this.m_bCubeDisplay3DFloor = this.m_Perspective.getDisplay3DFloor();
        this.m_bCubeDisplay3DLeftWall = this.m_Perspective.getDisplay3DLeftWall();
        this.m_bCubeDisplay3DRightWall = this.m_Perspective.getDisplay3DRightWall();
        this.m_fCubeWallThickX = this.denormalize(this.m_Perspective.getCubeWallThickX(), 0.0, 100.0, 20.0, 100.0);
        this.m_fCubeWallThickY = this.denormalize(this.m_Perspective.getCubeWallThickY(), 0.0, 100.0, 20.0, 100.0);
        this.m_fCubeWallThickZ = this.denormalize(this.m_Perspective.getCubeWallThickZ(), 0.0, 100.0, 20.0, 100.0);
        this.m_fCubeSizeX = this.denormalize(this.m_Perspective.getCubeSizeX(), 0.0, 100.0, 200.0, 2000.0);
        this.m_fCubeSizeY = this.denormalize(this.m_Perspective.getCubeSizeY(), 0.0, 100.0, 200.0, 2000.0);
        this.m_fCubeSizeZ = this.denormalize(this.m_Perspective.getCubeSizeZ(), 0.0, 100.0, 200.0, 2000.0);
    }

    public void copyGridParams() {
        this.m_bGrid3DFloorDisplayX = this.m_Perspective.getGrid3DFloorDisplayX();
        this.m_bGrid3DFloorDisplayZ = this.m_Perspective.getGrid3DFloorDisplayZ();
        this.m_bGrid3DLeftWallDisplayY = this.m_Perspective.getGrid3DLeftWallDisplayY();
        this.m_bGrid3DLeftWallDisplayZ = this.m_Perspective.getGrid3DLeftWallDisplayZ();
        this.m_bGrid3DRightWallDisplayX = this.m_Perspective.getGrid3DRightWallDisplayX();
        this.m_bGrid3DRightWallDisplayY = this.m_Perspective.getGrid3DRightWallDisplayY();
        this.m_bGrid3DRiserDisplayX = this.m_Perspective.getGrid3DRiserDisplayX();
        this.m_bGrid3DRiserDisplayY = this.m_Perspective.getGrid3DRiserDisplayY();
        this.m_bGrid3DRiserDisplayZ = this.m_Perspective.getGrid3DRiserDisplayZ();
    }

    public void copyRiserParams() {
        this.m_nRiser3DThicknessY = this.m_Perspective.getRiser3DThicknessY();
        this.m_bRiserScaleFromZero = this.m_Perspective.getScaleFromZero() && (this.m_gt.is3DRiser() || this.m_gt.is3DSurface() || this.m_gt.equals(5));
        this.m_bRiserSquareRisers = this.m_Perspective.getCubeSquareRisers() && (this.m_gt.is3DFloating() || this.m_gt.is3DRiser());
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
    }

    public void copyScaleParams() {
        this.m_bScaleY1AxisAscending = true;
        this.m_bScaleMustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        this.m_bScaleO1LabelDisplay = this.m_Perspective.getO1LabelDisplay();
        this.m_bScaleO2LabelDisplay = this.m_Perspective.getO2LabelDisplay();
        this.m_bScaleY1LabelDisplay = this.m_Perspective.getY1LabelDisplay();
        this.m_bY1LogScale = this.m_Perspective.getY1LogScale();
    }

    public void copyViewParams() {
        this.m_fViewTranslationX = this.denormalize(this.m_Perspective.getCubeTranslationX(), 0.0, 100.0, 200.0, -10000.0);
        this.m_fViewTranslationY = this.denormalize(this.m_Perspective.getCubeTranslationY(), 0.0, 100.0, 200.0, -10000.0);
        this.m_fViewTranslationZ = this.denormalize(this.m_Perspective.getCubeTranslationZ(), 0.0, 100.0, 200.0, -10000.0);
        this.m_fViewViewerX = this.denormalize(this.m_Perspective.getCubeViewerX(), 0.0, 100.0, 100.0, -5000.0);
        this.m_fViewViewerY = this.denormalize(this.m_Perspective.getCubeViewerY(), 0.0, 100.0, 100.0, -5000.0);
        this.m_fViewViewerZ = this.denormalize(this.m_Perspective.getCubeViewerZ(), 0.0, 100.0, 500.0, 0.0);
        this.m_bViewRawViewerZ = true;
        this.m_fViewPanX = this.denormalize(this.m_Perspective.getCubePanX(), 0.0, 100.0, 300.0, -15000.0);
        this.m_fViewPanY = this.denormalize(this.m_Perspective.getCubePanY(), 0.0, 100.0, 300.0, -15000.0);
        this.m_fViewZoomFactor = this.denormalizeGeom(this.m_Perspective.getCubeZoomFactor(), 0.0, 100.0, 1.028113827, 0.25);
        this.m_fViewFocusFactor = this.denormalizeGeom(this.m_Perspective.getCubeFocusFactor(), 0.0, 100.0, 1.011778466, 0.556837407);
        this.m_bViewForceIsometric = this.m_Perspective.getCubeIsometricProjection();
        this.m_rotationMatrix = this.m_Perspective.getCubeRotationMatrix();
    }

    private void createAxes3D() {
        int orient = 2;
        int scaling = 1;
        int offsetY1 = 0;
        int sizeY1 = 100;
        boolean bAscending = !this.m_gt.is3DSurface();
        this.m_O1Axis = new Axis3DObj(this, this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, this.m_gt.is3DConnectSeries() ? 5 : 7, orient, bAscending, (int)this.m_fCubeWallThickZ, (int)(this.m_fCubeSizeZ - this.m_fCubeWallThickZ));
        this.m_O2Axis = new Axis3DObj(this, this.m_Perspective, this.m_Access, AxisTemplate.O2_AXIS, this.m_gt.is3DConnectGroups() ? 4 : 8, orient, true, (int)this.m_fCubeWallThickX, (int)(this.m_fCubeSizeX - this.m_fCubeWallThickX));
        MinMaxObj y1MinMaxObj = this.findLimits(0, scaling, this.m_bScaleMustIncludeZero);
        this.m_Y1Axis = new Axis3DObj(this, this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, orient, this.m_bScaleY1AxisAscending, offsetY1, sizeY1, (int)this.m_fCubeWallThickY, (int)(this.m_fCubeSizeY - this.m_fCubeWallThickY));
    }

    public void createMatrix() {
        this.m_matrix = new Matrix4d();
        this.m_matrix.rotate(this.m_rotationMatrix);
        this.m_matrix.scale(this.m_fViewZoomFactor);
        this.m_matrix.translate(this.m_fViewTranslationX, this.m_fViewTranslationY, this.m_fViewTranslationZ);
    }

    public void createWireframe() {
        this.m_wirePts3D = new Point3d[17];
        this.m_wirePts2D = new Point[17];
        for (int i = 0; i < 17; ++i) {
            this.m_wirePts3D[i] = new Point3d();
            this.m_wirePts2D[i] = new Point(0, 0);
        }
        this.setWireframePoints();
        this.m_bNoWireframeYet = false;
    }

    public void defineCube() {
        Point3d origin = new Point3d(0.0, 0.0, 0.0);
        Point3d size = new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        if (this.m_bViewRawViewerZ) {
            double fMinZ = this.getMinCubeViewerZ();
            this.m_fViewViewerZ += fMinZ;
            this.m_bViewRawViewerZ = false;
        }
        IdentObj id = new IdentObj(-3);
        bGridStatus[1][0] = false;
        bGridStatus[1][1] = false;
        bGridStatus[1][2] = false;
        this.m_wholeCube = new Model3DRectSolid(this, id, null, origin, size, bGridStatus, false, false);
        this.m_bSafeAngle = this.m_gt.is3DSurface() ? false : this.m_wholeCube.visibility(0) >= 0.0 && this.m_wholeCube.visibility(2) >= 0.0 && this.m_wholeCube.visibility(4) >= 0.0;
        this.m_bCanUseSimpleVis = this.m_bSafeAngle && !this.m_bColorAutoshadeRisers;
        size.y = this.m_fCubeWallThickY;
        id = new IdentObj(603);
        bGridStatus[1][0] = this.m_bGrid3DFloorDisplayX;
        bGridStatus[1][1] = false;
        bGridStatus[1][2] = this.m_bGrid3DFloorDisplayZ;
        this.m_Floor = new Model3DCubeWall(this, id, null, origin, size, bGridStatus, this.m_bColorAutoshading);
        this.m_Floor.calcGrids();
        origin.y = this.m_fCubeWallThickY;
        size.x = this.m_fCubeWallThickX;
        size.y = this.m_fCubeSizeY - this.m_fCubeWallThickY;
        id = new IdentObj(604);
        bGridStatus[1][0] = false;
        bGridStatus[1][1] = this.m_bGrid3DLeftWallDisplayY;
        bGridStatus[1][2] = this.m_bGrid3DLeftWallDisplayZ;
        this.m_LWall = new Model3DCubeWall(this, id, null, origin, size, bGridStatus, this.m_bColorAutoshading);
        this.m_LWall.calcGrids();
        origin.x = this.m_fCubeWallThickX;
        size.x = this.m_fCubeSizeX - this.m_fCubeWallThickX;
        size.z = this.m_fCubeWallThickZ;
        id = new IdentObj(605);
        bGridStatus[1][0] = this.m_bGrid3DRightWallDisplayX;
        bGridStatus[1][1] = this.m_bGrid3DRightWallDisplayY;
        bGridStatus[1][2] = false;
        this.m_RWall = new Model3DCubeWall(this, id, null, origin, size, bGridStatus, this.m_bColorAutoshading);
        this.m_RWall.calcGrids();
    }

    public void define3DMatrixObjects() {
        double minSize;
        double sizeZ;
        double sizeX;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(false);
        BlackBoxIF bb = null;
        Point3d origin = new Point3d();
        Point3d size = new Point3d();
        this.m_objectList = !this.m_bSafeAngle ? new ArrayList(this.m_nSeries * this.m_nGroups) : null;
        origin.y = this.m_bRiserScaleFromZero ? this.m_Y1Axis.getValueCoord(0.0) : this.m_Y1Axis.getBaseCoord();
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        bGridStatus[1][0] = this.m_bGrid3DRiserDisplayX;
        bGridStatus[1][1] = this.m_bGrid3DRiserDisplayY;
        bGridStatus[1][2] = this.m_bGrid3DRiserDisplayZ;
        double oldsizeX = sizeX = this.m_O2Axis.getHighCoord(0, 0) - this.m_O2Axis.getLowCoord(0, 0);
        double oldsizeZ = sizeZ = this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0);
        double d = minSize = sizeX < sizeZ ? sizeX : sizeZ;
        if (this.m_bRiserSquareRisers) {
            sizeX = sizeZ = minSize;
        }
        while (sEnum.hasMoreElements()) {
            int sRel;
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_nEffColorMode == 1) {
                bb = this.assignSeriesColor(s, 0);
                bb.runRules(s, -3);
            }
            PfjAssert.pfjAssert((sRel = sEnum.getRelativeSeries(s)) >= 0 && sRel < this.m_nSeries);
            origin.x = this.m_O2Axis.getLowCoord(0, sRel);
            size.x = sizeX;
            if (this.m_bRiserSquareRisers && oldsizeX != minSize) {
                origin.x += (oldsizeX - minSize) / 2.0;
            }
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                BlackBoxIF bbNew;
                int g = gEnum.nextGroup();
                int gRel = gEnum.getRelativeGroup(g);
                if (!this.m_dataOK[s][g]) continue;
                origin.z = this.m_O1Axis.getLowCoord(0, gRel);
                size.z = sizeZ;
                if (this.m_bRiserSquareRisers && oldsizeZ != minSize) {
                    origin.z += (oldsizeZ - minSize) / 2.0;
                }
                size.y = (double)this.m_numYCoords[s][g] - origin.y;
                IdentObj id = new IdentObj(606, s, g);
                if (this.m_nEffColorMode != 1) {
                    bb = this.assignSeriesColor(s, g);
                    bb.runRules(s, g);
                }
                if ((bbNew = this.getMissingDataBlackBox(s, g)) == null) {
                    bbNew = bb;
                }
                this.defineRiserObject(sEnum, gEnum, id, bbNew, origin, size, bGridStatus);
            }
        }
    }

    public void defineFast3DMatrixObjects() {
        double minSize;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator(false);
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        int gFirst = gEnum.getFirstGroup();
        int gLast = gEnum.getLastGroup();
        double fMin = this.m_Y1Axis.getMinValue();
        double fMax = this.m_Y1Axis.getMaxValue();
        double fMinCoord = this.m_Y1Axis.getMinCoord();
        double fMaxCoord = this.m_Y1Axis.getMaxCoord();
        double sizeX = this.m_O2Axis.getHighCoord(0, 0) - this.m_O2Axis.getLowCoord(0, 0);
        double sizeZ = this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0);
        double oldsizeX = sizeX;
        double oldsizeZ = sizeZ;
        double d = minSize = sizeX < sizeZ ? sizeX : sizeZ;
        if (this.m_bRiserSquareRisers) {
            sizeX = sizeZ = minSize;
        }
        Point3d size = new Point3d(sizeX, fMaxCoord - fMinCoord, sizeZ);
        double fLeftX = this.m_O2Axis.getLowCoord(0, sFirst);
        double fRightX = this.m_O2Axis.getLowCoord(0, sLast);
        double fBackZ = this.m_O1Axis.getLowCoord(0, gLast);
        double fFrontZ = this.m_O1Axis.getLowCoord(0, gFirst);
        if (this.m_bRiserSquareRisers && oldsizeX != minSize) {
            fLeftX += (oldsizeX - minSize) / 2.0;
            fRightX += (oldsizeX - minSize) / 2.0;
        }
        if (this.m_bRiserSquareRisers && oldsizeZ != minSize) {
            fBackZ += (oldsizeZ - minSize) / 2.0;
            fFrontZ += (oldsizeZ - minSize) / 2.0;
        }
        Point3d originBackLeft = new Point3d(fLeftX, fMinCoord, fBackZ);
        Point3d originBackRight = new Point3d(fRightX, fMinCoord, fBackZ);
        Point3d originFrontLeft = new Point3d(fLeftX, fMinCoord, fFrontZ);
        Point3d originFrontRight = new Point3d(fRightX, fMinCoord, fFrontZ);
        IdentObj id = new IdentObj(606, sFirst, gLast);
        Model3DRectSolid mdlBackLeft = new Model3DRectSolid(this, id, null, originBackLeft, size, null, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        id = new IdentObj(606, sLast, gLast);
        Model3DRectSolid mdlBackRight = new Model3DRectSolid(this, id, null, originBackRight, size, null, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        id = new IdentObj(606, sFirst, gFirst);
        Model3DRectSolid mdlFrontLeft = new Model3DRectSolid(this, id, null, originFrontLeft, size, null, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        id = new IdentObj(606, sLast, gFirst);
        Model3DRectSolid mdlFrontRight = new Model3DRectSolid(this, id, null, originFrontRight, size, null, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        mdlBackLeft.transformVertices();
        mdlBackRight.transformVertices();
        mdlFrontLeft.transformVertices();
        mdlFrontRight.transformVertices();
        double[] xBackLeft = new double[8];
        double[] yBackLeft = new double[8];
        double[] xBackRight = new double[8];
        double[] yBackRight = new double[8];
        double[] xFrontLeft = new double[8];
        double[] yFrontLeft = new double[8];
        double[] xFrontRight = new double[8];
        double[] yFrontRight = new double[8];
        mdlBackLeft.projectVerticesInDouble(xBackLeft, yBackLeft);
        mdlBackRight.projectVerticesInDouble(xBackRight, yBackRight);
        mdlFrontLeft.projectVerticesInDouble(xFrontLeft, yFrontLeft);
        mdlFrontRight.projectVerticesInDouble(xFrontRight, yFrontRight);
        BlackBoxIF bb = null;
        double[] xBack = new double[8];
        double[] yBack = new double[8];
        double[] xFront = new double[8];
        double[] yFront = new double[8];
        double[] xFactor = new double[8];
        double[] yFactor = new double[8];
        double[] xRiserEntire = new double[8];
        double[] yRiserEntire = new double[8];
        double[] xRiser = new double[8];
        double[] yRiser = new double[8];
        for (int sRel = 0; sRel < this.m_nSeries; ++sRel) {
            int i;
            int s = sEnum.seriesAt(sRel);
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_nEffColorMode == 1) {
                bb = this.assignSeriesColor(s, 0);
                bb.runRules(s, -3);
            }
            for (i = 0; i < 8; ++i) {
                xBack[i] = xBackLeft[i] + (double)sRel * (xBackRight[i] - xBackLeft[i]) / (double)(this.m_nSeries - 1);
                yBack[i] = yBackLeft[i] + (double)sRel * (yBackRight[i] - yBackLeft[i]) / (double)(this.m_nSeries - 1);
                xFront[i] = xFrontLeft[i] + (double)sRel * (xFrontRight[i] - xFrontLeft[i]) / (double)(this.m_nSeries - 1);
                yFront[i] = yFrontLeft[i] + (double)sRel * (yFrontRight[i] - yFrontLeft[i]) / (double)(this.m_nSeries - 1);
                xFactor[i] = (xFront[i] - xBack[i]) / (double)(this.m_nGroups - 1);
                yFactor[i] = (yFront[i] - yBack[i]) / (double)(this.m_nGroups - 1);
            }
            for (int gRel = 0; gRel < this.m_nGroups; ++gRel) {
                BlackBoxIF bbNew;
                int g = gEnum.groupAt(gRel);
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g]) continue;
                for (i = 0; i < 8; ++i) {
                    xRiserEntire[i] = xBack[i] + (double)gRel * xFactor[i];
                    yRiserEntire[i] = yBack[i] + (double)gRel * yFactor[i];
                    xRiser[i] = xRiserEntire[i];
                    yRiser[i] = yRiserEntire[i];
                }
                double fValue = this.m_rawValues[s][g];
                double fRiserMin = fMin;
                double fRiserMax = fValue;
                double fRatioMax = (fRiserMax - fMin) / (fMax - fMin);
                xRiser[2] = xRiser[1] + fRatioMax * (xRiser[2] - xRiser[1]);
                yRiser[2] = yRiser[1] + fRatioMax * (yRiser[2] - yRiser[1]);
                xRiser[3] = xRiser[0] + fRatioMax * (xRiser[3] - xRiser[0]);
                yRiser[3] = yRiser[0] + fRatioMax * (yRiser[3] - yRiser[0]);
                xRiser[6] = xRiser[5] + fRatioMax * (xRiser[6] - xRiser[5]);
                yRiser[6] = yRiser[5] + fRatioMax * (yRiser[6] - yRiser[5]);
                xRiser[7] = xRiser[4] + fRatioMax * (xRiser[7] - xRiser[4]);
                yRiser[7] = yRiser[4] + fRatioMax * (yRiser[7] - yRiser[4]);
                id = new IdentObj(606, s, g);
                if (this.m_nEffColorMode != 1) {
                    bb = this.assignSeriesColor(s, g);
                    bb.runRules(s, g);
                }
                if ((bbNew = this.getMissingDataBlackBox(s, g)) == null) {
                    bbNew = bb;
                }
                this.drawRiser(id, bbNew, xRiser, yRiser);
            }
        }
    }

    public Model3DFlatFace defineRiserObject(SeriesEnumerator sEnum, GroupsEnumerator gEnum, IdentObj id, BlackBoxIF bb, Point3d origin, Point3d size, boolean[][] bGridStatus) {
        Model3DFlatFace m = null;
        Point3d modOrigin = new Point3d(origin);
        Point3d modSize = new Point3d(size);
        double cubeThick = 0.0;
        int s = id.getSeriesID();
        int g = id.getGroupID();
        boolean bInverted = false;
        double f0 = this.m_numYCoords[s][g];
        double f1 = 0.0;
        if (modSize.y < 0.0) {
            bInverted = true;
            modOrigin.y += modSize.y;
            modSize.y = -modSize.y;
        }
        if (this.m_gt.is3DRaisedOrigin()) {
            double oldOrigin = modOrigin.y;
            cubeThick = this.m_gt.is3DConnectSeries() ? modSize.x * (double)this.m_nRiser3DThicknessY / 100.0 : (this.m_gt.is3DConnectGroups() ? modSize.z * (double)this.m_nRiser3DThicknessY / 100.0 : Math.max(modSize.x, modSize.z) * (double)this.m_nRiser3DThicknessY / 100.0);
            if (this.m_gt.is3DFloating()) {
                modOrigin.y = bInverted ? (modOrigin.y -= cubeThick / 2.0) : modOrigin.y + modSize.y - cubeThick / 2.0;
                modSize.y = cubeThick;
                if (modOrigin.y < this.m_fCubeWallThickY) {
                    modSize.y -= this.m_fCubeWallThickY - modOrigin.y;
                    modOrigin.y = this.m_fCubeWallThickY;
                }
            } else {
                modOrigin.y = modOrigin.y + modSize.y - cubeThick;
                if (modOrigin.y < this.m_fCubeWallThickY && !this.m_gt.is3DRibbonType()) {
                    modOrigin.y = this.m_fCubeWallThickY;
                }
                modSize.y = modSize.y + oldOrigin - modOrigin.y;
            }
        }
        if (this.m_gt.equals(0)) {
            m = new Model3DRectSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        } else if (this.m_gt.equals(1)) {
            m = new Model3DRectPyramid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, bInverted);
        } else if (this.m_gt.equals(2)) {
            m = new Model3DOctagonSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers);
        } else if (this.m_gt.equals(4)) {
            m = new Model3DRectSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        } else if (this.m_gt.equals(5)) {
            m = new Model3DRectPyramid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, bInverted);
        } else if (this.m_gt.equals(6)) {
            int gNext;
            if (gEnum.hasMoreElements() && this.m_dataOK[s][gNext = gEnum.peekAtNextGroup()] && (!this.m_bCubeDisplay3DFloor || f0 >= this.m_fCubeWallThickY || (double)this.m_numYCoords[s][gNext] >= this.m_fCubeWallThickY)) {
                m = new Model3DModRectSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers);
                double newTop = this.m_numYCoords[s][gNext];
                boolean bDescendingO1 = this.m_O1Axis.isDescending();
                if (bDescendingO1) {
                    ((Model3DModRectSolid)m).modBackFace(newTop, modOrigin.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
                } else {
                    ((Model3DModRectSolid)m).modFrontFace(newTop, modOrigin.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
                }
            }
        } else if (this.m_gt.equals(7)) {
            if (gEnum.hasMoreElements()) {
                int gNext = gEnum.peekAtNextGroup();
                if (gNext == -1 || !this.m_dataOK[s][gNext]) {
                    return null;
                }
                f1 = f0;
                f0 = this.m_numYCoords[s][gNext];
                if (!this.m_bCubeDisplay3DFloor || f0 >= this.m_fCubeWallThickY || f1 >= this.m_fCubeWallThickY) {
                    double z4;
                    double y4;
                    double z8;
                    double z6;
                    double y8;
                    double y6;
                    double z2;
                    double z0;
                    double y2;
                    double y0;
                    int nClipFront;
                    int nClipBack;
                    if (!this.m_bCubeDisplay3DFloor) {
                        nClipBack = 0;
                        nClipFront = 0;
                    } else {
                        nClipFront = f0 - modSize.y >= this.m_fCubeWallThickY ? 0 : (f0 >= this.m_fCubeWallThickY ? 1 : 2);
                        nClipBack = f1 - modSize.y >= this.m_fCubeWallThickY ? 0 : (f1 >= this.m_fCubeWallThickY ? 1 : 2);
                    }
                    if (nClipFront == 0) {
                        y0 = f0 - modSize.y;
                        y2 = f0;
                        z0 = 1.0;
                        z2 = 1.0;
                    } else if (nClipFront == 1) {
                        y0 = this.m_fCubeWallThickY;
                        y2 = f0;
                        z0 = 1.0;
                        z2 = 1.0;
                    } else if (nClipFront == 2) {
                        y0 = this.m_fCubeWallThickY;
                        y2 = this.m_fCubeWallThickY;
                        z2 = (f1 - this.m_fCubeWallThickY) / (f1 - f0);
                        z0 = nClipBack == 0 ? (f1 - modSize.y - this.m_fCubeWallThickY) / (f1 - f0) : z2;
                    } else {
                        throw new AssertionException("oops, unknown nClipFront = " + nClipFront);
                    }
                    if (nClipBack == 0) {
                        y6 = f1 - modSize.y;
                        y8 = f1;
                        z6 = 0.0;
                        z8 = 0.0;
                    } else if (nClipBack == 1) {
                        y6 = this.m_fCubeWallThickY;
                        y8 = f1;
                        z6 = 0.0;
                        z8 = 0.0;
                    } else if (nClipBack == 2) {
                        y6 = this.m_fCubeWallThickY;
                        y8 = this.m_fCubeWallThickY;
                        z8 = (this.m_fCubeWallThickY - f1) / (f0 - f1);
                        z6 = nClipFront == 0 ? (this.m_fCubeWallThickY - (f1 - modSize.y)) / (f0 - f1) : z8;
                    } else {
                        throw new AssertionException("oops, unknown nClipBack = " + nClipBack);
                    }
                    if (nClipFront == 0 && nClipBack == 1) {
                        y4 = this.m_fCubeWallThickY;
                        z4 = (this.m_fCubeWallThickY - (f1 - modSize.y)) / (f0 - f1);
                    } else if (nClipFront == 1 && nClipBack == 0) {
                        y4 = this.m_fCubeWallThickY;
                        z4 = (f1 - modSize.y - this.m_fCubeWallThickY) / (f1 - f0);
                    } else {
                        y4 = y6;
                        z4 = z6;
                    }
                    Point3d[] pts = new Point3d[]{new Point3d(modOrigin.x, y0, modOrigin.z + z0 * modSize.z), new Point3d(modOrigin.x + modSize.x, y0, modOrigin.z + z0 * modSize.z), new Point3d(modOrigin.x, y2, modOrigin.z + z2 * modSize.z), new Point3d(modOrigin.x + modSize.x, y2, modOrigin.z + z2 * modSize.z), new Point3d(modOrigin.x, y4, modOrigin.z + z4 * modSize.z), new Point3d(modOrigin.x + modSize.x, y4, modOrigin.z + z4 * modSize.z), new Point3d(modOrigin.x, y6, modOrigin.z + z6 * modSize.z), new Point3d(modOrigin.x + modSize.x, y6, modOrigin.z + z6 * modSize.z), new Point3d(modOrigin.x, y8, modOrigin.z + z8 * modSize.z), new Point3d(modOrigin.x + modSize.x, y8, modOrigin.z + z8 * modSize.z)};
                    m = new Model3DRibbonSeriesSolid(this, id, bb, modOrigin, modSize, pts, bGridStatus, this.m_bColorAutoshadeRisers);
                }
            }
        } else if (this.m_gt.equals(9)) {
            int sNext;
            if (sEnum.hasMoreElements() && this.m_dataOK[sNext = sEnum.peekAtNextSeries()][g] && (!this.m_bCubeDisplay3DFloor || f0 >= this.m_fCubeWallThickY || (double)this.m_numYCoords[sNext][g] >= this.m_fCubeWallThickY)) {
                m = new Model3DModRectSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers);
                double newTop = this.m_numYCoords[sNext][g];
                ((Model3DModRectSolid)m).modRightFace(newTop, modOrigin.y, this.m_bCubeDisplay3DFloor, this.m_fCubeWallThickY);
            }
        } else if (this.m_gt.equals(10)) {
            if (sEnum.hasMoreElements()) {
                int sNext = sEnum.peekAtNextSeries();
                if (sNext == -1 || !this.m_dataOK[sNext][g]) {
                    return null;
                }
                f1 = this.m_numYCoords[sNext][g];
                if (!this.m_bCubeDisplay3DFloor || f0 >= this.m_fCubeWallThickY || f1 >= this.m_fCubeWallThickY) {
                    double x4;
                    double y4;
                    double x8;
                    double x6;
                    double y8;
                    double y6;
                    double x2;
                    double x0;
                    double y2;
                    double y0;
                    int nClipFront;
                    int nClipBack;
                    if (!this.m_bCubeDisplay3DFloor) {
                        nClipBack = 0;
                        nClipFront = 0;
                    } else {
                        nClipBack = f0 - modSize.y >= this.m_fCubeWallThickY ? 0 : (f0 >= this.m_fCubeWallThickY ? 1 : 2);
                        nClipFront = f1 - modSize.y >= this.m_fCubeWallThickY ? 0 : (f1 >= this.m_fCubeWallThickY ? 1 : 2);
                    }
                    if (nClipBack == 0) {
                        y0 = f0 - modSize.y;
                        y2 = f0;
                        x0 = 0.0;
                        x2 = 0.0;
                    } else if (nClipBack == 1) {
                        y0 = this.m_fCubeWallThickY;
                        y2 = f0;
                        x0 = 0.0;
                        x2 = 0.0;
                    } else if (nClipBack == 2) {
                        y0 = this.m_fCubeWallThickY;
                        y2 = this.m_fCubeWallThickY;
                        x2 = (this.m_fCubeWallThickY - f0) / (f1 - f0);
                        x0 = nClipFront == 0 ? (this.m_fCubeWallThickY - (f0 - modSize.y)) / (f1 - f0) : x2;
                    } else {
                        throw new AssertionException("oops, unknown nClipBack = " + nClipBack);
                    }
                    if (nClipFront == 0) {
                        y6 = f1 - modSize.y;
                        y8 = f1;
                        x6 = 1.0;
                        x8 = 1.0;
                    } else if (nClipFront == 1) {
                        y6 = this.m_fCubeWallThickY;
                        y8 = f1;
                        x6 = 1.0;
                        x8 = 1.0;
                    } else if (nClipFront == 2) {
                        y6 = this.m_fCubeWallThickY;
                        y8 = this.m_fCubeWallThickY;
                        x8 = (f0 - this.m_fCubeWallThickY) / (f0 - f1);
                        x6 = nClipBack == 0 ? (f0 - modSize.y - this.m_fCubeWallThickY) / (f0 - f1) : x8;
                    } else {
                        throw new AssertionException("oops, unknown nClipFront = " + nClipFront);
                    }
                    if (nClipFront == 0 && nClipBack == 1) {
                        y4 = this.m_fCubeWallThickY;
                        x4 = (this.m_fCubeWallThickY - (f1 - modSize.y)) / (f0 - f1);
                        x4 = 1.0 - x4;
                    } else if (nClipFront == 1 && nClipBack == 0) {
                        y4 = this.m_fCubeWallThickY;
                        x4 = (f1 - modSize.y - this.m_fCubeWallThickY) / (f1 - f0);
                        x4 = 1.0 - x4;
                    } else {
                        y4 = y6;
                        x4 = x6;
                    }
                    Point3d[] pts = new Point3d[]{new Point3d(modOrigin.x + x0 * modSize.x, y0, modOrigin.z), new Point3d(modOrigin.x + x0 * modSize.x, y0, modOrigin.z + modSize.z), new Point3d(modOrigin.x + x2 * modSize.x, y2, modOrigin.z), new Point3d(modOrigin.x + x2 * modSize.x, y2, modOrigin.z + modSize.z), new Point3d(modOrigin.x + x4 * modSize.x, y4, modOrigin.z), new Point3d(modOrigin.x + x4 * modSize.x, y4, modOrigin.z + modSize.z), new Point3d(modOrigin.x + x6 * modSize.x, y6, modOrigin.z), new Point3d(modOrigin.x + x6 * modSize.x, y6, modOrigin.z + modSize.z), new Point3d(modOrigin.x + x8 * modSize.x, y8, modOrigin.z), new Point3d(modOrigin.x + x8 * modSize.x, y8, modOrigin.z + modSize.z)};
                    m = new Model3DRibbonGroupSolid(this, id, bb, modOrigin, modSize, pts, bGridStatus, this.m_bColorAutoshadeRisers);
                }
            }
        } else {
            m = new Model3DRectSolid(this, id, bb, modOrigin, modSize, bGridStatus, this.m_bColorAutoshadeRisers, this.m_bCanUseSimpleVis);
        }
        if (m != null) {
            m.calcGrids();
        }
        if (m != null) {
            if (this.m_bSafeAngle) {
                m.display();
            } else {
                this.m_objectList.add(m);
            }
        }
        return m;
    }

    protected double denormalize(double fNorm, double fNormMin, double fNormMax, double fFactor, double fOffset) {
        if (fNorm < fNormMin) {
            this.m_Perspective.getErrorHandler().log("property value (" + fNorm + ") set to minimum (" + fNormMin + ")", this.getClass().getName(), "denormalize()");
            fNorm = fNormMin;
        } else if (fNorm > fNormMax) {
            this.m_Perspective.getErrorHandler().log("property value (" + fNorm + ") set to maximum (" + fNormMax + ")", this.getClass().getName(), "denormalize()");
            fNorm = fNormMax;
        }
        double fWorld = fOffset + fFactor * fNorm;
        return fWorld;
    }

    protected double denormalizeGeom(double fNorm, double fNormMin, double fNormMax, double fBase, double fMult) {
        if (fNorm < fNormMin) {
            this.m_Perspective.getErrorHandler().log("property value (" + fNorm + ") set to minimum (" + fNormMin + ")", this.getClass().getName(), "denormalizeGeom()");
            fNorm = fNormMin;
        } else if (fNorm > fNormMax) {
            this.m_Perspective.getErrorHandler().log("property value (" + fNorm + ") set to maximum (" + fNormMax + ")", this.getClass().getName(), "denormalizeGeom()");
            fNorm = fNormMax;
        }
        double fWorld = Math.pow(fBase, fNorm) * fMult;
        return fWorld;
    }

    public void displayAll3DObjects() {
        PfjAssert.pfjAssert(!this.m_bSafeAngle && this.m_objectList != null);
        this.m_Floor.preDisplay();
        this.m_LWall.preDisplay();
        this.m_RWall.preDisplay();
        int objectCount = this.m_objectList.size();
        for (int index = 0; index < objectCount; ++index) {
            Model3DFlatFace obj = (Model3DFlatFace)this.m_objectList.get(index);
            obj.display();
        }
        this.m_RWall.postDisplay();
        this.m_LWall.postDisplay();
        this.m_Floor.postDisplay();
    }

    public void drawRiser(IdentObj id, BlackBoxIF bb, double[] xPoints, double[] yPoints) {
        Polygon poly = new Polygon();
        int x0 = (int)xPoints[0];
        int y0 = (int)yPoints[0];
        int x1 = (int)xPoints[1];
        int y1 = (int)yPoints[1];
        int x2 = (int)xPoints[2];
        int y2 = (int)yPoints[2];
        int x3 = (int)xPoints[3];
        int y3 = (int)yPoints[3];
        int x6 = (int)xPoints[6];
        int y6 = (int)yPoints[6];
        poly.addPoint(x0, y0);
        poly.addPoint(x1, y1);
        poly.addPoint(x2, y2);
        poly.addPoint(x3, y3);
        poly.addPoint(x0, y0);
        new DetPolygon(this.m_Detectiv, id, poly, bb, null, 1.0, true);
        poly = new Polygon();
        poly.addPoint(x3, y3);
        poly.addPoint(x2, y2);
        poly.addPoint(x6, y6);
        poly.addPoint((int)xPoints[7], (int)yPoints[7]);
        poly.addPoint(x3, y3);
        IdentObj newId = new IdentObj(id);
        newId.incrMiscID(2);
        new DetPolygon(this.m_Detectiv, newId, poly, bb, null, 1.0, true);
        poly = new Polygon();
        poly.addPoint(x1, y1);
        poly.addPoint((int)xPoints[5], (int)yPoints[5]);
        poly.addPoint(x6, y6);
        poly.addPoint(x2, y2);
        poly.addPoint(x1, y1);
        newId = new IdentObj(id);
        newId.incrMiscID(4);
        new DetPolygon(this.m_Detectiv, newId, poly, bb, null, 1.0, true);
    }

    public void drawWireframe() {
        int i;
        Point3d aPoint = new Point3d();
        Graphics gx = this.m_Perspective.getGraphicsContext();
        if (this.m_bAlreadyDrawn) {
            gx.setXORMode(Color.yellow);
            for (i = 0; i < 21; ++i) {
                this.drawWireframeLine(gx, this.m_wirePts2D[m_Connect[i][0]], this.m_wirePts2D[m_Connect[i][1]]);
            }
            gx.setPaintMode();
        }
        double fMinZ = this.getMinCubeViewerZ();
        if (this.m_bViewRawViewerZ) {
            this.m_fViewViewerZ += fMinZ;
            this.m_bViewRawViewerZ = false;
        }
        this.setWireframePoints();
        for (i = 0; i < 17; ++i) {
            aPoint.copy(this.m_wirePts3D[i]);
            this.transformPoint3d(aPoint);
            this.m_wirePts2D[i] = this.projectPoint3d(aPoint);
        }
        gx.setXORMode(Color.yellow);
        for (i = 0; i < 21; ++i) {
            this.drawWireframeLine(gx, this.m_wirePts2D[m_Connect[i][0]], this.m_wirePts2D[m_Connect[i][1]]);
        }
        gx.setPaintMode();
        gx.dispose();
        this.m_bAlreadyDrawn = true;
    }

    public void drawWireframeLine(Graphics g, Point p1, Point p2) {
        Point destP1 = new Point(p1.x, p1.y);
        Point destP2 = new Point(p2.x, p2.y);
        destP1 = this.m_Perspective.m_VC.virtToDest(destP1);
        destP2 = this.m_Perspective.m_VC.virtToDest(destP2);
        g.drawLine(destP1.x, destP1.y, destP2.x, destP2.y);
    }

    protected MinMaxObj findLimits(int axis, int scaling, boolean bMustIncludeZero) {
        MinMaxObj minMaxObj = this.findPreScaledLimits(axis, scaling, bMustIncludeZero);
        if (minMaxObj != null) {
            return minMaxObj;
        }
        minMaxObj = new MinMaxObj(bMustIncludeZero);
        if (scaling == 1) {
            for (int s = 0; s < this.m_nTotalSeries; ++s) {
                for (int g = 0; g < this.m_nTotalGroups; ++g) {
                    DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                    double fValue = dObj.m_fValue;
                    if (!dObj.m_bOK || this.m_bY1LogScale && fValue <= 0.0) continue;
                    minMaxObj.testRawValue(fValue);
                }
            }
        } else {
            throw new AssertionException(1, 1, scaling);
        }
        return minMaxObj;
    }

    public void focusCube(double focusFactor) {
        double newViewerZ;
        Matrix4d mCurrent = this.getMatrix();
        double oldFocus = this.m_fViewFocusFactor;
        if (mCurrent == null) {
            return;
        }
        double fMinZ = this.getMinCubeViewerZ();
        if (this.m_bViewRawViewerZ) {
            this.m_fViewViewerZ += fMinZ;
            this.m_bViewRawViewerZ = false;
        }
        if ((newViewerZ = this.m_fViewViewerZ * focusFactor) >= fMinZ && newViewerZ <= fMinZ + 50000.0) {
            mCurrent.m32 *= focusFactor;
            double newFocus = focusFactor * oldFocus;
            this.m_Perspective.setCubeFocusFactor(this.normalizeGeom(newFocus, 0.0, 100.0, 1.011778466, 0.556837407));
            this.m_Perspective.setCubeViewerZ(this.normalize(newViewerZ - fMinZ, 0.0, 100.0, 500.0, 0.0));
        }
    }

    public Axis3DObj getAxisObj(int nAxis) {
        switch (nAxis) {
            case 0: {
                return this.m_O2Axis;
            }
            case 2: {
                return this.m_O1Axis;
            }
            case 1: {
                return this.m_Y1Axis;
            }
        }
        throw new AssertionException("Invalid Parameter passed !");
    }

    public BlackBoxIF getModelBlackBox(IdentObj id) {
        BlackBoxIF bb;
        int s = id.getSeriesID();
        int g = id.getGroupID();
        boolean bExact = this.m_Perspective.getExactColorByHeight();
        if (this instanceof JChart_3D_Surf && this.m_Perspective.isColorByHeight() && s != -3) {
            int yCoord = this.getYCoordForHeight(s, g);
            double fValue = this.getValueFromCoord(yCoord);
            if (!bExact) {
                List szLabels = this.m_Y1Axis.getNumericLabelsAsDouble();
                int nLabels = szLabels.size();
                double fValueOrig = fValue;
                PfjAssert.pfjAssert(nLabels > 1);
                boolean bFound = false;
                for (int i = 1; i < nLabels && !bFound; ++i) {
                    double fCurr;
                    double fPrev = (Double)szLabels.get(i - 1);
                    double fMid = (fPrev + (fCurr = ((Double)szLabels.get(i)).doubleValue())) / 2.0;
                    if (!(fValue < fMid)) continue;
                    fValue = fPrev;
                    bFound = true;
                }
                if (!bFound) {
                    fValue = (Double)szLabels.get(nLabels - 1);
                }
            }
            double fRatio = this.m_Y1Axis.getValueRelCoord(fValue);
            bb = this.getBlackBox(id, fRatio);
        } else {
            bb = this.getBlackBox(id);
        }
        return bb;
    }

    protected int getYCoordForHeight(int s, int g) {
        int yCoord = 0;
        if (this.m_dataOK[s][g]) {
            yCoord = this.m_numYCoords[s][g];
        }
        return yCoord;
    }

    public Point3d getCubeSize() {
        return new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
    }

    public double getCubeWallThickY() {
        return this.m_fCubeWallThickY;
    }

    public Access getDataAccess() {
        return this.m_Access;
    }

    public IdentObj getMajorGridId(int nAxis) {
        return this.getAxisObj(nAxis).getMajorGridId();
    }

    public List getMajorGridPositions(int nAxis) {
        return this.getAxisObj(nAxis).getMajorGridPositions();
    }

    public BlackBoxIF getMajorGridsBlackBox(int nAxis) {
        return this.getAxisObj(nAxis).getMajorGridBlackBox();
    }

    public Matrix4d getMatrix() {
        return this.m_matrix;
    }

    public double getMinCubeViewerZ() {
        Point3d origin = new Point3d(0.0, 0.0, 0.0);
        Point3d size = new Point3d(this.m_fCubeSizeX, this.m_fCubeSizeY, this.m_fCubeSizeZ);
        boolean[][] bGridStatus = new boolean[2][3];
        bGridStatus[0][0] = false;
        bGridStatus[0][1] = false;
        bGridStatus[0][2] = false;
        bGridStatus[1][0] = false;
        bGridStatus[1][1] = false;
        bGridStatus[1][2] = false;
        Model3DRectSolid cube = new Model3DRectSolid(this, null, null, origin, size, bGridStatus, false, false);
        double fMinZ = cube.getMinZ();
        return fMinZ + 2000.0;
    }

    public IdentObj getMinorGridId(int nAxis) {
        return this.getAxisObj(nAxis).getMinorGridId();
    }

    public List getMinorGridPositions(int nAxis) {
        return this.getAxisObj(nAxis).getMinorGridPositions();
    }

    public BlackBoxIF getMinorGridsBlackBox(int nAxis) {
        return this.getAxisObj(nAxis).getMinorGridBlackBox();
    }

    public double getPanX() {
        return this.m_fViewPanX;
    }

    public double getPanY() {
        return this.m_fViewPanY;
    }

    public Perspective getPerspective() {
        return this.m_Perspective;
    }

    @Override
    public double getQuantizedDataValue(int nSeries, int nGroup, DataItem item) {
        double fValue = this.getDataValue((int)nSeries, (int)nGroup, (DataItem)item).m_fValue;
        boolean bExact = this.m_Perspective.getExactColorByHeight();
        if (!bExact) {
            List dLabels = this.m_Y1Axis.getNumericLabelsAsDouble();
            int nLabels = dLabels.size();
            PfjAssert.pfjAssert(nLabels > 1);
            boolean bFound = false;
            for (int i = 1; i < nLabels && !bFound; ++i) {
                double fCurr;
                double fPrev = (Double)dLabels.get(i - 1);
                double fMid = (fPrev + (fCurr = ((Double)dLabels.get(i)).doubleValue())) / 2.0;
                if (!(fValue < fMid)) continue;
                fValue = fPrev;
                bFound = true;
            }
            if (!bFound) {
                fValue = (Double)dLabels.get(nLabels - 1);
            }
        }
        return fValue;
    }

    public Point3d getViewer() {
        return new Point3d(this.m_fViewViewerX, this.m_fViewViewerY, this.m_fViewViewerZ);
    }

    @Override
    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_O1Axis = null;
        this.m_O2Axis = null;
        this.m_Y1Axis = null;
        this.m_bAlreadyDrawn = false;
        this.m_bChangedColor = true;
        this.m_bChangedCube = true;
        this.m_bChangedGrid = true;
        this.m_bChangedRiser = true;
        this.m_bChangedScale = true;
        this.m_bChangedView = true;
        this.m_bNoWireframeYet = true;
        this.m_bViewRawViewerZ = true;
        this.copyParams();
        this.createMatrix();
    }

    public boolean isSafeAngle() {
        return this.m_bSafeAngle;
    }

    public boolean isAxisVisible(int nAxis, int nSide) {
        return true;
    }

    protected double normalize(double fWorld, double fNormMin, double fNormMax, double fFactor, double fOffset) {
        double fNorm;
        double fWorldMin = fNormMin * fFactor + fOffset;
        double fWorldMax = fNormMax * fFactor + fOffset;
        if (fWorld < fWorldMin) {
            this.m_Perspective.getErrorHandler().log("property value (" + fWorld + ") set to minimum (" + fWorldMin + ")", this.getClass().getName(), "normalize()");
            fWorld = fWorldMin;
        } else if (fWorld > fWorldMax) {
            this.m_Perspective.getErrorHandler().log("property value (" + fWorld + ") set to maximum (" + fWorldMax + ")", this.getClass().getName(), "normalize()");
            fWorld = fWorldMax;
        }
        PfjAssert.pfjAssert(fFactor != 0.0);
        if (fFactor == 0.0) {
            double fMedian = (fNormMin + fNormMax) / 2.0;
            this.m_Perspective.getErrorHandler().log("bad factor, property value (" + fWorld + ") set to median (" + fMedian + ")", this.getClass().getName(), "normalize()");
            fNorm = fMedian;
        } else {
            fNorm = (fWorld - fOffset) / fFactor;
        }
        return fNorm;
    }

    protected double normalizeGeom(double fWorld, double fNormMin, double fNormMax, double fBase, double fMult) {
        double fNorm;
        double fWorldMin = Math.pow(fBase, fNormMin) * fMult;
        double fWorldMax = Math.pow(fBase, fNormMax) * fMult;
        if (fWorld < fWorldMin) {
            this.m_Perspective.getErrorHandler().log("property value (" + fWorld + ") set to minimum (" + fWorldMin + ")", this.getClass().getName(), "normalizeGeom()");
            fWorld = fWorldMin;
        } else if (fWorld > fWorldMax) {
            this.m_Perspective.getErrorHandler().log("property value (" + fWorld + ") set to maximum (" + fWorldMax + ")", this.getClass().getName(), "normalizeGeom()");
            fWorld = fWorldMax;
        }
        PfjAssert.pfjAssert(fBase != 0.0);
        PfjAssert.pfjAssert(fMult != 0.0);
        if (fMult == 0.0 || fBase == 0.0) {
            double fMedian = (fNormMin + fNormMax) / 2.0;
            this.m_Perspective.getErrorHandler().log("bad base or multiplier, property value (" + fWorld + ") set to median (" + fMedian + ")", this.getClass().getName(), "normalizeGeom()");
            fNorm = fMedian;
        } else {
            fNorm = Math.log(fWorld / fMult) / Math.log(fBase);
        }
        return fNorm;
    }

    public Point projectPoint3d(Point3d pt3d) {
        double y;
        double x;
        double dz = this.m_fViewViewerZ - pt3d.z;
        if (this.m_bViewForceIsometric) {
            x = pt3d.x - this.m_fViewViewerX;
            y = pt3d.y - this.m_fViewViewerY;
        } else if (dz == 0.0) {
            x = 0.0;
            y = 0.0;
        } else {
            x = (pt3d.x - this.m_fViewViewerX) * (this.m_fViewViewerZ / dz);
            y = (pt3d.y - this.m_fViewViewerY) * (this.m_fViewViewerZ / dz);
        }
        return new Point((int)(x += this.m_fViewPanX), (int)(y += this.m_fViewPanY));
    }

    public Point2D projectPoint3dInDouble(Point3d pt3d) {
        double y;
        double x;
        double dz = this.m_fViewViewerZ - pt3d.z;
        if (this.m_bViewForceIsometric) {
            x = pt3d.x - this.m_fViewViewerX;
            y = pt3d.y - this.m_fViewViewerY;
        } else if (dz == 0.0) {
            x = 0.0;
            y = 0.0;
        } else {
            x = (pt3d.x - this.m_fViewViewerX) * (this.m_fViewViewerZ / dz);
            y = (pt3d.y - this.m_fViewViewerY) * (this.m_fViewViewerZ / dz);
        }
        return new Point2D.Double(x += this.m_fViewPanX, y += this.m_fViewPanY);
    }

    @Override
    public void releaseReferences() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.releaseReferences();
        }
        if (this.m_O2Axis != null) {
            this.m_O2Axis.releaseReferences();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.releaseReferences();
        }
        super.releaseReferences();
    }

    public void rotateCubeX(double degreesX) {
        Matrix4d mCurrent = this.getMatrix();
        if (mCurrent == null) {
            return;
        }
        Point3d oldPos = this.centerGraph(mCurrent);
        Matrix4d mRot = new Matrix4d(0, degreesX * (Math.PI / 180));
        mCurrent.mult(mRot);
        mCurrent.translate(oldPos.x, oldPos.y, oldPos.z);
    }

    public void rotateCubeY(double degreesY) {
        Matrix4d mCurrent = this.getMatrix();
        if (mCurrent == null) {
            return;
        }
        Point3d oldPos = this.centerGraph(mCurrent);
        Matrix4d mRot = new Matrix4d(1, degreesY * (Math.PI / 180));
        mCurrent.mult(mRot);
        mCurrent.translate(oldPos.x, oldPos.y, oldPos.z);
    }

    public void rotateCubeZ(double degreesZ) {
        Matrix4d mCurrent = this.getMatrix();
        if (mCurrent == null) {
            return;
        }
        Point3d oldPos = this.centerGraph(mCurrent);
        Matrix4d mRot = new Matrix4d(2, degreesZ * (Math.PI / 180));
        mCurrent.mult(mRot);
        mCurrent.translate(oldPos.x, oldPos.y, oldPos.z);
    }

    public void scaleCube(double scaleFactor) {
        Matrix4d mCurrent = this.getMatrix();
        if (mCurrent == null) {
            return;
        }
        double oldZoom = this.m_fViewZoomFactor;
        double newZoom = oldZoom * scaleFactor;
        if (newZoom >= 0.25 && newZoom <= 4.0) {
            mCurrent.scale(scaleFactor);
            this.m_Perspective.setCubeZoomFactor(this.normalizeGeom(newZoom, 0.0, 100.0, 1.028113827, 0.25));
        }
    }

    public void setDrawOrder() {
        this.m_Floor.calcDisplayWhen(this.m_bCubeDisplay3DFloor, 2);
        this.m_LWall.calcDisplayWhen(this.m_bCubeDisplay3DLeftWall, 4);
        this.m_RWall.calcDisplayWhen(this.m_bCubeDisplay3DRightWall, 0);
    }

    public void setPanX(double newValue) {
        this.m_fViewPanX = newValue;
    }

    public void setPanY(double newValue) {
        this.m_fViewPanY = newValue;
    }

    public void setWireframePoints() {
        this.m_wirePts3D[0].x = this.m_fCubeWallThickX;
        this.m_wirePts3D[0].y = this.m_fCubeWallThickY;
        this.m_wirePts3D[0].z = this.m_fCubeWallThickZ;
        this.m_wirePts3D[1].x = this.m_fCubeSizeX;
        this.m_wirePts3D[1].y = this.m_fCubeWallThickY;
        this.m_wirePts3D[1].z = this.m_fCubeWallThickZ;
        this.m_wirePts3D[2].x = this.m_fCubeWallThickX;
        this.m_wirePts3D[2].y = this.m_fCubeSizeY;
        this.m_wirePts3D[2].z = this.m_fCubeWallThickZ;
        this.m_wirePts3D[3].x = this.m_fCubeWallThickX;
        this.m_wirePts3D[3].y = this.m_fCubeWallThickY;
        this.m_wirePts3D[3].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[7].x = this.m_fCubeSizeX;
        this.m_wirePts3D[7].y = this.m_fCubeWallThickY;
        this.m_wirePts3D[7].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[8].x = this.m_fCubeSizeX;
        this.m_wirePts3D[8].y = this.m_fCubeSizeY;
        this.m_wirePts3D[8].z = this.m_fCubeWallThickZ;
        this.m_wirePts3D[9].x = this.m_fCubeWallThickX;
        this.m_wirePts3D[9].y = this.m_fCubeSizeY;
        this.m_wirePts3D[9].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[11].x = this.m_fCubeSizeX;
        this.m_wirePts3D[12].x = this.m_fCubeSizeX;
        this.m_wirePts3D[12].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[13].z = this.m_fCubeSizeZ;
        this.m_wirePts3D[14].y = this.m_fCubeSizeY;
        this.m_wirePts3D[15].x = this.m_fCubeSizeX;
        this.m_wirePts3D[15].y = this.m_fCubeSizeY;
        this.m_wirePts3D[16].y = this.m_fCubeSizeY;
        this.m_wirePts3D[16].z = this.m_fCubeSizeZ;
    }

    public void sort3DObjects() {
        PfjAssert.pfjAssert(!this.m_bSafeAngle && this.m_objectList != null);
        QSortAlgorithm qsort = new QSortAlgorithm();
        Point3d viewer = new Point3d(this.m_fViewViewerX, this.m_fViewViewerY, this.m_fViewViewerZ);
        int objectCount = this.m_objectList.size();
        for (int index = 0; index < objectCount; ++index) {
            Model3DFlatFace obj = (Model3DFlatFace)this.m_objectList.get(index);
            obj.calcDistance(this.m_matrix, viewer);
        }
        qsort.sortDistance(this.m_objectList, viewer);
    }

    public void transformPoint3d(Point3d p3D_X) {
        double tempX = p3D_X.x;
        double tempY = p3D_X.y;
        double tempZ = p3D_X.z;
        p3D_X.x = tempX * this.m_matrix.m00 + tempY * this.m_matrix.m10 + tempZ * this.m_matrix.m20 + this.m_matrix.m30;
        p3D_X.y = tempX * this.m_matrix.m01 + tempY * this.m_matrix.m11 + tempZ * this.m_matrix.m21 + this.m_matrix.m31;
        p3D_X.z = tempX * this.m_matrix.m02 + tempY * this.m_matrix.m12 + tempZ * this.m_matrix.m22 + this.m_matrix.m32;
    }

    public void translateCube(double tx, double ty, double tz) {
        Matrix4d mCurrent = this.getMatrix();
        if (mCurrent == null) {
            return;
        }
        mCurrent.translate(tx, ty, tz);
    }

    public void updateViewParams() {
        this.copyCubeParams();
        this.copyViewParams();
    }

    public void updateParamsFromMatrix() {
        Matrix4d mTemp = new Matrix4d(this.getMatrix());
        double scale = this.m_fViewZoomFactor;
        if (scale == 0.0) {
            return;
        }
        mTemp.scale(1.0 / scale);
        Matrix3d m = mTemp.getMatrix3d();
        this.m_Perspective.setCubeRotationMatrix(m);
        this.m_Perspective.setCubeTranslationX(this.normalize(mTemp.m30, 0.0, 100.0, 200.0, -10000.0));
        this.m_Perspective.setCubeTranslationY(this.normalize(mTemp.m31, 0.0, 100.0, 200.0, -10000.0));
        this.m_Perspective.setCubeTranslationZ(this.normalize(mTemp.m32, 0.0, 100.0, 200.0, -10000.0));
    }

    @Override
    public boolean wantLegend() {
        return false;
    }

    public double getValueFromCoord(int coord) {
        return this.m_Y1Axis.getValueFromCoord(coord);
    }

    private Rectangle getWallBounds(Model3DCubeWall wall) {
        Rectangle rVC = this.getPerspective().getVC().getVirtCoords();
        int left = rVC.x + rVC.width;
        int right = rVC.x;
        int top = rVC.y;
        int bottom = rVC.y + rVC.height;
        Polygon poly = wall.getProjectedVertices();
        for (int i = 0; i < poly.npoints; ++i) {
            left = Math.min(left, poly.xpoints[i]);
            right = Math.max(right, poly.xpoints[i]);
            bottom = Math.min(bottom, poly.ypoints[i]);
            top = Math.max(top, poly.ypoints[i]);
        }
        return new Rectangle(left, bottom, right - left, top - bottom);
    }

    private void calculateAxisTitlePosition() {
        Rectangle r = this.getWallBounds(this.m_LWall);
        int left = r.x;
        int right = r.x + r.width;
        int bottom = r.y;
        int top = r.y + r.height;
        r = this.getWallBounds(this.m_RWall);
        left = Math.min(left, r.x);
        right = Math.max(right, r.x + r.width);
        bottom = Math.min(bottom, r.y);
        top = Math.max(top, r.y + r.height);
        r = this.getWallBounds(this.m_Floor);
        left = Math.min(left, r.x);
        right = Math.max(right, r.x + r.width);
        bottom = Math.min(bottom, r.y);
        top = Math.max(top, r.y + r.height);
        r = new Rectangle(left, bottom, right - left, top - bottom);
        r.grow(2000, 2000);
        this.m_O1Axis.setTitleRect(r);
        this.m_O2Axis.setTitleRect(r);
        this.m_Y1Axis.setTitleRect(r);
    }
}

