/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.pagingControl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.dss.dataView.CommonDataview;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.pagingControl.PagingControlAttributes;
import oracle.dss.pagingControl.PagingControlConstants;
import oracle.dss.pagingControl.PagingControlDefaultValues;
import oracle.dss.pagingControl.PagingControlStyleManager;
import oracle.dss.pagingControl.PagingControlXML;
import oracle.dss.pagingControl.managers.PagingControlRuleStyles;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.WaitData;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.dss.util.xml.XMLObjectReader;
import oracle.javatools.annotations.Concealed;

@Concealed
public class CommonPagingControl
extends CommonDataview
implements PagingControlConstants {
    @Concealed
    protected static final String m_version = "4.0.0.0";
    @Concealed
    protected Hashtable m_context = null;
    private PagingControlAttributes _pca;
    private boolean _embedded;
    private String _label = null;
    private boolean _labelVisible = PagingControlDefaultValues.isLabelVisible();
    private boolean _visible = PagingControlDefaultValues.isVisible();
    private boolean _dragEnabled = PagingControlDefaultValues.isDragEnabled();
    private int _orientation = PagingControlDefaultValues.getOrientation();
    private boolean _enabled = PagingControlDefaultValues.isEnabled();
    private boolean _splitterDragEnabled = PagingControlDefaultValues.isSplitterDragEnabled();
    private boolean _htmlPagingControlAutosubmit = PagingControlDefaultValues.isHTMLPagingControlAutosubmit();
    private boolean _swapAllowed = PagingControlDefaultValues.isSwapAllowed();
    private boolean _pageItemLabelVisible = PagingControlDefaultValues.isPageItemLabelVisible();
    private PagingControlStyleManager _pcStyleManager;
    private PagingControlXML _pagingControlXML;
    private HashMap _jsfHashMap = null;
    private HashMap _jsfHashMap_PagingControl = null;
    private static final String _method_setXML = "setXML(String xml, HashMap map)";
    private static final String _method__setXML = "_setXML(XMLObjectReader reader, int reset)";
    private static final String _method_updateResourceBundle = "updateResourceBundle()";

    public CommonPagingControl(PagingControlAttributes pca, Locale locale, boolean embedded) {
        super(locale);
        this._embedded = embedded;
        this._pca = pca;
        this._setupPagingControlView(locale);
    }

    private void _setupPagingControlView(Locale locale) {
        this._pagingControlXML = new PagingControlXML(this);
        this.setViewXML(this._pagingControlXML);
    }

    @Concealed
    public void setPagingControlStyleManager(PagingControlStyleManager m) {
        this._pcStyleManager = m;
    }

    @Concealed
    public PagingControlStyleManager getPagingControlStyleManager() {
        if (this._pcStyleManager == null) {
            return new PagingControlRuleStyles();
        }
        return this._pcStyleManager;
    }

    public void setLabelText(String label) {
        this._label = label;
    }

    public String getLabelText() {
        if (this._label != null) {
            return this._label;
        }
        return this.m_dvStrings.getString("Page Items");
    }

    public void setLabelVisible(boolean visible) {
        this._labelVisible = visible;
    }

    public boolean isLabelVisible() {
        return this._labelVisible;
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setDragEnabled(boolean drag) {
        this._dragEnabled = drag;
    }

    public boolean isDragEnabled() {
        return this._dragEnabled;
    }

    public void setOrientation(int orientation) {
        this._orientation = orientation;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setSplitterDragEnabled(boolean enable) {
        this._splitterDragEnabled = enable;
    }

    public boolean isSplitterDragEnabled() {
        return this._splitterDragEnabled;
    }

    @Override
    public void setHTMLPagingControlAutosubmit(boolean autosubmit) {
        this._htmlPagingControlAutosubmit = autosubmit;
    }

    @Override
    public boolean isHTMLPagingControlAutosubmit() {
        return this._htmlPagingControlAutosubmit;
    }

    public void setSwapAllowed(boolean swap) {
        this._swapAllowed = swap;
    }

    public boolean isSwapAllowed() {
        return this._swapAllowed;
    }

    public void setPageItemLabelVisible(boolean visible) {
        this._pageItemLabelVisible = visible;
    }

    public boolean isPageItemLabelVisible() {
        return this._pageItemLabelVisible;
    }

    @Override
    public void setWaitDataForRow(int row, WaitData waitData) {
    }

    @Override
    public WaitData getWaitDataForRow(int row) {
        return null;
    }

    @Override
    public boolean setTabularData(List tableRows) {
        return false;
    }

    @Override
    public boolean setGridData(Object[] columnLabels, Object[] rowLabels, Object[][] data) {
        return false;
    }

    @Override
    protected DataviewXML getViewXML() {
        return this._pagingControlXML;
    }

    @Override
    protected void setLocalXMLDataSource(LocalXMLDataSource ds) {
    }

    @Override
    protected void fillRelationalDataArrays(int colCount, int rowCount, List colLabelsList, List rowLabelsList, Hashtable dataVals, Object[] colLabels, Object[] rowLabels, Object[][] data) {
    }

    @Override
    protected void updateResourceBundle() {
        try {
            this.m_dvStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.pagingControl.resource.PagingControlBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.pagingControl.resource.PagingControlBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().log("missing resource bundle oracle.dss.pagingControl.resource.PagingControlBundle", this.getClass().getName(), _method_updateResourceBundle);
            this.m_dvStrings = null;
        }
    }

    @Override
    protected boolean isEdgeValid(int edge) {
        return edge == 2;
    }

    @Concealed
    public void initialize(Hashtable env) {
        if (env != null && env.containsKey("persistence_errorhandler")) {
            this.addErrorHandler((ErrorHandler)env.get("persistence_errorhandler"));
        }
        if (env != null && env.containsKey("persistence_locale")) {
            this.setLocale((Locale)env.get("persistence_locale"));
        }
        if (env != null && env.containsKey("migration") && env.containsKey("full_path_to_guid_converter")) {
            this._setXMLContext(env.get("migration"), env.get("full_path_to_guid_converter"));
            this.setContext();
        }
    }

    private void _setXMLContext(Object migration, Object converter) {
        ObjectScope scope = new ObjectScope();
        scope.addObject("migration", migration);
        scope.addObject("full_path_to_guid_converter", converter);
        XMLContext xmlcontext = new XMLContext();
        xmlcontext.setScope(scope);
        if (this.m_context == null) {
            this.m_context = new Hashtable();
        }
        this.m_context.put("xml_context", xmlcontext);
        this.setContext();
    }

    @Concealed
    public void setContext() {
        ((PagingControlRuleStyles)this.getPagingControlStyleManager()).setContext(this.m_context);
    }

    public String getXMLAsString() {
        return this.getXML("PagingControl", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Concealed
    public void setXML(String xml, HashMap map) {
        this._jsfHashMap = map;
        this._jsfHashMap_PagingControl = new HashMap();
        this._jsfHashMap.put("PageHeader", this._jsfHashMap_PagingControl);
        try {
            this.setXML(xml, 0);
        }
        catch (Exception exception) {
            this.getErrorHandler().error((Throwable)exception, this.getClass().getName(), _method_setXML);
        }
        finally {
            this._jsfHashMap = null;
            this._jsfHashMap_PagingControl = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Concealed
    public boolean setXML(String xmlString, int reset) throws BIIOException, BISAXException, BIParseException {
        XMLObjectReader reader = null;
        try {
            reader = new XMLObjectReader(xmlString);
            this._setXML(reader, reset);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private void _setXML(XMLObjectReader reader, int reset) throws BIIOException, BISAXException, BIParseException {
        if (this.isXMLValidated()) {
            reader.setValidationMode(true);
            try {
                reader.setDTD("/oracle/dss/pagingControl/PagingControl.dtd", "PageHeader");
            }
            catch (BIParseException bipe) {
                this.getErrorHandler().log("syntax error in DTD in line number " + bipe.getLineNumber(), this.getClass().getName(), _method__setXML);
            }
        }
        ObjectNode node = reader.readObjectNode();
        int newReset = reset;
        if (newReset < 0 || newReset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), _method__setXML);
            newReset = 0;
        }
        if (newReset != 0) {
            this._pca.resetToDefault(newReset);
        }
        this.setXML(node, newReset);
    }

    @Concealed
    protected void setXML(ObjectNode node, int reset) {
        ObjectNode pcNode;
        ObjectNode pNode;
        if (node == null) {
            return;
        }
        this.getViewXML().setXML(node, this._jsfHashMap_PagingControl);
        PropertyNode propNode = node.getProperty("labelVisible");
        if (propNode != null) {
            boolean labelVisible = propNode.getValueAsBoolean();
            this._jsfHashMap_PagingControl.put("labelVisible", labelVisible);
        }
        if ((propNode = node.getProperty("orientation")) != null) {
            String orientation = propNode.getValueAsString();
            this._jsfHashMap_PagingControl.put("orientation", orientation);
        }
        if ((propNode = node.getProperty("dragEnabled")) != null) {
            boolean dragEnabled = propNode.getValueAsBoolean();
            this._jsfHashMap_PagingControl.put("dragEnabled", dragEnabled);
        }
        if ((propNode = node.getProperty("visible")) != null) {
            boolean visible = propNode.getValueAsBoolean();
            this._jsfHashMap_PagingControl.put("visible", visible);
        }
        if ((propNode = node.getProperty("swapAllowed")) != null) {
            boolean swapAllowed = propNode.getValueAsBoolean();
            this._jsfHashMap_PagingControl.put("swapAllowed", swapAllowed);
        }
        if ((propNode = node.getProperty("htmlPagingControlAutosubmit")) != null) {
            boolean autoSubmit = propNode.getValueAsBoolean();
            this._jsfHashMap_PagingControl.put("htmlPagingControlAutosubmit", autoSubmit);
        }
        if ((propNode = node.getProperty("enabled")) != null) {
            boolean enabled = propNode.getValueAsBoolean();
            this._jsfHashMap_PagingControl.put("enabled", enabled);
        }
        if ((pNode = node.getPropertyValueAsObjectNode("PagingComponent", true)) != null && (pcNode = pNode.getPropertyValueAsObjectNode("ViewStyle", true)) != null) {
            this._jsfHashMap_PagingControl.put("ViewStyle", pcNode);
        }
    }

    @Concealed
    public void readXML(InputStream stream, int reset, HashMap map) throws BIIOException, BISAXException, BIParseException {
        this._jsfHashMap = map;
        this._jsfHashMap_PagingControl = new HashMap();
        this._jsfHashMap.put("PageHeader", this._jsfHashMap_PagingControl);
        XMLObjectReader reader = new XMLObjectReader(stream);
        this._setXML(reader, reset);
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes oldAttrs) {
        PersistableAttributes result = null;
        result = this.m_attrs == null ? new PersistableAttributes() : (PersistableAttributes)this.m_attrs.clone();
        if (oldAttrs != null) {
            result.merge(oldAttrs);
        }
        result.setObjectType("PagingControl");
        result.setObjectTypeVersion(1);
        return result;
    }

    @Override
    public void setPersistableComponents(AggregateInfo[] persistables) {
        if (persistables != null) {
            super.setPersistableComponents(persistables);
        }
    }

    @Override
    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] superAggr = super.getPersistableComponents();
        return superAggr;
    }

    public void setObjectNode(ObjectNode node, String version, int reset) {
        ObjectNode pcNode;
        ObjectNode pNode;
        if (node == null) {
            return;
        }
        PropertyNode propNode = node.getProperty("enabled");
        if (propNode != null) {
            boolean enabled = propNode.getValueAsBoolean();
            this._pca.setEnabled(enabled);
        }
        if ((pNode = node.getPropertyValueAsObjectNode("PagingComponent", true)) != null && (pcNode = pNode.getPropertyValueAsObjectNode("ViewStyle", true)) != null) {
            this._pca.getViewStyle().setXML(pcNode, version, reset);
        }
    }

    @Concealed
    public ObjectNode getObjectNode(boolean allProperties) {
        ObjectNode node = new ObjectNode("PageHeader");
        boolean nodeExists = false;
        if (!this._embedded) {
            node.addProperty("version", m_version);
            if (allProperties || this.isLabelVisible() != PagingControlDefaultValues.isLabelVisible()) {
                node.addProperty("labelVisible", this.isLabelVisible());
            }
            if (allProperties || this.getOrientation() != PagingControlDefaultValues.getOrientation()) {
                int orientation = this.getOrientation();
                if (orientation == 1) {
                    node.addProperty("orientation", "VERTICAL");
                } else {
                    node.addProperty("orientation", "HORIZONTAL");
                }
            }
            if (allProperties || this.isDragEnabled() != PagingControlDefaultValues.isDragEnabled()) {
                node.addProperty("dragEnabled", this.isDragEnabled());
            }
            if (allProperties || this.isVisible() != PagingControlDefaultValues.isVisible()) {
                node.addProperty("visible", this.isVisible());
            }
            if (allProperties || this.isSwapAllowed() != PagingControlDefaultValues.isSwapAllowed()) {
                node.addProperty("swapAllowed", this.isSwapAllowed());
            }
        }
        if (allProperties || this.isEnabled() != PagingControlDefaultValues.isPagingControlEnabled()) {
            node.addProperty("enabled", this.isEnabled());
            nodeExists = true;
        }
        ObjectNode viewStyleNode = new ObjectNode("PagingComponent");
        ObjectNode viewStyle = this._pca.getViewStyle().getXML(allProperties);
        if (viewStyle != null) {
            viewStyleNode.addProperty(viewStyle);
            node.addProperty(viewStyleNode);
            nodeExists = true;
        }
        if (this._embedded) {
            if (nodeExists) {
                return node;
            }
            return null;
        }
        return node;
    }
}

