/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.pagingControl;

import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.BeanInfo;
import java.util.Locale;
import javax.swing.JPanel;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.pagingControl.PagingComponent;
import oracle.dss.pagingControl.PagingControl;
import oracle.dss.pagingControl.PagingControlAttributes;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.xml.ObjectNode;
import oracle.javatools.annotations.Concealed;

public class ViewPagingControl
extends JPanel
implements ComponentListener,
ViewComponent,
PagingControlAttributes {
    private static final long serialVersionUID = 1L;
    private Dataview _view;
    private PagingControl _pagingControl;
    private int _previousItemCount;
    private int _previousPageItemIndex = -1;

    @Concealed
    public ViewPagingControl(Dataview view) {
        this._view = view;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.initPagingControl();
    }

    private void initPagingControl() {
        this.setName("PagingControl_PageAxis");
        this._pagingControl = this._view == null ? new PagingControl() : new PagingControl(this._view);
        this.add(this._pagingControl);
        this.addComponentListener(this);
    }

    public void setLayerMetadataLabelType(String type) {
        this._pagingControl.setLayerMetadataLabelType(2, type);
    }

    public String getLayerMetadataLabelType() {
        return this._pagingControl.getLayerMetadataLabelType(2);
    }

    public void setMemberMetadataLabelType(String type) {
        this._pagingControl.setMemberMetadataLabelType(2, type);
    }

    public String getMemberMetadataLabelType() {
        return this._pagingControl.getMemberMetadataLabelType(2);
    }

    @Override
    @Concealed
    public void componentShown(ComponentEvent e) {
        this._pagingControl.revalidate();
        this._pagingControl.calculatePreferredSize();
    }

    @Override
    @Concealed
    public void componentResized(ComponentEvent e) {
        this._pagingControl.revalidate();
        this._pagingControl.calculatePreferredSize();
    }

    @Override
    @Concealed
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    @Concealed
    public void componentMoved(ComponentEvent e) {
    }

    public void cleanUp() {
        this.removeComponentListener(this);
    }

    @Concealed
    public void setDataSource(DataSource ds) {
        this._pagingControl.setDataSource(ds);
    }

    public void setDataDirector(DataDirector dd) {
        this._pagingControl.setDataDirector(dd);
    }

    @Override
    public void setFormatProvider(DataviewCommon view) {
        this._pagingControl.setFormatProvider(view);
    }

    @Override
    public DataviewCommon getFormatProvider() {
        return this._pagingControl.getFormatProvider();
    }

    public void setOrientation(int orientation) {
        this._pagingControl.setOrientation(orientation);
    }

    @Concealed
    public PagingComponent getPagingComponent() {
        return this._pagingControl.getPagingComponent();
    }

    @Concealed
    public void updatePageItems() {
        this._pagingControl.updatePageItems();
    }

    @Concealed
    public int getPreviousPageItemIndex() {
        return this._pagingControl.getPreviousPageItemIndex();
    }

    @Override
    public int getID() {
        return this._pagingControl.getID();
    }

    @Override
    public String getComponentName() {
        return this._pagingControl.getComponentName();
    }

    @Override
    public BeanInfo getBeanInfo() {
        return this._pagingControl.getBeanInfo();
    }

    @Concealed
    public int getEdge() {
        return this._pagingControl.getEdge();
    }

    @Override
    public ViewStyle getViewStyle() {
        return this._pagingControl.getViewStyle();
    }

    @Override
    public void setViewStyle(ViewStyle vs) {
        this._pagingControl.setViewStyle(vs);
    }

    @Override
    @Concealed
    public void setLocale(Locale loc) {
        this._pagingControl.setLocale(loc);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._pagingControl.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this._pagingControl.isEnabled();
    }

    @Concealed
    public void setZoomFactor(int zoom) {
        this._pagingControl.setZoomFactor(zoom);
        this.updatePageItemStyles();
    }

    @Concealed
    public int getZoomFactor() {
        return this._pagingControl.getZoomFactor();
    }

    @Concealed
    public void updatePageItemStyles() {
        this._pagingControl.updatePageItemStyles();
    }

    @Override
    @Concealed
    public void setObjectNode(ObjectNode node, String version, int reset) {
        this._pagingControl.setObjectNode(node, version, reset);
    }

    @Override
    @Concealed
    public ObjectNode getObjectNode(boolean allProperties) {
        return this._pagingControl.getObjectNode(allProperties);
    }

    @Override
    @Concealed
    public void resetToDefault(int reset) {
        this._pagingControl.resetToDefault(reset);
    }

    @Concealed
    public void setSwapAllowed(boolean swap) {
        this._pagingControl.setSwapAllowed(swap);
    }

    @Concealed
    public boolean isSwapAllowed() {
        return this._pagingControl.isSwapAllowed();
    }
}

