/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.Set;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeRuntimeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

class DebugProbeBreakpoint
implements DebugBreakpoint {
    DebugProbe dp;
    String name;
    int passCount;
    DebugBreakpointCondition condition;
    String threadname;
    String threadnameNot;
    boolean enabled;
    boolean stop;
    boolean log;
    String enableOtherBPs;
    String disableOtherBPs;

    DebugProbeBreakpoint(DebugProbe dp) {
        this.dp = dp;
        this.stop = true;
        this.enabled = true;
        this.passCount = 1;
    }

    public void remove() {
        this.prepareForChange();
        if (this.dp != null) {
            this.dp.removeBreakpoint(this);
        }
    }

    public String getThreadname() {
        return this.threadname;
    }

    public void setThreadname(String threadname) {
        if (threadname != null && threadname.length() == 0) {
            threadname = null;
        }
        this.threadname = threadname;
        if (threadname != null && this.threadnameNot != null) {
            this.threadnameNot = null;
        }
    }

    public String getThreadnameNot() {
        return this.threadnameNot;
    }

    public void setThreadnameNot(String threadnameNot) {
        if (threadnameNot != null && threadnameNot.length() == 0) {
            threadnameNot = null;
        }
        this.threadnameNot = threadnameNot;
        if (threadnameNot != null && this.threadname != null) {
            this.threadname = null;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean getLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnableOtherBPs() {
        return this.enableOtherBPs;
    }

    public void setEnableOtherBPs(String enableOtherBPs) {
        this.enableOtherBPs = enableOtherBPs;
    }

    public String getDisableOtherBPs() {
        return this.disableOtherBPs;
    }

    public void setDisableOtherBPs(String disableOtherBPs) {
        this.disableOtherBPs = disableOtherBPs;
    }

    public DebugBreakpointCondition getCondition() {
        return this.condition;
    }

    public void setCondition(DebugBreakpointCondition condition) {
        this.condition = condition;
    }

    public int getPassCount() {
        return this.passCount == 0 ? 1 : this.passCount;
    }

    public void setPassCount(int passCount) {
        this.passCount = passCount;
    }

    public boolean isInstanceFilterAppropriate(DebugDataObjectInfo data, Set classNames) {
        return false;
    }

    public void addInstanceFilter(DebugDataObjectInfo data) {
    }

    public void removeInstanceFilter(DebugDataObjectInfo data) {
    }

    public void removeInstanceFilter(long uniqueID) {
    }

    public boolean isInstanceFilterSet(DebugDataObjectInfo data) {
        return false;
    }

    public long[] getInstanceFilters() {
        return null;
    }

    public DebugLocation[] getLocations() {
        return new DebugLocation[0];
    }

    void prepareForChange() {
    }

    boolean isThisYourEvent(DebugProbeRuntimeInfo runtimeInfo, DebugProbeThreadInfo thread) {
        return this.enabled && this.checkThread(thread) && this.checkCondition(thread) && this.checkPassCount();
    }

    boolean checkThread(DebugProbeThreadInfo thread) {
        if (this.threadname != null) {
            return this.threadname.equals(thread.name);
        }
        if (this.threadnameNot != null) {
            return !this.threadnameNot.equals(thread.name);
        }
        return true;
    }

    boolean checkCondition(DebugProbeThreadInfo thread) {
        DebugStackFrameInfo[] stack;
        return this.condition == null || this.condition.checkBreakpointCondition((DebugBreakpoint)this, (DebugVirtualMachine)this.dp, (DebugThreadInfo)thread, stack = thread.listStack());
    }

    boolean checkPassCount() {
        if (this.passCount > 0) {
            --this.passCount;
            if (this.dp.debugListener != null) {
                this.dp.debugListener.breakpointChanged((DebugBreakpoint)this);
            }
        }
        return this.passCount == 0;
    }

    public void setBreakpoint() {
    }

    public void changeBreakpoint() {
    }

    public String getLogMessage(DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        return null;
    }
}

