/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PBE;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.c;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public final class PKCS12PBE
extends PBE {
    public static final int SHA_128RC4 = 1;
    public static final int SHA_40RC4 = 2;
    public static final int SHA_3_3DES_CBC = 3;
    public static final int SHA_2_3DES_CBC = 4;
    public static final int SHA_128RC2_CBC = 5;
    public static final int SHA_40RC2_CBC = 6;
    private int d;

    public void initialize(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier instanceof PBEAlgorithmIdentifier) {
            this.a = (PBEAlgorithmIdentifier)algorithmIdentifier;
        } else {
            try {
                this.a = new PBEAlgorithmIdentifier(Utils.toStream(algorithmIdentifier));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
        }
        ASN1ObjectID aSN1ObjectID = this.a.getOID();
        this.b = AlgID.sha_1;
        if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC4)) {
            this.c = AlgID.RC4;
            this.d = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC4)) {
            this.c = AlgID.RC4;
            this.d = 5;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
            this.c = AlgID.DES_EDE3_CBC;
            this.d = 24;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            this.c = AlgID.DES_EDE3_CBC;
            this.d = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC2_CBC)) {
            this.c = AlgID.RC2_CBC;
            this.d = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC2_CBC)) {
            this.c = AlgID.RC2_CBC;
            this.d = 5;
        } else {
            throw new AlgorithmIdentifierException("Unknown algorithm identifier: " + algorithmIdentifier);
        }
    }

    public void initialize(int n, byte[] byArray, int n2) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n), byArray, n2));
    }

    public void initialize(int n) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n)));
    }

    public byte[] encrypt(String string, byte[] byArray) throws CipherException {
        FIPS_140_2.assertReadyState();
        return this.a(string, byArray, true);
    }

    public byte[] decrypt(String string, byte[] byArray) throws CipherException {
        FIPS_140_2.assertReadyState();
        return this.a(string, byArray, false);
    }

    public byte[] encryptPrivateKey(String string, PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot encrypt encrypted key");
        }
        return this.a(string, oracle.security.crypto.core.c.a(privateKey), true);
    }

    public PrivateKey decryptPrivateKey(String string, byte[] byArray) throws CipherException, IOException {
        byte[] byArray2 = this.a(string, byArray, false);
        PrivateKey privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    public byte[] encryptSymmetricKey(String string, SymmetricKey symmetricKey) throws CipherException {
        return this.a(string, symmetricKey.e(), true);
    }

    public SymmetricKey decryptSymmetricKey(String string, byte[] byArray) throws CipherException {
        byte[] byArray2 = this.a(string, byArray, false);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a(String string, byte[] byArray, boolean bl) throws CipherException {
        try {
            byte[] byArray2;
            SymmetricKey symmetricKey = this.a(string);
            Cipher cipher = null;
            try {
                if (!this.c.getOID().equals(AlgID.RC4.getOID())) {
                    cipher = Cipher.getInstance(symmetricKey.getAlgID(), symmetricKey, Padding.PKCS5);
                    byArray2 = bl ? ((BlockCipher)cipher).encrypt(byArray, 0, byArray.length, true) : ((BlockCipher)cipher).decrypt(byArray, 0, byArray.length, true);
                } else {
                    cipher = Cipher.getInstance(symmetricKey.getAlgID(), symmetricKey);
                    byArray2 = bl ? cipher.encrypt(byArray) : cipher.decrypt(byArray);
                }
            }
            finally {
                if (cipher != null) {
                    cipher.erase();
                }
                if (symmetricKey != null) {
                    symmetricKey.erase();
                }
            }
            return byArray2;
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    private SymmetricKey a(String string) throws CipherException {
        SymmetricKey symmetricKey;
        byte[] byArray = PKCS12PBE.a(this.b, string, this.a.getSalt(), this.a.getIterationCount(), (byte)1, this.d);
        if (this.c.getOID().equals(AlgID.RC4.getOID())) {
            symmetricKey = new SymmetricKey(byArray, AlgID.RC4);
        } else {
            byte[] byArray2 = PKCS12PBE.a(this.b, string, this.a.getSalt(), this.a.getIterationCount(), (byte)2, 8);
            if (this.c.getOID().equals(AlgID.RC2_CBC.getOID())) {
                symmetricKey = new SymmetricKey(byArray, new RC2AlgorithmIdentifier(byArray2, this.d * 8));
            }
            if (this.a.getOID().equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
                byte[] byArray3 = new byte[24];
                System.arraycopy(byArray, 0, byArray3, 0, 16);
                System.arraycopy(byArray, 0, byArray3, 16, 8);
                Utils.setArray(byArray, (byte)0);
                byArray = byArray3;
            }
            symmetricKey = new SymmetricKey(byArray, new CBCAlgorithmIdentifier(this.c.getOID(), byArray2));
        }
        Utils.setArray(byArray, (byte)0);
        return symmetricKey;
    }

    public static byte[] createPKCS12MacKey(AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n, int n2) throws CipherException {
        FIPS_140_2.assertReadyState();
        return PKCS12PBE.a(algorithmIdentifier, string, byArray, n, (byte)3, n2);
    }

    private static byte[] a(AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n, byte by, int n2) throws CipherException {
        int n3;
        MessageDigest messageDigest;
        if (string == null) {
            throw new CipherException("Password not set");
        }
        try {
            messageDigest = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        int n4 = messageDigest.getDigestLength();
        int n5 = messageDigest.blockSize();
        byte[] byArray2 = new byte[n5];
        Utils.setArray(byArray2, by);
        byte[] byArray3 = Utils.unicodeToBytes(string);
        byte[] byArray4 = new byte[byArray3.length + 2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byArray4[byArray4.length - 1] = 0;
        byArray4[byArray4.length - 2] = 0;
        int n6 = byArray.length == 0 ? 0 : ((byArray.length - 1) / n5 + 1) * n5;
        int n7 = byArray4.length == 0 ? 0 : ((byArray4.length - 1) / n5 + 1) * n5;
        byte[] byArray5 = new byte[n6 + n7];
        for (n3 = 0; n3 < n6; n3 += byArray.length) {
            System.arraycopy(byArray, 0, byArray5, n3, Math.min(n6 - n3, byArray.length));
        }
        int n8 = byArray5.length;
        for (n3 = n6; n3 < n8; n3 += byArray4.length) {
            System.arraycopy(byArray4, 0, byArray5, n3, Math.min(byArray5.length - n3, byArray4.length));
        }
        Utils.setArray(byArray4, (byte)0);
        Utils.setArray(byArray3, (byte)0);
        byte[] byArray6 = new byte[n2];
        for (n8 = 0; n8 < n2; n8 += n4) {
            messageDigest.init();
            messageDigest.update(byArray2);
            messageDigest.update(byArray5);
            messageDigest.computeCurrent();
            int n9 = n - 1;
            for (int i2 = 0; i2 < n9; ++i2) {
                messageDigest.init();
                messageDigest.update(messageDigest.a());
                messageDigest.computeCurrent();
            }
            byte[] byArray7 = new byte[n5];
            for (n9 = 0; n9 < n5; n9 += n4) {
                System.arraycopy(messageDigest.a(), 0, byArray7, n9, Math.min(n5 - n9, n4));
            }
            BigInt bigInt = new BigInt(1, byArray7).add(BigInt.ONE);
            BigInt bigInt2 = BigInt.ONE.shiftLeft(n5 * 8).subtract(BigInt.ONE);
            int n10 = byArray5.length;
            for (int i3 = 0; i3 < n10; i3 += n5) {
                byte[] byArray8 = new byte[n5];
                System.arraycopy(byArray5, i3, byArray8, 0, n5);
                BigInt bigInt3 = new BigInt(1, byArray8).add(bigInt).and(bigInt2);
                Utils.toByteArray(bigInt3, byArray5, i3, n5);
            }
            System.arraycopy(messageDigest.a(), 0, byArray6, n8, Math.min(n2 - n8, n4));
        }
        Utils.setArray(messageDigest.a(), (byte)0);
        return byArray6;
    }
}

