/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.PBE;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.fips.KeyExportException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PrivateKeyPKCS8
implements ASN1Object,
PrivateKey {
    private PBE a;
    private final Object b = new Object();
    private byte[] c;
    private PrivateKey d;
    private String e;
    private RandomBitsSource f;
    private boolean g = true;
    private byte[] h;

    public PrivateKeyPKCS8() {
        this.a(null, null, 3, null);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string) throws AlgorithmIdentifierException {
        this(privateKey, string, new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithSHAAnd3_KeyTripleDES_CBC, RandomBitsSource.getDefault()));
    }

    public PrivateKeyPKCS8(ASN1ObjectID aSN1ObjectID) throws AlgorithmIdentifierException {
        this(new PBEAlgorithmIdentifier(aSN1ObjectID, RandomBitsSource.getDefault()));
    }

    public PrivateKeyPKCS8(ASN1ObjectID aSN1ObjectID, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        this(new PBEAlgorithmIdentifier(aSN1ObjectID, randomBitsSource));
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, ASN1ObjectID aSN1ObjectID, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        this(privateKey, string, new PBEAlgorithmIdentifier(aSN1ObjectID, randomBitsSource));
    }

    public PrivateKeyPKCS8(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.a = PBE.getInstance(algorithmIdentifier);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this(algorithmIdentifier);
        this.d = privateKey;
        this.e = string;
    }

    public PrivateKeyPKCS8(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public PrivateKeyPKCS8(int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.a(null, null, n, randomBitsSource);
    }

    public PrivateKeyPKCS8(int n) {
        FIPS_140_2.assertReadyState();
        this.a(null, null, n, null);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.a(privateKey, null, 3, randomBitsSource);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        this.a(privateKey, null, 3, null);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.a(privateKey, null, n, randomBitsSource);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, int n) {
        FIPS_140_2.assertReadyState();
        this.a(privateKey, null, n, null);
    }

    public PrivateKeyPKCS8(String string, PrivateKey privateKey, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.a(privateKey, string, 3, randomBitsSource);
    }

    public PrivateKeyPKCS8(String string, PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        this.a(privateKey, string, 3, null);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.a(privateKey, string, n, randomBitsSource);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, int n) {
        FIPS_140_2.assertReadyState();
        this.a(privateKey, string, n, null);
    }

    public PrivateKeyPKCS8(String string, InputStream inputStream) throws IOException {
        this.e = string;
        this.input(inputStream);
    }

    public PrivateKeyPKCS8(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toStream(aSN1Sequence));
    }

    public PrivateKeyPKCS8(String string, File file) throws IOException, FileNotFoundException {
        this(string, new FileInputStream(file));
    }

    public PrivateKeyPKCS8(String string, ASN1Sequence aSN1Sequence) throws IOException {
        this(string, Utils.toStream(aSN1Sequence));
    }

    private void a(PrivateKey privateKey, String string, int n, RandomBitsSource randomBitsSource) {
        block5: {
            this.f = randomBitsSource == null ? RandomBitsSource.getDefault() : randomBitsSource;
            try {
                if (n > 0) {
                    this.a = PBE.getInstance(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n), this.f));
                    break block5;
                }
                if (n == 0) {
                    this.a = PBE.getInstance(new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC, this.f));
                    break block5;
                }
                if (n == -1) {
                    this.a = PBE.getInstance(new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC, this.f));
                    break block5;
                }
                throw new IllegalStateException("Unknown mode");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
        this.d = privateKey;
        this.e = string;
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(aSN1SequenceInputStream);
        try {
            this.a = PBE.getInstance(pBEAlgorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
        this.c = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.d = null;
        this.h = null;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void output(OutputStream outputStream) throws IOException {
        try {
            outputStream.write(this.getEncoded());
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new IOException(streamableOutputException.toString());
        }
    }

    public int length() {
        return this.getEncoded().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] c() throws CipherException {
        if (this.c == null) {
            Object object = this.b;
            synchronized (object) {
                if (this.c == null) {
                    if (this.d == null) {
                        throw new CipherException("Private key not found for encryption");
                    }
                    if (this.e == null) {
                        throw new CipherException("The password was not set");
                    }
                    this.c = this.a.encryptPrivateKey(this.e, this.d);
                }
            }
        }
        return this.c;
    }

    public void setPassword(String string) {
        FIPS_140_2.assertReadyState();
        this.e = string;
        if (this.d != null) {
            this.c = null;
        }
        this.h = null;
    }

    public void setMode(int n) {
        block6: {
            FIPS_140_2.assertReadyState();
            try {
                if (n > 0) {
                    this.a = PBE.getInstance(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n), this.d()));
                    break block6;
                }
                if (n == 0) {
                    this.a = PBE.getInstance(new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC, this.d()));
                    break block6;
                }
                if (n == -1) {
                    this.a = PBE.getInstance(new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC, this.d()));
                    break block6;
                }
                throw new AlgorithmIdentifierException("Unknown mode");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
        if (this.d != null) {
            this.c = null;
        }
        this.h = null;
    }

    public int getMode() {
        FIPS_140_2.assertReadyState();
        if (this.a == null || this.a.getAlgID() == null) {
            return 3;
        }
        ASN1ObjectID aSN1ObjectID = this.a.getAlgID().getOID();
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC)) {
            return -1;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC)) {
            return 0;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC4)) {
            return 1;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC4)) {
            return 2;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
            return 3;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            return 4;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC2_CBC)) {
            return 5;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC2_CBC)) {
            return 6;
        }
        throw new IllegalStateException("The mode value does exist for this PBE Alg ID:" + this.a.getAlgID());
    }

    public void setCount(int n) {
        FIPS_140_2.assertReadyState();
        try {
            PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(((PBEAlgorithmIdentifier)this.a.getAlgID()).getOID(), ((PBEAlgorithmIdentifier)this.a.getAlgID()).getSalt(), n);
            this.a.initialize(pBEAlgorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (this.d != null) {
            this.c = null;
        }
        this.h = null;
    }

    public void setSalt(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        try {
            PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(((PBEAlgorithmIdentifier)this.a.getAlgID()).getOID(), byArray, ((PBEAlgorithmIdentifier)this.a.getAlgID()).getIterationCount());
            this.a.initialize(pBEAlgorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (this.d != null) {
            this.c = null;
        }
        this.h = null;
    }

    public PrivateKey getKey() {
        return this.getKey(this.e);
    }

    public PrivateKey getKey(String string) {
        return this.a(string);
    }

    PrivateKey a() {
        return this.a(this.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrivateKey a(String string) {
        FIPS_140_2.assertReadyState();
        if (this.d == null) {
            Object object = this.b;
            synchronized (object) {
                if (this.d == null) {
                    try {
                        if (this.c == null) {
                            throw new IllegalStateException("Encrypted private key not found");
                        }
                        if (string == null) {
                            throw new IllegalStateException("Invalid password: the password is null");
                        }
                        this.d = this.a.decryptPrivateKey(string, this.c);
                    }
                    catch (CipherException cipherException) {
                        throw new IllegalStateException(cipherException.toString());
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException.toString());
                    }
                }
            }
        }
        return this.d;
    }

    public void setKey(PrivateKey privateKey) {
        this.setPrivateKey(privateKey);
    }

    public PrivateKey setPrivateKey(PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        PrivateKey privateKey2 = this.d;
        this.d = privateKey;
        this.c = null;
        this.h = null;
        return privateKey2;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "pbeAlgID = {" + this.getPBEAlgID() + "}, keyAlgID = {" + this.getAlgID() + "}";
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        try {
            return this.a().getAlgID();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public AlgorithmIdentifier getPBEAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.a != null) {
            return this.a.getAlgID();
        }
        return null;
    }

    private RandomBitsSource d() {
        if (this.f == null) {
            this.f = RandomBitsSource.getDefault();
        }
        return this.f;
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            throw new StreamableOutputException("No Password Based Encryption created");
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.a.getAlgID());
        try {
            aSN1Sequence.addElement(new ASN1OctetString(this.c()));
        }
        catch (CipherException cipherException) {
            throw new StreamableOutputException(cipherException.toString());
        }
        return aSN1Sequence;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws InvalidInputException, AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "privateKey");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("Unrecognized algorithm OID " + algorithmIdentifier.getOID());
        }
        try {
            PrivateKey privateKey = (PrivateKey)clazz.newInstance();
            privateKey.initialize(algorithmIdentifier, aSN1Object);
            this.d = privateKey;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ": " + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ": " + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement PrivateKey.");
        }
        this.c = null;
        this.h = null;
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        PrivateKeyPKCS8 privateKeyPKCS8 = new PrivateKeyPKCS8();
        if (this.d != null) {
            privateKeyPKCS8.d = (PrivateKey)this.d.clone();
        }
        if (this.c != null) {
            privateKeyPKCS8.c = (byte[])this.c.clone();
        }
        if (this.e != null) {
            privateKeyPKCS8.e = this.e;
        }
        if (this.a != null) {
            try {
                privateKeyPKCS8.a = PBE.getInstance(this.a.getAlgID());
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        } else {
            privateKeyPKCS8.a = null;
        }
        privateKeyPKCS8.f = this.d();
        privateKeyPKCS8.g = this.g;
        return privateKeyPKCS8;
    }

    public void erase() {
        this.d = null;
        this.a = null;
        this.c = null;
        this.h = null;
        this.f = null;
    }

    public String getAlgorithm() {
        FIPS_140_2.assertReadyState();
        try {
            return this.a().getAlgorithm();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        try {
            return this.a().getBitLength();
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
    }

    public byte[] getEncoded() {
        if (this.h == null) {
            this.h = Utils.toBytes(this.getContents());
        }
        return this.h;
    }

    public String getFormat() {
        FIPS_140_2.assertReadyState();
        try {
            return this.a().getFormat();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public void setAllowExport(boolean bl) {
        this.g = bl;
    }

    public boolean getAllowExport() {
        return this.g;
    }

    protected void b() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

