/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHKeyAttributes
extends ExportHandler {
    public EHKeyAttributes(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Key_ID").append(",");
        sb.append("Num_Key_ID").append(",");
        sb.append("AttributeID").append(",");
        sb.append("Num_AttributeID").append(",");
        sb.append("Entity_ID").append(",");
        sb.append("Num_Entity_ID").append(",");
        sb.append("Key_Name").append(",");
        sb.append("Entity_Name").append(",");
        sb.append("Attribute_Name");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            for (CandidateKey key : logDesign.getGlobalCandidateKeySet()) {
                ContainedObject[] attributes = key.getElements();
                for (int i = 0; i < attributes.length; ++i) {
                    ContainedObject attribute = attributes[i];
                    sb = new StringBuffer();
                    sb.append(key.getObjectID()).append(",");
                    sb.append(key.getNumID()).append(",");
                    sb.append(attribute.getObjectID()).append(",");
                    sb.append(attribute.getNumID()).append(",");
                    sb.append(attribute.getContainer().getObjectID()).append(",");
                    sb.append(attribute.getContainer().getNumID()).append(",");
                    sb.append(this.replaceAndQuoteString(key.getName())).append(",");
                    sb.append(this.replaceAndQuoteString(attribute.getContainer().getName())).append(",");
                    sb.append(this.replaceAndQuoteString(attribute.getName())).append(",");
                    lines.add(sb.toString());
                }
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Key_Attributes.csv";
    }
}

