/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;

public class EHTableView
extends ExportHandler {
    public EHTableView(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("TableView_Name").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("ModelID").append(",");
        sb.append("Num_ModelID").append(",");
        sb.append("Structured_Type_ID").append(",");
        sb.append("Num_Structured_Type_ID").append(",");
        sb.append("Structured_Type_Name").append(",");
        sb.append("User_Defined").append(",");
        sb.append("Engineer").append(",");
        sb.append("Allow_Type_Substitution").append(",");
        sb.append("OID_Columns");
        lines.add(sb.toString());
        for (RelationalDesign phDesign : this.getDesign().getRelationalDesigns()) {
            if (!this.getCsvExporter().isModelSelected(phDesign)) continue;
            Iterator tit = phDesign.getTableViewSet().iterator();
            while (tit.hasNext()) {
                TableView view = (TableView)tit.next();
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(view.getName())).append(",");
                sb.append(view.getObjectID()).append(",");
                sb.append(view.getNumID()).append(",");
                sb.append(view.getImportedId() != null ? view.getImportedId() : EMPTY_STR).append(",");
                sb.append(phDesign.getObjectID()).append(",");
                sb.append(phDesign.getNumID()).append(",");
                if (view.isBST()) {
                    sb.append(view.getBasedOnStructuredType().getObjectID()).append(",");
                    sb.append(view.getBasedOnStructuredType().getNumID()).append(",");
                    sb.append(this.replaceAndQuoteString(view.getBasedOnStructuredType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(view.getUserDefined() ? YES : NO).append(",");
                sb.append(view.getShouldEngineer() ? YES : NO).append(",");
                sb.append(view.isAllowTypeSubstitution() ? YES : NO).append(",");
                sb.append(this.replaceAndQuoteString(view.getOidText())).append(",");
                lines.add(sb.toString());
                this.getCsvExporter().addNote(view.getObjectID(), view.getNumID(), "TableView", view.getNotes());
                this.getCsvExporter().addComment(view.getObjectID(), view.getNumID(), "TableView", view.getComment());
                this.getCsvExporter().addCommentRDBMS(view.getObjectID(), view.getNumID(), "TableView", view.getCommentInRDBMS());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_TableViews.csv";
    }
}

