/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionLobItemSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexHashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.oracle.OracleIndexTemplate;

public class SSBIndexOraclev10g
extends AbstractSSBOracle {
    protected StorageDesignOraclev10g storageDesign;
    private Object sType;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxyOracle && ((IndexProxyOracle)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Index index = null;
        IndexProxyOraclev10g indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            StorageDesignOraclev10g storageDesign = (StorageDesignOraclev10g)this.getStorageDesign(object);
            indexProxy = (IndexProxyOraclev10g)storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyOraclev10g) {
            indexProxy = (IndexProxyOraclev10g)object;
            index = (Index)indexProxy.getObject();
        }
        if (index != null && !index.isOidKey() && indexProxy != null) {
            this.storageDesign = (StorageDesignOraclev10g)indexProxy.getStorageDesign();
            if (index.getElements().length > 0 || index.hasIndexExpression()) {
                if (indexProxy.isMarkedGenerate()) {
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, indexProxy);
                    } else {
                        this.appendComment(oldbuffer, index);
                    }
                    String indName = indexProxy.getName();
                    if (indName.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendPrompt(buffer, indexProxy, "INDEX");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "CREATE");
                    if (indexProxy.isUnique()) {
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
                    } else if (indexProxy.getBitmapIndex()) {
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "BITMAP");
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "INDEX");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(indexProxy));
                    advancedComment = buffer.toString();
                    this.appendTable(buffer, indexProxy);
                    this.appendElementList(buffer, index, indexProxy, true);
                    this.appendGlobalOrLocal(buffer, indexProxy, prettyPrint);
                    if (!index.isSpatialIndex() && indexProxy.getIndexType().equals("")) {
                        this.appendIndexAttributes(buffer, indexProxy, prettyPrint);
                    }
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    SSBIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                }
            } else {
                SSBIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                oldbuffer.append("-- Error - Index ");
                oldbuffer.append(this.storageDesign.getFormatedName(index));
                oldbuffer.append(" has no columns");
                SSBIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                DDLFileMaker.incrementErrors();
            }
        }
    }

    private void appendTable(StringBuffer buffer, IndexProxy indexProxy) {
        TableProxy tableProxy = indexProxy.getTableProxy();
        SSBIndexOraclev10g.appendStringWithSpace(buffer, "ON");
        SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(tableProxy));
    }

    private void appendElementList(StringBuffer buffer, Index index, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        if (index.hasIndexExpression()) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendString(buffer, ' ');
            SSBIndexOraclev10g.appendString(buffer, index.getIndexExpression());
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            ColumnProxy column = null;
            IndexProxy constrProxy = null;
            Index constr = index.getSupportedConstraint();
            if (constr != null) {
                try {
                    constrProxy = (IndexProxy)indexProxy.getStorageDesign().getStorageObject(constr.getObjectID());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ColumnProxy[] columns = null;
            columns = constrProxy != null ? constrProxy.getColumnProxies() : indexProxy.getColumnProxies();
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if (columns.length < 1) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "-- No Columns");
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < columns.length; ++i) {
                if (i != 0) {
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
                }
                column = columns[i];
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendString(buffer, ' ');
                String columnName = this.storageDesign.getFormatedName(column);
                if (index.isSpatialIndex()) {
                    Datatype colType = column.getDataType();
                    if (this.sType == null) {
                        this.sType = column.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                    }
                    if (colType instanceof StructuredType) {
                        StructuredType st = (StructuredType)colType;
                        for (TypeElement te : st.getAllElements()) {
                            if (te.getType() != this.sType) continue;
                            columnName = columnName.concat(".").concat(this.storageDesign.getFormatedName(te));
                            break;
                        }
                    }
                }
                SSBIndexOraclev10g.appendStringWithSpace(buffer, columnName);
                if (index.isSpatialIndex() || !indexProxy.getIndexType().equals("")) continue;
                SSBIndexOraclev10g.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
        if (indexProxy != null) {
            if (index.isSpatialIndex()) {
                this.appendSpatialIndex(buffer, index, indexProxy, prettyPrint);
            } else {
                this.appendDomainIndexProps(buffer, index, indexProxy, prettyPrint);
            }
        }
    }

    private void appendDomainIndexProps(StringBuffer buffer, Index index, IndexProxyOracle indexProxy, boolean prettyPrint) {
        String type;
        if (!index.isSpatialIndex() && !(type = indexProxy.getIndexType()).equals("")) {
            if (!type.equalsIgnoreCase("XMLINDEX") && !type.equalsIgnoreCase("XDB.XMLINDEX")) {
                type = this.storageDesign.getFormatedName(type);
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "INDEXTYPE");
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "IS");
            SSBIndexOraclev10g.appendStringWithSpace(buffer, type);
            String params = indexProxy.getIndexDomainParameters();
            if (!params.equals("")) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
                SSBIndexOraclev10g.appendString(buffer, '(');
                SSBIndexOraclev10g.appendString(buffer, '\'');
                SSBIndexOraclev10g.appendString(buffer, params);
                SSBIndexOraclev10g.appendString(buffer, '\'');
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendSpatialIndex(StringBuffer buffer, Index index, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        if (index.isSpatialIndex()) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "INDEXTYPE");
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "IS");
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "MDSYS.SPATIAL_INDEX");
            if (!index.getGeodetic().equals("YES") || index.getLayerType() != null && !index.getLayerType().equals("") || index.getDimensionsNumber() != 2 || indexProxy.getNonLeaf().equalsIgnoreCase("YES") || indexProxy.getTableSpace() != null || indexProxy.getBatchSize() != 1000 || indexProxy.getWorkTablespace() != null) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
                SSBIndexOraclev10g.appendString(buffer, '(');
                SSBIndexOraclev10g.appendString(buffer, '\'');
                if (!index.getGeodetic().equals("YES")) {
                    SSBIndexOraclev10g.appendString(buffer, "geodetic");
                    SSBIndexOraclev10g.appendString(buffer, '=');
                    this.appendString(buffer, Boolean.FALSE);
                }
                if (index.getLayerType() != null && !index.getLayerType().equals("")) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "layer_gtype");
                    SSBIndexOraclev10g.appendString(buffer, '=');
                    SSBIndexOraclev10g.appendString(buffer, index.getLayerType());
                }
                if (index.getDimensionsNumber() != 2) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "sdo_indx_dims");
                    SSBIndexOraclev10g.appendString(buffer, '=');
                    SSBIndexOraclev10g.appendString(buffer, index.getDimensionsNumber());
                }
                if (indexProxy.getBatchSize() != 1000) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "sdo_dml_batch_size=");
                    SSBIndexOraclev10g.appendString(buffer, indexProxy.getBatchSize());
                }
                if (indexProxy.getTableSpace() != null) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "tablespace=");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableSpace()));
                }
                if (indexProxy.getWorkTablespace() != null) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "work_tablespace=");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getWorkTablespace()));
                }
                if (indexProxy.getNonLeaf().equalsIgnoreCase("YES")) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "sdo_non_leaf_tbl=TRUE");
                }
                SSBIndexOraclev10g.appendString(buffer, '\'');
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
            this.appendSpatialIndexPartitions(buffer, indexProxy, prettyPrint);
        }
    }

    private void appendSpatialIndexPartitions(StringBuffer buffer, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        if ("LOCAL".equalsIgnoreCase(indexProxy.getIndexPartitioned())) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "LOCAL");
            TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)indexProxy.getTableProxy();
            PartitionListOraclev10g partitionList = (PartitionListOraclev10g)tableProxy.getPartitionList();
            if (partitionList != null) {
                this.appendSpatialPartitions(buffer, indexProxy, partitionList, prettyPrint);
            }
        }
    }

    private void appendSpatialPartitions(StringBuffer buffer, IndexProxyOraclev10g indexProxy, PartitionListOraclev10g partitionList, boolean prettyPrint) {
        PartitionSetOraclev10g partitionSet = (PartitionSetOraclev10g)((StorageDesignOraclev10g)partitionList.getStorageDesign()).getPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            String lipPName;
            PartitionOraclev10g partition = (PartitionOraclev10g)setIt.next();
            if (partition.getPartitionList() == null || !partition.getPartitionList().getObjectID().equalsIgnoreCase(partitionList.getObjectID())) continue;
            if (first) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
            SSBIndexOraclev10g.appendString(buffer, '(');
            SSBIndexOraclev10g.appendString(buffer, '\'');
            if (lip != null) {
                SegmentOraclev10g indexSegment;
                if (lip.getTableSpace() != null) {
                    SSBIndexOraclev10g.appendString(buffer, "tablespace=");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lip.getTableSpace()));
                }
                if ((indexSegment = (SegmentOraclev10g)lip.getSegment()) != null && indexSegment.isMarkedGenerate()) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "sdo_rdr_pctfree=");
                    SSBIndexOraclev10g.appendString(buffer, String.valueOf(indexSegment.getPCTFree()).trim());
                    if (indexSegment.getSCInitialExtent() > 0L) {
                        SSBIndexOraclev10g.appendSpace(buffer);
                        SSBIndexOraclev10g.appendString(buffer, "initial=");
                        SSBIndexOraclev10g.appendString(buffer, String.valueOf(indexSegment.getSCInitialExtent()).trim());
                    }
                    if (indexSegment.getSCNextExtent() > 0L) {
                        SSBIndexOraclev10g.appendSpace(buffer);
                        SSBIndexOraclev10g.appendString(buffer, "next=");
                        SSBIndexOraclev10g.appendString(buffer, String.valueOf(indexSegment.getSCNextExtent()).trim());
                    }
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "pctincrease=");
                    SSBIndexOraclev10g.appendString(buffer, indexSegment.getSCPctIncrease());
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "minextents=");
                    SSBIndexOraclev10g.appendString(buffer, indexSegment.getSCMinExtents());
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "maxextents=");
                    SSBIndexOraclev10g.appendString(buffer, indexSegment.getSCMaxExtents());
                }
                if (lip.getWorkTablespace() != null) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "work_tablespace=");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lip.getWorkTablespace()));
                }
                if (lip.getLayerType() != null && !lip.getLayerType().equals("")) {
                    SSBIndexOraclev10g.appendSpace(buffer);
                    SSBIndexOraclev10g.appendString(buffer, "layer_gtype=");
                    SSBIndexOraclev10g.appendString(buffer, lip.getLayerType());
                }
            }
            if (indexProxy.getNonLeaf().equalsIgnoreCase("YES")) {
                SSBIndexOraclev10g.appendSpace(buffer);
                SSBIndexOraclev10g.appendString(buffer, "sdo_non_leaf_tbl=TRUE");
            }
            SSBIndexOraclev10g.appendString(buffer, '\'');
            SSBIndexOraclev10g.appendString(buffer, ')');
        }
        if (!first) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendString(buffer, ')');
        }
    }

    private void appendGlobalOrLocal(StringBuffer buffer, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        String partitionType = indexProxy.getIndexPartitioned();
        if ("LOCAL".equalsIgnoreCase(partitionType)) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "LOCAL");
            this.appendPartitionList(buffer, indexProxy, (TableProxyOraclev10g)indexProxy.getTableProxy(), prettyPrint);
        } else {
            IndexGlobalPartitionsListOraclev10g globalPartitionList = (IndexGlobalPartitionsListOraclev10g)indexProxy.getIndexGlobalPartitionsList();
            if (globalPartitionList != null) {
                String rangeOrHash = "";
                if ("GLOBAL BY RANGE".equalsIgnoreCase(partitionType)) {
                    rangeOrHash = "RANGE";
                } else if ("GLOBAL HASH PARTITIONED BY QUANTITY".equalsIgnoreCase(partitionType) || "GLOBAL HASH PARTITIONED BY LIST".equalsIgnoreCase(partitionType)) {
                    rangeOrHash = "HASH";
                } else {
                    return;
                }
                Index index = (Index)indexProxy.getObject();
                if (!index.isSpatialIndex() && indexProxy.getIndexType().equals("")) {
                    SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "GLOBAL");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "BY");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, rangeOrHash);
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(globalPartitionList.getGlobalPartColumns()));
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
                    if ("GLOBAL BY RANGE".equalsIgnoreCase(partitionType)) {
                        this.appendGlobalRangePartitions(buffer, indexProxy, prettyPrint);
                    } else if ("GLOBAL HASH PARTITIONED BY QUANTITY".equalsIgnoreCase(partitionType)) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITIONS");
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, globalPartitionList.getHashPQuantity());
                        if (!"".equals(globalPartitionList.getHashPTableSpaces())) {
                            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(globalPartitionList.getHashPTableSpaces()));
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
                        }
                        if (!"".equals(globalPartitionList.getIOTOverflowHashPTS())) {
                            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(globalPartitionList.getIOTOverflowHashPTS()));
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
                        }
                    } else if ("GLOBAL HASH PARTITIONED BY LIST".equalsIgnoreCase(partitionType)) {
                        this.appendGlobalHashPartitions(buffer, indexProxy, prettyPrint);
                    }
                }
            }
        }
    }

    private void appendGlobalRangePartitions(StringBuffer buffer, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        StorageObjectCollection globalPartitions = indexProxy.getGlobalPartitions();
        Object[] partitionsArray = globalPartitions.toArray();
        for (int i = 0; i < partitionsArray.length; ++i) {
            if (partitionsArray[i] instanceof IndexGlobalPartitionOraclev10g) continue;
            return;
        }
        Arrays.sort(partitionsArray, new SSBTableOraclev10g.GlobalPossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>(partitionsArray.length);
        for (int i = 0; i < partitionsArray.length; ++i) {
            sortedList.add(partitionsArray[i]);
        }
        Iterator it = sortedList.iterator();
        boolean first = true;
        while (it.hasNext()) {
            IndexGlobalPartitionOraclev10g globalPartition = (IndexGlobalPartitionOraclev10g)it.next();
            if (first) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "VALUES LESS THAN");
            SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            SSBIndexOraclev10g.appendStringWithSpace(buffer, globalPartition.getValueList());
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            if (globalPartition.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            this.appendSegment(buffer, (SegmentOraclev10g)globalPartition.getSegment(), prettyPrint, 2);
            if (!this.storageDesign.isOpen() || !this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendGlobalHashPartitions(StringBuffer buffer, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        Iterator it = indexProxy.getGlobalPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Object partition = it.next();
            if (!(partition instanceof IndexHashPartitionOraclev10g)) continue;
            IndexHashPartitionOraclev10g hashPartition = (IndexHashPartitionOraclev10g)partition;
            if (first) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                if (hashPartition.getTableSpace() != null) {
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
                }
                if (hashPartition.getOverflowTableSpace() != null) {
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "OVERFLOW");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getOverflowTableSpace()));
                }
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashPLobItems(StringBuffer buffer, IndexHashPartitionOraclev10g hashPartition, boolean prettyPrint) {
        IndexHashPartitionLobItemSetOraclev10g hashPLobItemSet = (IndexHashPartitionLobItemSetOraclev10g)((StorageDesignOraclev10g)hashPartition.getStorageDesign()).getIndexHashPartitionLobItemSet();
        for (IndexHashPartitionLobItemOraclev10g hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getIndexHashPartition() == null || !hashPLobItem.getIndexHashPartition().getObjectID().equalsIgnoreCase(hashPartition.getObjectID())) continue;
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, ColumnProxy columnProxy, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        SSBIndexOraclev10g.appendStringWithSpace(buffer, "LOB");
        SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
        if (columnProxy != null) {
            SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        } else {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append("--  ERROR: Lob ");
            buffer.append(lobObject.getName());
            buffer.append(" has no Column specified");
            DDLFileMaker.incrementErrors();
        }
        SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        SSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        if (!lobSegName.equalsIgnoreCase("")) {
            SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
            SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendSegment(StringBuffer buffer, SegmentOraclev10g segment, boolean prettyPrint, int indent) {
        if (segment != null && segment.isMarkedGenerate() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            if (this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "PCTFREE");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                if (segment.getInitrans() > 2) {
                    SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getInitrans());
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "INITRANS");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "2");
                }
                if (!(this.storageDesign instanceof StorageDesignOraclev11g)) {
                    if (segment.getMaxTrans() > 2) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getMaxTrans());
                    } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "MAXTRANS");
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "255");
                    }
                }
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "NEXT");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCNextExtent());
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMinExtents());
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCFreeLists());
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, indent + 1);
                props = true;
            }
            if (this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, segment.getSCBufferPool());
                props = true;
            }
            if (props) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            } else {
                buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
            }
        }
    }

    private void appendIndexAttributes(StringBuffer buffer, IndexProxyOraclev10g indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        boolean temporaryTable = tableProxy.getTemporary().equalsIgnoreCase("YES");
        if (!temporaryTable) {
            if (indexProxy.getTableSpace() != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableSpace()));
            }
            this.appendSegment(buffer, (SegmentOraclev10g)indexProxy.getSegment(), prettyPrint, 1);
        }
        if (this.storageDesign.isOpen()) {
            if (!temporaryTable && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(indexProxy.getLogging())) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(indexProxy.getLogging())) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            if ("YES".equalsIgnoreCase(indexProxy.getOnline())) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "ONLINE");
            }
            if ("YES".equalsIgnoreCase(indexProxy.getComputeStatistics())) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
            if (indexProxy.getCompress() > 0) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, indexProxy.getCompress());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                buffer.append(NEWLINE).append("    ");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (!indexProxy.getBitmapIndex()) {
                if ("NO".equalsIgnoreCase(indexProxy.getSortedRows())) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOSORT");
                } else if ("REVERSE".equalsIgnoreCase(indexProxy.getSortedRows())) {
                    buffer.append(NEWLINE).append("    ");
                    if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "REVERSE");
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "SORT");
                }
            }
            if (indexProxy.getInvisible().equalsIgnoreCase("YES") && this.storageDesign instanceof StorageDesignOraclev11g) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "INVISIBLE");
            }
            if (!temporaryTable) {
                if ("YES".equalsIgnoreCase(indexProxy.getParallel())) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
                    if (!"".equalsIgnoreCase(indexProxy.getDegree())) {
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, indexProxy.getDegree());
                    }
                } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append(NEWLINE).append("    ");
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
                }
            }
        }
    }

    public void appendPartitionList(StringBuffer buffer, IndexProxyOracle indexProxy, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        PartitionListOraclev10g partitionList = (PartitionListOraclev10g)tableProxy.getPartitionList();
        if (partitionList != null) {
            boolean composite;
            String subPartitionTableSpaceIDs;
            String partitionType = partitionList.getPartitionType();
            String subpartitionType = partitionList.getSubpartitionType();
            if ((partitionType.equalsIgnoreCase("HASH BY QUANTITY") || subpartitionType.equalsIgnoreCase("HASH")) && !"".equals(subPartitionTableSpaceIDs = indexProxy.getHashSubPartitionsTableSpaces())) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(subPartitionTableSpaceIDs));
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
            boolean bl = composite = !subpartitionType.equals("");
            if ("RANGE".equalsIgnoreCase(partitionType) || "COMPOSITE BY HASH".equalsIgnoreCase(partitionType) || "COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                this.appendPartitions(buffer, indexProxy, partitionList, composite, prettyPrint);
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                this.appendHashPartitions(buffer, partitionList, indexProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                this.appendListPartitions(buffer, partitionList, indexProxy, prettyPrint);
            }
        }
    }

    protected void appendListPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, IndexProxyOracle indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            ListPartitionOraclev10g partition = (ListPartitionOraclev10g)it.next();
            if (first) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip != null) {
                TableSpaceOraclev10g ts = (TableSpaceOraclev10g)lip.getTableSpace();
                String logging = lip.getLogging();
                SegmentOraclev10g indexSegment = (SegmentOraclev10g)lip.getSegment();
                if (indexSegment != null) {
                    this.appendSegment(buffer, indexSegment, prettyPrint, 2);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    if (ts != null) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                    } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                    }
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if ("YES".equalsIgnoreCase(logging)) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(logging)) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
                if (indexProxy.getCompress() > 0) {
                    if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    } else if ("NO".equalsIgnoreCase(lip.getKeyCompress())) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                    }
                }
            }
            if (partitionList.getSubpartitionType().equals("")) continue;
            String tablespaceIDs = "";
            if (lip != null) {
                tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            }
            this.appendIndexSubPartitions(buffer, indexProxy, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendHashPartitions(StringBuffer buffer, PartitionListOraclev10g partitionList, IndexProxyOracle indexProxy, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            HashPartitionOraclev10g partition = (HashPartitionOraclev10g)it.next();
            if (first) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOraclev10g ts = (TableSpaceOraclev10g)lip.getTableSpace();
            if (ts != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (indexProxy.getCompress() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                continue;
            }
            if (!"NO".equalsIgnoreCase(lip.getKeyCompress())) continue;
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!first) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, PartitionListOraclev10g partitionList, boolean composite, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)indexProxy.getTableProxy();
        StorageObjectCollection partitions = tableProxy.getPartitions();
        Iterator it = partitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            PartitionOraclev10g partition = (PartitionOraclev10g)it.next();
            if (first) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                buffer.append(',');
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "PARTITION");
            String pName = partition.getName();
            String formattedPName = this.storageDesign.getFormatedName(partition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, partition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !pName.equals(lipPName)) {
                pName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!pName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip != null) {
                TableSpaceOracle ts = lip.getTableSpace();
                String logging = lip.getLogging();
                SegmentOraclev10g indexSegment = (SegmentOraclev10g)lip.getSegment();
                if (indexSegment != null) {
                    this.appendSegment(buffer, indexSegment, prettyPrint, 2);
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                    if (ts != null) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
                    } else if (indexSegment != null && indexSegment.getTableSpace() != null) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexSegment.getTableSpace()));
                    }
                }
                if (this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL()) {
                    if ("YES".equalsIgnoreCase(logging)) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                    } else if ("NO".equalsIgnoreCase(logging)) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
                if (indexProxy.getCompress() > 0) {
                    if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                    } else if ("NO".equalsIgnoreCase(lip.getKeyCompress())) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
                    }
                }
            }
            if (!composite) continue;
            String tablespaceIDs = "";
            if (lip != null) {
                tablespaceIDs = lip.getHashSubPartitionsTableSpaces();
            }
            this.appendIndexSubPartitions(buffer, indexProxy, partitionList, partition, tablespaceIDs, prettyPrint);
        }
        if (!first) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected LocalIndexProperties getPropsForIndex(IndexProxyOracle indexProxy, StorageObject partition) {
        return this.storageDesign.getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(partition, indexProxy);
    }

    protected void appendIndexSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, PartitionListOraclev10g partitionList, AbstractStorageObjectOracle partition, String tablespaceIDs, boolean prettyPrint) {
        String subPartType = partitionList.getSubpartitionType();
        if (subPartType.equalsIgnoreCase("HASH")) {
            PartitionOraclev10g rangePartition;
            if (partition instanceof PartitionOraclev10g && !this.appendHashSubPartitions(buffer, indexProxy, (rangePartition = (PartitionOraclev10g)partition).getPartitions(), prettyPrint) && !"".equalsIgnoreCase(tablespaceIDs.trim())) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "STORE IN");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(tablespaceIDs));
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
            }
        } else if (subPartType.equalsIgnoreCase("LIST") && partition instanceof PartitionOraclev10g) {
            this.appendListSubPartitions(buffer, indexProxy, ((PartitionOraclev10g)partition).getListPartitions(), prettyPrint);
        }
    }

    protected void appendListSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, StorageObjectCollection subpartitions, boolean prettyPrint) {
        boolean first = true;
        for (ListStorageTemplatePartitionOraclev10g listPartition : subpartitions) {
            String lipPName;
            if (first) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            String lpName = listPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(listPartition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, listPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !lpName.equals(lipPName)) {
                lpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!lpName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOracle ts = lip.getTableSpace();
            if (ts != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (indexProxy.getCompress() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                continue;
            }
            if (!"NO".equalsIgnoreCase(lip.getKeyCompress())) continue;
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!first) {
            SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected boolean appendHashSubPartitions(StringBuffer buffer, IndexProxyOracle indexProxy, StorageObjectCollection subpartitions, boolean prettyPrint) {
        boolean result = false;
        Iterator it = subpartitions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String lipPName;
            HashPartitionOraclev10g hashPartition = (HashPartitionOraclev10g)it.next();
            if (first) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
                first = false;
                result = true;
            } else {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "SUBPARTITION");
            String hpName = hashPartition.getName();
            String formattedPName = this.storageDesign.getFormatedName(hashPartition);
            LocalIndexProperties lip = this.getPropsForIndex(indexProxy, hashPartition);
            if (lip != null && !"".equals(lipPName = lip.getPartitionName()) && !hpName.equals(lipPName)) {
                hpName = lipPName;
                formattedPName = this.storageDesign.getFormatedName(lipPName);
            }
            if (!hpName.toUpperCase().startsWith("SYS_")) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, formattedPName);
            }
            if (lip == null) continue;
            TableSpaceOraclev10g ts = (TableSpaceOraclev10g)lip.getTableSpace();
            if (ts != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(ts));
            }
            if (indexProxy.getCompress() <= 0 || !(this.storageDesign instanceof StorageDesignOraclev11g)) continue;
            if ("YES".equalsIgnoreCase(lip.getKeyCompress())) {
                SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                SSBIndexOraclev10g.appendStringWithSpace(buffer, "COMPRESS");
                continue;
            }
            if (!"NO".equalsIgnoreCase(lip.getKeyCompress())) continue;
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 3);
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if (!first) {
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            buffer.append(')');
        }
        return result;
    }

    private void appendConstraintElementList(StringBuffer buffer, Index index, IndexProxy indexProxy, boolean prettyPrint) {
        ColumnProxy column = null;
        ColumnProxy[] columns = indexProxy.getColumnProxies();
        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBIndexOraclev10g.appendStringWithSpace(buffer, "-- No Columns");
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexOraclev10g.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                SSBIndexOraclev10g.appendStringWithSpace(buffer, ',');
            }
            column = columns[i];
            SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexOraclev10g.appendString(buffer, ' ');
            SSBIndexOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
            SSBIndexOraclev10g.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
        }
        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexOraclev10g.appendStringWithSpace(buffer, ')');
    }

    public void appendIndexForConstraint(StringBuffer oldbuffer, Index index, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        IndexProxy indexProxy = null;
        StorageDesignOraclev10g storageDesign = (StorageDesignOraclev10g)this.getStorageDesign(index);
        if ("Primary Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxyOracle)storageDesign.getPKProxySet().getProxy(index.getObjectID());
        } else if ("Unique Constraint".equals(index.getIndexState())) {
            indexProxy = (IndexProxyOracle)storageDesign.getUniqueSet().getProxy(index.getObjectID());
        } else if (index.isFK()) {
            indexProxy = (FKProxyOracle)storageDesign.getFKProxySet().getProxy(index.getObjectID());
        }
        if (indexProxy != null && !index.isOidKey()) {
            this.storageDesign = (StorageDesignOraclev10g)indexProxy.getStorageDesign();
            if (indexProxy.isMarkedGenerate()) {
                if (index.getElements().length > 0) {
                    String tablespaceName;
                    ModelIDObject tableUser;
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, indexProxy);
                    } else {
                        this.appendComment(oldbuffer, index);
                    }
                    TableProxy tp = indexProxy.getTableProxy();
                    String indName = indexProxy.getName();
                    indName = ApplyNamingStandards.createIndexNameAuto(tp.getName(), indName, index, index.getDesign().getDesignLevelSettings().getNamingStandardRule(), index.getDesignPart().getName(), index.getTable().getAbbreviation());
                    if (indName.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    OracleIndexTemplate oit = null;
                    if (storageDesign.getAppView().getSettings().useOracleIndexTemplate()) {
                        oit = storageDesign.getAppView().getSettings().getOracleIndexTemplate();
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "CREATE");
                    if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
                    } else if (oit != null && oit.isBitmapIndex()) {
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "BITMAP");
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, "INDEX");
                    if (storageDesign.getAppView().getSettings().isIncludeSchemaInDDL() && (tableUser = tp.getSchemaImplementingObject()) != null) {
                        SSBIndexOraclev10g.appendString(buffer, storageDesign.getFormatedName(tableUser));
                        SSBIndexOraclev10g.appendString(buffer, '.');
                    }
                    SSBIndexOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(indName));
                    advancedComment = buffer.toString();
                    this.appendTable(buffer, indexProxy);
                    this.appendConstraintElementList(buffer, index, indexProxy, true);
                    if (oit != null && (tablespaceName = oit.getTableSpace().trim()).length() > 0 && storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
                        SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        SSBIndexOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                        TableSpaceOracle tablespace = (TableSpaceOracle)storageDesign.getTableSpaceSet().getByName(tablespaceName);
                        if (tablespace != null) {
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(tablespace));
                        } else {
                            SSBIndexOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(tablespaceName));
                        }
                    }
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    SSBIndexOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    SSBIndexOraclev10g.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    oldbuffer.append("-- Error - Index ");
                    oldbuffer.append(storageDesign.getFormatedName(index));
                    oldbuffer.append(" has no columns");
                    SSBIndexOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    public void setStorageDesign(StorageDesignOraclev10g storageDesign) {
        this.storageDesign = storageDesign;
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (one instanceof PartitionOraclev10g && two instanceof PartitionOraclev10g) {
                if (((PartitionOraclev10g)one).getPosition() > ((PartitionOraclev10g)two).getPosition()) {
                    return 1;
                }
                if (((PartitionOraclev10g)one).getPosition() < ((PartitionOraclev10g)two).getPosition()) {
                    return -1;
                }
            } else if (one instanceof ListPartitionOraclev10g && two instanceof ListPartitionOraclev10g) {
                if (((ListPartitionOraclev10g)one).getPosition() > ((ListPartitionOraclev10g)two).getPosition()) {
                    return 1;
                }
                if (((ListPartitionOraclev10g)one).getPosition() < ((ListPartitionOraclev10g)two).getPosition()) {
                    return -1;
                }
            } else {
                return 0;
            }
            return 0;
        }
    }
}

