/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StoredProcedureSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBStoredProcedureSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        StoredProcedureSqlServerv2k proc = (StoredProcedureSqlServerv2k)object;
        this.storageDesign = proc.getStorageDesign();
        this.appendComment(buffer, proc);
        SSBStoredProcedureSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        this.appendCreate(buffer, proc);
        this.appendBody(buffer, proc, prettyPrint);
        SSBStoredProcedureSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, "GO");
        DDLFileMaker.incrementCreateProc();
        SSBStoredProcedureSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        if (proc.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendProcedureComment(buffer, proc, prettyPrint);
        }
        SSBStoredProcedureSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
    }

    private void appendProcedureComment(StringBuffer buffer, StoredProcedureSqlServerv2k proc, boolean prettyPrint) {
        String comment = proc.getCommentInRDBMS();
        if (comment != null && !comment.trim().equalsIgnoreCase("")) {
            SSBStoredProcedureSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, "sp_addextendedproperty");
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, "'MS_Description'");
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBStoredProcedureSqlServerv2k.appendString(buffer, '\'');
            SSBStoredProcedureSqlServerv2k.appendString(buffer, comment);
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, ',');
            if (proc != null && proc.getOwner() != null) {
                SSBStoredProcedureSqlServerv2k.appendString(buffer, '\'');
                SSBStoredProcedureSqlServerv2k.appendString(buffer, "USER");
                SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, ',');
                SSBStoredProcedureSqlServerv2k.appendString(buffer, '\'');
                this.appendString(buffer, proc.getOwner());
                SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, '\'');
                SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, ',');
            }
            SSBStoredProcedureSqlServerv2k.appendString(buffer, '\'');
            SSBStoredProcedureSqlServerv2k.appendString(buffer, "PROCEDURE");
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, ',');
            SSBStoredProcedureSqlServerv2k.appendString(buffer, '\'');
            SSBStoredProcedureSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(proc.getLongNameDDL()));
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, '\'');
            SSBStoredProcedureSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBStoredProcedureSqlServerv2k.appendString(buffer, "GO");
            SSBStoredProcedureSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendCreate(StringBuffer buffer, StoredProcedureSqlServerv2k proc) {
        this.appendCreate(buffer);
        SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, "PROCEDURE");
        if (proc.getOwner() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            SSBStoredProcedureSqlServerv2k.appendString(buffer, this.storageDesign.getFormatedName(proc.getOwner().getName()));
            SSBStoredProcedureSqlServerv2k.appendString(buffer, '.');
        }
        SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(proc.getName()));
    }

    private void appendBody(StringBuffer buffer, StoredProcedureSqlServerv2k proc, boolean prettyPrint) {
        SSBStoredProcedureSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        if (!proc.getBody().trim().equalsIgnoreCase("")) {
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, proc.getBody());
        } else {
            SSBStoredProcedureSqlServerv2k.appendStringWithSpace(buffer, " -- Empty body");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof StoredProcedureSqlServerv2k && ((StoredProcedureSqlServerv2k)object).isMarkedGenerate();
    }
}

