/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseSqlServerv2kv5
extends AbstractSSBSqlServer {
    private StorageDesignSqlServer storageDesign;
    boolean existsPrimary = false;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)object;
        this.storageDesign = (StorageDesignSqlServer)this.getStorageDesign(object);
        this.appendComment(buffer, database);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 0);
        this.appendCreate(buffer, database, prettyPrint);
        this.appendFileSpec(buffer, database, prettyPrint);
        this.appendFileGroup(buffer, database, prettyPrint);
        this.appendLogOn(buffer, database, prettyPrint);
        this.appendCollate(buffer, database, prettyPrint);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 0);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "GO");
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 0);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 0);
        DDLFileMaker.incrementCreateDatabase();
        this.appendAlterDatabase(buffer, database, prettyPrint);
    }

    protected void appendCreate(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        this.appendCreate(buffer);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "DATABASE");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(database.getName()));
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
    }

    protected void appendFileSpec(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        StorageObjectCollection fileGroups = database.getFilegroups();
        if (fileGroups.containsName("PRIMARY") && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            FileGroupSqlServer primary = (FileGroupSqlServer)fileGroups.getByName("PRIMARY");
            if (primary != null && primary.getDatafiles() != null) {
                if (this.checkFileGroupValidity(primary)) {
                    StorageObjectCollection datafiles = primary.getDatafiles();
                    if (datafiles.size() > 0) {
                        this.existsPrimary = true;
                        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ON");
                        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "PRIMARY");
                        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
                        this.appendDataFiles(buffer, datafiles, prettyPrint);
                    }
                } else {
                    SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
                    SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "-- Invalid filegroup");
                    SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(primary.getName()));
                }
            }
        } else {
            this.existsPrimary = false;
        }
    }

    protected void appendFileGroup(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        if (this.existsPrimary && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            StorageObjectCollection fileGroups = database.getFilegroups();
            for (FileGroupSqlServer filegroup : fileGroups) {
                if (filegroup.getName().equalsIgnoreCase("PRIMARY")) continue;
                if (this.checkFileGroupValidity(filegroup)) {
                    this.appendComma(buffer);
                    SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
                    this.appendGroup(buffer, filegroup, prettyPrint);
                    continue;
                }
                SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "-- Invalid filegroup");
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(filegroup.getName()));
            }
        }
    }

    protected void appendCollate(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        String collation = database.getCollationName();
        if (collation != null && !collation.trim().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "COLLATE");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, collation);
        }
    }

    protected void appendLogOn(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        if (this.existsPrimary && this.storageDesign.getAppView().getSettings().isIncludeLoggingInDDL() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            StorageObjectCollection datafiles = database.getTransactionLogs();
            Iterator it = datafiles.iterator();
            boolean wasInside = false;
            while (it.hasNext()) {
                DataFileSqlServer datafile = (DataFileSqlServer)it.next();
                if (datafile.getDataBase() != null && this.checkDataFileValidity(datafile)) {
                    if (!wasInside) {
                        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
                        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "LOG ON");
                        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
                    }
                    wasInside = true;
                    this.appendDataFile(buffer, datafile, prettyPrint);
                    continue;
                }
                if (datafile.getDataBase() == null || this.checkDataFileValidity(datafile)) continue;
                SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "-- Invalid datafile name");
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(datafile.getName()));
            }
            this.deleteLastComma(buffer, prettyPrint, wasInside);
        }
    }

    protected void appendAlterDatabase(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ALTER");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "DATABASE");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(database.getLongNameDDL()));
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "SET");
        this.appendStateOption(buffer, database, prettyPrint);
        this.appendCursorOption(buffer, database, prettyPrint);
        this.appendAutoOption(buffer, database, prettyPrint);
        this.appendSqlOption(buffer, database, prettyPrint);
        this.appendRecoveryOption(buffer, database, prettyPrint);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "GO");
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 0);
    }

    protected void appendStateOption(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getUserState());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
    }

    protected void appendCursorOption(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "CURSOR_CLOSE_ON_COMMIT");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getCursorCloseOnCommit());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "CURSOR_DEFAULT");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getCursorDefault());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
    }

    protected void appendAutoOption(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        if (database.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "AUTO_CLOSE");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAutoClose());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "AUTO_CREATE_STATISTICS");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAutoCreateStatistics());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "AUTO_SHRINK");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAutoShrink());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "AUTO_UPDATE_STATISTICS");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAutoUpdateStatistics());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "AUTO_UPDATE_STATISTICS_ASYNC");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAutoUpdateStatisticsAsync());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    protected void appendSqlOption(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ANSI_NULLS");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAnsiNulls());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ANSI_NULL_DEFAULT");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAnsiNullDefault());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "DATE_CORRELATION_OPTIMIZATION");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getDateCorrelationOptimization());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "TRUSTWORTHY");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getTrustworthy());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ALLOW_SNAPSHOT_ISOLATION");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAllowSnapshotIsolation());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "READ_COMMITTED_SNAPSHOT");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getReadCommittedSnapshot());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "DB_CHAINING");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getDbChaining());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        if (database.getEnableBroker()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ENABLE_BROKER");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (database.getDisableBroker()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "DISABLE_BROKER");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (database.getNewBroker()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "NEW_BROKER");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (database.getErrorBrokerConversations()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ERROR_BROKER_CONVERSATIONS");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (database.getReadWrite()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "READ_WRITE");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (database.getReadOnly()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "READ_ONLY");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getRollbackAfter().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ROLLBACK AFTER");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getRollbackAfter());
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "SECONDS");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (database.getRollbackImmediate()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ROLLBACK IMMEDIATE");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (database.getNoWait()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "NO_WAIT");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "PARAMETERIZATION");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getParameterization());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "PAGE_VERIFY");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getPageVerify());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        if (this.storageDesign.getRDBMSSite().getName().equalsIgnoreCase(StorageDesignSqlServerv2k8.RDBMS_TYPE.getName()) || this.storageDesign.getRDBMSSite().getName().equalsIgnoreCase(StorageDesignSqlServerv2k12.RDBMS_TYPE.getName())) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "HONOR_BROKER_PRIORITY");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getHonorBrokerPriority());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "COMPATIBILITY_LEVEL");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "=");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getCompatibilityLevel());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "CHANGE_TRACKING");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "=");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getChangeTracking());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "AUTO_CLEANUP");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "=");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAutoCleanup());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ENCRYPTION");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getEncryption());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getAnsiPadding().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ANSI_PADDING");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAnsiPadding());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getAnsiWarnings().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ANSI_WARNINGS");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getAnsiWarnings());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getArithabort().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "ARITHABORT");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getArithabort());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getConcatNullYieldsNull().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "CONCAT_NULL_YIELDS_NULL");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getConcatNullYieldsNull());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "CONCAT_NULL_YIELDS_NULL");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "OFF");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        if (!database.getNumericRoundabort().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "NUMERIC_ROUNDABORT");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getNumericRoundabort());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "QUOTED_IDENTIFIER");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getQuotedIdentifier());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        if (!database.getRecursiveTriggers().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "RECURSIVE_TRIGGERS");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getRecursiveTriggers());
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "RECURSIVE_TRIGGERS");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "OFF");
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    protected void appendRecoveryOption(StringBuffer buffer, DataBaseSqlServerv2k5 database, boolean prettyPrint) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "RECOVERY");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getRecovery());
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "TORN_PAGE_DETECTION");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, database.getTornPageDetection());
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 0);
    }

    private boolean checkFileGroupValidity(FileGroupSqlServer filegroup) {
        StorageObjectCollection datafiles = filegroup.getDatafiles();
        if (datafiles == null || datafiles.size() == 0) {
            return false;
        }
        for (DataFileSqlServer df : datafiles) {
            if (df.getFileName() != null && !df.getFileName().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private boolean checkDataFileValidity(DataFileSqlServer datafile) {
        return datafile.getFileName() != null && !datafile.getFileName().trim().equalsIgnoreCase("");
    }

    protected void appendGroup(StringBuffer buffer, FileGroupSqlServer filegroup, boolean prettyPrint) {
        StorageObjectCollection datafiles = filegroup.getDatafiles();
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "FILEGROUP");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(filegroup.getName()));
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        this.appendDataFiles(buffer, datafiles, prettyPrint);
    }

    protected void appendDataFiles(StringBuffer buffer, StorageObjectCollection datafiles, boolean prettyPrint) {
        Iterator it = datafiles.iterator();
        boolean wasInside = false;
        while (it.hasNext()) {
            wasInside = true;
            DataFileSqlServer datafile = (DataFileSqlServer)it.next();
            this.appendDataFile(buffer, datafile, prettyPrint);
        }
        if (wasInside) {
            int newline = prettyPrint ? NEWLINE.length() + "    ".length() : 1;
            buffer = buffer.delete(buffer.length() - newline - 2, buffer.length() - 1);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseSqlServerv2k5 && ((DataBaseSqlServerv2k5)object).isMarkedGenerate();
    }

    protected void appendDataFile(StringBuffer buffer, DataFileSqlServer datafile, boolean prettyPrint) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '(');
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        this.appendNameWithQuotes(buffer, prettyPrint, datafile);
        this.appendFilename(buffer, prettyPrint, datafile);
        this.appendInitialSize(buffer, prettyPrint, datafile);
        this.appendMaxSize(buffer, datafile);
        this.appendGrowthValue(buffer, prettyPrint, datafile);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        SSBDataBaseSqlServerv2kv5.appendString(buffer, ')');
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
    }

    private void deleteLastComma(StringBuffer buffer, boolean prettyPrint, boolean wasInside) {
        int newline = prettyPrint ? NEWLINE.length() + "    ".length() : 1;
        if (wasInside) {
            buffer = buffer.delete(buffer.length() - newline - 2, buffer.length());
        }
    }

    private void appendNameWithQuotes(StringBuffer buffer, boolean prettyPrint, DataFileSqlServer datafile) {
        if (!datafile.getName().trim().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "NAME");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '=');
            SSBDataBaseSqlServerv2kv5.appendString(buffer, '\'');
            this.appendString(buffer, datafile);
            SSBDataBaseSqlServerv2kv5.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    private void appendFilename(StringBuffer buffer, boolean prettyPrint, DataFileSqlServer datafile) {
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "FILENAME");
        SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '=');
        SSBDataBaseSqlServerv2kv5.appendString(buffer, '\'');
        SSBDataBaseSqlServerv2kv5.appendString(buffer, datafile.getFileName());
        SSBDataBaseSqlServerv2kv5.appendString(buffer, '\'');
        this.appendComma(buffer);
        SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
    }

    private void appendInitialSize(StringBuffer buffer, boolean prettyPrint, DataFileSqlServer datafile) {
        if (datafile.getInitialSize() != 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "SIZE");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '=');
            SSBDataBaseSqlServerv2kv5.appendString(buffer, datafile.getInitialSize());
            if (!datafile.getInitialSizeInUnit().equals("")) {
                SSBDataBaseSqlServerv2kv5.appendSpace(buffer);
                SSBDataBaseSqlServerv2kv5.appendString(buffer, datafile.getSizeUnitFromInUnit(datafile.getInitialSizeInUnit()));
            }
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
        }
    }

    private void appendMaxSize(StringBuffer buffer, DataFileSqlServer datafile) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "MAXSIZE");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '=');
            if (datafile.getIsUnlimited()) {
                SSBDataBaseSqlServerv2kv5.appendString(buffer, "UNLIMITED");
            } else {
                SSBDataBaseSqlServerv2kv5.appendString(buffer, datafile.getMaxSize());
                if (!datafile.getMaxSizeInUnit().equals("")) {
                    SSBDataBaseSqlServerv2kv5.appendSpace(buffer);
                    SSBDataBaseSqlServerv2kv5.appendString(buffer, datafile.getSizeUnitFromInUnit(datafile.getMaxSizeInUnit()));
                }
            }
        }
    }

    private void appendGrowthValue(StringBuffer buffer, boolean prettyPrint, DataFileSqlServer datafile) {
        if (datafile.getGrowthValue() != 0) {
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "FILEGROWTH");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '=');
            SSBDataBaseSqlServerv2kv5.appendString(buffer, datafile.getGrowthValue());
            if (datafile.getGrowthMethod().equalsIgnoreCase("By Percent")) {
                SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '%');
            } else if (!datafile.getGrowthMethod().equals("")) {
                SSBDataBaseSqlServerv2kv5.appendSpace(buffer);
                SSBDataBaseSqlServerv2kv5.appendString(buffer, datafile.getSizeUnitFromInUnit(datafile.getGrowthMethod()));
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            this.appendComma(buffer);
            SSBDataBaseSqlServerv2kv5.appendNewLine(buffer, prettyPrint, 1);
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, "FILEGROWTH");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '=');
            SSBDataBaseSqlServerv2kv5.appendString(buffer, "10");
            SSBDataBaseSqlServerv2kv5.appendStringWithSpace(buffer, '%');
        }
    }
}

