/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;

public class RSFKColumns
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, FKIndexAssociation index) throws Exception {
        int count = 0;
        String query = "INSERT INTO DMRS_CONSTR_FK_COLUMNS (Fk_ID, Fk_OVID, Column_ID, Column_OVID, Table_ID, Table_OVID, Index_Name, Table_Name, Column_Name, Sequence, Sort_Order, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        KeyObject idx = index.getLocalFKIndex();
        Iterator it = idx.getElementsCollection().iterator();
        int seq = 0;
        while (it.hasNext()) {
            ++seq;
            ContainedObject column = (ContainedObject)it.next();
            String columnOVID = RSFKColumns.getOrCreateOVID(map, column.getObjectID());
            stmt.setString(1, idx.getObjectID());
            stmt.setString(2, RSFKColumns.getOrCreateOVID(map, index.getObjectID()));
            stmt.setString(3, column.getObjectID());
            stmt.setString(4, columnOVID);
            stmt.setString(5, column.getContainer().getObjectID());
            stmt.setString(6, (String)map.get(column.getContainer().getObjectID()));
            stmt.setString(7, idx.getName());
            stmt.setString(8, column.getContainer().getName());
            stmt.setString(9, column.getName());
            stmt.setInt(10, seq);
            stmt.setString(11, idx.getColumnSortOrder(column));
            stmt.setString(12, (String)map.get(design.getObjectID()));
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

