/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Measurement;
import oracle.dbtools.crest.swingui.ProgressDialog;

public class RSMeasurements
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, ProgressDialog monitor) throws Exception {
        ArrayList<Measurement> list = new ArrayList<Measurement>(1000);
        int count = 0;
        String designOVID = (String)map.get(design.getObjectID());
        String query = "INSERT INTO DMRS_MEASUREMENTS (Design_ID, Design_OVID, Design_Name, Model_OVID, Model_Name, Measurement_ID, Measurement_OVID, Measurement_Name, Measurement_Value, Measurement_Unit, Measurement_Type, Measurement_CR_Date, Measurement_EF_Date, Object_Name, Object_Type, Object_Model)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (DesignPart dp : design.getStorableDesignParts()) {
            List owm = dp.getObjectsWithMeasurements();
            if (owm.size() <= 0) continue;
            for (DesignObject desObject : owm) {
                for (Measurement measurement2 : desObject.getMeasurements()) {
                    String ovid = RSMeasurements.getOrCreateOVID(map, measurement2.getObjectID());
                    stmt.setString(1, design.getObjectID());
                    stmt.setString(2, designOVID);
                    stmt.setString(3, design.getName());
                    stmt.setString(4, measurement2.getDesignPart().getObjectID());
                    stmt.setString(5, measurement2.getDesignPart().getName());
                    stmt.setString(6, measurement2.getObjectID());
                    stmt.setString(7, ovid);
                    stmt.setString(8, measurement2.getName());
                    stmt.setString(9, measurement2.getValue());
                    stmt.setString(10, measurement2.getUnit());
                    stmt.setString(11, measurement2.getType());
                    stmt.setString(12, measurement2.getCreationDate());
                    stmt.setString(13, measurement2.getEffectiveDate());
                    stmt.setString(14, desObject.getName());
                    stmt.setString(15, desObject.getObjectTypeName());
                    stmt.setString(16, desObject.getDesignPart().getName());
                    stmt.addBatch();
                    list.add(measurement2);
                    if (++count != 1000) continue;
                    count = 0;
                    stmt.executeBatch();
                    for (Measurement measurement2 : list) {
                        RSObjectNotes.export(map, connection, measurement2);
                        RSComments.export(map, connection, measurement2);
                    }
                    list.clear();
                }
            }
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Measurement measurement : list) {
                RSObjectNotes.export(map, connection, measurement);
                RSComments.export(map, connection, measurement);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }
}

