/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;

public class RSMeasures
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Measure> list = new ArrayList<Measure>(1000);
        int count = 0;
        int count1 = 0;
        ArrayList<MeasureFolder> list1 = new ArrayList<MeasureFolder>(1000);
        ArrayList<Measure> measuresCollection = new ArrayList<Measure>();
        ArrayList<MeasureFolder> foldersCollection = new ArrayList<MeasureFolder>();
        String query = "INSERT INTO DMRS_MEASURES (Measure_ID, Measure_Name, Measure_OVID, Model_ID, Model_Name, Model_OVID, Cube_ID, Cube_Name, Cube_OVID, Fact_Object_ID, Fact_Object_Name, Fact_Object_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Fact_Object_Type, Additivity_Type, Is_Fact_Dimension, Is_Formula, Is_Custom_Formula, Formula, Where_Clause, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        String fQuery = "INSERT INTO DMRS_MEASURE_FOLDERS (Measure_Folder_ID, Measure_Folder_Name, Measure_Folder_OVID, Model_ID, Model_Name, Model_OVID, Parent_Folder_ID, Parent_Folder_Name, Parent_Folder_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Leaf, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement fStmt = connection.prepareStatement(fQuery);
        for (MultidimensionalDesign model : design.getMultidimensionalDesigns()) {
            String modelOVID = (String)map.get(model.getObjectID());
            String designOVID = (String)map.get(model.getDesign().getObjectID());
            measuresCollection.clear();
            foldersCollection.clear();
            Iterator it = model.getMeasureSet().iterator();
            while (it.hasNext()) {
                Measure meas2 = (Measure)it.next();
                String measOVID = RSMeasures.getOrCreateOVID(map, meas2.getObjectID());
                measuresCollection.add(meas2);
                Cube cube = meas2.getCube();
                ContainedObject factObj = meas2.getMeasureFact();
                stmt.setString(1, meas2.getObjectID());
                stmt.setString(2, meas2.getName());
                stmt.setString(3, measOVID);
                stmt.setString(4, model.getObjectID());
                stmt.setString(5, model.getName());
                stmt.setString(6, modelOVID);
                if (cube != null) {
                    stmt.setString(7, cube.getObjectID());
                    stmt.setString(8, cube.getName());
                    stmt.setString(9, RSMeasures.getOrCreateOVID(map, cube.getObjectID()));
                } else {
                    stmt.setString(7, null);
                    stmt.setString(8, null);
                    stmt.setString(9, null);
                }
                if (factObj != null) {
                    stmt.setString(10, factObj.getObjectID());
                    stmt.setString(11, factObj.getName());
                    stmt.setString(12, RSMeasures.getOrCreateOVID(map, factObj.getObjectID()));
                    stmt.setString(16, factObj.getObjectTypeName());
                } else {
                    stmt.setString(10, null);
                    stmt.setString(11, null);
                    stmt.setString(12, null);
                    stmt.setString(16, null);
                }
                stmt.setString(13, meas2.getOracleLongName());
                stmt.setString(14, meas2.getOraclePluralName());
                stmt.setString(15, meas2.getOracleShortName());
                stmt.setString(17, meas2.getAdditivity());
                stmt.setString(18, meas2.isFactDimension() ? "Y" : "N");
                stmt.setString(19, meas2.isFormula() ? "Y" : "N");
                stmt.setString(20, meas2.isCustomFormula() ? "Y" : "N");
                stmt.setString(21, meas2.getFormula());
                stmt.setString(22, meas2.getWhereClause());
                stmt.setString(23, meas2.getDescription());
                stmt.setString(24, designOVID);
                stmt.addBatch();
                list.add(meas2);
                if (++count != 1000) continue;
                count = 0;
                stmt.executeBatch();
                for (Measure meas2 : list) {
                    RSObjectNotes.export(map, connection, meas2);
                    RSComments.export(map, connection, meas2);
                    RSDynamicProperties.export(design, map, connection, meas2);
                }
                list.clear();
            }
            RSMeasures.exportAggregateFunctions(map, connection, measuresCollection, designOVID);
            Iterator fit = model.getMeasureFolderSet().iterator();
            while (fit.hasNext()) {
                MeasureFolder fold2 = (MeasureFolder)fit.next();
                String foldOVID = RSMeasures.getOrCreateOVID(map, fold2.getObjectID());
                foldersCollection.add(fold2);
                MeasureFolder parFold = fold2.getParentFolder();
                fStmt.setString(1, fold2.getObjectID());
                fStmt.setString(2, fold2.getName());
                fStmt.setString(3, foldOVID);
                fStmt.setString(4, model.getObjectID());
                fStmt.setString(5, model.getName());
                fStmt.setString(6, modelOVID);
                if (parFold != null) {
                    fStmt.setString(7, parFold.getObjectID());
                    fStmt.setString(8, parFold.getName());
                    fStmt.setString(9, RSMeasures.getOrCreateOVID(map, parFold.getObjectID()));
                } else {
                    fStmt.setString(7, null);
                    fStmt.setString(8, null);
                    fStmt.setString(9, null);
                }
                fStmt.setString(10, fold2.getOracleLongName());
                fStmt.setString(11, fold2.getOraclePluralName());
                fStmt.setString(12, fold2.getOracleShortName());
                fStmt.setString(13, fold2.isLeaf() ? "Y" : "N");
                fStmt.setString(14, fold2.getDescription());
                fStmt.setString(15, designOVID);
                fStmt.addBatch();
                list1.add(fold2);
                if (++count1 != 1000) continue;
                count1 = 0;
                fStmt.executeBatch();
                for (MeasureFolder fold2 : list1) {
                    RSObjectNotes.export(map, connection, fold2);
                    RSComments.export(map, connection, fold2);
                    RSDynamicProperties.export(design, map, connection, fold2);
                }
                list1.clear();
            }
            RSMeasures.exportMeasuresInFolders(map, connection, foldersCollection, designOVID);
        }
        if (count1 > 0) {
            count1 = 0;
            fStmt.executeBatch();
            for (MeasureFolder fold : list1) {
                RSObjectNotes.export(map, connection, fold);
                RSComments.export(map, connection, fold);
                RSDynamicProperties.export(design, map, connection, fold);
            }
            list1.clear();
        }
        fStmt.close();
        fStmt = null;
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
            for (Measure meas : list) {
                RSObjectNotes.export(map, connection, meas);
                RSComments.export(map, connection, meas);
                RSDynamicProperties.export(design, map, connection, meas);
            }
            list.clear();
        }
        stmt.close();
        stmt = null;
    }

    private static void exportAggregateFunctions(Map map, Connection connection, List measures, String designOVID) throws Exception {
        int count1 = 0;
        int count2 = 0;
        String funQuery = "INSERT INTO DMRS_MEASURE_AGGR_FUNCS (Measure_ID, Measure_Name, Measure_OVID, Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Measure_Alias, Is_Default, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement funStmt = connection.prepareStatement(funQuery);
        String dimQuery = "INSERT INTO DMRS_AGGR_FUNC_DIMENSIONS (Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement dimStmt = connection.prepareStatement(dimQuery);
        String levQuery = "INSERT INTO DMRS_AGGR_FUNC_LEVELS (Aggregate_Function_ID, Aggregate_Function_Name, Aggregate_Function_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement levStmt = connection.prepareStatement(levQuery);
        for (Measure meas : measures) {
            String defID = meas.getDefaultAggregationFunction().getObjectID();
            for (Measure.AggregateFunction fun : meas.getAggregateFunctions()) {
                String funOVID = RSMeasures.getOrCreateOVID(map, fun.getObjectID());
                funStmt.setString(1, meas.getObjectID());
                funStmt.setString(2, meas.getName());
                funStmt.setString(3, (String)map.get(meas.getObjectID()));
                funStmt.setString(4, fun.getObjectID());
                funStmt.setString(5, fun.getName());
                funStmt.setString(6, funOVID);
                funStmt.setString(7, fun.getMeasureAlias());
                funStmt.setString(8, defID.equals(fun.getObjectID()) ? "Y" : "N");
                funStmt.setString(9, designOVID);
                funStmt.executeUpdate();
                for (Dimension dim : fun.getDimensions()) {
                    String dimOVID = RSMeasures.getOrCreateOVID(map, dim.getObjectID());
                    dimStmt.setString(1, fun.getObjectID());
                    dimStmt.setString(2, fun.getName());
                    dimStmt.setString(3, funOVID);
                    dimStmt.setString(4, dim.getObjectID());
                    dimStmt.setString(5, dim.getName());
                    dimStmt.setString(6, dimOVID);
                    dimStmt.setString(7, designOVID);
                    dimStmt.addBatch();
                    if (++count1 != 1000) continue;
                    count1 = 0;
                    dimStmt.executeBatch();
                }
                for (Level lev : fun.getLevels()) {
                    String levOVID = RSMeasures.getOrCreateOVID(map, lev.getObjectID());
                    levStmt.setString(1, fun.getObjectID());
                    levStmt.setString(2, fun.getName());
                    levStmt.setString(3, funOVID);
                    levStmt.setString(4, lev.getObjectID());
                    levStmt.setString(5, lev.getName());
                    levStmt.setString(6, levOVID);
                    levStmt.setString(7, designOVID);
                    levStmt.addBatch();
                    if (++count2 != 1000) continue;
                    count2 = 0;
                    levStmt.executeBatch();
                }
            }
        }
        if (count2 > 0) {
            count2 = 0;
            levStmt.executeBatch();
        }
        levStmt.close();
        levStmt = null;
        if (count1 > 0) {
            count1 = 0;
            dimStmt.executeBatch();
        }
        dimStmt.close();
        dimStmt = null;
        funStmt.close();
        funStmt = null;
    }

    private static void exportMeasuresInFolders(Map map, Connection connection, List folders, String designOVID) throws Exception {
        int count = 0;
        String fmQuery = "INSERT INTO DMRS_MEASURE_FOLDER_MEASURES (Measure_Folder_ID, Measure_Folder_Name, Measure_Folder_OVID, Measure_ID, Measure_Name, Measure_OVID, Parent_Object_ID, Parent_Object_Name, Parent_Object_OVID, Parent_Object_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement fmStmt = connection.prepareStatement(fmQuery);
        for (MeasureFolder fold : folders) {
            for (MeasureFolder.MFElement fmElem : fold.getMeasures()) {
                Object fmObj = fmElem.getMeasure();
                if (fmObj == null) continue;
                Measure fm = null;
                if (fmElem.isMeasureWrapper()) {
                    fm = ((Slice.MeasureWrapper)fmObj).getMeasure();
                } else if (fmObj instanceof Measure) {
                    fm = (Measure)fmObj;
                }
                if (fm == null) continue;
                String fmOVID = RSMeasures.getOrCreateOVID(map, fm.getObjectID());
                DesignObject fmParObj = fmElem.getParent();
                fmStmt.setString(1, fold.getObjectID());
                fmStmt.setString(2, fold.getName());
                fmStmt.setString(3, (String)map.get(fold.getObjectID()));
                fmStmt.setString(4, fm.getObjectID());
                fmStmt.setString(5, fm.getName());
                fmStmt.setString(6, fmOVID);
                if (fmParObj != null) {
                    fmStmt.setString(7, fmParObj.getObjectID());
                    fmStmt.setString(8, fmParObj.getName());
                    fmStmt.setString(9, RSMeasures.getOrCreateOVID(map, fmParObj.getObjectID()));
                    fmStmt.setString(10, fmParObj.getObjectTypeName());
                } else {
                    fmStmt.setString(7, null);
                    fmStmt.setString(8, null);
                    fmStmt.setString(9, null);
                    fmStmt.setString(10, null);
                }
                fmStmt.setString(11, designOVID);
                fmStmt.addBatch();
                if (++count != 1000) continue;
                count = 0;
                fmStmt.executeBatch();
            }
        }
        if (count > 0) {
            count = 0;
            fmStmt.executeBatch();
        }
        fmStmt.close();
        fmStmt = null;
    }
}

