/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.swingui.ApplicationView;

public class RSSensitiveTypes
extends RSGeneral {
    public static void export(ApplicationView appView, Map map, Connection connection) throws Exception {
        String checkQuery = "SELECT Object_OVID FROM DMRS_SENSITIVE_TYPES WHERE Object_ID = ? ";
        String insertQuery = "INSERT INTO DMRS_SENSITIVE_TYPES (Object_OVID, Object_ID, Sensitive_Type_Name) VALUES (?, ?, ?)";
        String updateQuery = "UPDATE DMRS_SENSITIVE_TYPES SET Sensitive_Type_Name = ? WHERE Object_ID = ?";
        PreparedStatement stmtCheck = connection.prepareStatement(checkQuery);
        PreparedStatement insertStmt = connection.prepareStatement(insertQuery);
        PreparedStatement updateStmt = connection.prepareStatement(updateQuery);
        for (SensitiveType st : appView.getSensitiveTypeSet()) {
            stmtCheck.setString(1, st.getObjectID());
            ResultSet rsCheck = stmtCheck.executeQuery();
            if (rsCheck.next()) {
                String checkOvid = rsCheck.getString(1);
                map.put(st.getObjectID(), checkOvid);
                updateStmt.setString(1, st.getName());
                updateStmt.setString(2, st.getObjectID());
                updateStmt.executeUpdate();
            } else {
                String ovid = RSSensitiveTypes.getOrCreateOVID(map, st.getObjectID());
                map.put(st.getObjectID(), ovid);
                insertStmt.setString(1, ovid);
                insertStmt.setString(2, st.getObjectID());
                insertStmt.setString(3, st.getName());
                insertStmt.executeUpdate();
            }
            RSObjectNotes.export(map, connection, st);
            RSComments.export(map, connection, st);
            RSCommentsInRDBMS.export(map, connection, st);
        }
        stmtCheck.close();
        stmtCheck = null;
        insertStmt.close();
        insertStmt = null;
        updateStmt.close();
        updateStmt = null;
    }
}

