/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.plSqlSourceEditors;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.ide.model.TextNode;

public class PlSqlNode
extends TextNode {
    protected PlSqlSourceStorageObjectOracle sourceObject;

    public PlSqlSourceStorageObjectOracle getSourceObject() {
        return this.sourceObject;
    }

    public void setSourceObject(PlSqlSourceStorageObjectOracle sourceObject) {
        this.sourceObject = sourceObject;
    }

    public void save(String sourceText) throws IOException {
        this.sourceObject.setSource(sourceText);
        this.sourceObject.setDirty(true);
        this.markDirty(false);
    }

    protected void saveImpl() throws IOException {
        StringWriter writer = new StringWriter();
        this.acquireTextBufferOrThrow().write((Writer)writer);
        String source = writer.toString().trim();
        this.sourceObject.setSource(source);
        this.sourceObject.setDirty(true);
        this.markDirty(false);
    }

    protected void markDirtyImpl(boolean dirty) {
        super.markDirtyImpl(dirty);
        if (dirty) {
            this.sourceObject.setDirty(dirty);
        }
    }

    public String getLongLabel() {
        return this.sourceObject != null ? this.sourceObject.getLongName() : null;
    }

    public String getShortLabel() {
        return this.sourceObject != null ? this.sourceObject.getName() : null;
    }
}

