/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.UserDefinedPreferencesPreferences;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.UserDefinedPreference;
import oracle.dbtools.crest.util.Messages;
import oracle.ide.panels.TraversableContext;

public class UserDefinedPreferencesPP
extends AbstractPP {
    public static final String TYPE_NAME = "UserDefinedPreference";
    private List<UserDefinedPreference> udpList;
    private int cgCounter = 0;
    private JTable udpTable;
    private UDPModel udpModel;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();

    public UserDefinedPreferencesPP() {
        this.setHelpID("USER_DEFINED_PREFERENCES_PANEL");
        this.initControls();
    }

    private void initControls() {
        JButton btnAdd = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        final JButton btnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        btnRemove.setEnabled(false);
        this.udpList = new ArrayList<UserDefinedPreference>();
        this.udpModel = new UDPModel();
        this.udpTable = new JTable(this.udpModel){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                if (this.editCellAt(row, column)) {
                    Component editor = this.getEditorComponent();
                    editor.requestFocusInWindow();
                }
            }
        };
        this.udpTable.setSelectionMode(0);
        this.udpTable.getTableHeader().setReorderingAllowed(false);
        this.udpTable.setCellSelectionEnabled(true);
        ListSelectionModel cellSelectionModel = this.udpTable.getSelectionModel();
        cellSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selectedData = null;
                int[] selectedRow = UserDefinedPreferencesPP.this.udpTable.getSelectedRows();
                int[] selectedColumns = UserDefinedPreferencesPP.this.udpTable.getSelectedColumns();
                for (int i = 0; i < selectedRow.length; ++i) {
                    for (int j = 0; j < selectedColumns.length; ++j) {
                        selectedData = (String)UserDefinedPreferencesPP.this.udpTable.getValueAt(selectedRow[i], selectedColumns[j]);
                        if (selectedData != null) {
                            btnRemove.setEnabled(true);
                            continue;
                        }
                        btnRemove.setEnabled(false);
                    }
                }
            }
        });
        btnAdd.setToolTipText(Messages.getString("UserDefinedPreferencesPP.Add"));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UserDefinedPreferencesPP.this.udpTable.getRowSorter() != null) {
                    UserDefinedPreferencesPP.this.udpTable.getRowSorter().setSortKeys(null);
                }
                UserDefinedPreferencesPP.this.createAndAddUDPreference(UserDefinedPreferencesPP.this.generateUDPName(), "");
                if (UserDefinedPreferencesPP.this.udpList.size() == 1) {
                    UserDefinedPreferencesPP.this.initUDPTableSorter();
                }
                WindowsTableHeader.setSortedHeader(UserDefinedPreferencesPP.this.udpTable, 0);
                int lastRow = UserDefinedPreferencesPP.this.udpTable.convertRowIndexToView(UserDefinedPreferencesPP.this.udpList.size() - 1);
                UserDefinedPreferencesPP.this.udpTable.setRowSelectionInterval(lastRow, lastRow);
                UserDefinedPreferencesPP.this.udpTable.updateUI();
            }
        });
        btnRemove.setToolTipText(Messages.getString("UserDefinedPreferencesPP.Remove"));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDefinedPreferencesPP.stopCellEditing(UserDefinedPreferencesPP.this.udpTable);
                int objectNumber = UserDefinedPreferencesPP.this.udpTable.convertRowIndexToModel(UserDefinedPreferencesPP.this.udpTable.getSelectedRow());
                if (objectNumber != -1) {
                    UserDefinedPreferencesPP.this.udpList.remove(objectNumber);
                    if (UserDefinedPreferencesPP.this.udpTable.getRowSorter() != null) {
                        if (UserDefinedPreferencesPP.this.udpList.size() >= 1) {
                            UserDefinedPreferencesPP.this.udpTable.getRowSorter().setSortKeys(null);
                        } else {
                            UserDefinedPreferencesPP.this.udpTable.setAutoCreateRowSorter(false);
                            UserDefinedPreferencesPP.this.udpTable.setRowSorter(null);
                        }
                    }
                    UserDefinedPreferencesPP.this.udpTable.updateUI();
                }
                if (UserDefinedPreferencesPP.this.udpList.size() >= 1) {
                    WindowsTableHeader.setSortedHeader(UserDefinedPreferencesPP.this.udpTable, 0);
                }
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnAdd);
        toolBar.add(btnRemove);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserDefinedPreferencesPP.UserDefinedPreferences")));
        mainPanel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)new JScrollPane(this.udpTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
        this.add(mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, -1));
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    protected String generateUDPName() {
        String name = TYPE_NAME;
        int newNumber = 0;
        int lastNumber = this.udpList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String dpName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExists(dpName)) {
            newNumber = ++this.cgCounter;
            dpName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return dpName;
    }

    private boolean nameExists(String name) {
        for (int i = 0; i < this.udpList.size(); ++i) {
            UserDefinedPreference dp = this.udpList.get(i);
            if (!name.equalsIgnoreCase(dp.getName())) continue;
            return true;
        }
        return false;
    }

    private UserDefinedPreference createAndAddUDPreference(String name, String value) {
        UserDefinedPreference dp = new UserDefinedPreference("", "");
        dp.setName(name);
        dp.setValue(value);
        this.udpList.add(dp);
        return dp;
    }

    private void initUDPTableSorter() {
        if (this.udpList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.udpTable.getModel());
            sorter.setSortsOnUpdates(true);
            this.udpTable.setRowSorter(sorter);
            this.udpTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.udpTable, 0);
        }
    }

    public void onEntry(TraversableContext tc) {
        this.udpList.clear();
        TreeMap<String, String> udpMap = settings.getUserDefinedPreferences();
        Set<Map.Entry<String, String>> set = udpMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            this.udpList.add(new UserDefinedPreference(entry.getKey(), entry.getValue()));
        }
        this.initUDPTableSorter();
        this.udpTable.updateUI();
    }

    public void onExit(TraversableContext tc) {
        UserDefinedPreferencesPP.stopCellEditing(this.udpTable);
        TreeMap<String, String> udpMap = settings.getUserDefinedPreferences();
        udpMap.clear();
        UserDefinedPreferencesPreferences preferences = this.getUserDefinedPreferencesPreferences(tc);
        for (UserDefinedPreference p : this.udpList) {
            udpMap.put(p.getName(), p.getValue());
        }
        preferences.setUserDefinedPreferences(this.udpList);
    }

    private UserDefinedPreferencesPreferences getUserDefinedPreferencesPreferences(TraversableContext tc) {
        return UserDefinedPreferencesPreferences.getInstance(tc.getPropertyStorage());
    }

    private class UDPModel
    extends AbstractTableModel {
        private UDPModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return UserDefinedPreferencesPP.this.udpList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("UserDefinedPreferencesPP.Name");
            }
            return Messages.getString("UserDefinedPreferencesPP.Value");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            UserDefinedPreference object = (UserDefinedPreference)UserDefinedPreferencesPP.this.udpList.get(row);
            if (col == 0) {
                return object.getName();
            }
            if (col == 1) {
                return object.getValue();
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            UserDefinedPreference dp = (UserDefinedPreference)UserDefinedPreferencesPP.this.udpList.get(rowIndex);
            if (columnIndex == 0) {
                dp.setName(obj.toString());
            } else if (columnIndex == 1) {
                dp.setValue(obj.toString());
            }
        }
    }
}

