/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.v80.SequenceDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSequenceDB2v80
extends DDLStatementHandler {
    private String userName;
    private String line;
    private static final Logger LOGGER = new Logger(SHCreateSequenceDB2v80.class);

    public SHCreateSequenceDB2v80(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateSequenceDB2v80.clearCR(line);
        this.line = line;
        if (Token.startsWithString(statement, "create sequence")) {
            this.parseSequence(statement.replaceAll("\"", ""));
        } else {
            this.nextHandler(line);
        }
    }

    public void parseSequence(String statement) {
        SequenceDB2v80 sequence;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignDB2v80 stoDesign = (StorageDesignDB2v80)this.design.getStorageDesign(site);
        if (stoDesign != null && (sequence = (SequenceDB2v80)stoDesign.getSequenceSet().createSequence()) != null) {
            try {
                this.initName(sequence);
                this.initOwner(sequence, stoDesign);
                this.initDataType(sequence);
                this.initStartWith(sequence);
                this.initIncrementBy(sequence);
                this.initMaxValue(sequence);
                this.initMinValue(sequence);
                this.initCycle(sequence);
                this.initCache(sequence);
                this.initOrder(sequence);
                this.design.getRelationalDesign().stampModelObjectDDL(sequence);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for DB2 8.0 failed!", e);
                this.importLog.addFailedStatement(SHCreateSequenceDB2v80.FormatCR(this.line, "\n"));
            }
        }
    }

    private void initName(SequenceDB2v80 sequence) {
        String name = Token.getTokenAfter(this.statement, "SEQUENCE").trim();
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            this.userName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "SEQUENCE"), '.');
            name = Token.getValAfterCharacter(Token.getTokenAfter(this.statement, "SEQUENCE"), '.');
        }
        sequence.setName(name);
    }

    private void initOwner(SequenceDB2v80 sequence, StorageDesignDB2v80 storageDesign) {
        if (this.userName != null) {
            Owner owner = (Owner)storageDesign.getOwnerSet().getByName(this.userName);
            if (owner == null) {
                owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                owner.setName(this.userName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            sequence.setOwner(owner);
        } else {
            sequence.setOwner(storageDesign.getOwnerSet().getDefaultOwner());
        }
    }

    private void initDataType(SequenceDB2v80 sequence) throws ParseException {
        if (!Token.hasString(this.statement, "AS")) {
            throw new ParseException("wrong format in SHCreateSequenceDB2v80.initDataType : ");
        }
        String datatype = Token.getTokenAfter(this.statement, "AS").trim();
        sequence.setDatatype(datatype);
    }

    private void initStartWith(SequenceDB2v80 sequence) throws ParseException {
        if (Token.hasString(this.statement, "START")) {
            String str = Token.getTokenAfter(this.statement, "WITH").trim();
            try {
                int value = Integer.parseInt(str);
                sequence.setStartWith(value);
            }
            catch (NumberFormatException e) {
                throw new ParseException("wrong format in SHCreateSequenceDB2v80.initStartWith : " + e.getMessage());
            }
        } else {
            throw new ParseException("wrong format in SHCreateSequenceDB2v80.initStartWith : ");
        }
    }

    private void initIncrementBy(SequenceDB2v80 sequence) {
        if (Token.hasToken(this.statement, "BY")) {
            String str = Token.getTokenAfter(this.statement, "BY").trim();
            try {
                int value = Integer.parseInt(str);
                sequence.setIncrementBy(value);
            }
            catch (NumberFormatException e) {
                LOGGER.error("wrong format in SHCreateSequenceDB2v80.initIncrementBy : " + e.getMessage());
            }
        }
    }

    private void initMaxValue(SequenceDB2v80 sequence) {
        if (Token.hasToken(this.statement, "MAXVALUE")) {
            if (!Token.getTokenBefore(this.statement, "MAXVALUE").equalsIgnoreCase("NO")) {
                String str = Token.getTokenAfter(this.statement, "MAXVALUE").trim();
                try {
                    Integer.parseInt(str);
                    sequence.setMaxValue(str);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateSequenceOracle.initMaxValue : " + e.getMessage());
                }
            } else {
                sequence.setMaxValue("NO");
            }
        } else {
            sequence.setMaxValue("NO");
        }
    }

    private void initMinValue(SequenceDB2v80 sequence) {
        if (Token.hasToken(this.statement, "MINVALUE")) {
            if (!Token.getTokenBefore(this.statement, "MINVALUE").equalsIgnoreCase("NO")) {
                String str = Token.getTokenAfter(this.statement, "MINVALUE").trim();
                try {
                    Integer.parseInt(str);
                    sequence.setMinValue(str);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateSequenceDB2v80.initMinValue : " + e.getMessage());
                }
            } else {
                sequence.setMinValue("NO");
            }
        } else {
            sequence.setMinValue("NO");
        }
    }

    private void initCycle(SequenceDB2v80 sequence) {
        if (Token.hasToken(this.statement, "CYCLE")) {
            if (!Token.getTokenBefore(this.statement, "CYCLE").equalsIgnoreCase("NO")) {
                sequence.setCycle("YES");
            } else {
                sequence.setCycle("NO");
            }
        } else {
            sequence.setCycle("NO");
        }
    }

    private void initCache(SequenceDB2v80 sequence) {
        if (Token.hasToken(this.statement, "CACHE")) {
            if (!Token.getTokenBefore(this.statement, "CACHE").equalsIgnoreCase("NO")) {
                String str = Token.getTokenAfter(this.statement, "CACHE").trim();
                try {
                    int value = Integer.parseInt(str);
                    sequence.setCache(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("wrong format in SHCreateSequenceDB2v80.initCache : " + e.getMessage());
                }
            } else {
                sequence.setCache(0);
            }
        } else {
            sequence.setCache(0);
        }
    }

    private void initOrder(SequenceDB2v80 sequence) {
        if (Token.hasToken(this.statement, "ORDER")) {
            if (!Token.getTokenBefore(this.statement, "ORDER").equalsIgnoreCase("NO")) {
                sequence.setOrder("YES");
            } else {
                sequence.setOrder("NO");
            }
        } else {
            sequence.setOrder("NO");
        }
    }
}

