/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2.v80;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHProcedureDB2v80
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PROCEDURE";
    private static final Logger LOGGER = new Logger(MOHProcedureDB2v80.class);

    public MOHProcedureDB2v80(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            StorageDesign storageDesign;
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String ownerName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT s.CREATESTMT ");
                buffer.append("from SYSIBM.SYSROUTINES r, SYSIBM.SYSROUTINES_SRC s ");
                buffer.append("WHERE r.NAME = '").append(name).append("'");
                buffer.append(" AND r.SCHEMA = '").append(ownerName).append("'");
                buffer.append(" AND r.ROUTINETYPE = 'P'");
                buffer.append(" AND r.NAME = s.ROUTINENAME");
                buffer.append(" AND r.LANGUAGE = 'SQL'");
                buffer.append(" AND r.SCHEMA = s.SCHEMA");
                buffer.append(" ORDER BY s.SEQNO ");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHProcedureDB2v80.generate():", e);
            }
            StringBuffer bodyBuffer = new StringBuffer();
            if (rs != null) {
                while (rs.next()) {
                    String body = rs.getString(1);
                    bodyBuffer.append(body.toString());
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if ((storageDesign = this.getStorageDesign()) != null && storageDesign instanceof AbstractStorageDesignDB2) {
                AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                StoredProcedureDB2 proc = storage.getStoredProcedureSet().createStoredProcedure();
                proc.setName(name);
                proc.setBody(bodyBuffer.toString());
                this.stampModelObject(proc, dbo);
                Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                if (owner != null) {
                    proc.setOwner(owner);
                } else {
                    owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                    owner.setName(ownerName);
                    this.stampModelObject((ModelObject)owner, "", ownerName);
                }
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT NAME from SYSIBM.SYSROUTINES ");
                buffer.append("WHERE SCHEMA = '");
                buffer.append(dboNext.getName()).append("'");
                buffer.append(" AND LANGUAGE = 'SQL'");
                buffer.append(" AND ROUTINETYPE = 'P'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHProcedureDB2v80.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), name, OBJECT_TYPE, dboNext.getName());
                    list.add(dbo);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

