/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTypeIncompleteOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "OBJECT";
    private Map selectedTypes;
    private Map allTypes;
    private static List types;
    private static final Logger LOGGER;
    protected boolean dbaUser;
    PreparedStatement supert_statement = null;
    PreparedStatement attr_statement = null;
    PreparedStatement par_statement = null;
    PreparedStatement result_statement = null;
    PreparedStatement elem_statement = null;

    public MOHTypeIncompleteOraclev9i(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHTypeIncompleteOraclev9i(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract TypeIncomplete begin");
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (this.allTypes == null) {
            this.allTypes = new TreeMap();
        } else {
            this.allTypes.clear();
        }
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            String schemaName = dboNext.getName();
            if (statement == null) {
                String filterCondition = this.getFilterConditionOracle("TYPE_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("TYPE_NAME").append(',');
                buffer.append("TYPECODE").append(',');
                buffer.append("SUPERTYPE_OWNER").append(',');
                buffer.append("SUPERTYPE_NAME").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_TYPES : ALL_TYPES).append(' ');
                buffer.append("WHERE").append(' ').append("PREDEFINED").append('=');
                buffer.append('\'').append("NO").append('\'').append(' ');
                buffer.append("AND").append(' ').append("OWNER").append('=').append('?').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                DBObject dboDim;
                String dimName = rs.getString("TYPE_NAME");
                String typeCode = rs.getString("TYPECODE");
                String superTypeOwner = rs.getString("SUPERTYPE_OWNER");
                String superTypeName = rs.getString("SUPERTYPE_NAME");
                if (typeCode.equalsIgnoreCase("COLLECTION")) {
                    dboDim = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dimName, "COLLECTION", schemaName);
                    list.add(dboDim);
                    CollectionType ct = (CollectionType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(dimName);
                    if (ct == null || schemaName.equals(ct.getSourceObjSchema()) && dimName.equals(ct.getSourceObjName())) continue;
                    dboDim.setStatus(DBObject.NAME_EXIST);
                    dboDim.setSelected(false);
                    continue;
                }
                dboDim = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dimName, OBJECT_TYPE, schemaName);
                dboDim.setSuperTypeOwner(superTypeOwner);
                dboDim.setSuperTypeName(superTypeName);
                StructuredType st = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(dimName);
                if (!(st == null || schemaName.equals(st.getSourceObjSchema()) && dimName.equals(st.getSourceObjName()))) {
                    dboDim.setStatus(DBObject.NAME_EXIST);
                    dboDim.setSelected(false);
                }
                list.add(dboDim);
                this.allTypes.put(dboDim.toString(), dboDim);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("Extract TypeIncomplete end");
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Object temp;
        String key;
        DBObject dbo;
        int i;
        TimeLog.log("Type Incomplete begin");
        this.supert_statement = null;
        this.attr_statement = null;
        this.par_statement = null;
        this.result_statement = null;
        this.elem_statement = null;
        StorageDesign storageDesign = this.getStorageDesign();
        StorageDesignOracle storageOracle = null;
        TreeMap additionalTypes = new TreeMap();
        this.selectedTypes = new TreeMap();
        if (types == null) {
            types = new ArrayList();
        } else {
            types.clear();
        }
        if (this.allTypes == null) {
            this.allTypes = new TreeMap();
        }
        ArrayList<DBObject> tab_view_types = new ArrayList<DBObject>();
        for (i = 0; i < selectedObjects.size(); ++i) {
            dbo = (DBObject)selectedObjects.get(i);
            if (OBJECT_TYPE.equalsIgnoreCase(dbo.getType()) || "COLLECTION".equalsIgnoreCase(dbo.getType())) {
                String key2 = dbo.toString();
                DBObject existingDBO = (DBObject)this.selectedTypes.get(key2);
                if (existingDBO != null) {
                    types.remove(existingDBO);
                }
                types.add(dbo);
                this.selectedTypes.put(key2, dbo);
            }
            if (!"TABLE".equalsIgnoreCase(dbo.getType()) && !"VIEW".equalsIgnoreCase(dbo.getType())) continue;
            if ("XMLTYPE".equalsIgnoreCase(dbo.getTypeName())) {
                dbo.setTypeCode(OBJECT_TYPE);
            } else if (dbo.getTypeName() != null && dbo.getTypeOwner() != null) {
                DBObject dbot = new DBObject(true, dbo.getTypeName(), OBJECT_TYPE, dbo.getTypeOwner());
                dbot.setTypeCode(OBJECT_TYPE);
                key = dbot.toString();
                if (!this.selectedTypes.containsKey(key)) {
                    temp = this.allTypes.get(key);
                    if (temp != null) {
                        dbot = (DBObject)temp;
                    }
                    types.add(dbot);
                    this.selectedTypes.put(key, dbot);
                }
            }
            if (!this.getDbmeHandler().isStructuredTypesScan()) continue;
            if ("TABLE".equalsIgnoreCase(dbo.getType()) || "VIEW".equalsIgnoreCase(dbo.getType())) {
                this.addAdditionalType(additionalTypes, dbo);
            }
            if (dbo.getTypeCode() == null || !OBJECT_TYPE.equalsIgnoreCase(dbo.getTypeCode()) && !"XMLTYPE".equalsIgnoreCase(dbo.getTypeCode()) && !"COLLECTION".equalsIgnoreCase(dbo.getTypeCode())) continue;
            tab_view_types.add(dbo);
        }
        TimeLog.log("Step 1 end");
        if (this.getDbmeHandler().isStructuredTypesScan()) {
            this.generateAdditionalColumnTypes(sqlConnection, additionalTypes);
            TimeLog.log("Step 2 end");
        }
        for (i = 0; i < tab_view_types.size(); ++i) {
            DBObject dbotv = (DBObject)tab_view_types.get(i);
            DBObject dbo2 = new DBObject(true, dbotv.getTypeName(), dbotv.getTypeCode(), dbotv.getTypeOwner());
            dbo2.setSuperTypeOwner(dbotv.getSuperTypeOwner());
            dbo2.setSuperTypeName(dbotv.getSuperTypeName());
            key = dbo2.toString();
            if (this.selectedTypes.containsKey(key)) continue;
            temp = this.allTypes.get(key);
            if (temp != null) {
                dbo2 = (DBObject)temp;
            }
            types.add(dbo2);
            this.selectedTypes.put(key, dbo2);
        }
        if (this.getDbmeHandler().isStructuredTypesScan()) {
            List notprocessed = this.getNotProcessed1000(types, OBJECT_TYPE);
            if (notprocessed.size() == 0) {
                notprocessed = this.getNotProcessed1000(types, "COLLECTION");
            }
            TreeMap map = new TreeMap();
            while (notprocessed.size() > 0) {
                map.clear();
                this.addAdditionalTypes(map, notprocessed, OBJECT_TYPE, true);
                if (!map.isEmpty()) {
                    TimeLog.log("Struct_types begin " + notprocessed.size());
                    this.addSuperTypesMulti(map, sqlConnection, notprocessed);
                    TimeLog.log(" Super types END ");
                    map.clear();
                    this.addAdditionalTypesWithAttributes(map, notprocessed, OBJECT_TYPE);
                    this.getAttributeTypeMulti(map, sqlConnection);
                    map.clear();
                    this.addAdditionalTypesWithMethods(map, notprocessed, OBJECT_TYPE);
                    this.getParameterTypesMulti(map, sqlConnection);
                    this.getMethodResultTypesMulti(map, sqlConnection);
                    this.markProcessed(notprocessed);
                    TimeLog.log("Struct_types end ");
                }
                map.clear();
                notprocessed = this.getNotProcessed1000(types, "COLLECTION");
                this.addAdditionalTypes(map, notprocessed, "COLLECTION", false);
                if (!map.isEmpty()) {
                    TimeLog.log("Collections begin " + notprocessed.size());
                    this.getCollectionElementTypesMulti(map, sqlConnection);
                    this.markProcessed(notprocessed);
                    TimeLog.log("Collections end ");
                }
                if ((notprocessed = this.getNotProcessed1000(types, OBJECT_TYPE)).size() != 0) continue;
                notprocessed = this.getNotProcessed1000(types, "COLLECTION");
            }
        }
        TimeLog.log("Step 3 end");
        if (storageDesign != null && storageDesign instanceof StorageDesignOracle) {
            storageOracle = (StorageDesignOracle)storageDesign;
        }
        for (int i2 = 0; i2 < types.size(); ++i2) {
            dbo = (DBObject)types.get(i2);
            if (OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) {
                if (!this.createStructuredType(storageOracle, dbo) || !selectedObjects.contains(dbo)) continue;
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
                continue;
            }
            if (!"COLLECTION".equalsIgnoreCase(dbo.getType()) || !this.createCollectionType(storageOracle, dbo) || !selectedObjects.contains(dbo)) continue;
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (this.supert_statement != null) {
            this.supert_statement.close();
        }
        if (this.attr_statement != null) {
            this.attr_statement.close();
        }
        if (this.par_statement != null) {
            this.par_statement.close();
        }
        if (this.result_statement != null) {
            this.result_statement.close();
        }
        if (this.elem_statement != null) {
            this.elem_statement.close();
        }
        this.allTypes.clear();
        this.selectedTypes.clear();
        TimeLog.log("Type Incomplete end");
    }

    private void generateAdditionalColumnTypes(Connection sqlConnection, Map additionalTypes) throws SQLException {
        for (String schemaName : additionalTypes.keySet()) {
            List tableNameList = (List)additionalTypes.get(schemaName);
            Statement statement = null;
            int size = tableNameList.size();
            if (size > 1000) {
                size = 1000;
            }
            ResultSet rs = null;
            try {
                int i;
                StringBuffer buffer = new StringBuffer();
                buffer.append("with cols as (select /*+ materialize */ distinct owner,DATA_TYPE_OWNER,DATA_TYPE ");
                if (this.dbaUser) {
                    buffer.append("from dba_tab_columns ");
                } else {
                    buffer.append("from all_tab_columns ");
                }
                buffer.append("where DATA_TYPE_OWNER is not null and owner = ").append('?').append(' ').append("AND");
                buffer.append(" table_name in ").append('(').append('?');
                for (i = 1; i < size; ++i) {
                    buffer.append(',').append('?');
                }
                buffer.append(')').append(')');
                buffer.append(" select distinct b.TYPE_NAME, b.OWNER, b.typecode, b.SUPERTYPE_OWNER, b.SUPERTYPE_NAME ");
                if (this.dbaUser) {
                    buffer.append("from dba_types b ");
                } else {
                    buffer.append("from all_types b ");
                }
                buffer.append("where exists( select 1 from cols where b.owner = cols.DATA_TYPE_OWNER and b.TYPE_NAME = cols.DATA_TYPE ) ");
                buffer.append("and b.predefined = 'NO'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                statement.setString(1, schemaName);
                for (i = 0; i < size; ++i) {
                    statement.setString(i + 2, (String)tableNameList.get(i));
                }
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.generateAdditionalColumnTypes():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String owner = rs.getString(2);
                    String type = rs.getString(3);
                    String superTypeOwner = rs.getString(4);
                    String superTypeName = rs.getString(5);
                    DBObject dbo = new DBObject(true, name, type, owner);
                    dbo.setSuperTypeOwner(superTypeOwner);
                    dbo.setSuperTypeName(superTypeName);
                    String key = dbo.toString();
                    if (this.selectedTypes.containsKey(key)) continue;
                    Object temp = this.allTypes.get(key);
                    if (temp != null) {
                        dbo = (DBObject)temp;
                    }
                    types.add(dbo);
                    this.selectedTypes.put(key, dbo);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getParameterTypesMulti(Map map, Connection sqlConnection) throws SQLException {
        try (Statement statement = null;){
            statement = sqlConnection.createStatement();
            for (String schemaName : map.keySet()) {
                String names = (String)map.get(schemaName);
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
                buffer.append("b.").append("TYPE_NAME").append(',');
                buffer.append("b.").append("OWNER").append(',');
                buffer.append("b.").append("TYPECODE").append(',');
                buffer.append("b.").append("SUPERTYPE_OWNER").append(',');
                buffer.append("b.").append("SUPERTYPE_NAME").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_METHOD_PARAMS : ALL_METHOD_PARAMS).append(' ').append("a").append(',');
                buffer.append(this.dbaUser ? DBA_TYPES : ALL_TYPES).append(' ').append("b").append(' ');
                buffer.append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append("'" + schemaName + "'").append(' ');
                buffer.append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append(" in (" + names + ")").append(' ');
                buffer.append("AND").append(" a.PARAM_TYPE_OWNER is not null AND ").append("a.").append("PARAM_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
                buffer.append("AND").append(' ').append("a.").append("PARAM_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
                buffer.append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
                buffer.append('\'').append("NO").append('\'').append(' ');
                buffer.append("AND").append(' ').append("a.").append("PARAM_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                String sql = buffer.toString();
                ResultSet rs = null;
                try {
                    rs = statement.executeQuery(sql);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTypeIncompleteOraclev9i.getParameterTypesMulti():", e);
                }
                if (rs == null) continue;
                while (rs.next()) {
                    DBObject superType;
                    String typeName = rs.getString(1);
                    String owner = rs.getString(2);
                    String typecode = rs.getString(3);
                    String superTypeOwner = rs.getString(4);
                    String superTypeName = rs.getString(5);
                    DBObject newType = new DBObject(true, typeName, typecode, owner);
                    newType.setSuperTypeOwner(superTypeOwner);
                    newType.setSuperTypeName(superTypeName);
                    String key = newType.toString();
                    if (!this.selectedTypes.containsKey(key)) {
                        Object temp = this.allTypes.get(key);
                        if (temp != null) {
                            newType = (DBObject)temp;
                        }
                        types.add(newType);
                        this.selectedTypes.put(key, newType);
                    }
                    if (superTypeName == null || superTypeName.equals("") || this.selectedTypes.containsKey((superType = new DBObject(true, superTypeName, typecode, superTypeOwner)).toString())) continue;
                    types.add(superType);
                    this.selectedTypes.put(superType.toString(), superType);
                }
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMethodResultTypesMulti(Map map, Connection sqlConnection) throws SQLException {
        try (Statement statement = null;){
            statement = sqlConnection.createStatement();
            for (String schemaName : map.keySet()) {
                String names = (String)map.get(schemaName);
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
                buffer.append("b.").append("TYPE_NAME").append(',');
                buffer.append("b.").append("OWNER").append(',');
                buffer.append("b.").append("TYPECODE").append(',');
                buffer.append("b.").append("SUPERTYPE_OWNER").append(',');
                buffer.append("b.").append("SUPERTYPE_NAME").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_METHOD_RESULTS : ALL_METHOD_RESULTS).append(' ').append("a").append(',');
                buffer.append(this.dbaUser ? DBA_TYPES : ALL_TYPES).append(' ').append("b").append(' ');
                buffer.append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(" '" + schemaName + "'").append(' ');
                buffer.append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append(" in (" + names + ")").append(' ');
                buffer.append("AND").append(" a.RESULT_TYPE_OWNER is not null AND ").append("a.").append("RESULT_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
                buffer.append("AND").append(' ').append("a.").append("RESULT_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
                buffer.append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
                buffer.append('\'').append("NO").append('\'').append(' ');
                buffer.append("AND").append(' ').append("a.").append("RESULT_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                String sql = buffer.toString();
                ResultSet rs = null;
                try {
                    rs = statement.executeQuery(sql);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTypeIncompleteOraclev9i.getMethodResultTypesMulti():", e);
                }
                if (rs == null) continue;
                while (rs.next()) {
                    DBObject superType;
                    String typeName = rs.getString(1);
                    String owner = rs.getString(2);
                    String typecode = rs.getString(3);
                    String superTypeOwner = rs.getString(4);
                    String superTypeName = rs.getString(5);
                    DBObject newType = new DBObject(true, typeName, typecode, owner);
                    newType.setSuperTypeOwner(superTypeOwner);
                    newType.setSuperTypeName(superTypeName);
                    String key = newType.toString();
                    if (!this.selectedTypes.containsKey(key)) {
                        Object temp = this.allTypes.get(key);
                        if (temp != null) {
                            newType = (DBObject)temp;
                        }
                        types.add(newType);
                        this.selectedTypes.put(key, newType);
                    }
                    if (superTypeName == null || superTypeName.equals("") || this.selectedTypes.containsKey((superType = new DBObject(true, superTypeName, typecode, superTypeOwner)).toString())) continue;
                    types.add(superType);
                    this.selectedTypes.put(superType.toString(), superType);
                }
                rs.close();
            }
        }
    }

    private void addSuperTypesMulti(Map map, Connection sqlConnection, List notProcessed) throws SQLException {
        for (DBObject dbo : notProcessed) {
            DBObject superType;
            String key;
            String superTypeOwner = dbo.getSuperTypeOwner();
            String superTypeName = dbo.getSuperTypeName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType()) || superTypeName == null || superTypeName.equals("") || this.selectedTypes.containsKey(key = (superType = new DBObject(true, superTypeName, OBJECT_TYPE, superTypeOwner)).toString())) continue;
            Object temp = this.allTypes.get(key);
            if (temp != null) {
                superType = (DBObject)temp;
            }
            types.add(superType);
            this.selectedTypes.put(key, superType);
            if (temp != null) continue;
            ResultSet rs = null;
            if (this.supert_statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("SUPERTYPE_OWNER").append(',');
                buffer.append("SUPERTYPE_NAME").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_TYPES : ALL_TYPES).append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("TYPE_NAME").append('=').append('?');
                String sql = buffer.toString();
                this.supert_statement = sqlConnection.prepareStatement(sql);
            }
            try {
                this.supert_statement.setString(1, superTypeOwner);
                this.supert_statement.setString(2, superTypeName);
                rs = this.supert_statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.addSuperTypesMulti(): " + e.getMessage());
            }
            if (rs == null) continue;
            if (rs.next()) {
                String superOwner = rs.getString(1);
                String superName = rs.getString(2);
                superType.setSuperTypeOwner(superOwner);
                superType.setSuperTypeName(superName);
            }
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCollectionElementTypesMulti(Map map, Connection sqlConnection) throws SQLException {
        try (Statement statement = null;){
            statement = sqlConnection.createStatement();
            String schemaNames = null;
            String names = null;
            boolean first = true;
            for (String schemaName : map.keySet()) {
                String names1 = (String)map.get(schemaName);
                if (first) {
                    schemaNames = "'" + schemaName + "'";
                    names = names1;
                    continue;
                }
                schemaNames = schemaNames + "," + "'" + schemaName + "'";
                names = names + "," + names1;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
            buffer.append("b.").append("TYPE_NAME").append(',');
            buffer.append("b.").append("OWNER").append(',');
            buffer.append("b.").append("TYPECODE").append(',');
            buffer.append("b.").append("SUPERTYPE_OWNER").append(',');
            buffer.append("b.").append("SUPERTYPE_NAME").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_COLL_TYPES : ALL_COLL_TYPES).append(' ').append("a").append(',');
            buffer.append(this.dbaUser ? DBA_TYPES : ALL_TYPES).append(' ').append("b").append(' ');
            buffer.append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append(" in (" + schemaNames + ")").append(' ');
            buffer.append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append(" in (" + names + ")").append(' ');
            buffer.append("AND").append(" a.ELEM_TYPE_OWNER is not null AND ").append("a.").append("ELEM_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
            buffer.append("AND").append(' ').append("a.").append("ELEM_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER").append(' ');
            buffer.append("AND").append(' ').append("b.").append("PREDEFINED").append(' ').append('=').append(' ');
            buffer.append('\'').append("NO").append('\'').append(' ');
            buffer.append("AND").append(' ').append("a.").append("ELEM_TYPE_OWNER").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
            String sql = buffer.toString();
            ResultSet rs = null;
            try {
                rs = statement.executeQuery(sql);
            }
            catch (Exception e) {
                LOGGER.error("MOHTypeIncompleteOraclev9i.getCollectionElementTypesMulti():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    DBObject superType;
                    String typeName = rs.getString(1);
                    String owner = rs.getString(2);
                    String typecode = rs.getString(3);
                    String superTypeOwner = rs.getString(4);
                    String superTypeName = rs.getString(5);
                    DBObject newType = new DBObject(true, typeName, typecode, owner);
                    newType.setSuperTypeOwner(superTypeOwner);
                    newType.setSuperTypeName(superTypeName);
                    String key = newType.toString();
                    if (!this.selectedTypes.containsKey(key)) {
                        Object temp = this.allTypes.get(key);
                        if (temp != null) {
                            newType = (DBObject)temp;
                        }
                        types.add(newType);
                        this.selectedTypes.put(key, newType);
                    }
                    if (superTypeName == null || superTypeName.equals("") || this.selectedTypes.containsKey(key = (superType = new DBObject(true, superTypeName, typecode, superTypeOwner)).toString())) continue;
                    Object temp = this.allTypes.get(key);
                    if (temp != null) {
                        superType = (DBObject)temp;
                    }
                    types.add(superType);
                    this.selectedTypes.put(key, superType);
                }
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttributeTypeMulti(Map map, Connection sqlConnection) throws SQLException {
        try (Statement statement = null;){
            statement = sqlConnection.createStatement();
            for (String schemaName : map.keySet()) {
                String names = (String)map.get(schemaName);
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("DISTINCT").append(' ');
                buffer.append("b.").append("TYPE_NAME").append(',');
                buffer.append("b.").append("OWNER").append(',');
                buffer.append("b.").append("TYPECODE").append(',');
                buffer.append("b.").append("SUPERTYPE_OWNER").append(',');
                buffer.append("b.").append("SUPERTYPE_NAME").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? DBA_TYPE_ATTRS : ALL_TYPE_ATTRS).append(' ').append("a").append(',');
                buffer.append(this.dbaUser ? DBA_TYPES : ALL_TYPES).append(' ').append("b").append(' ');
                buffer.append("WHERE").append(' ').append("a.").append("OWNER").append(' ').append('=').append(' ').append("'" + schemaName + "'").append(' ');
                buffer.append("AND").append(' ').append("a.").append("TYPE_NAME").append(' ').append(" in (" + names + ")").append(' ');
                buffer.append("AND").append(" a.ATTR_TYPE_OWNER is not null AND ").append("a.").append("ATTR_TYPE_NAME").append(' ').append('=').append(' ').append("b.").append("TYPE_NAME").append(' ');
                buffer.append("AND").append(' ').append("a.").append("ATTR_TYPE_OWNER").append(' ').append('=').append(' ').append("b.").append("OWNER");
                String sql = buffer.toString();
                ResultSet rs = null;
                try {
                    rs = statement.executeQuery(sql);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTypeIncompleteOraclev9i.getAttributeTypeMulti():", e);
                }
                if (rs == null) continue;
                while (rs.next()) {
                    DBObject superType;
                    String typeName = rs.getString(1);
                    String owner = rs.getString(2);
                    String typecode = rs.getString(3);
                    String superTypeOwner = rs.getString(4);
                    String superTypeName = rs.getString(5);
                    DBObject newType = new DBObject(true, typeName, typecode, owner);
                    newType.setSuperTypeOwner(superTypeOwner);
                    newType.setSuperTypeName(superTypeName);
                    String key = newType.toString();
                    if (!this.selectedTypes.containsKey(key)) {
                        Object temp = this.allTypes.get(key);
                        if (temp != null) {
                            newType = (DBObject)temp;
                        }
                        types.add(newType);
                        this.selectedTypes.put(key, newType);
                    }
                    if (superTypeName == null || superTypeName.equals("") || this.selectedTypes.containsKey(key = (superType = new DBObject(true, superTypeName, typecode, superTypeOwner)).toString())) continue;
                    Object temp = this.allTypes.get(key);
                    if (temp != null) {
                        superType = (DBObject)temp;
                    }
                    types.add(superType);
                    this.selectedTypes.put(key, superType);
                }
                rs.close();
            }
        }
    }

    private void markProcessed(List notProcessed) {
        for (DBObject dbo : notProcessed) {
            dbo.setProcessed(true);
        }
    }

    private boolean createCollectionType(StorageDesignOracle storageOracle, DBObject dbo) {
        String name = dbo.getName();
        String schema = dbo.getSchema();
        CollectionType type = (CollectionType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(name);
        if (type == null) {
            type = this.getDesign().getDataTypesDesign().createCollectionType();
            type.setName(name);
            if (!name.equals(name.toUpperCase())) {
                type.setNameHasQuotes(true);
            }
            this.stampModelObject(type, dbo);
        }
        if (storageOracle != null) {
            CollectionTypeProxyOracle proxy = (CollectionTypeProxyOracle)storageOracle.getCollectionTypeProxySet().getProxy(type.getObjectID());
            if (proxy != null) {
                UserOracle user = (UserOracle)storageOracle.getUserSet().getByName(schema);
                if (user == null) {
                    user = storageOracle.getUserSet().createUser();
                    user.setName(schema);
                    this.stampModelObject((ModelObject)user, "", schema);
                }
                proxy.setOwner(user);
                this.stampModelObject(proxy, dbo);
            }
            return true;
        }
        return false;
    }

    private boolean createStructuredType(StorageDesignOracle storageOracle, DBObject dbo) {
        String name = dbo.getName();
        String schema = dbo.getSchema();
        StructuredType type = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(name);
        if (type != null) {
            type.removeAll();
            type.removeAllMethods();
        } else {
            type = this.getDesign().getDataTypesDesign().createStructuredType();
            type.setName(name);
            if (!name.equals(name.toUpperCase())) {
                type.setNameHasQuotes(true);
            }
            this.stampModelObject(type, dbo);
        }
        if (storageOracle != null) {
            StructuredTypeProxyOracle proxy = (StructuredTypeProxyOracle)storageOracle.getStructuredTypeProxySet().getProxy(type.getObjectID());
            if (proxy != null) {
                proxy.setName(name);
                UserOracle user = (UserOracle)storageOracle.getUserSet().getByName(schema);
                if (user == null) {
                    user = storageOracle.getUserSet().createUser();
                    user.setName(schema);
                    this.stampModelObject((ModelObject)user, "", schema);
                }
                proxy.setOwner(user);
                this.stampModelObject(proxy, dbo);
            }
            return true;
        }
        return false;
    }

    private void addAdditionalType(Map additionalTypes, DBObject dbo) {
        ArrayList<String> tableNameList = (ArrayList<String>)additionalTypes.get(dbo.getSchema());
        if (tableNameList == null) {
            tableNameList = new ArrayList<String>();
            tableNameList.add(dbo.getName());
            additionalTypes.put(dbo.getSchema(), tableNameList);
        } else {
            tableNameList.add(dbo.getName());
        }
    }

    private void addAdditionalTypes(Map map, List list, String type, boolean includeEmptyTypeCode) {
        for (DBObject dbo : list) {
            if (!type.equals(dbo.getType()) && (!includeEmptyTypeCode || dbo.getType() != null)) continue;
            String key = dbo.getSchema();
            if (!map.containsKey(key)) {
                map.put(dbo.getSchema(), '\'' + dbo.getName() + '\'');
                continue;
            }
            String tableNames = (String)map.get(key);
            tableNames = tableNames + ',' + '\'' + dbo.getName() + '\'';
            map.put(key, tableNames);
        }
    }

    private void addAdditionalTypesWithAttributes(Map map, List list, String type) {
        for (DBObject dbo : list) {
            if (!type.equals(dbo.getType())) continue;
            String key = dbo.getSchema();
            if (!map.containsKey(key)) {
                map.put(dbo.getSchema(), '\'' + dbo.getName() + '\'');
                continue;
            }
            String tableNames = (String)map.get(key);
            tableNames = tableNames + ',' + '\'' + dbo.getName() + '\'';
            map.put(key, tableNames);
        }
    }

    private void addAdditionalTypesWithMethods(Map map, List list, String type) {
        for (DBObject dbo : list) {
            String key;
            if (!type.equals(dbo.getType()) || "ORDSYS".equalsIgnoreCase(key = dbo.getSchema())) continue;
            if (!map.containsKey(key)) {
                map.put(key, '\'' + dbo.getName() + '\'');
                continue;
            }
            String tableNames = (String)map.get(key);
            tableNames = tableNames + ',' + '\'' + dbo.getName() + '\'';
            map.put(key, tableNames);
        }
    }

    private List getNotProcessed1000(List all, String type) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            if (list.size() < 1000) {
                DBObject dbo = (DBObject)it.next();
                if (dbo.isProcessed() || !type.equals(dbo.getType())) continue;
                list.add(dbo);
                continue;
            }
            return list;
        }
        return list;
    }

    public static List getAllTypes() {
        return types;
    }

    static {
        LOGGER = new Logger(MOHTypeIncompleteOraclev9i.class);
    }
}

