/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHRoleSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "ROLE";
    private static final Logger LOGGER = new Logger(MOHRoleSqlServer.class);

    public MOHRoleSqlServer(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append('\'').append("RoleId").append('\'').append(' ');
                buffer.append('=').append(' ');
                buffer.append("UID").append(' ');
                buffer.append(',').append(' ');
                buffer.append('\'').append("IsAppRole").append('\'').append(' ');
                buffer.append('=').append(' ');
                buffer.append("ISAPPROLE").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHRoleSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append('(').append(' ');
                buffer.append("issqlrole = 1").append(' ');
                buffer.append("OR").append(' ');
                buffer.append("isapprole = 1").append(' ');
                buffer.append(')').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("NAME").append(' ');
                buffer.append("NOT").append(' ');
                buffer.append("IN").append(' ');
                buffer.append('(').append(' ');
                buffer.append('\'').append("db_owner").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_accessadmin").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_securityadmin").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_ddladmin").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_backupoperator").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_datareader").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_datawriter").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_denydatareader").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_denydatawriter").append('\'').append(' ');
                buffer.append(')').append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHRoleSqlServer.generate():", e);
            }
            ArrayList<Properties> list = new ArrayList<Properties>();
            if (rs != null) {
                while (rs.next()) {
                    String role_id = rs.getString(1);
                    int isAppl = rs.getInt(2);
                    Properties props = new Properties();
                    props.setProperty("role_id", role_id);
                    props.setProperty("isAppl", String.valueOf(isAppl));
                    list.add(props);
                }
            }
            if (statement != null) {
                statement.close();
            }
            for (Properties props : list) {
                String role_id = props.getProperty("role_id");
                int isAppl = Integer.parseInt(props.getProperty("isAppl"));
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                    RoleSqlServer role = (RoleSqlServer)storage.getRoleSet().getByName(name);
                    if (role == null) {
                        role = storage.getRoleSet().createRole();
                        role.setName(name);
                        this.stampModelObject(role, dbo);
                    }
                    this.setProperties(role, storage, db, isAppl);
                    this.setMembers(role, role_id, db, sqlConnection);
                    this.initPrivileges(role, role_id, db, sqlConnection);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initPrivileges(RoleSqlServer role, String role_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("DB_PRIV").append(' ');
            buffer.append('=').append(' ');
            buffer.append(" case action ");
            buffer.append(" when 178 then 'CREATE FUNCTION'");
            buffer.append(" when 198 then 'CREATE TABLE'");
            buffer.append(" when 203 then 'CREATE DATABASE'");
            buffer.append(" when 207 then 'CREATE VIEW'");
            buffer.append(" when 222 then 'CREATE PROCEDURE'");
            buffer.append(" when 228 then 'BACKUP DATABASE'");
            buffer.append(" when 233 then 'CREATE DEFAULT'");
            buffer.append(" when 235 then 'BACKUP LOG'");
            buffer.append(" when 236 then 'CREATE RULE'");
            buffer.append(" end").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHRoleSqlServer.getFormattedName(db)).append('.').append("dbo.sysprotects").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("protecttype in (204,205)").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("action in (178,198,203,207,222,228,233,235,236)").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(role_id).append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    role.setSystemPrivileges(rs.getString(1));
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHRoleSqlServer.bindColumns():", e);
        }
    }

    private void setMembers(RoleSqlServer role, String role_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("u.name").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHRoleSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHRoleSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers G").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHRoleSqlServer.getFormattedName(db)).append('.').append("dbo.sysmembers M").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("g").append('.').append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(role_id).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("g").append('.').append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("m").append('.').append("groupuid").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("g").append('.').append("issqlrole").append(' ');
            buffer.append('=').append(' ');
            buffer.append(1).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("u").append('.').append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("m").append('.').append("memberuid").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("u").append('.').append("issqlrole").append(' ');
            buffer.append('=').append(' ');
            buffer.append(0).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("u").append('.').append("isapprole").append(' ');
            buffer.append('=').append(' ');
            buffer.append(0).append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String username = rs.getString(1);
                    role.setUsers(username);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHRoleSqlServer.bindColumns():", e);
        }
    }

    private void setProperties(RoleSqlServer role, StorageDesignSqlServer storage, String db, int isAppl) throws Exception {
        DataBaseSqlServer database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
        if (database == null) {
            database = storage.getDataBaseSet().createDataBase();
            database.setName(db);
            this.stampModelObject((ModelObject)database, "", db);
        }
        role.setDatabase(database);
        if (isAppl == 0) {
            role.setIsApplicationRole(false);
        } else {
            role.setIsApplicationRole(true);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        Iterator it = schemas.iterator();
        String dbName = null;
        while (it.hasNext()) {
            DBUserSqlServer dbo;
            DBObject dboNext = (DBObject)it.next();
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer) || (dbName = !this.containsDboForDb(schemas, dbo = (DBUserSqlServer)dboNext) ? dbo.getDb() : null) == null) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append('\'').append("RoleName").append('\'').append(' ');
                buffer.append('=').append(' ').append("NAME").append(' ').append(',').append(' ');
                buffer.append('\'').append("RoleId").append('\'').append(' ');
                buffer.append('=').append(' ').append("UID").append(' ').append(',').append(' ');
                buffer.append('\'').append("IsAppRole").append('\'').append(' ');
                buffer.append('=').append(' ').append("ISAPPROLE").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHRoleSqlServer.getFormattedName(dbName)).append(".dbo.sysusers").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append('(').append(' ');
                buffer.append("ISSQLROLE").append(' ');
                buffer.append('=').append(' ');
                buffer.append(1).append(' ');
                buffer.append("OR").append(' ');
                buffer.append("ISAPPROLE").append(' ');
                buffer.append('=').append(' ');
                buffer.append(1).append(' ');
                buffer.append(')').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("NAME").append(' ').append("NOT").append(' ').append("IN").append(' ');
                buffer.append('(').append(' ');
                buffer.append('\'').append("db_owner").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_accessadmin").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_securityadmin").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_ddladmin").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_backupoperator").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_datareader").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_datawriter").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_denydatareader").append('\'').append(',').append(' ');
                buffer.append('\'').append("db_denydatawriter").append('\'').append(' ');
                buffer.append(')').append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("getRoles(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String sid = rs.getString(1);
                    DBObjectSqlServer dboRole = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), sid, OBJECT_TYPE, "");
                    dboRole.setDb(dbName);
                    list.add(dboRole);
                }
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

