/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Collections;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;

public class SubViewObjectSet
extends DesignObjectSet {
    private static final Object[] PROTO_DESIGNOBJECT = new DesignObject[0];
    String name = Messages.getString("SubViewObjectSet.SubView");
    Object parent;
    Object elDescriptor;
    private boolean containsDisplays = false;

    public SubViewObjectSet(DesignPart designPart, String name) {
        super(designPart);
        this.setName(name);
        this.requireSort = true;
    }

    public SubViewObjectSet(DesignPart designPart, String name, boolean containsDisplays) {
        this(designPart, name);
        this.containsDisplays = containsDisplays;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_DESIGNOBJECT;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return Messages.getString("SubViewObjectSet.SubView");
    }

    @Override
    public boolean setName(String name) {
        this.name = name;
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void clear() {
        this.removeAll();
    }

    @Override
    public void setParent(Object parent) {
        this.parent = parent;
    }

    @Override
    public Object getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        return super.getParent();
    }

    public void removePlaceHolderFor(Object object) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            PlaceHolder ph = (PlaceHolder)it.next();
            if (!object.equals(ph.getObject())) continue;
            this.remove(ph);
            return;
        }
    }

    public boolean containsObject(Object object) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            PlaceHolder ph = (PlaceHolder)it.next();
            if (!object.equals(ph.getObject())) continue;
            return true;
        }
        return false;
    }

    public void setElementDescriptor(Object elementDescriptor) {
        this.elDescriptor = elementDescriptor;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    public DesignPartView getSubViewGeneratedByDPV(String designPVId) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            DesignPartView dpv = ph.getDesignPartView();
            if (dpv == null || designPVId == null || !designPVId.equals(dpv.getGeneratorId())) continue;
            return dpv;
        }
        return null;
    }

    public DesignPartView getSubViewByID(String designPVId) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            DesignPartView dpv = ph.getDesignPartView();
            if (dpv == null || !designPVId.equals(dpv.getDPVId())) continue;
            return dpv;
        }
        return null;
    }

    public DesignPartView getSubViewByName(String name) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            DesignPartView dpv = ph.getDesignPartView();
            if (dpv == null || !name.equalsIgnoreCase(dpv.getName())) continue;
            return dpv;
        }
        return null;
    }

    public DesignPartView[] getMainViewAndSubViews() {
        DesignPartView[] dpvs = new DesignPartView[this.size() + 1];
        dpvs[0] = this.getDesignPart().getMainView();
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            ++i;
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            DesignPartView dpv = ph.getDesignPartView();
            if (dpv == null) continue;
            dpvs[i] = dpv;
        }
        return dpvs;
    }

    @Override
    public Design getDesign() {
        return this.getDesignPart().getDesign();
    }

    public boolean isContainsDisplays() {
        return this.containsDisplays;
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_IGNORE_CASE_COMPARATOR);
        this.fireChange(SetEvent.OBJECT_ADDED);
    }
}

