/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDDataTypeFactory;
import oracle.dbtools.crest.model.datatype.MDFloat;
import oracle.dbtools.crest.model.datatype.MDUnknown;
import oracle.dbtools.crest.model.datatype.oracle.MDBFileOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDBlobOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDCharOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDClobOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDDateOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDDecimalOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDFixedSizeOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDLongOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDLongRowOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNCharOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNClobOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNVarChar2Oracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNumberOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDNumericOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDRawOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDRowIDOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDURowIDOracle;
import oracle.dbtools.crest.model.datatype.oracle.MDVarChar2Oracle;
import oracle.dbtools.crest.util.options.Settings;

public class MDDataTypeFactoryOracle
extends MDDataTypeFactory {
    protected Settings settings;

    public MDDataTypeFactoryOracle(Settings settings) {
        this.settings = settings;
    }

    @Override
    protected void initFlyWeights() {
        this.flyweights.put("UNKNOWN", new MDUnknown());
        this.flyweights.put("DATE", new MDDateOracle());
        this.flyweights.put("LONG", new MDLongOracle());
        this.flyweights.put("LONG VARCHAR", new MDLongOracle());
        MDFixedSizeOracle integ = new MDFixedSizeOracle();
        integ.setIntegerSynonym();
        this.flyweights.put("INTEGER", integ);
        this.flyweights.put("INT", integ);
        MDFixedSizeOracle smallint = new MDFixedSizeOracle();
        smallint.setSmallIntSynonym();
        this.flyweights.put("SMALLINT", smallint);
        MDFixedSizeOracle real = new MDFixedSizeOracle();
        real.setRealSynonym();
        this.flyweights.put("REAL", real);
        MDFixedSizeOracle doubl = new MDFixedSizeOracle();
        doubl.setDoubleSynonym();
        this.flyweights.put("DOUBLE", doubl);
        this.flyweights.put("LONG RAW", new MDLongRowOracle());
        this.flyweights.put("ROWID", new MDRowIDOracle());
        this.flyweights.put("BLOB", new MDBlobOracle());
        this.flyweights.put("CLOB", new MDClobOracle());
        this.flyweights.put("NCLOB", new MDNClobOracle());
        this.flyweights.put("BFILE", new MDBFileOracle());
        this.initFlyWeightsTimeTypes();
    }

    protected void initFlyWeightsTimeTypes() {
        this.flyweights.put("TIME", new MDDateOracle());
        this.flyweights.put("TIMESTAMP", new MDDateOracle());
    }

    @Override
    protected void initHeavyWeights() {
        this.heavyweights.put("VARCHAR", MDVarChar2Oracle.class);
        this.heavyweights.put("VARCHAR2", MDVarChar2Oracle.class);
        this.heavyweights.put("NVARCHAR2", MDNVarChar2Oracle.class);
        this.heavyweights.put("NVARCHAR", MDNVarChar2Oracle.class);
        this.heavyweights.put("RAW", MDRawOracle.class);
        this.heavyweights.put("ROWID", MDRowIDOracle.class);
        this.heavyweights.put("UROWID", MDURowIDOracle.class);
        this.heavyweights.put("NUMBER", MDNumberOracle.class);
        this.heavyweights.put("DECIMAL", MDDecimalOracle.class);
        this.heavyweights.put("DEC", MDDecimalOracle.class);
        this.heavyweights.put("NUMERIC", MDNumericOracle.class);
        this.heavyweights.put("CHAR", MDCharOracle.class);
        this.heavyweights.put("NCHAR", MDNCharOracle.class);
        this.heavyweights.put("FLOAT", MDFloat.class);
    }

    @Override
    public MDDataType createType(String name, String size) {
        MDDataType dataType = null;
        if ("CHAR".equals(name) || "CHARACTER".equals(name)) {
            dataType = new MDCharOracle(this.settings);
        } else if ("NCHAR".equals(name)) {
            dataType = new MDNCharOracle();
        } else if ("VARCHAR2".equals(name)) {
            dataType = new MDVarChar2Oracle(this.settings);
        } else if ("VARCHAR".equals(name)) {
            dataType = new MDVarChar2Oracle(this.settings);
            ((MDVarChar2Oracle)dataType).setVarcharSynonym();
        } else if ("NVARCHAR2".equals(name)) {
            dataType = new MDNVarChar2Oracle();
        } else if ("NVARCHAR".equals(name)) {
            dataType = new MDNVarChar2Oracle();
        } else if ("RAW".equals(name)) {
            dataType = new MDRawOracle();
        } else if ("UROWID".equals(name)) {
            dataType = new MDURowIDOracle();
        } else {
            if ("NUMBER".equals(name)) {
                dataType = new MDNumberOracle();
                dataType.setPrecisionStr(size);
                return dataType;
            }
            if ("NUMERIC".equals(name)) {
                MDNumberOracle dec = new MDNumberOracle();
                dec.setNumericSynonym();
                dec.setPrecisionStr(size);
                return dec;
            }
            if ("DECIMAL".equals(name)) {
                MDNumberOracle dec = new MDNumberOracle();
                dec.setDecimalSynonym();
                dec.setPrecisionStr(size);
                return dec;
            }
            if ("DEC".equals(name)) {
                MDNumberOracle dec = new MDNumberOracle();
                dec.setDecSynonym();
                dec.setPrecisionStr(size);
                return dec;
            }
            if ("FLOAT".equals(name)) {
                MDFloat fl = new MDFloat();
                dataType = fl;
                dataType.setPrecisionStr(size);
                return dataType;
            }
            if ("NATIONAL CHARACTER".equals(name)) {
                dataType = new MDNCharOracle();
            } else if ("NATIONAL CHARACTER VARYING".equals(name)) {
                dataType = new MDNVarChar2Oracle();
            } else if ("NATIONAL CHAR".equals(name)) {
                dataType = new MDNCharOracle();
            } else if ("NATIONAL CHAR VARYING".equals(name)) {
                dataType = new MDNVarChar2Oracle();
            } else if ("NCHAR VARYING".equals(name)) {
                dataType = new MDNVarChar2Oracle();
            }
        }
        if (dataType == null) {
            dataType = super.createUDNativeType(name, size);
        } else {
            dataType.setSize(size);
        }
        return dataType;
    }

    @Override
    public MDDataType createType(String name, int precision, int scale) {
        if ("NUMBER".equals(name)) {
            MDNumberOracle dec = new MDNumberOracle();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        if ("NUMERIC".equals(name)) {
            MDNumberOracle dec = new MDNumberOracle();
            dec.setNumericSynonym();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        if ("DECIMAL".equals(name)) {
            MDNumberOracle dec = new MDNumberOracle();
            dec.setDecimalSynonym();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        if ("DEC".equals(name)) {
            MDNumberOracle dec = new MDNumberOracle();
            dec.setDecSynonym();
            dec.setPrecision(precision);
            dec.setScale(scale);
            return dec;
        }
        if ("FLOAT".equals(name)) {
            MDFloat fl = new MDFloat();
            return fl;
        }
        return super.createUDNativeType(name, precision, scale);
    }

    @Override
    public MDDataType createType(String name, String precision, String scale) {
        if ("NUMBER".equals(name)) {
            MDNumberOracle dec = new MDNumberOracle();
            if (!"precision".equalsIgnoreCase(precision)) {
                dec.setPrecisionStr(precision);
            } else {
                dec.setPrecision(0);
            }
            int sc = 0;
            try {
                sc = Integer.valueOf(scale);
            }
            catch (Exception e) {
                // empty catch block
            }
            dec.setScale(sc);
            return dec;
        }
        return super.createType(name, precision, scale);
    }
}

