/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.storage.oracle.StructuredTypeComparatorOracle;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;

public class StructuredTypeComparator
extends PropertiesComparator {
    public static final String FINAL = StructuredTypeComparator.removeColon(AbstractEditorConstants.LB_FINAL);
    public static final String INSTANTIABLE = StructuredTypeComparator.removeColon(AbstractEditorConstants.LB_INSTANTIABLE);
    public static final String HIVE_TYPE = StructuredTypeComparator.removeColon(AbstractEditorConstants.LB_HIVE_TYPE);
    public static final String MAX_SIZE_AS_STRING = StructuredTypeComparator.removeColon(AbstractEditorConstants.LB_MAX_SIZE_AS_STRING);
    public static final String SUPERTYPE = StructuredTypeComparator.removeColon(AbstractEditorConstants.LB_SUPER_TYPE);
    private StructuredType sourceType;
    private StructuredType targetType;
    private StructuredTypeProxy sourceTypeProxy;
    private StructuredTypeProxy targetTypeProxy;
    private CompareCWDDesigns selectionObject;

    public StructuredTypeComparator(StructuredType source, StructuredType target) {
        this(source, target, null, null);
    }

    public StructuredTypeComparator(StructuredType source, StructuredType target, StructuredTypeProxy sourceTypeProxy, StructuredTypeProxy targetTypeProxy) {
        super(source, target);
        this.sourceType = source;
        this.targetType = target;
        this.sourceTypeProxy = sourceTypeProxy;
        this.targetTypeProxy = targetTypeProxy;
        this.initPropertiesList();
        this.initPropertiesFilterList();
        this.initPhysicalPropertiesComparator();
    }

    private void initPhysicalPropertiesComparator() {
        StructuredTypeProxy typeProxy;
        StructuredTypeComparatorOracle physicalComparator = null;
        StructuredTypeProxy structuredTypeProxy = typeProxy = this.sourceTypeProxy != null ? this.sourceTypeProxy : this.targetTypeProxy;
        if (typeProxy instanceof StructuredTypeProxyOracle) {
            physicalComparator = new StructuredTypeComparatorOracle(this.sourceTypeProxy, this.targetTypeProxy);
        }
        this.setPhysicalPropertiesComparator(physicalComparator);
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(SUPERTYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.getSupertypeName(this.sourceType));
        ph.setRightValue(this.getSupertypeName(this.targetType));
        if (this.isExcludedFromComparison(SUPERTYPE)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(FINAL);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? String.valueOf(this.sourceType.isFinal()) : "");
        ph.setRightValue(this.targetType != null ? String.valueOf(this.targetType.isFinal()) : "");
        if (this.isExcludedFromComparison(FINAL)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INSTANTIABLE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? String.valueOf(this.sourceType.isInstantiable()) : "");
        ph.setRightValue(this.targetType != null ? String.valueOf(this.targetType.isInstantiable()) : "");
        if (this.isExcludedFromComparison(INSTANTIABLE)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(HIVE_TYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? this.sourceType.getHiveType() : "");
        ph.setRightValue(this.targetType != null ? this.targetType.getHiveType() : "");
        if (this.isExcludedFromComparison(HIVE_TYPE)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(ATTRIBUTE_ORDER);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.sourceType != null ? this.getElementsToString(this.sourceType) : "");
        ph.setRightValue(this.targetType != null ? this.getElementsToString(this.targetType) : "");
        if (this.isExcludedFromComparison(ATTRIBUTE_ORDER)) {
            ph.setExcluded(true);
        } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(MAX_SIZE_AS_STRING);
            ph.setLeftValue(this.sourceType != null ? String.valueOf(this.sourceType.getMaxLengthAsString()) : "");
            ph.setRightValue(this.targetType != null ? String.valueOf(this.targetType.getMaxLengthAsString()) : "");
            if (this.isExcludedFromComparison(MAX_SIZE_AS_STRING)) {
                ph.setExcluded(true);
            } else if (this.sourceType != null && this.targetType != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
        }
        this.initCommentsAndNotes(false);
        this.initDynamicProperties();
    }

    private String getSupertypeName(StructuredType structType) {
        StructuredType supertype;
        if (structType != null && (supertype = structType.getParentType()) != null) {
            return supertype.getName();
        }
        return "";
    }

    @Override
    public void copySelectedProperties() {
        this.copySelectedProperties(null);
    }

    protected void copySelectedProperties(Map objectsMap) {
        if (this.sourceType != null && this.targetType != null) {
            this.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(ATTRIBUTE_ORDER)) {
                    this.reorderAttributes(objectsMap);
                    continue;
                }
                if (ph.getName().equals(SUPERTYPE)) {
                    Object targetObject;
                    StructuredType targetParent = null;
                    StructuredType sourceParent = this.sourceType.getParentType();
                    if (sourceParent != null && objectsMap != null && (targetObject = objectsMap.get(sourceParent.getObjectID())) instanceof StructuredType) {
                        targetParent = (StructuredType)targetObject;
                    }
                    this.targetType.setParentType(targetParent);
                    continue;
                }
                if (ph.getName().equals(FINAL)) {
                    this.targetType.setFinal(this.sourceType.isFinal());
                    continue;
                }
                if (ph.getName().equals(INSTANTIABLE)) {
                    this.targetType.setInstantiable(this.sourceType.isInstantiable());
                    continue;
                }
                if (ph.getName().equals(HIVE_TYPE)) {
                    this.targetType.setHiveType(this.sourceType.getHiveType());
                    continue;
                }
                if (!ph.getName().equals(MAX_SIZE_AS_STRING)) continue;
                this.targetType.setMaxLengthAsString(this.sourceType.getMaxLengthAsString());
            }
        }
    }

    private void reorderAttributes(Map objectsMap) {
        if (objectsMap != null) {
            int targetPos = 0;
            TypeElement[] sourceElements = this.sourceType.getElements();
            for (int i = 0; i < sourceElements.length; ++i) {
                TypeElement sourceAtt = sourceElements[i];
                TypeElement targetAtt = (TypeElement)objectsMap.get(sourceAtt.getObjectID());
                if (targetAtt == null || !this.targetType.moveElementToIndex(targetAtt, targetPos)) continue;
                ++targetPos;
            }
        }
    }

    public void presetTypeElemsOrder() {
    }

    private String getElementsToString(StructuredType strType) {
        StringBuffer sb = new StringBuffer();
        TypeElement[] attributes = strType.getElements();
        for (int i = 0; i < attributes.length; ++i) {
            TypeElement typeElem = attributes[i];
            if (i > 0) {
                sb.append(" \n");
            }
            sb.append(typeElem.getName());
        }
        return sb.toString();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceType == null && this.targetType != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public ModelIdObjectSelection getSelectionObject() {
        if (this.selectionObject != null) {
            return this.selectionObject;
        }
        return this.getLeftSelectionObject();
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }

    @Override
    public String getLeftName() {
        if (this.sourceType != null && !this.sourceType.getName().equalsIgnoreCase("SDO_GEOMETRY")) {
            return MessageFormat.format(Messages.getString("StructuredTypeComparator.SourceStructureType"), this.sourceType.getName());
        }
        return "";
    }

    @Override
    public String getRightName() {
        return this.targetType != null ? MessageFormat.format(Messages.getString("StructuredTypeComparator.TargetStructureType"), this.targetType.getName()) : "";
    }
}

