/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.List;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.impact.ImpA_Column;
import oracle.dbtools.crest.model.design.impact.ImpA_Relation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_FKAssociation
extends LongNameObjectSelection {
    private FKIndexAssociation fkIndex;

    public ImpA_FKAssociation(FKIndexAssociation fkIndex, ModelIdObjectSelection parent, boolean load) {
        super(fkIndex);
        this.fkIndex = fkIndex;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addFKColumns();
        this.addMappings(this);
        this.loaded = true;
    }

    private void addMappings(ImpA_FKAssociation parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_FKAssociation.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        parent.addChild(selection);
        if (this.fkIndex.getObjectID() != null) {
            List list = this.fkIndex.getDesign().getExtendedMap().getMappingsForDesignPart(this.fkIndex, this.fkIndex.getDesign().getLogicalDesign().getObjectID());
            for (XtdMapping mapping : list) {
                Relation relation = (Relation)mapping.getObjectMappedTo(this.fkIndex);
                if (relation == null) continue;
                if (!selection.hasAsParent(relation)) {
                    selection.addChild(new ImpA_Relation(relation, selection, false));
                    continue;
                }
                selection.addChild(new ModelIdObjectSelection(relation));
            }
        }
    }

    private void addFKColumns() {
        KeyObject index = this.fkIndex.getLocalFKIndex();
        if (index != null && index.getElementsCollection().size() > 0) {
            ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_FKAssociation.FKColumns"));
            selection.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
            this.addChild(selection);
            for (Column column : index.getElementsCollection()) {
                if (!selection.hasAsParent(column)) {
                    selection.addChild(new ImpA_Column(column, selection, false));
                    continue;
                }
                selection.addChild(new LongNameObjectSelection(column));
            }
        }
    }
}

