/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.logical.ArcPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.TVEntity;

public class Arc
extends ContainerObject
implements ObjectListener {
    private Entity entity;
    private List relations = new ArrayList();
    private int sizeIndex;
    public static final String TYPE_NAME = "Arc";

    public Arc(DesignPart designPart) {
        super(designPart);
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
        if (entity != null && !entity.arcExists(this)) {
            entity.addArc(this);
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void addRelation(Relation relation) {
        if (!this.relations.contains(relation)) {
            this.relations.add(relation);
            relation.addObjectListener(this);
            relation.setArc(this);
        }
    }

    public void removeRelation(Relation relation) {
        this.relations.remove(relation);
        relation.removeObjectListener(this);
        relation.setArc(null);
    }

    public void clearRelations() {
        this.relations.clear();
    }

    public List getRelations() {
        return this.relations;
    }

    public boolean containsRelation(Relation relation) {
        return this.relations.contains(relation);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public int getSizeIndex() {
        return this.sizeIndex;
    }

    public void setSizeIndex(int sizeIndex) {
        this.sizeIndex = sizeIndex;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (object instanceof Relation && event == ObjectChangeEvent.OBJECT_REMOVED) {
            this.removeRelation((Relation)object);
            if (this.relations.size() <= 1) {
                this.remove();
            }
        }
    }

    @Override
    public void remove() {
        Object[] rels = this.relations.toArray();
        for (int i = rels.length - 1; i >= 0; --i) {
            Relation relation = (Relation)rels[i];
            this.removeRelation(relation);
        }
        super.remove();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ArcPropertiesDialogEx dialog = new ArcPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public boolean shouldBeEngineered() {
        return false;
    }

    @Override
    protected void clearStructure() {
    }

    @Override
    public ContainedObject createContainedObject(String id) {
        return null;
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return null;
    }

    @Override
    protected void updateStructure() {
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "arc" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        super.copy(desObject);
        if (desObject instanceof Arc) {
            Arc arc = (Arc)desObject;
            Arc.synchronizeReationships(this, arc, copyMap, remoteObject);
        }
    }

    public static void synchronizeReationships(Arc source, Arc arc, Map copyMap, boolean remoteObject) {
        if (arc.isRemoteObject() || remoteObject || copyMap != null) {
            Object[] oldFkeys = arc.getRelations().toArray();
            ArrayList<Relation> newFkeys = new ArrayList<Relation>();
            for (Relation fk : source.getRelations()) {
                Relation newfk = null;
                if (copyMap != null) {
                    newfk = (Relation)copyMap.get(fk.getObjectID());
                }
                if (newfk == null && (remoteObject || arc.isRemoteObject())) {
                    newfk = (Relation)((LogicalDesign)arc.getDesignPart()).getRelationSet().getObjectByRemoteObjectID(fk.getObjectID());
                }
                if (newfk == null) continue;
                arc.addRelation(newfk);
                newFkeys.add(newfk);
            }
            for (int i = 0; i < oldFkeys.length; ++i) {
                if (newFkeys.contains(oldFkeys[i])) continue;
                arc.removeRelation((Relation)oldFkeys[i]);
            }
        }
    }

    public static boolean isMatchingRelationships(Arc source, Arc arc, Map copyMap) {
        if (source.getRelations().size() != arc.getRelations().size()) {
            return false;
        }
        Object[] oldFkeys = arc.getRelations().toArray();
        ArrayList<Relation> newFkeys = new ArrayList<Relation>();
        for (Relation fk : source.getRelations()) {
            Relation newfk = null;
            if (copyMap != null) {
                newfk = (Relation)copyMap.get(fk.getObjectID());
            }
            if (newfk == null && arc.isRemoteObject()) {
                newfk = (Relation)((LogicalDesign)arc.getDesignPart()).getRelationSet().getObjectByRemoteObjectID(fk.getObjectID());
            }
            if (newfk == null && !arc.isRemoteObject() && (newfk = (Relation)((LogicalDesign)arc.getDesignPart()).getRelationSet().getObjectByID(fk.getObjectID())) == null) {
                newfk = (Relation)((LogicalDesign)arc.getDesignPart()).getRelationSet().getObjectByImportedID(fk.getObjectID());
            }
            if (newfk == null) continue;
            newFkeys.add(newfk);
        }
        if (oldFkeys.length != newFkeys.size()) {
            return false;
        }
        for (int i = 0; i < oldFkeys.length; ++i) {
            if (newFkeys.contains(oldFkeys[i])) continue;
            return false;
        }
        return true;
    }

    public void addToAllDPVs() {
        Entity ent = this.getEntity();
        if (ent == null) {
            return;
        }
        Collection targetDPVs = ent.getAffectedDPVs();
        for (DesignPartView dpv : targetDPVs) {
            TVEntity tvent = (TVEntity)ent.getFirstViewForDPV(dpv);
            if (tvent == null) continue;
            tvent.addArc(this);
        }
    }
}

