/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.FKAttributeManager;
import oracle.dbtools.crest.model.design.logical.InheritanceFKAttributeManager;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.logical.InheritanceRelationPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;

public class InheritanceRelation
extends Relation {
    private FKAttributeManager fkAttributeManager = null;
    public static final String TYPE_NAME = "Hierarchy relation";

    public InheritanceRelation(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isInheritanceRelation() {
        return true;
    }

    @Override
    public void setEntity(int endPoint, Entity entity) {
        super.setEntityInh(endPoint, entity);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.getSourceEntity() != null) {
            this.getSourceEntity().setHierarchicalParent(null);
        }
        this.setTargetEntity(null);
        this.setSourceEntity(null);
    }

    @Override
    public FKAttributeManager getFKAttributeManager() {
        if (this.fkAttributeManager == null) {
            this.fkAttributeManager = new InheritanceFKAttributeManager(this);
        }
        return this.fkAttributeManager;
    }

    @Override
    public Object getSourceCardinality() {
        return "";
    }

    @Override
    public Object getTargetCardinality() {
        return "";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            InheritanceRelationPropertiesDialogEx dialog = new InheritanceRelationPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void addTVRelation(Relation.dpvInfo dpi) {
        if (dpi.tv == null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null) {
            TVInheritanceRelation tvr = new TVInheritanceRelation(this.getDesign().getAppView(), dpi.dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpi.dpv.registerForTreemodel(tvr);
            if (dpi.dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
            }
        } else if (dpi.tv != null && dpi.sourceTV != null && dpi.targetTV != null && dpi.dpv != null && ((TVInheritanceRelation)dpi.tv).getEdge() == null && !ApplicationView.loading) {
            ((TVInheritanceRelation)dpi.tv).addConnection();
        }
    }

    @Override
    public void addTVRelation(TopView tv, TVEntity sourceTV, TVEntity targetTV, DesignPartView dpv) {
        if (tv == null && sourceTV != null && targetTV != null && dpv != null) {
            TVInheritanceRelation tvr = new TVInheritanceRelation(this.getDesign().getAppView(), dpv);
            tvr.setModel(this);
            tvr.setSize(new Dimension(100, 100));
            this.addObjectListener(tvr);
            dpv.registerForTreemodel(tvr);
            if (dpv.isVisible() && !ApplicationView.loading) {
                tvr.addConnection();
            }
        }
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("inheritance id prefix");
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "inheritance" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void setSourceEntity(Entity entity) {
        super.setSourceEntity(entity);
    }

    @Override
    public void setTargetEntity(Entity entity) {
        super.setTargetEntity(entity);
    }

    @Override
    public CandidateKey getSourcePk() {
        return null;
    }

    @Override
    public CandidateKey getTargetPk() {
        return null;
    }

    @Override
    public void setSourcePk(CandidateKey sourcePk) {
    }

    @Override
    public void setTargetPk(CandidateKey targetPk) {
    }
}

