/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;

public abstract class AbstractMDObject
extends DesignObject {
    private String description = "";
    protected List relationConnections = new ArrayList();
    protected List raggedLinkConnections = new ArrayList();
    private Collection allViews = new ArrayList();
    private MultidimensionalDesign multidimensionalDesign;
    private String oracleShortName = "";
    private String oracleLongName = "";
    private String oraclePluralName = "";
    private String nameInOracleAW = "";

    public AbstractMDObject(DesignPart designPart) {
        super(designPart);
        this.multidimensionalDesign = (MultidimensionalDesign)designPart;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    void add(Link.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(null);
    }

    void add(RaggedHLink.Connection connection) {
        this.raggedLinkConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(null);
    }

    void remove(Link.Connection connection) {
        this.relationConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(null);
    }

    void remove(RaggedHLink.Connection connection) {
        this.raggedLinkConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(null);
    }

    void moveToIndex(Link.Connection connection, int index) {
        this.relationConnections.remove(connection);
        this.relationConnections.add(index, connection);
    }

    void moveToIndex(RaggedHLink.Connection connection, int index) {
        this.raggedLinkConnections.remove(connection);
        this.raggedLinkConnections.add(index, connection);
    }

    public Link.Connection[] getAllLinks() {
        return (Link.Connection[])this.relationConnections.toArray(Link.CONNECTION_PROTO_ARRAY);
    }

    public RaggedHLink.Connection[] getAllRaggedHLinks() {
        return (RaggedHLink.Connection[])this.raggedLinkConnections.toArray(RaggedHLink.CONNECTION_PROTO_ARRAY);
    }

    public void removeLinks() {
        for (int i = this.relationConnections.size() - 1; i >= 0; --i) {
            Link.Connection c = (Link.Connection)this.relationConnections.get(i);
            Link link = c.getLink();
            link.getSource().remove(c);
            link.getTargetMDObject().remove(c);
            TVLink tv = (TVLink)link.getTopView();
            tv.remove();
        }
    }

    public void removeRaggedHLinks() {
        for (int i = this.raggedLinkConnections.size() - 1; i >= 0; --i) {
            RaggedHLink.Connection c = (RaggedHLink.Connection)this.raggedLinkConnections.get(i);
            RaggedHLink link = c.getRaggedHLink();
            link.getSource().remove(c);
            link.getTargetMDObject().remove(c);
            TVRaggedHLink tv = (TVRaggedHLink)link.getTopView();
            tv.remove();
        }
    }

    @Override
    public void remove() {
        this.removeLinks();
        this.removeRaggedHLinks();
        this.removeAllViews();
        super.remove();
    }

    public void removeAllViews() {
        TopViewCollection[] tvcar = this.allViews.toArray(new TopViewCollection[0]);
        for (int i = 0; i < tvcar.length; ++i) {
            DesignPartView dpv = tvcar[i].getDPV();
            dpv.getWorkSpace().removeMDObject(this);
            TopView[] tvar = tvcar[i].toArray(new TopView[0]);
            for (int j = 0; j < tvar.length; ++j) {
                dpv.unregisterFromTreemodel(tvar[j]);
                this.removeTopView(tvar[j]);
            }
        }
    }

    @Override
    public TopViewCollection getViewsForDPV(DesignPartView dpv) {
        TopViewCollection tvc2;
        for (TopViewCollection tvc2 : this.allViews) {
            if (tvc2.getDPV() != dpv) continue;
            return tvc2;
        }
        tvc2 = new TopViewCollection();
        tvc2.setDPV(dpv);
        this.allViews.add(tvc2);
        return tvc2;
    }

    @Override
    public void setTopView(TopView tv) {
        this.addTopView(tv);
    }

    @Override
    public TopView getTopView() {
        if (this.allViews.isEmpty()) {
            return null;
        }
        for (TopViewCollection tvc : this.allViews) {
            TopView tv;
            if (tvc.dpv == null || !tvc.dpv.isMainDiagram()) continue;
            if (tvc.isEmpty() && (tv = tvc.dpv.getViewFor(this)) != null) {
                tvc.add(tv);
                return tv;
            }
            Iterator it2 = tvc.iterator();
            if (tvc.size() <= 0) continue;
            return (TopView)it2.next();
        }
        return null;
    }

    public TopView getTopViewByID(String id) {
        TopViewCollection tvc2 = null;
        for (TopViewCollection tvc2 : this.allViews) {
            for (TopView tv : tvc2) {
                if (!id.equalsIgnoreCase(tv.getViewID())) continue;
                return tv;
            }
        }
        return this.getTopView();
    }

    @Override
    public TopView getTopViewByID(DesignPartView dpv, String id, int viewnumber) {
        if (id != null) {
            Collection tvc = this.getAllViews(dpv);
            for (TopView tv : tvc) {
                if (!id.equalsIgnoreCase(tv.getViewID())) continue;
                return tv;
            }
            int i = 0;
            for (TopView tv : tvc) {
                if (viewnumber == i) {
                    tv.setViewNumber(viewnumber);
                    return tv;
                }
                ++i;
            }
        }
        return null;
    }

    public Collection getAllViews(DesignPartView dpv) {
        ArrayList vs = new ArrayList();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (views.size() > 0) {
            Iterator it = views.iterator();
            while (it.hasNext()) {
                vs.add(it.next());
            }
        }
        return vs;
    }

    @Override
    public int getViewNumber(TopView tv) {
        DesignPartView dpv = tv.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (views.isEmpty()) {
            return -100;
        }
        Iterator it = views.iterator();
        int i = 0;
        while (it.hasNext()) {
            TopView t = (TopView)it.next();
            if (t == tv) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void removeViewSynonim(TopView tv) {
        this.removeTopView(tv);
    }

    @Override
    public void resetViewNumbers() {
        for (TopViewCollection tvc : this.allViews) {
            for (TopView tv : tvc) {
                tv.setViewNumber(this.getViewNumber(tv));
            }
        }
    }

    @Override
    public int getTopViewsCount() {
        int count = 0;
        for (TopViewCollection tvc : this.allViews) {
            count += tvc.size();
        }
        return count;
    }

    @Override
    public int getViewsCountForDPV(DesignPartView dpv) {
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.getDPV() != dpv) continue;
            return tvc.size();
        }
        return 0;
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        TopViewCollection tvc = this.getViewsForDPV(dpv);
        return tvc.size() > 0;
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        views.add(view);
        this.addObjectListener(view);
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.getDPV() != dpv) continue;
            if (tvc.size() > 0) {
                return (TopView)tvc.get(0);
            }
            return null;
        }
        return null;
    }

    public void removeTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        views.remove(view);
        if (views.size() == 0) {
            this.allViews.remove(views);
        }
        this.removeObjectListener(view);
    }

    public List getIncomingLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        Link.Connection[] links = this.getAllLinks();
        for (int i = 0; i < links.length; ++i) {
            if (links[i].isSource()) continue;
            result.add(links[i].getLink());
        }
        return result;
    }

    public List getOutgoingLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        Link.Connection[] links = this.getAllLinks();
        for (int i = 0; i < links.length; ++i) {
            if (!links[i].isSource() || links[i].getLink().getSourceMDObject() != this) continue;
            result.add(links[i].getLink());
        }
        return result;
    }

    public Link getFirstLinkToTarget(AbstractMDObject target) {
        for (Link link : this.getOutgoingLinks()) {
            if (link.getTargetMDObject() != target) continue;
            return link;
        }
        return null;
    }

    public List getAllLinksToTarget(AbstractMDObject target) {
        ArrayList<Link> list = new ArrayList<Link>();
        for (Link link : this.getOutgoingLinks()) {
            if (link.getTargetMDObject() != target) continue;
            list.add(link);
        }
        return list;
    }

    public List getAllRollupLinksToTarget(AbstractMDObject target) {
        ArrayList<RollupLink> list = new ArrayList<RollupLink>();
        for (Link link : this.getOutgoingLinks()) {
            if (link.getTargetMDObject() != target || link.getRollupLink() == null) continue;
            list.add(link.getRollupLink());
        }
        return list;
    }

    public String getOracleLongName() {
        return this.oracleLongName;
    }

    public void setOracleLongName(String oracleLongName) {
        this.oracleLongName = oracleLongName;
    }

    public String getOraclePluralName() {
        return this.oraclePluralName;
    }

    public void setOraclePluralName(String oraclePluralName) {
        this.oraclePluralName = oraclePluralName;
    }

    public String getOracleShortName() {
        return this.oracleShortName;
    }

    public void setOracleShortName(String oracleShortName) {
        this.oracleShortName = oracleShortName;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.multidimensionalDesign;
    }

    public String getNameInOracleAW() {
        if ("".equals(this.nameInOracleAW)) {
            return this.getName().replaceAll(" ", "_").toUpperCase();
        }
        return this.nameInOracleAW.toUpperCase();
    }

    public void setNameInOracleAW(String nameInOracleAW) {
        this.nameInOracleAW = nameInOracleAW;
    }

    @Override
    public Collection getAffectedDPVs() {
        HashSet<DesignPartView> col = new HashSet<DesignPartView>();
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.dpv == null || tvc.size() <= 0) continue;
            col.add(tvc.dpv);
        }
        return col;
    }

    public void showPropertyDialog(Dialog owner) {
        this.showPropertyDialog();
    }
}

