/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.data.cursor.CompoundCursor;
import oracle.olapi.data.cursor.Cursor;
import oracle.olapi.data.cursor.IncorrectDataTypeException;
import oracle.olapi.data.cursor.NotSpecifiedException;
import oracle.olapi.data.cursor.ValueCursor;

public class CursorPrintWriter
extends PrintWriter {
    static CursorPrintWriter stdOut = null;

    public CursorPrintWriter(PrintWriter dataWriter) {
        super((Writer)dataWriter, true);
    }

    static CursorPrintWriter getStandardOutput() {
        if (null == stdOut) {
            stdOut = new UncloseablePrintWriter(System.out);
        }
        return stdOut;
    }

    private void _printTuple(Cursor cursor, boolean displayLocVal) {
        if (cursor instanceof CompoundCursor) {
            CompoundCursor compoundCursor = (CompoundCursor)cursor;
            this.print("(");
            Iterator iterOutputs = compoundCursor.getOutputs().iterator();
            Cursor output = (Cursor)iterOutputs.next();
            this._printTuple(output, displayLocVal);
            while (iterOutputs.hasNext()) {
                this.print(",");
                this._printTuple((Cursor)iterOutputs.next(), displayLocVal);
            }
            this.print(",");
            this._printTuple((Cursor)compoundCursor.getValueCursor(), displayLocVal);
            this.print(")");
            this._printParentInfo(cursor);
        } else if (cursor instanceof ValueCursor) {
            ValueCursor valueCursor = (ValueCursor)cursor;
            if (valueCursor.hasCurrentValue()) {
                if (!displayLocVal) {
                    this.print(valueCursor.getCurrentValue());
                } else {
                    int index = 0;
                    Object value = valueCursor.getCurrentValue();
                    if (value instanceof String) {
                        String uVal = valueCursor.getCurrentString();
                        if (uVal.indexOf("::") > 0) {
                            index = uVal.lastIndexOf("::");
                            String lVal = uVal.substring(uVal.lastIndexOf("::") + 2, uVal.length());
                            this.print(lVal);
                        } else {
                            this.print(value);
                        }
                    } else {
                        this.print(value);
                    }
                }
            } else {
                this.print("NA");
            }
            this._printParentInfo(cursor);
        }
    }

    public void printCursor(Cursor rootCursor, boolean displayLocVal) {
        int i = 1;
        do {
            this.print(i++ + ": ");
            this._printTuple(rootCursor, displayLocVal);
            this.println();
            this.flush();
        } while (rootCursor.next());
    }

    private void _printParentInfo(Cursor cursor) {
        try {
            long parentStart = cursor.getParentStart();
            long parentEnd = cursor.getParentEnd();
            this.print("{" + parentStart + "," + parentEnd + "}");
        }
        catch (NotSpecifiedException notSpecifiedException) {
            // empty catch block
        }
    }

    public void printTopBottomResult(ValueCursor valueCursor) {
        int i = 1;
        do {
            String count = i < 10 ? " " + i + ". " : i + ". ";
            try {
                this.println(count + Math.round(valueCursor.getCurrentDouble()));
            }
            catch (IncorrectDataTypeException e) {
                this.println(count + valueCursor.getCurrentValue());
            }
            ++i;
        } while (valueCursor.next());
    }

    public void printAsCrosstab(CompoundCursor rootCursor) {
        List outputs = rootCursor.getOutputs();
        int nOutputs = outputs.size();
        Iterator outputIter = outputs.iterator();
        while (outputIter.hasNext()) {
            ((Cursor)outputIter.next()).setPosition(1L);
        }
        Cursor colCursor = (Cursor)outputs.get(nOutputs - 1);
        Cursor rowCursor = (Cursor)outputs.get(nOutputs - 2);
        ArrayList pageCursors = new ArrayList();
        for (int i = 0; i < nOutputs - 2; ++i) {
            pageCursors.add(outputs.get(i));
        }
        ValueCursor dataCursor = rootCursor.getValueCursor();
        this.printPages(pageCursors, 0, rowCursor, colCursor, dataCursor);
    }

    private void printPages(List pageCursors, int pageIndex, Cursor rowCursor, Cursor colCursor, ValueCursor dataCursor) {
        Cursor pageCursor = (Cursor)pageCursors.get(pageIndex);
        do {
            if (pageIndex == pageCursors.size() - 1) {
                this.printPageHeadings(pageCursors);
                this.printColumnHeadings(colCursor);
                this.printRows(rowCursor, colCursor, dataCursor);
                this.println();
                this.println();
                continue;
            }
            this.printPages(pageCursors, pageIndex + 1, rowCursor, colCursor, dataCursor);
        } while (pageCursor.next());
        pageCursor.setPosition(1L);
    }

    private void printPageHeadings(List pageCursors) {
        for (Cursor cursor : pageCursors) {
            if (cursor instanceof CompoundCursor) {
                CompoundCursor cc = (CompoundCursor)cursor;
                List outputs = cc.getOutputs();
                ValueCursor output = (ValueCursor)outputs.get(0);
                String value = output.getCurrentString();
                this.println(value);
                continue;
            }
            ValueCursor vc = (ValueCursor)cursor;
            String value = vc.getCurrentString();
            this.println(this.getLocalValue(value));
        }
        this.println();
    }

    private void printColumnHeadings(Cursor colCursor) {
        do {
            this.print("\t");
            if (colCursor instanceof CompoundCursor) {
                CompoundCursor cc = (CompoundCursor)colCursor;
                List outputs = cc.getOutputs();
                ValueCursor output = (ValueCursor)outputs.get(0);
                String value = output.getCurrentString();
                this.print(value);
                continue;
            }
            ValueCursor vc = (ValueCursor)colCursor;
            String value = vc.getCurrentString();
            this.print(this.getLocalValue(value));
        } while (colCursor.next());
        this.println();
        colCursor.setPosition(1L);
    }

    private void printRows(Cursor rowCursor, Cursor colCursor, ValueCursor dataCursor) {
        do {
            if (rowCursor instanceof CompoundCursor) {
                CompoundCursor cc = (CompoundCursor)rowCursor;
                List outputs = cc.getOutputs();
                ValueCursor output = (ValueCursor)outputs.get(0);
                String value = output.getCurrentString();
                this.print(value);
            } else {
                ValueCursor vc = (ValueCursor)rowCursor;
                String value = vc.getCurrentString();
                this.print(this.getLocalValue(value));
            }
            this.print("\t");
            do {
                try {
                    if (!dataCursor.hasCurrentValue()) {
                        this.print("NULL");
                    } else {
                        this.print(Math.round(dataCursor.getCurrentDouble()));
                    }
                }
                catch (IncorrectDataTypeException e) {
                    this.print(dataCursor.getCurrentValue());
                }
                this.print("\t");
            } while (colCursor.next());
            this.println();
            colCursor.setPosition(1L);
        } while (rowCursor.next());
        rowCursor.setPosition(1L);
    }

    protected String getLocalValue(String uniqueValue) {
        int index = 0;
        if (uniqueValue.indexOf("::") > 0) {
            index = uniqueValue.lastIndexOf("::");
            String localValue = uniqueValue.substring(uniqueValue.lastIndexOf("::") + 2, uniqueValue.length());
            return localValue;
        }
        return uniqueValue;
    }

    private static class UncloseablePrintWriter
    extends CursorPrintWriter {
        public UncloseablePrintWriter(OutputStream out) {
            super(new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(out)), true));
        }

        @Override
        public void close() {
        }
    }
}

