/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.EngineerFromOracle;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FromOracleModelSelector
extends CustomDialog {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign mdm;
    private String schema = "";
    private JButton okButton;
    private JSpinner jspinner;
    private boolean useFactTables;
    private JCheckBox chbFactTablesOnly;
    private JComboBox cbSearch;
    private Object[] searchList = new Object[]{EngineerFromOracle.USE_FK, EngineerFromOracle.USE_COLUMN_NAMES};

    public FromOracleModelSelector(ApplicationView appView, MultidimensionalDesign mdm) {
        super(appView);
        this.mdm = mdm;
        this.design = appView.getCurrentDesign();
        this.init();
    }

    private void init() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.okButton = new JButton(Messages.getString("OracleModelSelector.OK"));
        this.okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FromOracleModelSelector.this.result = true;
                FromOracleModelSelector.this.physicalDesign = (RelationalDesign)FromOracleModelSelector.this.cbRelDes.getSelectedItem();
                FromOracleModelSelector.this.storageDesign = (StorageDesign)FromOracleModelSelector.this.cbStorage.getSelectedItem();
                if (FromOracleModelSelector.this.result) {
                    FromOracleModelSelector.this.dialog.dispose();
                }
            }
        });
        JButton cancelButton = new JButton(Messages.getString("OracleModelSelector.Cancel"));
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FromOracleModelSelector.this.result = false;
                FromOracleModelSelector.this.dialog.dispose();
            }
        });
        JPanel bottom = new JPanel();
        bottom.add(this.okButton);
        bottom.add(cancelButton);
        JPanel modelsPanel = new JPanel(new SpringLayout());
        modelsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("FromOracleModelSelector.OracleModel")));
        modelsPanel.setPreferredSize(new Dimension(420, 80));
        JLabel lbRelD = new JLabel(Messages.getString("OracleModelSelector.RelationalModel"));
        ArrayList rlist = new ArrayList();
        this.design.getRelationalDesigns().addAllElementsTo(rlist);
        lbRelD.setPreferredSize(new Dimension(150, 20));
        this.cbRelDes = new JComboBox<Object>(rlist.toArray());
        this.cbRelDes.setPreferredSize(new Dimension(220, 20));
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(new Dimension(220, 20));
        if (this.mdm.getBoundModel() != null && this.mdm.getBoundModel() instanceof RelationalDesign) {
            this.cbRelDes.setSelectedItem(this.mdm.getBoundModel());
            this.cbRelDes.setEnabled(false);
        }
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object ob = FromOracleModelSelector.this.cbRelDes.getSelectedItem();
                if (ob != null && ob instanceof RelationalDesign) {
                    RelationalDesign phd = (RelationalDesign)ob;
                    ArrayList<StorageDesign> rlist = new ArrayList<StorageDesign>();
                    StorageDesign[] stds = phd.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < stds.length; ++i) {
                        StorageDesign sd = stds[i];
                        if (!(sd instanceof StorageDesignOracle)) continue;
                        rlist.add(sd);
                    }
                    FromOracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(rlist.toArray()));
                    if (rlist.size() > 0) {
                        FromOracleModelSelector.this.okButton.setEnabled(true);
                    } else {
                        FromOracleModelSelector.this.okButton.setEnabled(false);
                    }
                } else if (ob == null) {
                    FromOracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        if (rlist.size() > 0) {
            this.cbRelDes.setSelectedItem(rlist.get(0));
        }
        JLabel lbStoreD = new JLabel(Messages.getString("OracleModelSelector.PhysicalOracleModel"));
        lbStoreD.setPreferredSize(new Dimension(150, 20));
        modelsPanel.add(lbRelD);
        modelsPanel.add(this.cbRelDes);
        modelsPanel.add(lbStoreD);
        modelsPanel.add(this.cbStorage);
        CommonUtil.setObjectConstraints((SpringLayout)modelsPanel.getLayout(), lbRelD, 5, 5);
        CommonUtil.setObjectConstraints((SpringLayout)modelsPanel.getLayout(), this.cbRelDes, 180, 5);
        CommonUtil.setObjectConstraints((SpringLayout)modelsPanel.getLayout(), lbStoreD, 5, 30);
        CommonUtil.setObjectConstraints((SpringLayout)modelsPanel.getLayout(), this.cbStorage, 180, 30);
        JPanel optionsPanel = new JPanel(new SpringLayout());
        optionsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("FromOracleModelSelector.CubeDiscoveryOptions")));
        optionsPanel.setPreferredSize(new Dimension(420, 100));
        SpinnerNumberModel spmodel = new SpinnerNumberModel(3, 3, 100, 1);
        this.jspinner = new JSpinner(spmodel);
        JLabel lbDimNumber = new JLabel(Messages.getString("FromOracleModelSelector.MinimumDimensions"));
        lbDimNumber.setPreferredSize(new Dimension(150, 20));
        this.jspinner.setPreferredSize(new Dimension(220, 20));
        JLabel lbSearch = new JLabel(Messages.getString("FromOracleModelSelector.MatchMethod"));
        lbSearch.setPreferredSize(new Dimension(150, 20));
        this.cbSearch = new JComboBox<Object>(this.searchList);
        this.cbSearch.setPreferredSize(new Dimension(220, 20));
        this.chbFactTablesOnly = new JCheckBox(Messages.getString("FromOracleModelSelector.UseFactEntitiesOnly"));
        optionsPanel.add(lbDimNumber);
        optionsPanel.add(this.jspinner);
        optionsPanel.add(lbSearch);
        optionsPanel.add(this.cbSearch);
        optionsPanel.add(this.chbFactTablesOnly);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), lbDimNumber, 5, 5);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.jspinner, 180, 5);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), lbSearch, 5, 30);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.cbSearch, 180, 30);
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.chbFactTablesOnly, 5, 55);
        jpanel.add((Component)modelsPanel, "North");
        jpanel.add((Component)optionsPanel, "South");
        this.add((Component)jpanel, "Center");
        this.add((Component)bottom, "South");
    }

    public boolean showDialog() {
        this.result = false;
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.mdm;
    }

    public int getMinDimensions() {
        Object obj = this.jspinner.getValue();
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 3;
    }

    public boolean isUseFactTablesOnly() {
        return this.useFactTables;
    }

    public String getSearchMethod() {
        return (String)this.cbSearch.getSelectedItem();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("FromOracleModelSelector.SelectOracleModel"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setPreferredSize(new Dimension(420, 240));
            this.dialog.getContentPane().add(this);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }
}

