/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.AbstractRDBMSObject;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.util.GUID;

public class RDBMSSite
extends AbstractRDBMSObject
implements Comparable {
    private RDBMSType type;
    private String name;
    private boolean isDefault = false;
    private String objectID = new GUID().toString();
    private int pathID = 0;
    private RDBMSSiteSet set;
    private boolean designLevel = false;

    public RDBMSSite(String name, Design design) {
        this.name = name;
    }

    public RDBMSSite(String name, RDBMSType type, Design design) {
        this.name = name;
        this.type = type;
    }

    public RDBMSSite(RDBMSSite site) {
        this.name = site.name;
        this.type = site.type;
        this.isDefault = site.isDefault;
        this.objectID = site.objectID;
        this.pathID = site.pathID;
        this.designLevel = site.designLevel;
    }

    public RDBMSSite(String name, RDBMSType type, boolean isDefault, String objectID, int pathID, boolean designLevel) {
        this.name = name;
        this.type = type;
        this.isDefault = isDefault;
        this.objectID = objectID;
        this.pathID = pathID;
        this.designLevel = designLevel;
    }

    public void setType(RDBMSType type) {
        if (type != null && !type.equals(this.type) && this.set != null) {
            this.set.setDirty(true);
        }
        this.type = type;
    }

    public RDBMSType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && !name.equals(this.name) && this.set != null) {
            this.set.setDirty(true);
        }
        this.name = name;
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        if (objectID != null && !"".equalsIgnoreCase(objectID)) {
            this.objectID = objectID;
        }
    }

    public String getShortObjectID() {
        int pos;
        if (this.objectID != null && !"".equalsIgnoreCase(this.objectID) && (pos = this.objectID.indexOf(45)) > -1) {
            String s1 = this.objectID.substring(0, pos);
            pos = this.objectID.lastIndexOf(45);
            String s2 = this.objectID.substring(pos + 1);
            return s1 + '-' + s2;
        }
        return this.objectID;
    }

    public String toString() {
        return this.getLongName();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public int getPathID() {
        if (this.pathID == 0) {
            this.pathID = this.set.nextIndex();
        }
        return this.pathID;
    }

    public void setPathID(int pathID) {
        this.pathID = pathID;
    }

    public String getPathIDString() {
        return String.valueOf(this.getPathID());
    }

    public void setRDBMSSiteSet(RDBMSSiteSet set) {
        this.set = set;
    }

    public boolean isDesignLevel() {
        return this.designLevel;
    }

    public void setDesignLevel(boolean designLevel) {
        this.designLevel = designLevel;
    }

    public void setTypeID(int id) {
        RDBMSType rdbmsType = Design.getDefaultRDBMSTypeSet().get(id);
        if (rdbmsType == null) {
            rdbmsType = StorageDesignOraclev11g.RDBMS_TYPE;
        }
        this.setType(rdbmsType);
    }

    public int getTypeID() {
        return this.getType().getType();
    }

    public void copyTo(RDBMSSite site) {
        site.name = this.name;
        site.type = this.type;
        site.isDefault = this.isDefault;
        site.pathID = this.pathID;
        site.designLevel = this.designLevel;
    }
}

