/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Map;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;

public class ReadRequest {
    private StorageDesign storageDesign;
    private String id;
    private StorageObjectSet storageObjectSet;
    private RelationalObjectProxySet proxySet;
    private StorageObject storageObject = null;
    private boolean requestLock = true;
    private String name;
    private String dataBaseName;
    private boolean isTopLevelObject = true;

    public ReadRequest(StorageDesign storageDesign, String id) {
        this.storageDesign = storageDesign;
        this.id = id;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public String getObjectName() {
        return this.id;
    }

    public String getObjectId() {
        return this.id;
    }

    public boolean isRequestFor(StorageDesign storageDesign) {
        return this.isRequestFor(storageDesign.getRDBMSSite());
    }

    public boolean isRequestFor(RDBMSSite site) {
        return this.getStorageDesign().getRDBMSSite().equals(site);
    }

    public boolean isRequestFor(RDBMSType type) {
        return this.getStorageDesign().getRDBMSType().equals(type);
    }

    public void setRequestLock(boolean value) {
        this.requestLock = value;
    }

    public boolean getRequestLock() {
        return this.requestLock;
    }

    public void setObjectSet(Object objectSet) {
        if (objectSet instanceof StorageObjectSet) {
            this.storageObjectSet = (StorageObjectSet)objectSet;
        } else if (objectSet instanceof RelationalObjectProxySet) {
            this.proxySet = (RelationalObjectProxySet)objectSet;
        } else {
            throw new IllegalArgumentException("GenericRXMLStorageObject accepts a StorageObjectSet or a PhysicalObjectProxySet only");
        }
    }

    protected StorageObject createObject(String id) {
        if (this.proxySet != null) {
            return this.createProxy(id);
        }
        if (this.storageObjectSet != null) {
            return this.createStorageObject(id);
        }
        throw new IllegalStateException("Either a PhysicalObjectProxySet or a StorageObjectSet instance should be set");
    }

    protected RelationalObjectProxy createProxy(String id) {
        if (this.proxySet != null) {
            return this.proxySet.getProxy(id);
        }
        return null;
    }

    protected StorageObject createStorageObject(String id) {
        if (this.storageObjectSet != null) {
            StorageObject result = (StorageObject)this.storageObjectSet.getById(id);
            if (result != null) {
                return result;
            }
            if (this.storageDesign.getDesign().isMerging() && this.isTopLevelObject && this.name != null && this.name.length() > 0 && (result = this.dataBaseName != null ? this.storageObjectSet.getByNameAndDatabase(this.name, this.dataBaseName) : (StorageObject)this.storageObjectSet.getByName(this.name)) != null) {
                this.storageDesign.getCorrespondenceMap().put(id, result);
                Map revmap = this.storageDesign.getReverseMap();
                if (revmap != null) {
                    revmap.put(result.getObjectID(), id);
                }
                return result;
            }
            return (StorageObject)this.storageObjectSet.createElement(id);
        }
        return null;
    }

    public StorageObject getStorageObject() {
        if (this.storageObject == null) {
            this.storageObject = this.createStorageObject(this.id);
        }
        return this.storageObject;
    }

    public void setStorageObject(StorageObject storageObject) {
        if (this.storageObject != null && this.storageObject != storageObject) {
            throw new IllegalStateException("Changing StorageObject instance on read request is not allowed");
        }
        this.storageObject = storageObject;
    }

    public String toString() {
        return new StringBuffer("Read request for <").append(this.id).append("> in Storage Design <").append(this.storageDesign.getLongName()).append(">").toString();
    }

    public boolean hasObjectSet() {
        return this.proxySet != null || this.storageObjectSet != null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTopLevelObject(boolean isTopLevelObject) {
        this.isTopLevelObject = isTopLevelObject;
    }

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    public void setDataBaseName(String dataBaseName) {
        this.dataBaseName = dataBaseName;
    }
}

