/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;

public class TableSpaceSetDB2
extends StorageObjectSet {
    protected static final Object[] PROTO = new TableSpaceDB2[0];
    private boolean createDefaultTableSpaces = false;

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "TS";
    }

    public TableSpaceDB2 createTableSpace() {
        return this.createTableSpace(null);
    }

    public TableSpaceDB2 createTableSpace(String id) {
        TableSpaceDB2 tspace = new TableSpaceDB2(this.getStorageDesign());
        tspace.setObjectID(id);
        tspace.setName(this.createName());
        tspace.setDesign(this.getDesign());
        this.add(tspace);
        if (!this.getStorageDesign().isLoading() && !this.getStorageDesign().getDesign().getAppView().isImporting()) {
            String stName;
            if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace()) {
                StorageTemplateDB2 template = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                tspace.setStorageTemplate(template);
            } else if (this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerTS() && (stName = this.getDesign().getAppView().getSettings().getDefaultTSStorageTemplateName()) != null && !"".equalsIgnoreCase(stName)) {
                StorageTemplateDB2 template = (StorageTemplateDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().getByName(stName);
                if (template == null) {
                    template = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                    template.setName(stName);
                }
                if (template != null) {
                    tspace.setStorageTemplate(template);
                }
            }
        }
        return tspace;
    }

    @Override
    public ModelIDObject createElement(String id) {
        return this.createTableSpace(id);
    }

    public void setCreateDefaultTableSpaces(boolean value) {
        this.createDefaultTableSpaces = value;
    }

    public boolean getCreateDefaultTableSpaces() {
        return this.createDefaultTableSpaces;
    }

    public TableSpaceDB2 getOrCreateTablespace(String database, String name) {
        String dbName = database;
        if ("".equals(database)) {
            dbName = "DSNDB04";
        }
        for (TableSpaceDB2 t : this) {
            if (!t.getName().equalsIgnoreCase(name) || t.getDataBase() == null || !t.getDataBase().getName().equalsIgnoreCase(dbName)) continue;
            return t;
        }
        TableSpaceDB2 tablespace = this.createTableSpace();
        tablespace.setName(name);
        DataBaseDB2 db = (DataBaseDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().getByName(dbName);
        if (db == null && !"DSNDB04".equalsIgnoreCase(dbName)) {
            db = ((AbstractStorageDesignDB2)this.getStorageDesign()).getDataBaseSet().createDataBase();
            db.setName(dbName);
        }
        tablespace.setDataBase(db);
        return tablespace;
    }
}

