/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.SequenceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.SequencePropertyDialogUDBv81;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class SequenceUDBv81
extends SequenceUDB
implements PropertiesPropagator {
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    @Override
    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(SequenceUDBv81.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SequencePropertyDialogUDBv81 dialog = new SequencePropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("DataType", this, "getDatatype", "setDatatype", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Start with", this, "getStartWith", "setStartWith", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Increment By", this, "getIncrementBy", "setIncrementBy", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Min Value", this, "getMinValue", "setMinValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Max Value", this, "getMaxValue", "setMaxValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cycle", this, "getCycle", "setCycle", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cache", this, "getCache", "setCache", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Order", this, "getOrder", "setOrder", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SequenceUDBv81 sequence = null;
        StorageObject stObject = (StorageObject)((StorageDesignUDBv81)targetDesign).getSequenceSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                sequence = (SequenceUDBv81)stObject;
            }
        } else {
            sequence = (SequenceUDBv81)((StorageDesignUDBv81)targetDesign).getSequenceSet().createSequence();
        }
        if (sequence != null) {
            sequence.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv81 scheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (scheme == null) {
                    SchemaUDBv81 newScheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().createSchema();
                    newScheme.setName(this.getSchema().getName());
                    newScheme.setRawObject(true);
                    sequence.setSchema(newScheme);
                    sequence.setOwner(newScheme.getOwner());
                } else {
                    sequence.setSchema(scheme);
                    sequence.setOwner(scheme.getOwner());
                }
            }
            sequence.setDatatype(this.getDatatype());
            sequence.setStartWith(this.getStartWith());
            sequence.setIncrementBy(this.getIncrementBy());
            sequence.setMinValue(this.getMinValue());
            sequence.setMaxValue(this.getMaxValue());
            sequence.setCycle(this.getCycle());
            sequence.setCache(this.getCache());
            sequence.setOrder(this.getOrder());
            sequence.setComment(this.getComment());
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEQUENCE_ICON", 16);
    }
}

