/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRConstraintNameOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "1136807F-D7B9-780C-87C4-FAFCDA457A1F";

    public DRConstraintNameOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRConstraintNameOracle.CheckConstraintNames"));
        this.setDescription(Messages.getString("DRConstraintNameOracle.ConstraintsShouldHaveUniqueNames"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        StorageDesignOracle storage = (StorageDesignOracle)object;
        if (storage.getTableCheckConstraintSet().hasDublicateNames()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRConstraintNameOracle.DublicateTableCheckConstraintNames"));
        }
        if (storage.getPKProxySet().hasDublicateNames()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRConstraintNameOracle.DublicatePrimaryKeyNames"));
        }
        if (storage.getUniqueSet().hasDublicateNames()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRConstraintNameOracle.DublicateUniqueKeyNames"));
        }
        if (storage.getFKProxySet().hasDublicateNames()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRConstraintNameOracle.DublicateFKNames"));
        }
        if (storage.getNotNullConstraintSet().hasDublicateNames()) {
            return CheckResult.createFailed(object, this, Messages.getString("DRConstraintNameOracle.DublicateNotNullConstraintNames"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRConstraintNameOracle.ConstraintsForEverySchemaHaveUniqueNames"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "1136807F-D7B9-780C-87C4-FAFCDA457A1F";
    }
}

