/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRNodeGroupName
extends AbstractDRStorageDesign {
    private final String RULE_ID = "C3C826D2-7CAE-180D-A08B-FDC28C1B4269";

    public DRNodeGroupName(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRNodeGroupName.CheckIfNodeGroupNameIsValid"));
        this.setDescription(Messages.getString("DRNodeGroupName.NodeGroupNameShouldBeValid"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        NodeGroupUDB nodegroup = (NodeGroupUDB)object;
        if (nodegroup.getName().toUpperCase().startsWith("IBM") && nodegroup.getName().equalsIgnoreCase("IBMDEFAULTGROUP") && nodegroup.getName().equalsIgnoreCase("IBMTEMPGROUP")) {
            return CheckResult.createWarning(nodegroup, this, Messages.getString("DRNodeGroupName.NodeGroupNameStartsWithIBM"));
        }
        if (nodegroup.getName().toUpperCase().startsWith("SYS")) {
            return CheckResult.createWarning(nodegroup, this, Messages.getString("DRNodeGroupName.NodeGroupNameStartsWithSYS"));
        }
        if (nodegroup.getName().toUpperCase().startsWith("DBM")) {
            return CheckResult.createWarning(nodegroup, this, Messages.getString("DRNodeGroupName.NodeGroupNameStartsWithDBM"));
        }
        if (nodegroup.getName().indexOf(32) > -1) {
            return CheckResult.createWarning(nodegroup, this, Messages.getString("DRNodeGroupName.NodeGroupNameContainsBlank"));
        }
        return CheckResult.createOk(nodegroup, this, Messages.getString("DRNodeGroupName.NodeGroupNameIsValid"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "C3C826D2-7CAE-180D-A08B-FDC28C1B4269";
    }
}

