/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetaFileLoader {
    private static final Logger LOGGER;
    public static boolean standalone;
    public static String standaloneBaseDir;
    public static DocumentBuilder DOCUMENT_BUILDER;

    public static void main(String[] args) {
    }

    public static Document loadFile(String className) {
        Document doc = null;
        if (DOCUMENT_BUILDER != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(MetaFileLoader.getFileName(className));
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (is != null) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)is, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("MetaFileLoader: InputStreamReader(is, XMLConstants.ENCODING_UTF8)", e);
                }
                if (reader != null) {
                    InputSource inputSource = new InputSource(reader);
                    try {
                        doc = DOCUMENT_BUILDER.parse(inputSource);
                    }
                    catch (SAXException e) {
                        LOGGER.error("MetaFileLoader: DOCUMENT_BUILDER.parse(inputSource)", e);
                    }
                    catch (IOException e) {
                        LOGGER.error("MetaFileLoader: InputSource(reader)", e);
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("MetaFileLoader: reader.close()", e);
                    }
                }
            }
        }
        return doc;
    }

    public static Document loadDocForFile(String fileName) {
        Document doc = null;
        if (DOCUMENT_BUILDER != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(fileName);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (is != null) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)is, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("MetaFileLoader: InputStreamReader(is, XMLConstants.ENCODING_UTF8)", e);
                    System.out.println("InputStreamReader(is) error in file " + fileName + "\n" + e.getMessage());
                }
                if (reader != null) {
                    InputSource inputSource = new InputSource(reader);
                    try {
                        try {
                            doc = DOCUMENT_BUILDER.parse(inputSource);
                        }
                        catch (SAXException e) {
                            LOGGER.error("MetaFileLoader: DOCUMENT_BUILDER.parse(inputSource)", e);
                            System.out.println("parse error in file " + fileName + "\n" + e.getMessage());
                        }
                        catch (IOException e) {
                            LOGGER.error("MetaFileLoader: InputSource(reader)", e);
                            System.out.println("InputSource(reader) error in file " + fileName + "\n" + e.getMessage());
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LOGGER.error("MetaFileLoader: reader.close()", e);
                            System.out.println("reader.close() error in file " + fileName + "\n" + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("MetaFileLoader: exception in file " + fileName + "\n", e);
                        System.out.println("exception in file " + fileName + "\n" + e.getMessage());
                    }
                }
            }
        }
        return doc;
    }

    private static String getFileName(String className) {
        int ind = className.lastIndexOf(46) + 1;
        String fname = className.substring(ind);
        if ((ind = fname.indexOf(36)) > -1) {
            fname = fname.replace('$', '.');
        }
        String rootPath = !standalone ? (!ApplicationView.isGUIMode() ? ApplicationView.dmInternalsDistDir : Extension.getBaseDir()) : standaloneBaseDir;
        File fPath = new File(rootPath);
        fPath = new File(fPath, "xmlmetadata");
        return new File(fPath, fname + ".xml").getAbsolutePath();
    }

    static {
        standalone = false;
        standaloneBaseDir = "D:/Projects/Crest/ide/datamodeler";
        LOGGER = new Logger(MetaFileLoader.class);
        DOCUMENT_BUILDER = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DOCUMENT_BUILDER = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }
}

