/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLToObjectSAXTransformer
extends DefaultHandler
implements MDXMLConstants {
    protected ClassDescription classDescription;
    protected Class objectClass;
    protected MetaDataManager metaDataManager;
    protected MDTransformationManager transformationManager;
    public static boolean includeID = true;
    public static boolean includeLoggingProps = true;
    public static boolean SKP_DEFAULTS = true;
    public static boolean SKP_CLASS_NAME = false;
    private static final Logger LOGGER = new Logger(PropertyMapWrapper.class);
    private Stack stack = new Stack();
    private Stack ctxStack = new Stack();
    CharArrayWriter text = new CharArrayWriter();
    private PContext curCtx;
    private boolean initial = false;
    SAXParser saxParser = null;

    public XMLToObjectSAXTransformer(MetaDataManager metaDataManager) {
        this.metaDataManager = metaDataManager;
    }

    public static void main(String[] args) {
    }

    public void setProperty(Object object, String value, ClassDescription.PropertyDescription pd) {
        Method method = pd.setter;
        if (method != null) {
            Object obj = null;
            try {
                if (pd.propertyTranslator != null) {
                    obj = pd.propertyTranslator.translateFromString(value);
                } else if (object instanceof ID_ObjectPropertyTranslator) {
                    obj = ((ID_ObjectPropertyTranslator)object).translateIdToObject(pd.name, value);
                }
                method.invoke(object, obj);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for setter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for setter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for setter", e);
            }
            catch (Exception e) {}
        } else if (object instanceof PropertyMap) {
            ((PropertyMap)object).setProperty(pd.name, value);
        }
    }

    public void setNestedProperty(Object object, Object value, ClassDescription.PropertyDescription pd) {
        Method method = pd.setter;
        if (method != null && value != null) {
            try {
                method.invoke(object, value);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for setter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for setter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for setter", e);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void setRelatedProperty(Object object, ClassDescription.PropertyDescription pd) {
        Method method;
        if (pd.relatedProperty != null && (method = pd.relatedProperty.setter) != null) {
            try {
                Object obj = null;
                if (pd.relatedProperty.propertyTranslator != null) {
                    obj = pd.relatedProperty.propertyTranslator.translateFromString(pd.relatedValue);
                }
                method.invoke(object, obj);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for setter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for setter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for setter", e);
            }
        }
    }

    public String getProperty(Object object, ClassDescription.PropertyDescription pd) {
        Method method = pd.getter;
        if (method != null) {
            try {
                Object result = method.invoke(object, new Object[0]);
                if (pd.propertyTranslator != null) {
                    return pd.propertyTranslator.translateToString(result);
                }
                if (object instanceof ID_ObjectPropertyTranslator) {
                    String id = ((ID_ObjectPropertyTranslator)object).translateObjectToID(pd.name, result);
                    return id;
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
            catch (Exception e) {}
        } else if (object instanceof PropertyMap) {
            return ((PropertyMap)object).getProperty(pd.name);
        }
        return null;
    }

    public static Object getObjectForProperty(Object composite, ClassDescription.PropertyDescription pd) {
        Method method = pd.getter;
        if (method != null) {
            try {
                Object result = method.invoke(composite, new Object[0]);
                return result;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
        }
        return null;
    }

    public void setObjectForProperty(Object composite, ClassDescription.PropertyDescription pd, Object property) {
        Method method = pd.setter;
        if (method != null) {
            try {
                method.invoke(composite, property);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
        }
    }

    public static Object getCollection(Object composite, ClassDescription.CollectionDescription cold) {
        Method method = cold.getter;
        if (method != null) {
            try {
                Object result = method.invoke(composite, new Object[0]);
                return result;
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
        }
        return null;
    }

    Object createObject(Object container, Method method) {
        if (container != null && method != null) {
            try {
                return method.invoke(container, (Object[])null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    Object createItem(Object container, Method method) {
        if (container != null && method != null) {
            try {
                return method.invoke(container, (Object[])null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    void applyList(Object container, Method method, List list) {
        if (container != null && method != null) {
            try {
                method.invoke(container, list);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    void moveContained(Object container, Method method, Object contained, Integer position) {
        if (container != null && method != null && contained != null) {
            try {
                method.invoke(container, contained, position);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    Object getItemByID(Object container, Method method, String id) {
        if (container != null && method != null) {
            try {
                return method.invoke(container, id);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return null;
    }

    void removeItem(Object container, Method method, Object item) {
        if (container != null && method != null) {
            try {
                method.invoke(container, item);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    void addItem(Object container, Method method, Object item) {
        if (container != null && method != null) {
            try {
                method.invoke(container, item);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    void removeProperty(Object container, Method method) {
        if (container != null && method != null) {
            try {
                method.invoke(container, (Object[])null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public ClassDescription getClassDescription() {
        return this.classDescription;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public MDTransformationManager getTransformationManager() {
        return this.transformationManager;
    }

    public void setDefaultProperty(Object object, ClassDescription.PropertyDescription pd) {
        if (pd.isContainedClass()) {
            this.removeProperty(object, pd.removeProperty);
        } else if (pd.isPropertyMap) {
            if (object instanceof PropertyMap) {
                PropertyMap pmap = (PropertyMap)object;
                pmap.clearProperties();
            } else {
                this.removeProperty(object, pd.removeProperty);
            }
        } else if (pd.isMap) {
            if (object instanceof Map) {
                Map pmap = (Map)object;
                pmap.clear();
            } else {
                this.removeProperty(object, pd.removeProperty);
            }
        } else if (!"".equals(pd.defaultValue)) {
            this.setProperty(object, pd.defaultValue, pd);
        } else if (pd.isStringClass()) {
            String prop = null;
            try {
                prop = this.getProperty(object, pd);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (prop != null && !"".equals(prop)) {
                this.setProperty(object, "", pd);
            }
        }
    }

    public Collection getObjectList(Object sourceCol, ClassDescription.CollectionDescription cold) {
        if (sourceCol instanceof Collection) {
            return (Collection)sourceCol;
        }
        if (sourceCol instanceof ElementSet) {
            ArrayList list = new ArrayList();
            ((ElementSet)sourceCol).addAllElementsTo(list);
            if (cold.isProxyitem) {
                Collections.sort(list, ModelIDObjectSet.OBJECT_ID_COMPARATOR);
            }
            return list;
        }
        return null;
    }

    public void invokeMethod(Object object, Method method) {
        if (method != null) {
            try {
                method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("No access rights for getter method", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Illegal argument for getter", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation error for getter", e);
            }
        }
    }

    public boolean canProcessCollectionItem(ClassDescription.CollectionDescription cold) {
        return (cold.createItem != null || cold.itemIsRef || cold.isProxyitem || cold.isObjectViewItem || cold.isTVDiagramItem || cold.isTVConnectorItem || cold.isPhysicalModelItem) && !cold.isMapItem;
    }

    public static Iterator getObjectsIterator(Object object, ClassDescription.CollectionDescription cold) {
        Object sourceCol = XMLToObjectSAXTransformer.getCollection(object, cold);
        if (sourceCol instanceof Collection) {
            return ((Collection)sourceCol).iterator();
        }
        if (sourceCol instanceof ModelIDObjectSet) {
            return ((ModelIDObjectSet)sourceCol).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected Element getFirstElementByTagName(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            Element elem = (Element)nodes.item(0);
            return elem;
        }
        return null;
    }

    void orderAndClearList(Object container, ClassDescription.CollectionDescription cold, List oldElements, List elements) {
        if (cold.isProxyitem) {
            return;
        }
        for (Object obj : oldElements) {
            if (elements.contains(obj)) continue;
            if (cold.removeItem != null) {
                this.removeItem(container, cold.removeItem, obj);
                continue;
            }
            if (obj instanceof ModelIDObject && !cold.itemIsRef) {
                if (obj instanceof PermissionsOracle) continue;
                ((ModelIDObject)obj).remove();
                continue;
            }
            if (!(obj instanceof ContainerView)) continue;
            ((ContainerView)obj).remove(false);
        }
        if (cold.applyList != null) {
            this.applyList(container, cold.applyList, elements);
        } else if (cold.moveMethod != null) {
            for (int i = 0; i < elements.size(); ++i) {
                Object obj = elements.get(i);
                this.moveContained(container, cold.moveMethod, obj, i);
            }
        } else if (cold.nativeList && cold.orderTheList) {
            Object obj;
            obj = XMLToObjectSAXTransformer.getCollection(container, cold);
            if (obj instanceof List) {
                List target = (List)obj;
                target.clear();
                target.addAll(elements);
            }
        } else if (cold.isIDObjectSet) {
            // empty if block
        }
    }

    List getListWithElements(Object container, ClassDescription.CollectionDescription cold) {
        Object col = XMLToObjectSAXTransformer.getCollection(container, cold);
        if (col != null) {
            ElementSet idset;
            if (col instanceof Collection) {
                Collection collection = (Collection)col;
                if (collection.size() > 0) {
                    ArrayList list = new ArrayList();
                    list.addAll(collection);
                    return list;
                }
            } else if (col instanceof ElementSet && (idset = (ElementSet)col).size() > 0) {
                ArrayList list = new ArrayList();
                idset.addAllElementsTo(list);
                return list;
            }
        }
        return Collections.EMPTY_LIST;
    }

    Object getItemByID(List oldItems, String id, ClassDescription.CollectionDescription cold) {
        for (Object obj : oldItems) {
            if (obj instanceof ModelIDObject) {
                if (!((ModelIDObject)obj).getObjectID().equals(id)) continue;
                return obj;
            }
            return null;
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.stack.push(qName);
        this.text.reset();
        this.processStart(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.processEnd(uri, localName, qName);
        this.stack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }

    public String getText() {
        return this.text.toString().trim();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    void processStart(String uri, String locName, String qName, Attributes attributes) {
        String[] ids;
        String name;
        String value;
        String name2;
        this.getMetaDataManager();
        String localName = MetaDataManager.getTagForCode(locName);
        int l = attributes.getLength();
        HashMap<String, String> map = new HashMap<String, String>();
        String className = null;
        String itemClass = null;
        for (int i = 0; i < l; ++i) {
            String cname = attributes.getLocalName(i);
            this.getMetaDataManager();
            name2 = MetaDataManager.getTagForCode(cname);
            value = attributes.getValue(i);
            if ("class".equals(name2)) {
                className = value;
                continue;
            }
            if ("itemClass".equals(name2)) {
                itemClass = value;
                continue;
            }
            value = StringUtilities.decodeAttributeValue(value);
            map.put(name2, value);
        }
        ClassDescription.CollectionDescription cold = this.curCtx.cd.getCollectionDescriptionByName(localName);
        if (cold != null && this.curCtx.cold == null) {
            this.curCtx.cold = cold;
            this.curCtx.itemClass = itemClass != null ? itemClass : cold.itemClassName;
            this.curCtx.itemTag = cold.itemXmlName;
            this.curCtx.itemIsRef = cold.itemIsRef;
            this.curCtx.colTag = localName;
            this.curCtx.oldItems = this.getListWithElements(this.curCtx.obj, cold);
            this.curCtx.newItems = new ArrayList();
            if (cold.itemIsRef) {
                this.curCtx.refs = new ArrayList();
            }
        } else if (cold != null) {
            int k = 0;
            ++k;
        }
        if (this.curCtx.cd.isPropertyMap && this.curCtx.obj instanceof PropertyMap && "propertyMap".equals(localName)) {
            this.curCtx.inClassPM = true;
        }
        if (localName.equals(this.curCtx.classTag)) {
            this.setProperties(this.curCtx.obj, map, this.curCtx.cd);
        } else if (this.curCtx.cd.isPropertyMap && this.curCtx.obj instanceof PropertyMap && this.curCtx.inClassPM && "property".equals(localName) && (name = (String)map.get("name")) != null) {
            String value2 = (String)map.get("value");
            if (value2 == null) {
                value2 = "";
            }
            ((PropertyMap)this.curCtx.obj).setProperty(name, value2);
        }
        if (className != null && this.curCtx.cold == null) {
            ClassDescription.PropertyDescription pd;
            if (this.initial) {
                this.initial = false;
            } else if (!localName.equals(this.curCtx.classTag) && (pd = this.curCtx.cd.getPropertyDescriptionByXMLName(localName)) != null) {
                ClassDescription cd;
                Object nested = XMLToObjectSAXTransformer.getObjectForProperty(this.curCtx.obj, pd);
                if (nested == null && pd.createProperty != null && (nested = this.createObject(this.curCtx.obj, pd.createProperty)) != null && pd.setter != null) {
                    this.setNestedProperty(this.curCtx.obj, nested, pd);
                }
                if (nested != null && (cd = this.getMetaDataManager().getClassDescription(nested.getClass().getName())) != null) {
                    this.ctxStack.push(this.curCtx);
                    this.curCtx = new PContext();
                    this.curCtx.obj = nested;
                    this.curCtx.cd = cd;
                    this.curCtx.classTag = localName;
                }
            }
        } else if (this.curCtx.obj instanceof TVConnector && "point".equals(localName)) {
            String px = (String)map.get("x");
            String py = (String)map.get("y");
            int x = 0;
            int y = 0;
            try {
                x = Integer.valueOf(px);
                y = Integer.valueOf(py);
            }
            catch (Exception e) {
                // empty catch block
            }
            Point p = new Point(x, y);
            if (this.curCtx.points == null) {
                this.curCtx.points = new ArrayList();
            }
            this.curCtx.points.add(p);
        } else if (localName.equals(this.curCtx.itemTag) && this.curCtx.cold != null) {
            String refs;
            if (this.curCtx.cold.isMapItem) {
                if (this.curCtx.cold.applyList != null) {
                    this.processMapItem(map);
                }
            } else if (!this.curCtx.itemIsRef) {
                Object obj = this.getOrCreateObject(this.curCtx.obj, map, this.curCtx.cold, this.curCtx.oldItems);
                if (obj instanceof StorageDesign) {
                    ((StorageDesign)obj).setLoading(true);
                }
                if (obj != null) {
                    if (this.curCtx.cold.addItem != null) {
                        this.addItem(this.curCtx.obj, this.curCtx.cold.addItem, obj);
                    }
                    this.curCtx.newItems.add(obj);
                    ClassDescription cd = this.getMetaDataManager().getClassDescription(obj.getClass().getName());
                    if (cd != null) {
                        this.ctxStack.push(this.curCtx);
                        this.curCtx = new PContext();
                        this.curCtx.obj = obj;
                        this.curCtx.cd = cd;
                        this.curCtx.classTag = localName;
                        if (localName.equals(this.curCtx.classTag)) {
                            this.setProperties(this.curCtx.obj, map, this.curCtx.cd);
                        }
                    }
                }
            } else if (this.curCtx.cold.listOfRefs && (refs = (String)map.get(this.curCtx.cold.refsXMLName)) != null && !"".equals(refs)) {
                ids = refs.split(" ");
                for (int i = 0; i < ids.length; ++i) {
                    if (this.curCtx.refs == null) {
                        this.curCtx.refs = new ArrayList();
                    }
                    this.curCtx.refs.add(ids[i]);
                }
            }
        } else if (this.curCtx.cold != null && this.curCtx.cold.listOfRefs) {
            String refs = (String)map.get(this.curCtx.cold.refsXMLName);
            if (refs != null && !"".equals(refs)) {
                ids = refs.split(" ");
                for (int i = 0; i < ids.length; ++i) {
                    if (this.curCtx.refs == null) {
                        this.curCtx.refs = new ArrayList();
                    }
                    this.curCtx.refs.add(ids[i]);
                }
            }
        } else {
            ClassDescription.PropertyDescription pd = this.curCtx.cd.getPropertyDescriptionByXMLName(localName);
            if (pd != null) {
                if (pd.isRectangle) {
                    this.processRectangle(map, this.curCtx.obj, pd);
                } else if (pd.isPropertyMap) {
                    this.curCtx.pd = pd;
                    Object obj = XMLToObjectSAXTransformer.getObjectForProperty(this.curCtx.obj, pd);
                    boolean created = false;
                    if (obj == null) {
                        obj = this.createObject(this.curCtx.obj, pd.createPMap);
                        created = true;
                    }
                    if (obj instanceof PropertyMap) {
                        PropertyMap pm = (PropertyMap)obj;
                        if (!created) {
                            pm.clearProperties();
                        }
                        this.curCtx.propMW = pm;
                        this.curCtx.inPropMW = true;
                        if (created) {
                            this.curCtx.propMWcreated = true;
                        }
                    }
                }
            } else if (this.curCtx.inPropMW && this.curCtx.propMW != null && this.curCtx.pd != null && localName.equals(this.curCtx.pd.pmItemName) && this.curCtx.propMW instanceof PropertyMap && (name2 = (String)map.get(this.curCtx.pd.pmKeyName)) != null) {
                value = (String)map.get(this.curCtx.pd.pmValueName);
                if (value == null) {
                    value = "";
                }
                ((PropertyMap)this.curCtx.propMW).setProperty(name2, value);
            }
        }
    }

    private void processMapItem(Map map) {
        HashMap nmap = new HashMap(map);
        this.curCtx.newItems.add(nmap);
    }

    private void processDefaultvalues(PContext curCtx) {
        for (ClassDescription.PropertyDescription pd : curCtx.cd.getPropertiesList()) {
            String pname;
            String value;
            if (!pd.isStringClass() && !pd.isSimpleClass() || (value = (String)curCtx.processedprops.get(pname = pd.xmlName)) != null) continue;
            this.setDefaultProperty(curCtx.obj, pd);
        }
    }

    void processEnd(String uri, String locName, String qName) {
        this.getMetaDataManager();
        String localName = MetaDataManager.getTagForCode(locName);
        String value = this.getText();
        if (value == null) {
            value = "";
        } else if (!"".equals(value)) {
            value = StringUtilities.decodeAttributeValue(value);
        }
        if (this.curCtx.cd.isPropertyMap && this.curCtx.obj instanceof PropertyMap && "propertyMap".equals(localName)) {
            this.curCtx.inClassPM = false;
        }
        if (this.curCtx.obj instanceof TVConnector && "points".equals(localName)) {
            TVConnector tvc = (TVConnector)this.curCtx.obj;
            List list = tvc.getEdgePoints();
            list.clear();
            for (Point2D p : this.curCtx.points) {
                list.add(DiagramConstants.createPoint(p));
            }
            this.curCtx.points = null;
        }
        if (this.curCtx.classTag.equals(localName)) {
            this.processDefaultvalues(this.curCtx);
            if (this.curCtx.obj instanceof DesignPart) {
                ((DesignPart)this.curCtx.obj).executeTasks();
            }
            this.invokeMethod(this.curCtx.obj, this.curCtx.cd.afterInit);
            this.invokeMethod(this.curCtx.obj, this.curCtx.cd.afterInitExt);
            if (this.curCtx.obj instanceof StorageDesign) {
                ((StorageDesign)this.curCtx.obj).setLoading(false);
                ((StorageDesign)this.curCtx.obj).setOpen(true);
            }
            if (this.curCtx.obj instanceof ModelIDObject) {
                ((ModelIDObject)this.curCtx.obj).setLoadedCompletely(true);
            }
            this.curCtx = (PContext)this.ctxStack.pop();
        } else if (localName.equals(this.curCtx.colTag)) {
            if (this.curCtx.cold.itemIsRef) {
                this.processCollectionWithRefs(this.curCtx.obj, this.curCtx.refs, this.curCtx.cold, this.curCtx.newItems);
            } else if (this.curCtx.cold.isMapItem && this.curCtx.cold.applyList != null) {
                this.applyList(this.curCtx.obj, this.curCtx.cold.applyList, this.curCtx.newItems);
            }
            if (!this.curCtx.cold.isMapItem) {
                if (this.curCtx.cold.applyList == null) {
                    this.orderAndClearList(this.curCtx.obj, this.curCtx.cold, this.curCtx.oldItems, this.curCtx.newItems);
                } else {
                    this.applyList(this.curCtx.obj, this.curCtx.cold.applyList, this.curCtx.newItems);
                }
            }
            this.curCtx.colTag = null;
            this.curCtx.cold = null;
            this.curCtx.itemTag = null;
        } else if (localName.equals(this.curCtx.itemTag)) {
            if (this.curCtx.cold.itemIsRef && !"".equals(value)) {
                this.curCtx.refs.add(value);
            }
        } else {
            ClassDescription.PropertyDescription pd = this.curCtx.cd.getPropertyDescriptionByXMLName(localName);
            if (pd != null) {
                this.curCtx.processedprops.put(localName, localName);
                if (pd.isPropertyMap && this.curCtx.inPropMW) {
                    if (this.curCtx.propMWcreated) {
                        this.setObjectForProperty(this.curCtx.obj, pd, this.curCtx.propMW);
                    }
                    this.curCtx.pd = null;
                    this.curCtx.propMW = null;
                    this.curCtx.inPropMW = false;
                    this.curCtx.propMWcreated = false;
                } else if (!pd.isRectangle) {
                    if ((pd.isID || pd.isListOfRefs) && this.curCtx.obj instanceof ModelIDObject) {
                        value = ((ModelIDObject)this.curCtx.obj).replaceIDsInValue(value);
                    }
                    this.setProperty(this.curCtx.obj, value, pd);
                }
            }
        }
    }

    private void processCollectionWithRefs(Object container, List idslist, ClassDescription.CollectionDescription cold, List newItems) {
        Object obj;
        List target = null;
        if (cold.nativeList && cold.addItem == null && (obj = XMLToObjectSAXTransformer.getCollection(container, cold)) instanceof List) {
            target = (List)obj;
        }
        for (String id : idslist) {
            Object object = this.getItemByID(container, cold.getItemByID, id);
            if (object == null && container instanceof ID_ObjectPropertyTranslator && (object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.xmlName, id)) != null) {
                if (cold.addItem != null) {
                    this.addItem(container, cold.addItem, object);
                } else if (cold.nativeList && target != null) {
                    target.add(object);
                }
            }
            if (object == null) continue;
            newItems.add(object);
        }
    }

    void setProperties(Object object, Map map, ClassDescription cd) {
        for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
            String pname = pd.xmlName;
            String value = (String)map.get(pname);
            if (value == null) continue;
            this.setProperty(object, value, pd);
            this.curCtx.processedprops.put(pname, pname);
        }
    }

    public void transformToObject(Object object, File file, boolean processExternals, List excludeProps) {
        InputSource inputSource = null;
        InputStreamReader isr = null;
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                isr = new InputStreamReader((InputStream)is, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (isr != null) {
                inputSource = new InputSource(isr);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (inputSource != null) {
            this.transformToObject(object, inputSource, processExternals, excludeProps);
        }
    }

    private SAXParser getSAXParser() {
        if (this.saxParser == null) {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            try {
                this.saxParser = spf.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return this.saxParser;
    }

    public void transformToObject(Object object, InputSource inputSource, boolean processExternals, List excludeProps) {
        SAXParser sp = this.getSAXParser();
        if (sp != null) {
            try {
                ClassDescription cd;
                this.curCtx = new PContext();
                this.curCtx.obj = object;
                this.curCtx.cd = cd = this.getMetaDataManager().getClassDescription(object.getClass().getName());
                this.curCtx.classTag = cd.getXmlName();
                this.initial = true;
                this.ctxStack.push(this.curCtx);
                sp.parse(inputSource, (DefaultHandler)this);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Object getOrCreateObject(Object container, Map map, ClassDescription.CollectionDescription cold, List oldItems) {
        if (cold.isObjectViewItem && container instanceof DesignPartView) {
            return this.getOrCreateTopView((DesignPartView)container, map, cold);
        }
        if (cold.isTVConnectorItem && container instanceof DesignPartView) {
            return this.getOrCreateTVConnector((DesignPartView)container, map, cold);
        }
        if (cold.isTVDiagramItem && container instanceof DesignPartView) {
            return this.getOrCreateTVDiagram((DesignPartView)container, map, cold);
        }
        if (cold.isPhysicalModelItem && container instanceof RelationalDesign) {
            return this.getOrCreateStorageDesign((RelationalDesign)container, map, cold);
        }
        String id = this.getID(map);
        Object object = null;
        if (id != null) {
            object = cold.getItemByID != null ? this.getItemByID(container, cold.getItemByID, id) : (container instanceof DesignObject || container instanceof DesignPart ? ((ModelIDObject)container).getDesign().getDesignObject(id) : (container instanceof StorageObject ? ((StorageObject)container).getStorageDesign().getStorageObject(id) : (container instanceof StorageDesign ? ((StorageDesign)container).getStorageObject(id) : this.getItemByID(oldItems, id, cold))));
        }
        if (object == null) {
            if (cold.isProxyitem) {
                if (container instanceof ID_ObjectPropertyTranslator) {
                    object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(null, id);
                }
            } else {
                if (cold.getItemByID == null && container instanceof ID_ObjectPropertyTranslator) {
                    object = ((ID_ObjectPropertyTranslator)container).translateIdToObject(cold.itemXmlName, id);
                }
                if (object == null) {
                    object = this.createItem(container, cold.createItem);
                }
            }
        }
        if (object instanceof TableProxyOracle) {
            ((TableProxyOracle)object).setUser(null);
        }
        if (!XMLToObjectTransformer.checkShouldMerge && object instanceof ModelIDObject && id != null) {
            ((ModelIDObject)object).setObjectID(id);
        }
        return object;
    }

    private Object getOrCreateTopView(DesignPartView dpv, Map map, ClassDescription.CollectionDescription cold) {
        if (cold.isObjectViewItem) {
            String oid = (String)map.get("oid");
            DesignObject object = dpv.getDesignPart().getDesign().getDesignObject(oid);
            if (object != null && object instanceof Note) {
                dpv.getDesign().getOldNotesDPVs().add(dpv);
            }
            if (object == null) {
                String type = (String)map.get("otype");
                if ("Image".equalsIgnoreCase(type)) {
                    object = dpv.getDesignPart().createImage();
                    object.setObjectID(oid);
                    String ifn = (String)map.get("imageFileName");
                    ((ImageObject)object).setImageFileName(ifn);
                } else if ("Note".equalsIgnoreCase(type)) {
                    object = dpv.getDesignPart().createNote();
                    object.setObjectID(oid);
                } else if ("Legend".equalsIgnoreCase(type)) {
                    dpv.setShowLegend(true);
                    object = dpv.getLegend();
                    object.setObjectID(oid);
                }
                if (dpv.getDesignPart() instanceof TransformationTask) {
                    if ("InOutParams".equalsIgnoreCase(type)) {
                        object = ((TransformationTask)dpv.getDesignPart()).getInOutParamsObjectById(oid);
                    } else if ("InfoStore".equalsIgnoreCase(type)) {
                        object = ((TransformationTask)dpv.getDesignPart()).getInfoStoreSet().getObjectByID(oid);
                    }
                }
            }
            if (object != null) {
                String vid = (String)map.get("vid");
                String vnum = (String)map.get("vid");
                int num = 0;
                try {
                    num = Integer.valueOf(vnum);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                TopView cv = object.getTopViewByID(dpv, vid, num);
                if (cv == null) {
                    cv = dpv.createTopViewForGlobal(object);
                }
                if (!dpv.getTopviewsList().contains(cv)) {
                    dpv.add(cv);
                }
                cv.setViewID(vid);
                return cv;
            }
        }
        return null;
    }

    private Object getOrCreateTVConnector(DesignPartView dpv, Map map, ClassDescription.CollectionDescription cold) {
        if (cold.isTVConnectorItem) {
            String oid = (String)map.get("oid");
            DesignObject dobj = dpv.getDesignPart().getDesign().getDesignObject(oid);
            if (dobj != null && dobj instanceof ConnectionInterface) {
                ConnectionInterface connector = (ConnectionInterface)((Object)dobj);
                String vid_source = (String)map.get("vid_source");
                String vid_target = (String)map.get("vid_target");
                if (connector.getSourceObject() != null && connector.getTargetObject() != null) {
                    TopView tv;
                    TopView ttv;
                    TopView stv;
                    if (!vid_source.equals("") && (stv = connector.getSourceObject().getTopViewByID(dpv, vid_source)) != null) {
                        connector.setSourceTopView(stv);
                    }
                    if (!vid_target.equals("") && (ttv = connector.getTargetObject().getTopViewByID(dpv, vid_target)) != null) {
                        connector.setTargetTopView(ttv);
                    }
                    if ((tv = connector.getViewFor(dpv)) != null && !dpv.getTopviewsList().contains(tv)) {
                        dpv.add(tv);
                    }
                    return tv;
                }
            }
        }
        return null;
    }

    private Object getOrCreateStorageDesign(RelationalDesign rd, Map map, ClassDescription.CollectionDescription cold) {
        String siteID = (String)map.get("siteID");
        RDBMSSite site = rd.getDesign().getRDBMSSiteSet().getByObjectID(siteID);
        if (site == null) {
            String siteType = (String)map.get("siteType");
            String siteName = (String)map.get("siteName");
            site = rd.getDesign().getRDBMSSiteSet().createSite(siteName, rd.getDesign());
            int type = 9;
            try {
                type = Integer.parseInt(siteType);
            }
            catch (Exception e) {
                // empty catch block
            }
            RDBMSType rdbmsType = Design.getDefaultRDBMSTypeSet().get(type);
            site.setType(rdbmsType);
            site.setObjectID(siteID);
            site.setPathID(rd.getDesign().getRDBMSSiteSet().nextIndex());
        }
        if (site != null) {
            boolean exists = rd.getStorageDesignFactory().existStorageDesign(site);
            StorageDesign stoDes = rd.getStorageDesign(site);
            if (stoDes != null) {
                stoDes.setTempModel(false);
                if (exists && !rd.getDesign().isNewDesign()) {
                    stoDes.openStorageDesign();
                }
            }
            return stoDes;
        }
        return null;
    }

    private Object getOrCreateTVDiagram(DesignPartView dpv, Map map, ClassDescription.CollectionDescription cold) {
        if (cold.isTVDiagramItem) {
            String oid = StringUtilities.decodeAttributeValue((String)map.get("oid"));
            DesignPart dp = dpv.getDesignPart();
            DiagramView object = dp.recreateDiagramView(oid);
            if (object != null) {
                String vid;
                TopView cv;
                if (!dpv.isMainDiagram()) {
                    dpv.getDesignPart().getMainView().removeViewFor(object);
                }
                if ((cv = object.getFirstViewForDPV(dpv)) == null) {
                    cv = dpv.createTopViewFor(object);
                }
                if (cv != null && !"".equals(vid = StringUtilities.decodeAttributeValue((String)map.get("vid")))) {
                    cv.setViewID(vid);
                }
                return cv;
            }
        }
        return null;
    }

    private void processRectangle(Map map, Object object, ClassDescription.PropertyDescription pd) {
        String xs = (String)map.get("x");
        String ys = (String)map.get("y");
        String ws = (String)map.get("width");
        String hs = (String)map.get("height");
        int x = 0;
        int y = 0;
        int w = 20;
        int h = 20;
        try {
            x = Integer.valueOf(xs);
            y = Integer.valueOf(ys);
            w = Integer.valueOf(ws);
            h = Integer.valueOf(hs);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
        Rectangle rect = new Rectangle(x, y, w, h);
        this.setObjectForProperty(object, pd, rect);
    }

    private String getID(Map map) {
        String id = (String)map.get("id");
        if ((id == null || "".equals(id)) && (id = (String)map.get("objectID")) != null && "".equals(id) && (id = (String)map.get("IDREF")) != null && "".equals(id)) {
            return null;
        }
        return id;
    }

    class PContext {
        Object obj;
        ClassDescription cd;
        ClassDescription.PropertyDescription pd;
        ClassDescription.CollectionDescription cold;
        String tag;
        Map processedprops = new HashMap();
        boolean isProp;
        boolean itemIsRef;
        String classTag;
        String colTag;
        String itemTag;
        String itemClass;
        List oldItems;
        List newItems;
        List points;
        List refs;
        Object propMW;
        boolean inPropMW;
        boolean inClassPM;
        boolean propMWcreated;

        PContext() {
        }
    }
}

